CREATE TABLE IF NOT EXISTS `#__ce_cf` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(1020) NOT NULL,
  `label` varchar(1020) NOT NULL,
  `alias` varchar(255) NOT NULL,
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `type` varchar(20) NOT NULL,
  `value` mediumtext NOT NULL,
  `ordering` int(11) NOT NULL,
  `catid` int(11) NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `attributes` mediumtext,
  `tooltip` varchar(255) DEFAULT NULL,
  `iscore` tinyint(1) NOT NULL DEFAULT '0',
  `params` mediumtext,
  `access` tinyint(3) unsigned NOT NULL,
  `language` char(7) NOT NULL,
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_ce_cf_language` (`language`),
  KEY `idx_ce_cf_published` (`published`),
  KEY `idx_ce_cf_access` (`access`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__ce_cv` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `text` varchar(255) NOT NULL COMMENT 'Will be removed from future versions... use NAME field now',
  `name` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `description` mediumtext NOT NULL,
  `type` varchar(100) DEFAULT NULL,
  `ordering` int(11) NOT NULL,
  `catid` int(11) NOT NULL,
  `parent` varchar(100) DEFAULT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `access` tinyint(3) unsigned NOT NULL,
  `params` mediumtext,
  `language` char(7) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ce_cv_text_values` (`text`),
  KEY `idx_ce_cv_language` (`language`),
  KEY `idx_ce_cv_published` (`published`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__ce_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) NOT NULL DEFAULT '',
  `department` varchar(255) NOT NULL DEFAULT '',
  `con_position` varchar(255) DEFAULT NULL,
  `address` text,
  `suburb` varchar(100) DEFAULT NULL,
  `state` varchar(100) DEFAULT NULL,
  `country` varchar(100) DEFAULT NULL,
  `postcode` varchar(100) DEFAULT NULL,
  `telephone` varchar(255) DEFAULT NULL,
  `fax` varchar(255) DEFAULT NULL,
  `misc` mediumtext,
  `sidebar` mediumtext,
  `image` varchar(255) DEFAULT NULL,
  `category_image` varchar(255) DEFAULT NULL,
  `imagepos` varchar(20) DEFAULT NULL,
  `email_to` varchar(255) DEFAULT NULL,
  `default_con` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `catid` int(11) NOT NULL DEFAULT '0',
  `access` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `mobile` varchar(255) NOT NULL DEFAULT '',
  `skype` varchar(255) NOT NULL,
  `twitter` varchar(255) NOT NULL,
  `facebook` varchar(255) NOT NULL,
  `linkedin` varchar(255) NOT NULL,
  `webpage` varchar(255) NOT NULL DEFAULT '',
  `birthdate` date NULL,
  `sortname1` varchar(255) NOT NULL,
  `sortname2` varchar(255) NOT NULL,
  `sortname3` varchar(255) NOT NULL,
  `language` char(7) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  `metadata` text NOT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `xreference` varchar(50) NOT NULL COMMENT 'A reference to enable linkages to external data sets.',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lat` varchar(20) NOT NULL,
  `lng` varchar(20) NOT NULL,
  `zoom` tinyint(3) unsigned NOT NULL DEFAULT '15',
  `extra_field_1` mediumtext NOT NULL,
  `extra_field_2` mediumtext NOT NULL,
  `extra_field_3` mediumtext NOT NULL,
  `extra_field_4` mediumtext NOT NULL,
  `extra_field_5` mediumtext NOT NULL,
  `extra_field_6` mediumtext NOT NULL,
  `extra_field_7` mediumtext NOT NULL,
  `extra_field_8` mediumtext NOT NULL,
  `extra_field_9` mediumtext NOT NULL,
  `extra_field_10` mediumtext NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__ce_message_fields` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `message_id` int(11) unsigned NOT NULL,
  `field_id` int(11) unsigned NOT NULL,
  `field_type` varchar(20) NOT NULL,
  `value` mediumtext NOT NULL,
  `modified` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__ce_messages` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `parent` int(11) NOT NULL DEFAULT '0',
  `from_name` varchar(200) NOT NULL,
  `from_email` varchar(100) NOT NULL,
  `from_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT 'Joomla user id, in case the user is logged in when he submits the form',
  `email_to` mediumtext NOT NULL,
  `email_cc` mediumtext NOT NULL,
  `email_bcc` mediumtext NOT NULL,
  `subject` varchar(255) NOT NULL,
  `contact_id` int(11) NOT NULL,
  `catid` int(11) unsigned NOT NULL,
  `date` datetime NOT NULL,
  `reply_date` datetime NOT NULL,
  `replied_by` int(11) unsigned NOT NULL,
  `message` mediumtext NOT NULL,
  `message_html` mediumtext NOT NULL,
  `user_ip` varchar(24) NOT NULL,
  `published` tinyint(3) NOT NULL DEFAULT '0',
  `access` tinyint(3) unsigned NOT NULL,
  `language` char(7) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Recorded emails';

CREATE TABLE IF NOT EXISTS `#__ce_template` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `html` mediumtext NOT NULL,
  `type` varchar(50) NOT NULL,
  `published` tinyint(3) NOT NULL,
  `access` int(10) unsigned NOT NULL,
  `language` char(7) NOT NULL,
  `params` mediumtext NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;


CREATE TABLE IF NOT EXISTS `#__ce_cannedanswers` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(64) NOT NULL,
  `text` mediumtext NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `modified` datetime NOT NULL,
  `modified_by` int(10) unsigned NOT NULL,
  `ordering` int(8) unsigned NOT NULL,
  `access` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `language` varchar(7) NOT NULL DEFAULT '*',
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;
