<?php
/**
 * @license		GNU GPL2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

jimport('joomla.application.component.modeladmin');

/**
 * @package		com_contactenhanced
* @version		1.6
 */
class ContactenhancedModelCpanel extends JModelList{
	/**
	 * The type alias for this content type.
	 *
	 * @var      string
	 * @since    3.2
	 */
	public $typeAlias = 'com_contactenhanced.cpanel';

	public function getUpdates()
	{
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$purged = JFactory::getSession()->get('com_contactenhanced.updates_purged', null);
		if($purged== null){ // Run only once per session
			$query->clear();
			JLoader::import('joomla.update.update');
			// Purge the updates list
			$this->purge();
			$updater = JUpdater::getInstance();
			$updater->findUpdates(0, 0);
			JFactory::getSession()->set('com_contactenhanced.updates_purged',  true);
		}


		$query->clear();
		$query->select('*')
			->from($db->quoteName('#__updates'))
			->where($db->quoteName('element') . ' = ' . $db->quote('com_contactenhanced'))
			;

		$db->setQuery($query);
		$update = $db->loadObject();
		if($update){
			JFactory::getLanguage()->load('plg_quickicon_extensionupdate');
			$update = JText::sprintf('PLG_QUICKICON_EXTENSIONUPDATE_UPDATEFOUND', ' <a style="color:#fff" href="http://idealextensions.com/downloads" target="_blank">Download '.$update->version.'</a> ');
			JFactory::getApplication()->enqueueMessage($update,'warning');
		}

	}

	/**
	 * Removes all of the updates from the table.
	 *
	 * @return  boolean result of operation
	 *
	 * @since   3.3.1
	 */
	public function purge()
	{
		$db = JFactory::getDbo();

		// Note: TRUNCATE is a DDL operation
		// This may or may not mean depending on your database
		$db->setQuery('TRUNCATE TABLE #__updates');
		if ($db->execute())
		{
			// Reset the last update check timestamp
			$query = $db->getQuery(true)
			->update($db->quoteName('#__update_sites'))
			->set($db->quoteName('last_check_timestamp') . ' = ' . $db->quote(0));
			$db->setQuery($query);
			$db->execute();
			return true;
		}
	}
}