<?php
/**
 * @copyright	Copyright (C) 2006 - 2013 Ideal Extensions for Joomla
 * @author     Douglas Machado {@link http://idealextensions.com}
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('JPATH_BASE') or die;

jimport('joomla.html.html');
jimport('joomla.form.formfield');

/**
 * Supports an HTML select list of contacts
 *
 * @package		com_irelated
* @since		1.6
 */
class JFormFieldLoadlanguages extends JFormField
{
	/**
	 * The form field type.
	 *
	 * @var		string
	 * @since	1.6
	 */
	protected $type = 'Loadlanguages';

	/**
	 * Method to get the field input markup.
	 *
	 * @return	string	The field input markup.
	 * @since	1.6
	 */
	protected function getInput()
	{
		$lang = JFactory::getLanguage();
		//Load English always, useful if file is partially translated
		$lang->load('com_contactenhanced',		JPATH_ADMINISTRATOR.'/components/com_contactenhanced', 'en-GB');
		$lang->load('com_contactenhanced',		JPATH_ADMINISTRATOR.'/components/com_contactenhanced',	null,	true);
		$lang->load('com_contactenhanced.sys',	JPATH_ADMINISTRATOR.'/components/com_contactenhanced', 'en-GB');
		$lang->load('com_contactenhanced.sys',	JPATH_ADMINISTRATOR.'/components/com_contactenhanced',	null,	true);
		$lang->load('com_contactenhanced.menu',	JPATH_ADMINISTRATOR.'/components/com_contactenhanced', 'en-GB');
		$lang->load('com_contactenhanced.menu',	JPATH_ADMINISTRATOR.'/components/com_contactenhanced',	null,	true);
		/* Load Feedback language strings because of the Feedback COPY plugin */
		$lang->load('plg_system_cefeedback',JPATH_ROOT.'/plugin/system/cefeedback');
		// Initialize variables.
		return '';
	}
	
	/**
	 * Method to get the field label markup.
	 *
	 * @return	string	The field label markup.
	 * @since	1.6
	 */
	protected function getLabel()
	{
		return '';
	}
}