<?php
/**
 * @package	 com_contactenhanced
 * @author	 Douglas Machado {@link http://idealextensions.com}
 * @author	 Created on 28-Aug-10
 * @license		GNU/GPL, see license.txt
 * Contact Enhanced  is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 */

// Check to ensure this file is within the rest of the framework
defined('JPATH_BASE') or die;

jimport('joomla.html.html');
jimport('joomla.form.formfield');

/**
 * Renders an element
 *
 * @package 	Contact_Enhanced
 * @since		1.5.8
 */

class JFormFieldModal_Campaignmonitorlist extends JFormField
{
	/**
	* Element name
	*
	* @access	protected
	* @var		string
	*/
	protected $type = 'Modal_Campaignmonitorlist';


	/**
	 * Method to get the field input markup.
	 *
	 * @return	string	The field input markup.
	 * @since	1.6
	 */
	protected function getInput()
	{
		// Load the javascript and css
		ceHelper::loadJqueryUI();
		JHtml::_('bootstrap.framework');
		JHtml::_('bootstrap.loadCss');

		$selector = 'modal-window-'.$this->id;
		$params	= array();
		// Build the script.
		$script = array();
		$script[] = '	function jSelectChart_'.$this->id.'(id, name, object) {';
		$script[] = '		jQuery("#'.$this->id.'_id").val(id);';
		$script[] = '		jQuery("#'.$this->id.'_name").val(name);';
		$script[] = '		jQuery("#'.$selector.'").modal("hide")';
		$script[] = '	}';

		// Add the script to the document head.
		JFactory::getDocument()->addScriptDeclaration(implode("\n", $script));

		if (empty($this->value)) {
			$title = JText::_('CE_CF_CM_SELECT_A_LIST');
		}else{
			$title = $this->getListName($this->value);
		}

		$link = 'index.php?option=com_contactenhanced&amp;task=element&amp;layout=modal&amp;tmpl=component&amp;function=jSelectChart_'.$this->id.'&object=campaignmonitor';

		$html = "\n".'<div class="input-append">
		  <input class="span7"
				type="text" id="'.$this->id.'_name"
				value="'.htmlspecialchars($title, ENT_QUOTES, 'UTF-8').'"
				disabled="disabled" />
		  <button class="btn btn-default"
		  		data-toggle="modal" data-target="#'.$selector.'"
		  		title="'.JText::_('CE_CF_CM_CHANGE_LIST_BUTTON').'"
		  		type="button">'.JText::_('CE_CF_CM_CHANGE_LIST_BUTTON').'</button>
		  <button type="button" class="btn btn-default"
	  				onclick="jQuery(\'#'.$this->id.'_name\').val(\'\');jQuery(\'#'.$this->id.'_id\').val(\'\');">'
  						.JText::_('JCLEAR').'</button>
		</div>';
		// The active contact id field.
		if (0 == (int)$this->value) {
			$value = '';
		}else{
			$value = (int)$this->value;
		}

		// class='required' for client side validation
		$class = '';
		if($this->required) {
			$class = ' class="required modal-value"';
		}

		$html .= '<input type="hidden" id="'.$this->id.'_id"'.$class.' name="'.$this->name.'" value="'.$value.'" />';

		$params['url']		= $link;
		$params['title']  = JText::_('CE_CF_CM_SELECT_A_LIST');
		$params['height'] = 480;
		$params['width']  = 800;

		$footer = '';

		$html .= $this->renderModal($selector, $params, $footer);
		return $html;
	}

	private function getListName($listID) {
		$app		= JFactory::getApplication();
		$jinput		= $app->input;
		if($jinput->getInt('id')) {
			require_once(JPATH_ROOT.'/components/com_contactenhanced/customFields.class.php');
			$db 	= JFactory::getDBO();
			$query	= $db->getQuery(true);
			$query->select('*');
			$query->from('#__ce_cf');
			$query->where("id=".$db->Quote($jinput->getInt('id')));
			$db->setQuery($query);
			$cf 	= $db->loadObject();
			if(is_object($cf)){
				$params	= new JRegistry();
				$params->loadString($cf->params);
				$cmObj	= new ceFieldType_campaignmonitor($cf,$params);
				if($list = $cmObj->getList()){
					return $list->title;
				}
			}
		}
		return '';
	}

	/**
	 * Method to render a Bootstrap modal
	 *
	 * @param   string  $selector  The ID selector for the modal.
	 * @param   array   $params	An array of options for the modal.
	 * @param   string  $footer	Optional markup for the modal footer
	 *
	 * @return  string  HTML markup for a modal
	 *
	 * @since   3.0
	 */
	public function renderModal($selector = 'modal', $params = array(), $footer = '')
	{
		// Ensure the behavior is loaded
		JHtml::_('bootstrap.modal',$selector, $params);

		$html = "<div class=\"modal hide fade\" id=\"" . $selector . "\">\n";
		$html .= "<div class=\"modal-header\">\n";
		$html .= "<button type=\"button\" class=\"close\" data-dismiss=\"modal\">×</button>\n";
		$html .= "<h3>" . $params['title'] . "</h3>\n";
		$html .= "</div>\n";
		$html .= "<div id=\"" . $selector . "-container\">\n";
		$html .= "</div>\n";
		$html .= "</div>\n";

		$html .= "<script>";
		$html .= "jQuery('#" . $selector . "').on('show', function () {\n";
		$html .= "document.getElementById('" . $selector . "-container').innerHTML = '<div class=\"modal-body\"><iframe class=\"iframe\" src=\""
				. $params['url'] . "&elemVar1='+jQuery('#jform_params_campaignmonitor_api_key').val()+'&elemVar2='+jQuery('#jform_params_campaignmonitor_api_client').val()+'"
				. "\" height=\"" . $params['height'] . "\" width=\"" . $params['width'] . "\"></iframe></div>" . $footer . "';\n";
		$html .= "});\n";
		$html .= "</script>";
		JFactory::getDocument()->addStyleDeclaration('.modal-body iframe{border:0}');

		return $html;
	}
}
