<?php
/**
 * @author	 Douglas Machado {@link http://idealextensions.com}
 * @license		GNU GPL2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

/**
 * @package		com_contactenhanced
*/
class ContactenhancedTableCannedanswer extends JTable
{
	/**
	 * Constructor
	 *
	 * @param object Database connector object
	 * @since 1.0
	 */
	public function __construct(& $db)
	{
		parent::__construct('#__ce_cannedanswers', 'id', $db);
	}

	/**
	 * Overloaded bind function
	 *
	 * @param	array		Named array
	 * @return	null|string	null is operation was satisfactory, otherwise returns an error
	 * @since	1.6
	 */
	public function bind($array, $ignore = '')
	{
		$userId = JFactory::getUser()->get('id');
		$input = JFactory::getApplication()->input;
		$array['modified'] = JFactory::getDate()->toSql();
		
		if ($input->getInt('id')) {
			$array['id']	= $input->getInt('id');
			$array['modified_by'] = $userId;
		}else{
			$array['created'] = JFactory::getDate()->toSql();
			$array['created_by'] = $userId;
		}
		if ($input->getString('title')) {
			$array['title']	= $input->getString('title');
		}
		if ($input->getString('text')) {
			$array['text']	= $input->get('text','','RAW');
		}
	
		return parent::bind($array, $ignore);
	}

	/**
	 * Stores a custom field
	 *
	 * @param	boolean	True to update fields even if they are null.
	 * @return	boolean	True on success, false on failure.
	 * @since	1.6
	 */
	public function store($updateNulls = false)
	{
	
		// Attempt to store the data.
		return parent::store($updateNulls);
	}

	/**
	 * Overloaded check function
	 *
	 * @return boolean
	 * @see JTable::check
	 * @since 1.5
	 */
	function check()
	{
		/** check for valid name */
		if (trim($this->title) == '') {
			$this->setError(JText::_('COM_CONTACTENHANCED_WARNING_PROVIDE_VALID_NAME'));
			return false;
		}
		return true;
	}

}
