<?php
/**
 * @package		com_contactenhanced
 * @copyright	Copyright (C) 2006 - 2015 IdealExtensions.com. All rights reserved
 * @author	 	Douglas Machado {@link http://idealextensions.com}
 * @license		GNU GPL2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

$doc =JFactory::getDocument();
$doc->addScriptDeclaration("

jQuery(document).ready(function($){
	$('#canned-asnwer-btn-cancel').on('click', function(){
		$('.edit-ca-loaded').remove();
	});
	$('#canned-asnwer-btn-save').on('click',function(){
		$.ajax({
		  type: 'GET',
		  url: 'index.php?option=com_contactenhanced&task=cannedanswer.add',
		  data: $('.edit-ca-loaded :input').serialize(),
		  dataType: 'json'
		}).done(function( data ) {
		    if ( data.status ) {
				// it's not a new Canned Answer
				$('#ca-'+data.id).remove();
		
				$('.canned-answers').prepend(data.html);
				// Add Events to new links
				caAddLinkEvents();
		
				$('.edit-ca-loaded').remove();
				
		    }
	 	 });	
	});
		
	function caAddLinkEvents(){
		$('.canned-answers .ca-edit').off('click');
		$('.canned-answers .ca-edit').on('click', function(e){
			e.preventDefault();
			// Make sure there's only one form 
			$('.edit-ca-loaded').remove();
			//Get Parent
			var parent = $(this).parent().parent();
			var eip = $('#edit-in-place-form').clone(true,true).appendTo( parent );
			eip.addClass('edit-ca-loaded');
			
			$('#canned-answer-id').val(parent.data('id'));
			if(parent.data('text')){
				$('#canned-answer-text').val($('<div>'+parent.data('text')+'</div>').html());
			}
			
			$('#canned-answer-title').val(parent.data('title'));
			
		});
		$('.canned-answers .ca-copy').off('click');
		$('.canned-answers .ca-copy').on('click', function(e){
			e.preventDefault();

			//Get Parent
			var parent = $(this).parent().parent();
			if(parent.data('text')){
				var caretPos = document.getElementById('message').selectionStart;
			    var textAreaTxt = $('#message').val();
			    $('#message').val(textAreaTxt.substring(0, caretPos) + ' ' + $('<div>'+parent.data('text')+'</div>').html()+ ' ' + textAreaTxt.substring(caretPos) );
				$('#email-add-canned-answer').popover('hide');
			}
		});
		$('.canned-answers .ca-remove').off('click');
		$('.canned-answers .ca-remove').on('click', function(e){
			e.preventDefault();
			
			var parent = $(this).parent().parent();
			if (confirm('".JText::_('JTOOLBAR_DELETE')."?')) {
				$.ajax({
				  type: 'GET',
				  url: 'index.php?option=com_contactenhanced&task=cannedanswer.remove',
				  data: '&id='+parent.data('id'),
				  dataType: 'json'
				}).done(function( data ) {
				    if ( data.status ) {
						// it's not a new Canned Answer
						$('#ca-'+parent.data('id')).remove();
				    }
				});
			}
			
		});
	}
	caAddLinkEvents();
	$('#email-add-canned-answer').popover(
		{title:	'".JText::_('CE_MESSAGE_CANNED_ANSWERS')."',
			content:	$('#canned-answers'),
			placement:	'left',
			//trigger:	'manual'
		});
	$('#email-add-canned-answer').on('shown.bs.popover', function () {
		caAddLinkEvents();
	})
	$('body').on('click', function (e) {
		var el = 'email-add-canned-answer';
		if ($(e.target).parents('#'+el).length === 0
			&& $(e.target).attr('id') != el
	        && $(e.target).parents('.popover.in').length === 0) {
	        $('#'+el).popover('hide');
	    }
	});
});
		
		
");


?>
<li>
	<a id="email-add-canned-answer" href="#ca">
	<i class="icon-pencil glyphicon glyphicon-pencil"></i>
	<?php echo JText::_('CE_MESSAGE_CANNED_ANSWERS'); ?> <b class="caret"></b></a>
</li>

<div style="display: none">
	<div id="canned-answers"  class="canned-answers row-striped" style="width:240px">
		<?php foreach ($this->cannedAnswers as $ca) {
			echo '<div class="row-fluid row" id="ca-'.$ca->id.'" data-id="'.$ca->id.'" data-text="'.htmlentities($ca->text).'" data-title="'.$ca->title.'">
 				<div class="span9 col-md-9"><a class="ca-copy" href="#ca" title="'.strip_tags($ca->text).'">'.$ca->title.'</a></div>
 				<div class="span1 col-md-1"><a class="ca-edit pull-right" 	href="#ca" title="'.JText::_('JTOOLBAR_EDIT').'"><i class="icon-pencil  glyphicon glyphicon-pencil"></i></a></div>
				<div class="span1 col-md-1"><a class="ca-remove pull-right" href="#ca" title="'.JText::_('JTOOLBAR_DELETE').'"><i class="icon-remove  glyphicon glyphicon-remove"></i></a></div>
 			</div>';
		}?>
		<div class="row-fluid" id="ca-id" data-id="" data-text="" data-title=""><a class="ca-edit" href="#ca-new"><?php echo JText::_('JTOOLBAR_NEW')?>...</a></div>
	</div>
	<div id="edit-in-place-form" class="edit-in-place-form" data-url="index.php?option=com_contactenhanced&task=message.saveCannedAnswer">
		<input		id="canned-answer-title" 	name="title" 	title="<?php echo JText::_('JGLOBAL_TITLE'); ?>"	type="text" class="inputbox span12 col-md-12" placeholder="<?php echo JText::_('JGLOBAL_TITLE'); ?>" />
		<textarea	id="canned-answer-text" 	name="text"		title="<?php echo JText::_('CE_MESSAGE_CANNED_ANSWERS'); ?>"	class="inputbox span12 col-md-12" placeholder="<?php echo JText::_('CE_MESSAGE_CANNED_ANSWERS'); ?>"></textarea>
		<input 		id="canned-answer-id" 		name="id" 	type="hidden" value="" />
		<button 	id="canned-asnwer-btn-save"		type="button" class="btn btn-primary"><i class="icon-ok glyphicon glyphicon-ok"></i> <?php echo JText::_('JTOOLBAR_APPLY'); ?></button>
		<button 	id="canned-asnwer-btn-cancel"	type="button" class="btn btn-default"><i class="icon-remove glyphicon glyphicon-remove"></i><?php echo JText::_('JCANCEL'); ?></button>
	</div>
</div>