<?php
/**
 * @version		1.5.0
 * @package		Joomla
 * @subpackage	Doc Indexer
 * @author  Tuan Pham Ngoc
 * @copyright	Copyright (C) 2010 Ossolution Team
 * @license		GNU/GPL, see LICENSE.php
 */
// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die( 'Restricted access' );
/**
 * Doc Indexer controller
 *
 * @package		Joomla
 * @subpackage	Doc Indexer
 * @since 1.5
 */
class DocIndexerController extends JControllerLegacy
{
	/**
	 * Constructor function
	 *
	 * @param array $config
	 */
	function __construct($config = array())
	{
		parent::__construct($config);	
					
		$this->registerTask('re_index_all', 'save_index');
	}
	/**
	 * Display information
	 *
	 */
	function display( )
	{	
		$task = $this->getTask();		
		switch ($task) {											
			case 'add_doc':
				JRequest::setVar( 'hidemainmenu', 1 );				
				JRequest::setVar( 'view'  , 'doc');
				JRequest::setVar( 'edit', false );
				break;	
			case 'edit_doc':
				JRequest::setVar( 'hidemainmenu', 1 );				
				JRequest::setVar( 'view'  , 'doc');
				JRequest::setVar( 'edit', true );
				break;	
			case 'show_fields':
				JRequest::setVar('view', 'fields') ;				
				break ;
			case 'new_index' :
				JRequest::setVar( 'hidemainmenu', 1 );
				JRequest::setVar('view', 'index');
				JRequest::setVar( 'edit', false );
				break ;
			case 'index_new_docs' :
				JRequest::setVar( 'hidemainmenu', 1 );
				JRequest::setVar('view', 'index');
				JRequest::setVar('layout', 'reindex');
				JRequest::setVar( 'edit', false );	
			case 're_index' :
				JRequest::setVar( 'hidemainmenu', 1 );
				JRequest::setVar('view', 'index');
				JRequest::setVar('layout', 'reindex');
				JRequest::setVar( 'edit', false );	
			case 'edit_index' :
				JRequest::setVar( 'hidemainmenu', 1 );
				JRequest::setVar('view', 'index');
				JRequest::setVar( 'edit', true );
				break ;		
			case 'save_index' :
				JRequest::setVar('view', 'index') ;
				JRequest::setVar('layout', 'ajax') ;
				break ;													
			default:				
				$view = JRequest::getVar('view', '');
				if (!$view) {
					JRequest::setVar('view', 'docs') ;	
				}							
				break;					 	 
		}
		
		if (version_compare(JVERSION, '1.6.0', 'ge')) {
			DocIndexerHelper::addSubmenus(JRequest::getVar('view', 'docs'));
		}
		
		parent::display();
	}
	/**
	 * Save configuration data into database table
	 *
	 */	
	function save_configuration() {						
		$data = array();
		$configKeys = array('documents_path',
							'integration' ,	
							'allowed_file_types'							
					);
		for ($i = 0 , $n = count($configKeys); $i < $n; $i++) {
			$key = $configKeys[$i];
			$data[$key] = $_POST[$key];
		}		
		$model = & $this->getModel('configuration');
		$ret = $model->store($data);
		if ($ret) {
			$msg = JText::_('Configuration data saved');
		} else {
			$msg =  JText::_('Error saving configuration data');
		}
		$this->setRedirect('index.php?option=com_docindexer&view=configuration', $msg);
	}		
	/**
	 * Save the indexing
	 *
	 */	
	function save_index() {
		jimport('joomla.filesystem.folder') ;		
		$deleteOld = JRequest::getVar('delete_old', 0) ;
		if ($deleteOld) {
			$db = & JFactory::getDBO();
			$sql = 'DELETE FROM #__dix_docs';
			$db->setQuery($sql) ;
			$db->query();
		}
		$post = JRequest::get('post') ;
		$model = & $this->getModel('index') ;
		$ret = $model->index($post);
		if ($ret) {
			 $this->display();
		} else {
			$mainframe = & JFactory::getApplication() ;
			$mainframe->redirect('index.php?option=com_docindexer&view=docs', JText::_('Documents successfully indexed'));	
		}
	}
	/**
	 * Remove selected documents
	 *
	 */
	function remove_documents() {
		$cid = JRequest::getVar('cid', array()) ;
		JArrayHelper::toInteger($cid);
		$model = & $this->getModel('doc') ;
		$ret = $model->delete($cid);
		if ($ret) {
			$msg = JText::_('The selected documents successfully removed') ;		
		} else {
			$msg = JText::_('Error removing documents') ;
		}
		$this->setRedirect('index.php?option=com_docindexer&view=docs', $msg);
	}
	/**
	 * Storing a doc
	 *
	 */
	function save_doc() {
		$post = JRequest::get('post');
		$cid = JRequest::getVar('cid', array());
		$post['id'] = (int) $cid[0];		
		$model = & $this->getModel('doc');
		$ret = $model->store($post);		
		if ($ret)
			$msg = JText::_('Document record saved');
		else
			$msg = JText::_('Error saving document record');
		$this->setRedirect('index.php?option=com_docindexer&view=docs', $msg);	
	}
	/**
	 * Remove selected docs from database
	 *
	 */
	function remove() {
		$cid = JRequest::getVar('cid', array(), 'post');
		JArrayHelper::toInteger($cid);
		$model = & $this->getModel('doc');
		$ret = $model->delete($cid);
		if ($ret) 
			$msg = JText::_('Document records removed');
		else
			$msg = JText::_('Error saving document');		
		$this->setRedirect('index.php?option=com_docindexer&view=docs', $msg);
	}	
	/**
	 * Publish selected documents
	 *
	 */
	function publish() {
		$cid = JRequest::getVar('cid', array(), 'post');
		JArrayHelper::toInteger($cid);		
		$model = & $this->getModel('doc');
		$model->publish($cid , 1);
		$msg = JText::_('Documents successfully published');
		$url = 'index.php?option=com_docindexer&view=docs';
		$this->setRedirect($url, $msg);
	}			
	/**
	 * Unpublish selected documents
	 *
	 */
	function unpublish() {
		$cid = JRequest::getVar('cid', array(), 'post');
		JArrayHelper::toInteger($cid);
		$model = & $this->getModel('doc');
		$model->publish($cid , 0);
		$msg = JText::_('Documents successfully unpublished');
		$url = 'index.php?option=com_docindexer&view=docs';
		$this->setRedirect($url, $msg);
	}	

	public function upgrade()
	{
		require_once JPATH_COMPONENT.'/install.docindexer.php';
		com_install();
	}
}