<?php
/*-------------------------------------------------------------------------
# com_improved_ajax_login - com_improved_ajax_login
# -------------------------------------------------------------------------
# @ author    Balint Polgarfi
# @ copyright Copyright (C) 2013 Offlajn.com  All Rights Reserved.
# @ license   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# @ website   http://www.offlajn.com
-------------------------------------------------------------------------*/
?>
JBackend = true;
JURI = "<?php echo JURI::root() ?>";
Theme = "<?php echo $this->theme ?>";
PredefinedElems = {
  // Default fields
  title: {
    type: {value: "header", predefined: "title",
      readonly: true, button: "Title", icon: "icon-quote icon-font"},
    wide: {checked: true},
    "class": {value: ""},
    label: {value: "", defaultValue: "MOD_LOGIN_REGISTER",
      placeholder: "<?php echo addslashes(JText::_('MOD_LOGIN_REGISTER')) ?>"},
    subtitle: {value: "", defaultValue: "COM_USERS_REGISTER_REQUIRED",
      placeholder: "<?php echo addslashes(JText::_('COM_USERS_REGISTER_REQUIRED')) ?>"}
  },
  name: {
    type: {value: "textfield", defaultValue: "text", predefined: "name",
      readonly: true, button: "Name", icon: "icon-user"},
    required: {checked: true, disabled: false},
    wide: {checked: false},
    "class": {value: "ial-name"},
    name: {value: "name", readonly: true},
    prefix: {value: "jform"},
    label: {value: "", defaultValue: "COM_USERS_REGISTER_NAME_LABEL",
      placeholder: "<?php echo addslashes(JText::_('COM_USERS_REGISTER_NAME_LABEL'))?>"},
    placeholder: {value: "", placeholder: ""},
    title: {value: "", defaultValue: "COM_USERS_REGISTER_NAME_DESC",
      placeholder: "<?php echo addslashes(JText::_('COM_USERS_REGISTER_NAME_DESC'))?>"},
    pattern: {value: ""},
    error: {value: "", defaultValue: "JLIB_FORM_VALIDATE_FIELD_INVALID",
      placeholder: "<?php echo addslashes(JText::sprintf('JLIB_FORM_VALIDATE_FIELD_INVALID', ''))?>"}
  },
  username: {
    type: {value: "textfield", defaultValue: "text", predefined: "username",
      readonly: true, button: "Username", icon: "icon-user"},
    required: {checked: true, disabled: true},
    wide: {checked: false},
    "class": {value: "ial-username"},
    name: {value: "username", readonly: true},
    prefix: {value: "jform"},
    label: {value: "", defaultValue: "COM_USERS_REGISTER_USERNAME_LABEL",
      placeholder: "<?php echo addslashes(JText::_('COM_USERS_REGISTER_USERNAME_LABEL'))?>"},
    placeholder: {value: "", placeholder: ""},
    title: {value: "", defaultValue: "COM_USERS_REGISTER_USERNAME_DESC",
      placeholder: "<?php echo addslashes(JText::_('COM_USERS_REGISTER_USERNAME_DESC'))?>"},
    error: {value: "", defaultValue: "JLIB_DATABASE_ERROR_VALID_AZ09",
      placeholder: "<?php echo addslashes(@JText::sprintf('JLIB_DATABASE_ERROR_VALID_AZ09', 2))?>"},
    pattern: {value: "^[^<>\\\\&%'\";\\(\\)]{2,}$", placeholder: "^[^<>\\\\&%'\";\\(\\)]{2,}$"},
    ajax: "username"
  },
  password1: {
    type: {value: "password1", defaultValue: "password", predefined: "password1",
      readonly: true, button: "Password", icon: "icon-lock"},
    required: {checked: true, disabled: true},
    wide: {checked: false},
    "class": {value: "ial-password1"},
    name: {value: "password1", readonly: true},
    prefix: {value: "jform"},
    label: {value: "", defaultValue: "COM_USERS_REGISTER_PASSWORD1_LABEL",
      placeholder: "<?php echo addslashes(JText::_('COM_USERS_REGISTER_PASSWORD1_LABEL'))?>"},
    placeholder: {value: "", placeholder: ""},
    title: {value: "", defaultValue: "COM_USERS_DESIRED_PASSWORD",
      placeholder: "<?php echo addslashes(JText::_('COM_USERS_DESIRED_PASSWORD'))?>"},
    error: {value: "", defaultValue: "JLIB_FORM_VALIDATE_FIELD_INVALID",
      placeholder: "<?php echo addslashes(JText::sprintf('JLIB_FORM_VALIDATE_FIELD_INVALID', ''))?>"}
  },
  password2: {
    type: {value: "password2", defaultValue: "password", predefined: "password2",
      readonly: true, button: "Password again", icon: "icon-lock"},
    required: {checked: true, disabled: true},
    wide: {checked: false},
    "class": {value: "ial-password2"},
    name: {value: "password2", readonly: true},
    prefix: {value: "jform"},
    label: {value: "", defaultValue: "COM_USERS_REGISTER_PASSWORD2_LABEL",
      placeholder: "<?php echo addslashes(JText::_('COM_USERS_REGISTER_PASSWORD2_LABEL'))?>"},
    placeholder: {value: "", placeholder: ""},
    title: {value: "", defaultValue: "COM_USERS_REGISTER_PASSWORD2_DESC",
      placeholder: "<?php echo addslashes(JText::_('COM_USERS_REGISTER_PASSWORD2_DESC'))?>"},
    error: {value: "", defaultValue: "COM_USERS_REGISTER_PASSWORD1_MESSAGE",
      placeholder: "<?php echo addslashes(JText::_('COM_USERS_REGISTER_PASSWORD1_MESSAGE'))?>"}
  },
  email: {
    type: {value: "textfield", defaultValue: "text", predefined: "email",
      readonly: true, button: "Email", icon: "icon-mail-2 icon-envelope"},
    required: {checked: true, disabled: true},
    wide: {checked: false},
    "class": {value: "ial-email1"},
    name: {value: "email1", readonly: true},
    prefix: {value: "jform"},
    label: {value: "", defaultValue: "COM_USERS_REGISTER_EMAIL1_LABEL",
      placeholder: "<?php echo addslashes(JText::_('COM_USERS_REGISTER_EMAIL1_LABEL'))?>"},
    placeholder: {value: "", placeholder: ""},
    title: {value: "", defaultValue: "COM_USERS_REGISTER_EMAIL1_DESC",
      placeholder: "<?php echo addslashes(JText::_('COM_USERS_REGISTER_EMAIL1_DESC'))?>"},
    error: {value: "", defaultValue: "COM_USERS_INVALID_EMAIL",
      placeholder: "<?php echo addslashes(JText::_('COM_USERS_INVALID_EMAIL'))?>"},
    pattern: {value: "^([\\w0-9\\.\\-])+\\@(([a-zA-Z0-9\\-])+\\.)+[a-zA-Z]{2,4}$",
      placeholder: "^([\\w0-9\\.\\-])+\\@(([a-zA-Z0-9\\-])+\\.)+[a-zA-Z]{2,4}$"},
    ajax: "email"
  },
  email2: {
    type: {value: "textfield", defaultValue: "text", predefined: "email2",
      readonly: true, button: "Email again", icon: "icon-mail-2 icon-envelope"},
    required: {checked: true, disabled: true},
    wide: {checked: false},
    "class": {value: "ial-email2"},
    name: {value: "email2", readonly: true},
    prefix: {value: "jform"},
    label: {value: "", defaultValue: "COM_USERS_REGISTER_EMAIL2_LABEL",
      placeholder: "<?php echo addslashes(JText::_('COM_USERS_REGISTER_EMAIL2_LABEL'))?>"},
    placeholder: {value: "", placeholder: ""},
    title: {value: "", defaultValue: "COM_USERS_REGISTER_EMAIL2_DESC",
      placeholder: "<?php echo addslashes(JText::_('COM_USERS_REGISTER_EMAIL2_DESC'))?>"},
    error: {value: "", defaultValue: "COM_USERS_REGISTER_EMAIL2_MESSAGE",
      placeholder: "<?php echo addslashes(JText::_('COM_USERS_REGISTER_EMAIL2_MESSAGE'))?>"}
  },
  captcha: {
    type: {value: "captcha", predefined: "captcha",
      readonly: true, button: "Captcha image", icon: "icon-picture"},
    "class": {value: ""},
    wide: {checked: true}
  },
  captcha2: {
    type: {value: "textfield", defaultValue: "text", predefined: "captcha2",
      readonly: true, button: "Captcha textfield", icon: "icon-pencil"},
    required: {checked: true, disabled: true},
    clear: {checked: false},
    wide: {checked: false},
    "class": {value: "ial-captcha"},
    name: {value: "recaptcha_response_field", readonly: true},
    prefix: {value: ""},
    label: {value: "", defaultValue: "COM_USERS_CAPTCHA_LABEL",
      placeholder: "<?php echo addslashes(JText::_('COM_USERS_CAPTCHA_LABEL'))?>:"},
    placeholder: {value: "", placeholder: ""},
    title: {value: "", defaultValue: "COM_USERS_CAPTCHA_DESC",
      placeholder: "<?php echo addslashes(JText::_('COM_USERS_CAPTCHA_DESC'))?>"},
    error: {value: "", defaultValue: "JLIB_FORM_VALIDATE_FIELD_INVALID",
      placeholder: "<?php echo addslashes(JText::sprintf('JLIB_FORM_VALIDATE_FIELD_INVALID', ''))?>"},
    pattern: {value: "", placeholder: ""},
    autoCompOff: true
  },
  submit: {
    type: {value: "button", predefined: "submit",
      readonly: true, button: "Submit", icon: "icon-arrow-right"},
    wide: {checked: false},
    "class": {value: ""},
    label: {value: "", defaultValue: "JREGISTER",
      placeholder: "<?php echo JText::_('JREGISTER') ?>"},
    subtitle: {value: "&nbsp", placeholder:""}
  },
  // Profile fields
  address1: {
    type: {profile: 1, value: "textfield", defaultValue: "text", predefined: "address1",
      readonly: true, button: "Address 1", icon: "icon-address icon-home"},
    required: {checked: false, disabled: false},
    wide: {checked: false},
    "class": {value: "ial-address1"},
    name: {value: "address1", readonly: true},
    prefix: {value: "jform[improved]"},
    label: {value: "", defaultValue: "PLG_USER_PROFILE_FIELD_ADDRESS1_LABEL",
      placeholder: "<?php echo addslashes(JText::_('PLG_USER_PROFILE_FIELD_ADDRESS1_LABEL'))?>"},
    placeholder: {value: "", placeholder: ""},
    title: {value: "", defaultValue: "PLG_USER_PROFILE_FIELD_ADDRESS1_DESC",
      placeholder: "<?php echo addslashes(JText::_('PLG_USER_PROFILE_FIELD_ADDRESS1_DESC'))?>"},
    pattern: {value: ""},
    error: {value: "", defaultValue: "JLIB_FORM_VALIDATE_FIELD_INVALID",
      placeholder: "<?php echo addslashes(JText::sprintf('JLIB_FORM_VALIDATE_FIELD_INVALID', ''))?>"}
  },
  address2: {
    type: {profile: 1, value: "textfield", defaultValue: "text", predefined: "address2",
      readonly: true, button: "Address 2", icon: "icon-address icon-home"},
    required: {checked: false, disabled: false},
    wide: {checked: false},
    "class": {value: "ial-address2"},
    name: {value: "address2", readonly: true},
    prefix: {value: "jform[improved]"},
    label: {value: "", defaultValue: "PLG_USER_PROFILE_FIELD_ADDRESS2_LABEL",
      placeholder: "<?php echo addslashes(JText::_('PLG_USER_PROFILE_FIELD_ADDRESS2_LABEL'))?>"},
    placeholder: {value: "", placeholder: ""},
    title: {value: "", defaultValue: "PLG_USER_PROFILE_FIELD_ADDRESS2_DESC",
      placeholder: "<?php echo addslashes(JText::_('PLG_USER_PROFILE_FIELD_ADDRESS2_DESC'))?>"},
    pattern: {value: ""},
    error: {value: "", defaultValue: "JLIB_FORM_VALIDATE_FIELD_INVALID",
      placeholder: "<?php echo addslashes(JText::sprintf('JLIB_FORM_VALIDATE_FIELD_INVALID', ''))?>"}
  },
  city: {
    type: {profile: 1, value: "textfield", defaultValue: "text", predefined: "city",
      readonly: true, button: "City", icon: "icon-location icon-map-marker"},
    required: {checked: false, disabled: false},
    wide: {checked: false},
    "class": {value: "ial-city"},
    name: {value: "city", readonly: true},
    prefix: {value: "jform[improved]"},
    label: {value: "", defaultValue: "PLG_USER_PROFILE_FIELD_CITY_LABEL",
      placeholder: "<?php echo addslashes(JText::_('PLG_USER_PROFILE_FIELD_CITY_LABEL'))?>"},
    placeholder: {value: "", placeholder: ""},
    title: {value: "", defaultValue: "PLG_USER_PROFILE_FIELD_CITY_DESC",
      placeholder: "<?php echo addslashes(JText::_('PLG_USER_PROFILE_FIELD_CITY_DESC'))?>"},
    pattern: {value: ""},
    error: {value: "", defaultValue: "JLIB_FORM_VALIDATE_FIELD_INVALID",
      placeholder: "<?php echo addslashes(JText::sprintf('JLIB_FORM_VALIDATE_FIELD_INVALID', ''))?>"}
  },
  region: {
    type: {profile: 1, value: "textfield", defaultValue: "text", predefined: "region",
      readonly: true, button: "Region", icon: "icon-location icon-map-marker"},
    required: {checked: false, disabled: false},
    wide: {checked: false},
    "class": {value: "ial-region"},
    name: {value: "region", readonly: true},
    prefix: {value: "jform[improved]"},
    label: {value: "", defaultValue: "PLG_USER_PROFILE_FIELD_REGION_LABEL",
      placeholder: "<?php echo addslashes(JText::_('PLG_USER_PROFILE_FIELD_REGION_LABEL'))?>"},
    placeholder: {value: "", placeholder: ""},
    title: {value: "", defaultValue: "PLG_USER_PROFILE_FIELD_REGION_DESC",
      placeholder: "<?php echo addslashes(JText::_('PLG_USER_PROFILE_FIELD_REGION_DESC'))?>"},
    pattern: {value: ""},
    error: {value: "", defaultValue: "JLIB_FORM_VALIDATE_FIELD_INVALID",
      placeholder: "<?php echo addslashes(JText::sprintf('JLIB_FORM_VALIDATE_FIELD_INVALID', ''))?>"}
  },
  country: {
    type: {profile: 1, value: "textfield", defaultValue: "text", predefined: "country",
      readonly: true, button: "Country", icon: "icon-flag"},
    required: {checked: false, disabled: false},
    wide: {checked: false},
    "class": {value: "ial-country"},
    name: {value: "country", readonly: true},
    prefix: {value: "jform[improved]"},
    label: {value: "", defaultValue: "PLG_USER_PROFILE_FIELD_COUNTRY_LABEL",
      placeholder: "<?php echo addslashes(JText::_('PLG_USER_PROFILE_FIELD_COUNTRY_LABEL'))?>"},
    placeholder: {value: "", placeholder: ""},
    title: {value: "", defaultValue: "PLG_USER_PROFILE_FIELD_COUNTRY_DESC",
      placeholder: "<?php echo addslashes(JText::_('PLG_USER_PROFILE_FIELD_COUNTRY_DESC'))?>"},
    pattern: {value: ""},
    error: {value: "", defaultValue: "JLIB_FORM_VALIDATE_FIELD_INVALID",
      placeholder: "<?php echo addslashes(JText::sprintf('JLIB_FORM_VALIDATE_FIELD_INVALID', ''))?>"}
  },
  postalcode: {
    type: {profile: 1, value: "textfield", defaultValue: "text", predefined: "postalcode",
      readonly: true, button: "Postal / ZIP Code", icon: "icon-location icon-map-marker"},
    required: {checked: false, disabled: false},
    wide: {checked: false},
    "class": {value: "ial-postal_code"},
    name: {value: "postal_code", readonly: true},
    prefix: {value: "jform[improved]"},
    label: {value: "", defaultValue: "PLG_USER_PROFILE_FIELD_POSTAL_CODE_LABEL",
      placeholder: "<?php echo addslashes(JText::_('PLG_USER_PROFILE_FIELD_POSTAL_CODE_LABEL'))?>"},
    placeholder: {value: "", placeholder: ""},
    title: {value: "", defaultValue: "PLG_USER_PROFILE_FIELD_POSTAL_CODE_DESC",
      placeholder: "<?php echo addslashes(JText::_('PLG_USER_PROFILE_FIELD_POSTAL_CODE_DESC'))?>"},
    pattern: {value: ""},
    error: {value: "", defaultValue: "JLIB_FORM_VALIDATE_FIELD_INVALID",
      placeholder: "<?php echo addslashes(JText::sprintf('JLIB_FORM_VALIDATE_FIELD_INVALID', ''))?>"}
  },
  phone: {
    type: {profile: 1, value: "textfield", defaultValue: "text", predefined: "phone",
      readonly: true, button: "Phone", icon: "icon-mobile icon-bell"},
    required: {checked: false, disabled: false},
    wide: {checked: false},
    "class": {value: "ial-phone"},
    name: {value: "phone", readonly: true},
    prefix: {value: "jform[improved]"},
    label: {value: "", defaultValue: "PLG_USER_PROFILE_FIELD_PHONE_LABEL",
      placeholder: "<?php echo addslashes(JText::_('PLG_USER_PROFILE_FIELD_PHONE_LABEL'))?>"},
    placeholder: {value: "", placeholder: ""},
    title: {value: "", defaultValue: "PLG_USER_PROFILE_FIELD_PHONE_DESC",
      placeholder: "<?php echo addslashes(JText::_('PLG_USER_PROFILE_FIELD_PHONE_DESC'))?>"},
    pattern: {value: ""},
    error: {value: "", defaultValue: "JLIB_FORM_VALIDATE_FIELD_INVALID",
      placeholder: "<?php echo addslashes(JText::sprintf('JLIB_FORM_VALIDATE_FIELD_INVALID', ''))?>"}
  },
  website: {
    type: {profile: 1, value: "textfield", defaultValue: "text", predefined: "website",
      readonly: true, button: "Website", icon: "icon-file"},
    required: {checked: false, disabled: false},
    wide: {checked: false},
    "class": {value: "ial-website"},
    name: {value: "website", readonly: true},
    prefix: {value: "jform[improved]"},
    label: {value: "", defaultValue: "PLG_USER_PROFILE_FIELD_WEB_SITE_LABEL",
      placeholder: "<?php echo addslashes(JText::_('PLG_USER_PROFILE_FIELD_WEB_SITE_LABEL'))?>"},
    placeholder: {value: "", placeholder: ""},
    value: {value: "http://"},
    title: {value: "", defaultValue: "PLG_USER_PROFILE_FIELD_WEB_SITE_DESC",
      placeholder: "<?php echo addslashes(JText::_('PLG_USER_PROFILE_FIELD_WEB_SITE_DESC'))?>"},
    pattern: {value: ""},
    error: {value: "", defaultValue: "JLIB_FORM_VALIDATE_FIELD_INVALID",
      placeholder: "<?php echo addslashes(JText::sprintf('JLIB_FORM_VALIDATE_FIELD_INVALID', ''))?>"}
  },
  favoritebook: {
    type: {profile: 1, value: "textfield", defaultValue: "text", predefined: "favoritebook",
      readonly: true, button: "Favorite Book", icon: "icon-star-empty"},
    required: {checked: false, disabled: false},
    wide: {checked: false},
    "class": {value: "ial-favoritebook"},
    name: {value: "favoritebook", readonly: true},
    prefix: {value: "jform[improved]"},
    label: {value: "", defaultValue: "PLG_USER_PROFILE_FIELD_FAVORITE_BOOK_LABEL",
      placeholder: "<?php echo addslashes(JText::_('PLG_USER_PROFILE_FIELD_FAVORITE_BOOK_LABEL'))?>"},
    placeholder: {value: "", placeholder: ""},
    title: {value: "", defaultValue: "PLG_USER_PROFILE_FIELD_FAVORITE_BOOK_DESC",
      placeholder: "<?php echo addslashes(JText::_('PLG_USER_PROFILE_FIELD_FAVORITE_BOOK_DESC'))?>"},
    pattern: {value: ""},
    error: {value: "", defaultValue: "JLIB_FORM_VALIDATE_FIELD_INVALID",
      placeholder: "<?php echo addslashes(JText::sprintf('JLIB_FORM_VALIDATE_FIELD_INVALID', ''))?>"}
  },
  aboutme: {
    type: {profile: 1, value: "textarea", predefined: "aboutme",
      readonly: true, button: "About me", icon: "icon-comment"},
    required: {checked: false, disabled: false},
    wide: {checked: false},
    "class": {value: "ial-aboutme"},
    name: {value: "aboutme", readonly: true},
    prefix: {value: "jform[improved]"},
    label: {value: "", defaultValue: "PLG_USER_PROFILE_FIELD_ABOUT_ME_LABEL",
      placeholder: "<?php echo addslashes(JText::_('PLG_USER_PROFILE_FIELD_ABOUT_ME_LABEL'))?>"},
    placeholder: {value: "", placeholder: ""},
    title: {value: "", defaultValue: "PLG_USER_PROFILE_FIELD_ABOUT_ME_DESC",
      placeholder: "<?php echo addslashes(JText::_('PLG_USER_PROFILE_FIELD_ABOUT_ME_DESC'))?>"},
    pattern: {value: ""},
    error: {value: "", defaultValue: "JLIB_FORM_VALIDATE_FIELD_INVALID",
      placeholder: "<?php echo addslashes(JText::sprintf('JLIB_FORM_VALIDATE_FIELD_INVALID', ''))?>"}
  },
  dob: {
    type: {profile: 1, value: "textfield", defaultValue: "text", predefined: "dob",
      readonly: true, button: "Date of birth", icon: "icon-calendar"},
    required: {checked: false, disabled: false},
    wide: {checked: false},
    "class": {value: "ial-dob"},
    name: {value: "dob", readonly: true},
    prefix: {value: "jform[improved]"},
    label: {value: "", defaultValue: "PLG_USER_PROFILE_FIELD_DOB_LABEL",
      placeholder: "<?php echo addslashes(JText::_('PLG_USER_PROFILE_FIELD_DOB_LABEL'))?>"},
    placeholder: {value: "", placeholder: "YYYY-MM-DD", defaultValue: "YYYY-MM-DD"},
    title: {value: "", defaultValue: "PLG_USER_PROFILE_FIELD_DOB_DESC",
      placeholder: "<?php echo addslashes(JText::_('PLG_USER_PROFILE_FIELD_DOB_DESC'))?>"},
    pattern: {value: "", placeholder: "^\\d{4}\\-\\d\\d\\-\\d\\d$"},
    error: {value: "", defaultValue: "JLIB_FORM_VALIDATE_FIELD_INVALID",
      placeholder: "<?php echo addslashes(JText::sprintf('JLIB_FORM_VALIDATE_FIELD_INVALID', ''))?>"}
  },
  tos: {
    type: {profile: 1, value: "tos", predefined: "tos",
      readonly: true, button: "Terms of services", icon: "icon-checkbox icon-ok-circle"},
    required: {checked: true, disabled: true},
    checked: {checked: false, disabled: true},
    wide: {checked: false},
    "class": {value: "ial-tos"},
    name: {value: "tos", readonly: true},
    prefix: {value: "jform[improved]"},
    label: {value: "", defaultValue: "PLG_USER_PROFILE_OPTION_AGREE",
      placeholder: "<?php echo addslashes(JText::_('PLG_USER_PROFILE_OPTION_AGREE'))?>"},
    title: {value: "", defaultValue: "PLG_USER_PROFILE_FIELD_TOS_DESC",
      placeholder: "<?php echo addslashes(JText::_('PLG_USER_PROFILE_FIELD_TOS_DESC'))?>"},
    article: {value: ""},
    article_name: {value: "", placeholder: "Select article for TOS"}
  },
  // Custom fields
  header: {
    type: {value: "header", readonly: true, button: "Header", icon: "icon-quote icon-font"},
    wide: {checked: true},
    "class": {value: ""},
    label: {value: "", placeholder: "Header text"},
    subtitle: {value: "", placeholder: ""}
  },
  label: {
    type: {value: "label", readonly: true, button: "Label", icon: "icon-quote icon-align-justify"},
    wide: {checked: false},
    "class": {value: ""},
    label: {value: "", placeholder: "Label text"}
  },
  textfield: {
    type: {profile: 1, value: "textfield", defaultValue: "text",
      readonly: true, button: "Textfield", icon: "icon-pencil"},
    required: {checked: false, disabled: false},
    wide: {checked: false},
    "class": {value: ""},
    name: {value: "", placeholder: "textfield", readonly: false},
    prefix: {value: "jform[improved]"},
    label: {value: "", placeholder: "Textfield:"},
    value: {value: ""},
    placeholder: {value: "", placeholder: ""},
    title: {value: "", placeholder: ""},
    error: {value: "", defaultValue: "JLIB_FORM_VALIDATE_FIELD_INVALID",
      placeholder: "<?php echo addslashes(JText::sprintf('JLIB_FORM_VALIDATE_FIELD_INVALID', ''))?>"},
    pattern: {value: ""}
  },
  password: {
    type: {value: "password2", defaultValue: "password",
      readonly: true, button: "Password", icon: "icon-lock"},
    required: {checked: true, disabled: false},
    wide: {checked: false},
    "class": {value: ""},
    name: {value: "", placeholder: "password", readonly: false},
    prefix: {value: "jform[improved]"},
    label: {value: "", placeholder: "Secret:"},
    placeholder: {value: "", placeholder: ""},
    title: {value: "", placeholder: ""},
    error: {value: "", defaultValue: "JLIB_FORM_VALIDATE_FIELD_INVALID",
      placeholder: "<?php echo addslashes(JText::sprintf('JLIB_FORM_VALIDATE_FIELD_INVALID', ''))?>"},
    pattern: {value: ""},
  },
  textarea: {
    type: {profile: 1, value: "textarea", readonly: true, button: "Textarea", icon: "icon-pencil-2 icon-pencil"},
    required: {checked: false, disabled: false},
    wide: {checked: false},
    "class": {value: ""},
    name: {value: "", placeholder: "textarea", readonly: false},
    prefix: {value: "jform[improved]"},
    label: {value: "", placeholder: "Textarea:"},
    value: {value: ""},
    placeholder: {value: "", placeholder: ""},
    title: {value: "", placeholder: ""},
    error: {value: "", defaultValue: "JLIB_FORM_VALIDATE_FIELD_INVALID",
      placeholder: "<?php echo addslashes(JText::sprintf('JLIB_FORM_VALIDATE_FIELD_INVALID', ''))?>"},
    pattern: {value: ""}
  },
  checkbox: {
    type: {profile: 1, value: "checkbox", readonly: true, button: "Checkbox", icon: "icon-checkbox icon-ok-circle"},
    required: {checked: false, disabled: false},
    checked: {checked: false, disabled: false},
    wide: {checked: false},
    "class": {value: "checkbox"},
    value: {defaultValue: "JYes", placeholder: "Yes", value: ""},    
    name: {value: "", placeholder: "checkbox", readonly: false},
    prefix: {value: "jform[improved]"},
    label: {value: "", placeholder: "Checkbox"},
    title: {value: "", placeholder: ""}
  },
  article: {
    type: {profile: 1, value: "tos", readonly: true, button: "Agree", icon: "icon-checkbox icon-ok-circle"},
    required: {checked: true, disabled: false},
    checked: {checked: false, disabled: false},
    wide: {checked: false},
    "class": {value: ""},
    name: {value: "", placeholder: "<?php echo addslashes(JText::_('PLG_USER_PROFILE_OPTION_AGREE'))?>", readonly: false},
    prefix: {value: "jform[improved]"},
    label: {value: "", defaultValue: "PLG_USER_PROFILE_OPTION_AGREE",
      placeholder: "<?php echo addslashes(JText::_('PLG_USER_PROFILE_OPTION_AGREE'))?>"},
    title: {value: "", defaultValue: "", placeholder: ""},
    article: {value: ""},
    article_name: {value: "", placeholder: "Select an Article"}
  },
  select: {
    type: {profile: 1, value: "select", readonly: true, button: "Select", icon: "icon-chevron-down"},
    required: {checked: false, disabled: false},
    wide: {checked: false},
    "class": {value: ""},
    name: {value: "", placeholder: "select", readonly: false},
    prefix: {value: "jform[improved]"},
    label: {value: "", placeholder: "Select:"},
    select: {value: ""},
    title: {value: "", placeholder: ""}
  },
  mailchimp: {
    type: {value: "checkbox", readonly: true, predefined: "mailchimp",
      button: "MailChimp", icon: "icon-mail-2 icon-envelope"},
    required: {checked: false, disabled: false},
    checked: {checked: true, disabled: false},
    wide: {checked: false},
    "class": {value: "ial-newsletter"},
    name: {value: "newsletter", readonly: true},
    prefix: {value: ""},
    label: {value: "", placeholder: "Sign up to our newsletter"},
    title: {value: "", placeholder: ""}
  }
};