<?php
/*-------------------------------------------------------------------------
# com_improved_ajax_login - com_improved_ajax_login
# -------------------------------------------------------------------------
# @ author    Balint Polgarfi
# @ copyright Copyright (C) 2013 Offlajn.com  All Rights Reserved.
# @ license   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# @ website   http://www.offlajn.com
-------------------------------------------------------------------------*/
?><?php
defined('_JEXEC') or die;

is_dir(JPATH_ADMINISTRATOR.'/components/com_virtuemart') or die('</script>VirtueMart is not installed!');

JFactory::getLanguage()->load('com_virtuemart');
$db = JFactory::getDBO();
$db->setQuery("SELECT * FROM #__virtuemart_userfields WHERE registration = 1 AND published = 1 AND virtuemart_userfield_id > 6 ORDER BY ordering");
$flds = $db->loadObjectList();

$name = array( 'value' => '', 'readonly' => false );
$empty = array( 'value' => '' );
$empty2 = array( 'value' => '', 'placeholder' => '' );
$prefix = array( 'value' => '' );
$pattern = array( 'value' => '', 'placeholder' => '' );
$checked = array( 'checked' => false );
$required = array( 'checked' => false, 'disabled' => false );

$custom = array(
  'header' => array(
    'type' => array( 'value' => 'header', 'readonly' => true, 'button' => 'Header', 'icon' => 'icon-quote icon-font' ),
    'wide' => array( 'checked' => true),
    'class' => $empty,
    'label' => array( 'value' => '', 'placeholder' => 'Header text' ),
    'subtitle' => $empty2,
  ),
  'label' => array(
    'type' => array( 'value' => 'label', 'readonly' => true, 'button' => 'Label', 'icon' => 'icon-quote icon-align-justify' ),
    'wide' => $checked,
    'class' => $empty,
    'label' => array( 'value' => '', 'placeholder' => 'Label text' ),
  ),
  'textfield' => array(
    'type' => array( 'value' => 'textfield', 'defaultValue' => 'text', 'readonly' => true, 'button' => 'Textfield', 'icon' => 'icon-pencil' ),
    'required' => $required,
    'wide' => $checked,
    'class' => $empty,
    'name' => $name,
    'prefix' => $prefix,
    'label' => array( 'value' => '', 'placeholder' => 'Textfield:' ),
    'value' => $empty,
    'placeholder' => $empty2,
    'title' => $empty2,
    'error' => $empty2,
    'pattern' => $pattern,
  ),
  'email' => array(
    'type' => array( 'value' => 'textfield', 'defaultValue' => 'text', 'readonly' => true, 'button' => 'Email', 'icon' => 'icon-mail-2 icon-envelope' ),
    'required' => $required,
    'wide' => $checked,
    'class' => $empty,
    'name' => $name,
    'prefix' => $prefix,
    'label' => array( 'value' => '', 'placeholder' => 'Email:' ),
    'value' => $empty,
    'placeholder' => $empty2,
    'title' => $empty2,
    'error' => array( 'value' => '', 'defaultValue' => 'COM_USERS_INVALID_EMAIL', 'placeholder' => JText::_('COM_USERS_INVALID_EMAIL') ),
    'pattern' => array( 'value' => '^([\\w0-9\\.\\-])+\\@(([a-zA-Z0-9\\-])+\\.)+[a-zA-Z]{2,4}$', 'placeholder' => '' ),
  ),
  'date' => array(
    'type' => array( 'value' => 'textfield', 'defaultValue' => 'text', 'readonly' => true, 'button' => 'Date', 'icon' => 'icon-calendar' ),
    'required' => $required,
    'wide' => $checked,
    'class' => array( 'value' => 'ial-dob' ),
    'name' => $name,
    'prefix' => $prefix,
    'label' => array( 'value' => '', 'placeholder' => 'Date:' ),
    'value' => $empty,
    'placeholder' => array( 'value' => 'YYYY-MM-DD', 'placeholder' => '' ),
    'title' => $empty2,
    'error' => array( 'value' => '', 'defaultValue' => 'JLIB_FORM_VALIDATE_FIELD_INVALID', 'placeholder' => JText::sprintf('JLIB_FORM_VALIDATE_FIELD_INVALID', '') ),
    'pattern' => array( 'value' => '^\\d{4}\\-\\d\\d\\-\\d\\d$', 'placeholder' => '' ),
  ),
  'password' => array(
    'type' => array( 'value' => 'password2', 'defaultValue' => 'password', 'readonly' => true, 'button' => 'Password', 'icon' => 'icon-lock' ),
    'required' => array( 'checked' => true, 'disabled' => false ),
    'wide' => $checked,
    'class' => $empty,
    'name' => $name,
    'prefix' => $prefix,
    'label' => array( 'value' => '', 'placeholder' => 'Secret:' ),
    'placeholder' => $empty2,
    'title' => $empty2,
    'error' => $empty2,
    'pattern' => $pattern,
  ),
  'textarea' => array(
    'type' => array( 'value' => 'textarea', 'readonly' => true, 'button' => 'Textarea', 'icon' => 'icon-pencil-2 icon-pencil' ),
    'required' => $required,
    'wide' => $checked,
    'class' => $empty,
    'name' => $name,
    'prefix' => $prefix,
    'label' => array( 'value' => '', 'placeholder' => 'Textarea:' ),
    'value' => $empty,
    'placeholder' => $empty2,
    'title' => $empty2,
    'error' => $empty2,
    'pattern' => $pattern,
  ),
  'checkbox' => array(
    'type' => array( 'value' => 'checkbox', 'readonly' => true, 'button' => 'Checkbox', 'icon' => 'icon-checkbox icon-ok-circle' ),
    'required' => $required,
    'checked' => array( 'checked' => false, 'disabled' => false ),
    'wide' => $checked,
    'class' => $empty,
    'name' => $name,
    'prefix' => $prefix,
    'label' => array( 'value' => '', 'placeholder' => 'Label text' ),
    'title' => $empty2,
  ),
  'article' => array(
    'type' => array( 'value' => 'tos', 'readonly' => true, 'button' => 'Agree', 'icon' => 'icon-checkbox icon-ok-circle' ),
    'required' => $required,
    'checked' => array( 'checked' => false, 'disabled' => false ),
    'wide' => $checked,
    'class' => $empty,
    'name' => $name,
    'prefix' => $prefix,
    'label' => array( 'value' => '', 'defaultValue' => 'PLG_USER_PROFILE_OPTION_AGREE', 'placeholder' => '' ),
    'title' => array( 'value' => '', 'defaultValue' => '', 'placeholder' => '' ),
    'article' => $empty,
    'article_name' => array( 'value' => '', 'placeholder' => 'Select an Article' ),
  ),
  'select' => array(
    'type' => array( 'value' => 'select', 'readonly' => true, 'button' => 'Select', 'icon' => 'icon-chevron-down' ),
    'required' => $required,
    'wide' => $checked,
    'class' => $empty,
    'name' => $name,
    'prefix' => $prefix,
    'label' => array( 'value' => '', 'placeholder' => 'Select:' ),
    'select' => $empty,
    'title' => $empty2
  )
);
$custom['website'] = $custom['textfield'];
$custom['website']['value']['value'] = 'http://';
$countries = '[option value=""][/option][option value="1"]Afghanistan[/option][option value="2"]Albania[/option][option value="3"]Algeria[/option][option value="4"]American Samoa[/option][option value="5"]Andorra[/option][option value="6"]Angola[/option][option value="7"]Anguilla[/option][option value="8"]Antarctica[/option][option value="9"]Antigua and Barbuda[/option][option value="10"]Argentina[/option][option value="11"]Armenia[/option][option value="12"]Aruba[/option][option value="13"]Australia[/option][option value="14"]Austria[/option][option value="15"]Azerbaijan[/option][option value="16"]Bahamas[/option][option value="17"]Bahrain[/option][option value="18"]Bangladesh[/option][option value="19"]Barbados[/option][option value="20"]Belarus[/option][option value="21"]Belgium[/option][option value="22"]Belize[/option][option value="23"]Benin[/option][option value="24"]Bermuda[/option][option value="25"]Bhutan[/option][option value="26"]Bolivia[/option][option value="27"]Bosnia and Herzegovina[/option][option value="28"]Botswana[/option][option value="29"]Bouvet Island[/option][option value="30"]Brazil[/option][option value="31"]British Indian Ocean Territory[/option][option value="32"]Brunei Darussalam[/option][option value="33"]Bulgaria[/option][option value="34"]Burkina Faso[/option][option value="35"]Burundi[/option][option value="36"]Cambodia[/option][option value="37"]Cameroon[/option][option value="38"]Canada[/option][option value="244"]Canary Islands[/option][option value="39"]Cape Verde[/option][option value="40"]Cayman Islands[/option][option value="41"]Central African Republic[/option][option value="42"]Chad[/option][option value="43"]Chile[/option][option value="44"]China[/option][option value="45"]Christmas Island[/option][option value="46"]Cocos (Keeling) Islands[/option][option value="47"]Colombia[/option][option value="48"]Comoros[/option][option value="49"]Congo[/option][option value="50"]Cook Islands[/option][option value="51"]Costa Rica[/option][option value="53"]Croatia[/option][option value="54"]Cuba[/option][option value="55"]Cyprus[/option][option value="56"]Czech Republic[/option][option value="52"]Côte d\'Ivoire[/option][option value="57"]Denmark[/option][option value="58"]Djibouti[/option][option value="59"]Dominica[/option][option value="60"]Dominican Republic[/option][option value="240"]East Timor[/option][option value="61"]East Timor[/option][option value="62"]Ecuador[/option][option value="63"]Egypt[/option][option value="64"]El Salvador[/option][option value="65"]Equatorial Guinea[/option][option value="66"]Eritrea[/option][option value="67"]Estonia[/option][option value="68"]Ethiopia[/option][option value="69"]Falkland Islands (Malvinas)[/option][option value="70"]Faroe Islands[/option][option value="71"]Fiji[/option][option value="72"]Finland[/option][option value="73"]France[/option][option value="75"]French Guiana[/option][option value="76"]French Polynesia[/option][option value="77"]French Southern Territories[/option][option value="78"]Gabon[/option][option value="79"]Gambia[/option][option value="80"]Georgia[/option][option value="81"]Germany[/option][option value="82"]Ghana[/option][option value="83"]Gibraltar[/option][option value="84"]Greece[/option][option value="85"]Greenland[/option][option value="86"]Grenada[/option][option value="87"]Guadeloupe[/option][option value="88"]Guam[/option][option value="89"]Guatemala[/option][option value="90"]Guinea[/option][option value="91"]Guinea-Bissau[/option][option value="92"]Guyana[/option][option value="93"]Haiti[/option][option value="94"]Heard and McDonald Islands[/option][option value="95"]Honduras[/option][option value="96"]Hong Kong[/option][option value="97"]Hungary[/option][option value="98"]Iceland[/option][option value="99"]India[/option][option value="100"]Indonesia[/option][option value="101"]Iran, Islamic Republic of[/option][option value="102"]Iraq[/option][option value="103"]Ireland[/option][option value="104"]Israel[/option][option value="105"]Italy[/option][option value="106"]Jamaica[/option][option value="107"]Japan[/option][option value="241"]Jersey[/option][option value="108"]Jordan[/option][option value="109"]Kazakhstan[/option][option value="110"]Kenya[/option][option value="111"]Kiribati[/option][option value="112"]Korea, Democratic People\'s Republic of[/option][option value="113"]Korea, Republic of[/option][option value="114"]Kuwait[/option][option value="115"]Kyrgyzstan[/option][option value="116"]Lao People\'s Democratic Republic[/option][option value="117"]Latvia[/option][option value="118"]Lebanon[/option][option value="119"]Lesotho[/option][option value="120"]Liberia[/option][option value="121"]Libyan Arab Jamahiriya[/option][option value="122"]Liechtenstein[/option][option value="123"]Lithuania[/option][option value="124"]Luxembourg[/option][option value="125"]Macau[/option][option value="126"]Macedonia, the former Yugoslav Republic of[/option][option value="127"]Madagascar[/option][option value="128"]Malawi[/option][option value="129"]Malaysia[/option][option value="130"]Maldives[/option][option value="131"]Mali[/option][option value="132"]Malta[/option][option value="133"]Marshall Islands[/option][option value="134"]Martinique[/option][option value="135"]Mauritania[/option][option value="136"]Mauritius[/option][option value="137"]Mayotte[/option][option value="138"]Mexico[/option][option value="139"]Micronesia, Federated States of[/option][option value="140"]Moldova, Republic of[/option][option value="141"]Monaco[/option][option value="142"]Mongolia[/option][option value="143"]Montserrat[/option][option value="144"]Morocco[/option][option value="145"]Mozambique[/option][option value="146"]Myanmar[/option][option value="147"]Namibia[/option][option value="148"]Nauru[/option][option value="149"]Nepal[/option][option value="150"]Netherlands[/option][option value="151"]Netherlands Antilles[/option][option value="152"]New Caledonia[/option][option value="153"]New Zealand[/option][option value="154"]Nicaragua[/option][option value="155"]Niger[/option][option value="156"]Nigeria[/option][option value="157"]Niue[/option][option value="158"]Norfolk Island[/option][option value="159"]Northern Mariana Islands[/option][option value="160"]Norway[/option][option value="161"]Oman[/option][option value="162"]Pakistan[/option][option value="163"]Palau[/option][option value="248"]Palestinian Territory, Occupied[/option][option value="164"]Panama[/option][option value="165"]Papua New Guinea[/option][option value="166"]Paraguay[/option][option value="167"]Peru[/option][option value="168"]Philippines[/option][option value="169"]Pitcairn[/option][option value="170"]Poland[/option][option value="171"]Portugal[/option][option value="172"]Puerto Rico[/option][option value="173"]Qatar[/option][option value="175"]Romania[/option][option value="176"]Russian Federation[/option][option value="177"]Rwanda[/option][option value="174"]Réunion[/option][option value="197"]Saint Helena[/option][option value="178"]Saint Kitts and Nevis[/option][option value="179"]Saint Lucia[/option][option value="246"]Saint Martin (French part)[/option][option value="198"]Saint Pierre and Miquelon[/option][option value="180"]Saint Vincent and the Grenadines[/option][option value="181"]Samoa[/option][option value="182"]San Marino[/option][option value="183"]Sao Tome And Principe[/option][option value="184"]Saudi Arabia[/option][option value="185"]Senegal[/option][option value="245"]Serbia[/option][option value="186"]Seychelles[/option][option value="187"]Sierra Leone[/option][option value="188"]Singapore[/option][option value="247"]Sint Maarten (Dutch part)[/option][option value="189"]Slovakia[/option][option value="190"]Slovenia[/option][option value="191"]Solomon Islands[/option][option value="192"]Somalia[/option][option value="193"]South Africa[/option][option value="194"]South Georgia and the South Sandwich Islands[/option][option value="195"]Spain[/option][option value="196"]Sri Lanka[/option][option value="242"]St. Barthelemy[/option][option value="243"]St. Eustatius[/option][option value="199"]Sudan[/option][option value="200"]Suriname[/option][option value="201"]Svalbard and Jan Mayen[/option][option value="202"]Swaziland[/option][option value="203"]Sweden[/option][option value="204"]Switzerland[/option][option value="205"]Syrian Arab Republic[/option][option value="206"]Taiwan[/option][option value="207"]Tajikistan[/option][option value="208"]Tanzania, United Republic of[/option][option value="209"]Thailand[/option][option value="237"]The Democratic Republic of Congo[/option][option value="210"]Togo[/option][option value="211"]Tokelau[/option][option value="212"]Tonga[/option][option value="213"]Trinidad and Tobago[/option][option value="214"]Tunisia[/option][option value="215"]Turkey[/option][option value="216"]Turkmenistan[/option][option value="217"]Turks and Caicos Islands[/option][option value="218"]Tuvalu[/option][option value="219"]Uganda[/option][option value="220"]Ukraine[/option][option value="221"]United Arab Emirates[/option][option value="222"]United Kingdom[/option][option value="223"]United States[/option][option value="224"]United States Minor Outlying Islands[/option][option value="225"]Uruguay[/option][option value="226"]Uzbekistan[/option][option value="227"]Vanuatu[/option][option value="228"]Vatican City State (Holy See)[/option][option value="229"]Venezuela[/option][option value="230"]Viet Nam[/option][option value="231"]Virgin Islands, British[/option][option value="232"]Virgin Islands, U.S.[/option][option value="233"]Wallis and Futuna[/option][option value="234"]Western Sahara[/option][option value="235"]Yemen[/option][option value="238"]Zambia[/option][option value="239"]Zimbabwe[/option]';

$field = array();
$types = array(
  'delimiter' => 'header',
  'emailaddress' => 'email',
  'text' => 'textfield',
  'password' => 'password',
  'checkbox' => 'checkbox',
  'select' => 'select',
  'date' => 'date',
  'checkbox' => 'checkbox',
  'webaddress' => 'website',
  'editorta' => 'textarea',
  'textarea' => 'textarea');
$class = array(
  'phone_1' => 'ial-phone',
  'phone_2' => 'ial-phone',
  'fax' => 'ial-phone',
  'address_1' => 'ial-address1',
  'address_2' => 'ial-address1',
  'zip' => 'ial-postal_code',
  'virtuemart_state_id' => 'ial-region',
  'city' => 'ial-city',
  'virtuemart_country_id' => 'ial-country');

foreach ($flds as $key => $v) {
  if (!isset($types[$v->type])) {
    unset($flds[$key]);
    continue;
  }
  $k = $v->name;
  $field[$k] = $custom[$types[$v->type]];

  $field[$k]['type']['button'] = JText::_($v->title);
  $field[$k]['type']['predefined'] = $k;
  $field[$k]['class']['value'] = @$class[$v->name];
  if (isset($field[$k]['name'])) {
    $field[$k]['name']['value'] = $v->name;
    $field[$k]['name']['readonly'] = true;
  }
  $field[$k]['label']['value'] = JText::_($v->title);
  if (isset($field[$k]['required']))
    $field[$k]['required']['checked'] = $v->required == 1;
  if (isset($field[$k]['title']))
    $field[$k]['title']['value'] = $v->description;
  if ($v->type == 'select') {
    if ($v->name == 'virtuemart_country_id') {
      $field[$k]['select']['value'] = $countries;
    } elseif ($v->name == 'virtuemart_state_id') {
      unset($field[$k]['select']);
    } else {
      $db->setQuery("SELECT * FROM #__virtuemart_userfield_values WHERE virtuemart_userfield_id = {$v->virtuemart_userfield_id} ORDER BY ordering");
      $opts = $db->loadObjectList();
      if ($opts) foreach ($opts as $opt) {
        $field[$k]['select']['value'].= '[option value="'.$opt->fieldvalue.'"]'.$opt->fieldtitle.'[/option]';
      }
    }
  }
}

$prefix = '';
?>
JBackend = true;
JURI = "<?php echo JURI::root() ?>";
Theme = "<?php echo $this->theme ?>";
PredefinedElems = jQuery.extend(<?php echo json_encode($field) ?>, {
  // Default fields
  create: {
    type: {value: "header", predefined: "create",
      readonly: true, button: "Title", icon: "icon-quote icon-font"},
    wide: {checked: true},
    "class": {value: ""},
    label: {value: "", defaultValue: "MOD_LOGIN_REGISTER",
      placeholder: "<?php echo addslashes(JText::_('MOD_LOGIN_REGISTER')) ?>"},
    subtitle: {value: "", defaultValue: "COM_USERS_REGISTER_REQUIRED",
      placeholder: "<?php echo addslashes(JText::_('COM_USERS_REGISTER_REQUIRED')) ?>"}
  },
  name: {
    type: {value: "textfield", defaultValue: "text", predefined: "name",
      readonly: true, button: "Name", icon: "icon-user"},
    required: {checked: true, disabled: false},
    wide: {checked: false},
    "class": {value: "ial-name"},
    name: {value: "name", readonly: true},
    prefix: {value: "<?php echo $prefix ?>"},
    label: {value: "", defaultValue: "COM_USERS_REGISTER_NAME_LABEL",
      placeholder: "<?php echo addslashes(JText::_('COM_USERS_REGISTER_NAME_LABEL'))?>"},
    placeholder: {value: "", placeholder: ""},
    title: {value: "", defaultValue: "COM_USERS_REGISTER_NAME_DESC",
      placeholder: "<?php echo addslashes(JText::_('COM_USERS_REGISTER_NAME_DESC'))?>"},
    pattern: {value: ".+", placeholder: ".+"},
    error: {value: "", defaultValue: "JLIB_FORM_VALIDATE_FIELD_INVALID",
      placeholder: "<?php echo addslashes(JText::sprintf('JLIB_FORM_VALIDATE_FIELD_INVALID', ''))?>"},
  },
  username: {
    type: {value: "textfield", defaultValue: "text", predefined: "username",
      readonly: true, button: "Username", icon: "icon-user"},
    required: {checked: true, disabled: true},
    wide: {checked: false},
    "class": {value: "ial-username"},
    name: {value: "username", readonly: true},
    prefix: {value: "<?php echo $prefix ?>"},
    label: {value: "", defaultValue: "COM_USERS_REGISTER_USERNAME_LABEL",
      placeholder: "<?php echo addslashes(JText::_('COM_USERS_REGISTER_USERNAME_LABEL'))?>"},
    placeholder: {value: "", placeholder: ""},
    title: {value: "", defaultValue: "COM_USERS_REGISTER_USERNAME_DESC",
      placeholder: "<?php echo addslashes(JText::_('COM_USERS_REGISTER_USERNAME_DESC'))?>"},
    error: {value: "", defaultValue: "JLIB_DATABASE_ERROR_VALID_AZ09",
      placeholder: "<?php echo addslashes(@JText::sprintf('JLIB_DATABASE_ERROR_VALID_AZ09', 2))?>"},
    pattern: {value: "^[^<>\\\\&%'\";\\(\\)]{2,}$", placeholder: "^[^<>\\\\&%'\";\\(\\)]{2,}$"},
    ajax: "username"
  },
  password1: {
    type: {value: "password1", defaultValue: "password", predefined: "password1",
      readonly: true, button: "Password", icon: "icon-lock"},
    required: {checked: true, disabled: true},
    wide: {checked: false},
    "class": {value: "ial-password1"},
    name: {value: "password", readonly: true},
    prefix: {value: "<?php echo $prefix ?>"},
    label: {value: "", defaultValue: "COM_USERS_REGISTER_PASSWORD1_LABEL",
      placeholder: "<?php echo addslashes(JText::_('COM_USERS_REGISTER_PASSWORD1_LABEL'))?>"},
    placeholder: {value: "", placeholder: ""},
    title: {value: "", defaultValue: "COM_USERS_DESIRED_PASSWORD",
      placeholder: "<?php echo addslashes(JText::_('COM_USERS_DESIRED_PASSWORD'))?>"},
    error: {value: "", defaultValue: "JLIB_FORM_FIELD_INVALID",
      placeholder: "<?php echo addslashes(JText::sprintf('JLIB_FORM_VALIDATE_FIELD_INVALID', ''))?>"},
  },
  password2: {
    type: {value: "password2", defaultValue: "password", predefined: "password2",
      readonly: true, button: "Password again", icon: "icon-lock"},
    required: {checked: true, disabled: true},
    wide: {checked: false},
    "class": {value: "ial-password2"},
    name: {value: "password2", readonly: true},
    prefix: {value: "<?php echo $prefix ?>"},
    label: {value: "", defaultValue: "COM_USERS_REGISTER_PASSWORD2_LABEL",
      placeholder: "<?php echo addslashes(JText::_('COM_USERS_REGISTER_PASSWORD2_LABEL'))?>"},
    placeholder: {value: "", placeholder: ""},
    title: {value: "", defaultValue: "COM_USERS_REGISTER_PASSWORD2_DESC",
      placeholder: "<?php echo addslashes(JText::_('COM_USERS_REGISTER_PASSWORD2_DESC'))?>"},
    error: {value: "", defaultValue: "COM_USERS_REGISTER_PASSWORD1_MESSAGE",
      placeholder: "<?php echo addslashes(JText::_('COM_USERS_REGISTER_PASSWORD1_MESSAGE'))?>"}
  },
  email: {
    type: {value: "textfield", defaultValue: "text", predefined: "email",
      readonly: true, button: "Email", icon: "icon-mail-2 icon-envelope"},
    required: {checked: true, disabled: true},
    wide: {checked: false},
    "class": {value: "ial-email1"},
    name: {value: "email", readonly: true},
    prefix: {value: "<?php echo $prefix ?>"},
    label: {value: "", defaultValue: "COM_USERS_REGISTER_EMAIL1_LABEL",
      placeholder: "<?php echo addslashes(JText::_('COM_USERS_REGISTER_EMAIL1_LABEL'))?>"},
    placeholder: {value: "", placeholder: ""},
    title: {value: "", defaultValue: "COM_USERS_REGISTER_EMAIL1_DESC",
      placeholder: "<?php echo addslashes(JText::_('COM_USERS_REGISTER_EMAIL1_DESC'))?>"},
    error: {value: "", defaultValue: "COM_USERS_INVALID_EMAIL",
      placeholder: "<?php echo addslashes(JText::_('COM_USERS_INVALID_EMAIL'))?>"},
    pattern: {value: "^([\\w0-9\\.\\-])+\\@(([a-zA-Z0-9\\-])+\\.)+[a-zA-Z]{2,4}$",
      placeholder: "^([\\w0-9\\.\\-])+\\@(([a-zA-Z0-9\\-])+\\.)+[a-zA-Z]{2,4}$"},
    ajax: "email"
  },
  email2: {
    type: {value: "textfield", defaultValue: "text", predefined: "email2",
      readonly: true, button: "Email again", icon: "icon-mail-2 icon-envelope"},
    required: {checked: true, disabled: true},
    wide: {checked: false},
    "class": {value: "ial-email2"},
    name: {value: "email2", readonly: true},
    prefix: {value: "<?php echo $prefix ?>"},
    label: {value: "", defaultValue: "COM_USERS_REGISTER_EMAIL2_LABEL",
      placeholder: "<?php echo addslashes(JText::_('COM_USERS_REGISTER_EMAIL2_LABEL'))?>"},
    placeholder: {value: "", placeholder: ""},
    title: {value: "", defaultValue: "COM_USERS_REGISTER_EMAIL2_DESC",
      placeholder: "<?php echo addslashes(JText::_('COM_USERS_REGISTER_EMAIL2_DESC'))?>"},
    error: {value: "", defaultValue: "COM_USERS_REGISTER_EMAIL2_MESSAGE",
      placeholder: "<?php echo addslashes(JText::_('COM_USERS_REGISTER_EMAIL2_MESSAGE'))?>"}
  },/*
  captcha: {
    type: {value: "captcha", predefined: "captcha",
      readonly: true, button: "Captcha image", icon: "icon-picture"},
    wide: {checked: true},
    "class": {value: ""},
  },
  captcha2: {
    type: {value: "textfield", defaultValue: "text", predefined: "captcha2",
      readonly: true, button: "Captcha textfield", icon: "icon-pencil"},
    required: {checked: true, disabled: true},
    clear: {checked: false},
    wide: {checked: false},
    "class": {value: "ial-captcha"},
    name: {value: "recaptcha_response_field", readonly: true},
    prefix: {value: ""},
    label: {value: "", defaultValue: "COM_USERS_CAPTCHA_LABEL",
      placeholder: "<?php echo addslashes(JText::_('COM_USERS_CAPTCHA_LABEL'))?>:"},
    placeholder: {value: "", placeholder: ""},
    title: {value: "", defaultValue: "COM_USERS_CAPTCHA_DESC",
      placeholder: "<?php echo addslashes(JText::_('COM_USERS_CAPTCHA_DESC'))?>"},
    error: {value: "", defaultValue: "JLIB_FORM_FIELD_INVALID",
      placeholder: "<?php echo addslashes(JText::sprintf('JLIB_FORM_VALIDATE_FIELD_INVALID', ''))?>"},
    pattern: {value: "", placeholder: ""},
    autoCompOff: true
  },*/
  tos: {
    type: {value: "tos", predefined: "tos",
      readonly: true, button: "Terms of services", icon: "icon-checkbox icon-ok-circle"},
    required: {checked: true, disabled: true},
    checked: {checked: false, disabled: true},
    wide: {checked: false},
    "class": {value: "ial-tos"},
    name: {value: "agreed", readonly: true},
    prefix: {value: "<?php echo $prefix ?>"},
    label: {value: "", defaultValue: "COM_VIRTUEMART_I_AGREE_TO_TOS",
      placeholder: "<?php echo addslashes(JText::_('COM_VIRTUEMART_I_AGREE_TO_TOS'))?>"},
    title: {value: "", placeholder: ""},
    article: {value: ""},
    article_name: {value: "", placeholder: ""}
  },
  submit: {
    type: {value: "button", predefined: "submit",
      readonly: true, button: "Submit", icon: "icon-arrow-right"},
    wide: {checked: false},
    "class": {value: ""},
    label: {value: "", defaultValue: "JREGISTER",
      placeholder: "<?php echo JText::_('JREGISTER') ?>"},
    subtitle: {value: "&nbsp", placeholder:""}
  },
  // Custom fields
  header: {
    type: {value: "header", readonly: true, button: "Header", icon: "icon-quote icon-font"},
    wide: {checked: true},
    "class": {value: ""},
    label: {value: "", placeholder: "Header text"},
    subtitle: {value: "", placeholder: ""}
  },
  label: {
    type: {value: "label", readonly: true, button: "Label", icon: "icon-quote icon-align-justify"},
    wide: {checked: false},
    "class": {value: ""},
    label: {value: "", placeholder: "Label text"}
  }
});