jQuery(document).ready(function($) {
	if ( !("placeholder" in document.createElement("input")) ) {
		$("input[placeholder]").each(function() {
			var val = $(this).attr("placeholder");
			if ( this.value == "" ) {
				this.value = val;
			}
			$(this).focus(function() {
				if ( this.value == val ) {
					this.value = "";
				}
			}).blur(function() {
				if ( $.trim(this.value) == "" ) {
					this.value = val;
				}
			})
		});
	}
	if ( !("placeholder" in document.createElement("textarea")) ) {
		$("textarea[placeholder]").each(function() {
			var val = $(this).attr("placeholder");
			if ( this.value == "" ) {
				this.value = val;
			}
			$(this).focus(function() {
				if ( this.value == val ) {
					this.value = "";
				}
			}).blur(function() {
				if ( $.trim(this.value) == "" ) {
					this.value = val;
				}
			})
		});
	}
	// Clear default placeholder values on form submit
	$('form').submit(function() {
        $(this).find("input[placeholder], textarea[placeholder]").each(function() {
            if ( this.value == $(this).attr("placeholder") ) {
                this.value = "";
            }
        });
    });
});