<?php
/**
 * @copyright	Copyright (C) 2006 - 2015 IdealExtensions.com. All rights reserved
 * @license		GNU GPL2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

jimport('joomla.application.component.controller');

/**
 * @package		com_contactenhanced
*/
class ContactenhancedControllerContact extends ContactenhancedController
{
	public $HTMLtemplate = array();

	/**
	 * Method to send an email to a contact
	 *
	 * @static
	 * @since 1.0
	 */
	function submit()
	{
		// Reset the Error Session variable:
		ceHelper::setSession('errors', array(), false);
		//Create Cookies in case there is a need to reload the form
		$this->createCookiesFromPost();

		$app			= JFactory::getApplication();
		$input			= $app->input;
		$lang			= JFactory::getLanguage();
		$pparams		= $app->getParams('com_contactenhanced');
		$sessionCheck	= $pparams->get('validate_session', 0);

		// Initialise some variables
		$session 		=JFactory::getSession();
		$this->emailInfo= new stdClass();
		$this->emailInfo->return_url	= ceHelper::decode(JRequest::getVar( 'return', 	false,		'post' ), 'base64' );
		$this->contactId= JRequest::getInt( 'id',	0,	'post' );

		$tmplURL	= (JRequest::getVar('tmpl') ? '&tmpl='.JRequest::getVar('tmpl') : '');

		if($sessionCheck){
			// Check for request forgeries
			JRequest::checkToken() OR jexit(JText::_('JInvalid_Token'));

			if (JFactory::getSession()->getState() != 'active'){
				JError::raiseWarning(403, JText::_('COM_CONTACT_SESSION_INVALID'));
				return $this->setDisplayError();
			}

			// Check for spambots
			if($pparams->get('honeypot',1) AND ceHelper::checkHoneypot() == false){
				JError::raiseWarning( 550, JText::_('COM_CONTACTENHANCED_HONEYPOT_CAUGHT_SPAMMER') );
				$link = JRoute::_('index.php?option=com_contactenhanced&view=contact&id='
								.$this->contactId
								. $tmplURL
							, false);
				$app->redirect($link);
				$app->close();
			}
		}

		// load the contact details
		$model		= $this->getModel('contact');
		// query options
		$this->emailInfo->contact	= $model->getItem($this->contactId);

		// Adds parameter handling
		$registry	= new JRegistry();
		$registry->loadString($this->emailInfo->contact->params);
		$this->emailInfo->contact->params = $registry;
		$pparams->merge($registry);

		// Contact plugins
		JPluginHelper::importPlugin('contact');
		// Contact Enhanced plugins
		JPluginHelper::importPlugin('contactenhanced');
		$dispatcher	= JDispatcher::getInstance();

		// Custom handlers
		$post		= JRequest::get('post');

		$menus	= $app->getMenu();
		$menu	= $menus->getActive();

		// Merge parameters
		if($this->emailInfo->contact->params){
			$pparams->merge($this->emailInfo->contact->params);
		}
		if(isset($menu) AND $menu->params){
			$pparams->merge($menu->params);
		}
		$this->emailInfo->contact->params	= $pparams;

		if($this->emailInfo->contact->email_to == '' && $this->emailInfo->contact->user_id != 0)
		{
			$contact_user = JUser::getInstance($this->emailInfo->contact->user_id);
			$this->emailInfo->contact->email_to = $contact_user->get('email');
		}

		if (!class_exists('iDealCaptcha')) {
			require_once (JPATH_ROOT.'/components/com_contactenhanced/helpers/captcha.php');
		}
		// Passed Validation: Process the contact plugins to integrate with other applications
		$this->emailInfo->contact->params->set('returnType',	'boolean');
		if (iDealCaptcha::test($this->emailInfo->contact->params,null,'com_contactenhanced') == false){
			ceHelper::setSession('captcha_passed', false, false);
			return $this->setDisplayError();
		}else{
			ceHelper::setSession('captcha_passed', true, false);
		}

		// Initialize some variables
		jimport('joomla.mail.helper');
		$db			= JFactory::getDbo();
		$mail		= JFactory::getMailer();
		$user		= JFactory::getUser();
		$config		= JFactory::getConfig();

		if($pparams->get('debug_mode') OR $app->getCfg('debug')){
			$mail->do_debug = true;
			$mail->Debugoutput = 'error_log';
		}

		$data = ceHelper::objectToArray($this->emailInfo);
		// All fields have already been validate, so we may continue with custom handlers
		$results	= $dispatcher->trigger('onSubmitContact', array(&$this->emailInfo->contact, &$data));

		foreach ($results as $result) {
			if($result instanceof Exception) {
				$app->enqueueMessage($result->getMessage(), 'error');
				return $this->setDisplayError();
			}
		}

		$this->emailInfo->siteName		= $app->getCfg('sitename');
		$default						= JText::sprintf('COM_CONTACTENHANCED_MAILENQUIRY', $this->emailInfo->siteName);
		$this->emailInfo->name			= JRequest::getVar( 'name', JRequest::getVar( 'first_name', $user->get('name', JText::_('Anonymous User') ) ) );
		$this->emailInfo->email			= (trim(JRequest::getVar( 'email'))? JRequest::getVar( 'email')	: ($user->get('email') 	? $user->get('email') 	: $app->getCfg('mailfrom')));

		// Make sure the POST has the correct value
		JRequest::setVar( 'name',		$this->emailInfo->name,		'post');
		JRequest::setVar( 'email',		$this->emailInfo->email,	'post');

		$this->emailInfo->subject		= JRequest::getVar( 'subject',		$default,	'post' );
		$this->emailInfo->emailCopy		= JRequest::getInt( 'email_copy', 	0,			'post' );
		$this->emailInfo->site_url		= JURI::base();
		$this->emailInfo->site_name		= $this->emailInfo->siteName;
		$this->emailInfo->site_link		= JHTML::_('link', JURI::base(),'<span  itemprop="name">'.$this->emailInfo->siteName.'</span>');
		$this->emailInfo->contact_url	= JRoute::_(JURI::base().'index.php?option=com_contactenhanced&view=contact&id='.$this->emailInfo->contact->slug.'&catid='.$this->emailInfo->contact->catslug);
		$this->emailInfo->contact_link	= JHTML::_('link', $this->emailInfo->contact_url,$this->emailInfo->contact->name);
		$surname						= ' '.JRequest::getVar( 'surname',	'' );
		$this->emailInfo->surname		= &$surname;

		$this->customfields	= ceHelper::getCustomFields( $this->emailInfo->contact->catid);
		
		//Get only the fields used
		$submittedFields	= ceHelper::getSubmitedFields($this->customfields, $pparams);

		$this->submittedFields			= &$submittedFields;

		$this->emailInfo->cfText		= ''; // For text

		$this->emailInfo->attachments	= '';
		$this->emailInfo->plainTextAttachments	= '';
		$totalFilesize					= 0;
		$filesToAttach	= array();

		if($this->emailInfo->contact->email_to == '' && $this->emailInfo->contact->user_id != 0){
			$contact_user = JUser::getInstance($this->emailInfo->contact->user_id);
			$this->emailInfo->contact->email_to = $contact_user->get('email');
		}elseif($this->emailInfo->contact->email_to == '' AND $this->emailInfo->contact->user_id){
			$this->emailInfo->contact->email_to	= $app->getCfg('mailfrom');
		}

		if($input->getString( 'encodedrecipient')){
			$session	= JFactory::getSession(); // Get the session
			if($session->get($input->getString( 'encodedrecipient'))){
				$recipient	= $session->get($input->getString( 'encodedrecipient'));
			}else{
				$decodedRecipient = ceHelper::decode($input->getString( 'encodedrecipient'),'base64');
				if(ceHelper::isEmailAddress($decodedRecipient)){
					$recipient = $decodedRecipient;
				}else{
					$decodedRecipient = ceHelper::decode($input->getString( 'encodedrecipient'));
					if(ceHelper::isEmailAddress($decodedRecipient)){
						$recipient = $decodedRecipient;
					}
				}
			}
		}elseif(isset($submittedFields['recipient'])){

			$recipient = $submittedFields['recipient'];
			unset($submittedFields['recipient']);
		}
		// IS empty array
		if(!isset($recipient) OR (is_array($recipient) AND count($recipient) == 0) ){
			$recipient	= explode(',', $this->emailInfo->contact->email_to);
		}
		if(is_array($recipient) AND count($recipient) == 1){
			$recipient	= explode(',', $recipient[0]);
		}elseif(is_array($recipient) AND count($recipient) > 1){
			// There were Multiple Select Recipient Custom Fields, so merge them into one array only.
			$temp = array();
			foreach ($recipient as $recipientEmail) {
				if(strstr($recipientEmail,',')){
					$temp = array_merge($temp, explode(',', $recipientEmail));
				}else{
					$temp = array_merge($temp, (array)$recipientEmail);
				}
			}
			$recipient = $temp;
		}
		if(!is_array($recipient) AND strstr($recipient,',')){
			$recipient	= explode(',', $recipient);
		}
		foreach($submittedFields as $cf){

			$this->customfields[$cf->type]	= $cf;
			// get's plain text Custom Fields
			$this->emailInfo->cfText .= $cf->getEmailOutput();

			//If it is a file add as attachment
			if( $cf->type == 'multiplefiles'){
				$filesToAttachTemp	= $cf->getUploadedFiles($totalFilesize);
				$filesToAttach 		= array_merge($filesToAttach,$filesToAttachTemp);
			}
		}

		/*
		 * If there is no valid email address or message body then we throw an
		 * error and return false.
		 */
		if (!$this->emailInfo->email || (JMailHelper::isEmailAddress($this->emailInfo->email) == false))
		{
			$this->setError(JText::_('COM_CONTACTENHANCED_FORM_NC'));
			//$this->display();
			return $this->setDisplayError();
		}

		// Input validation
		if  (!$this->_validateInputs( $this->emailInfo->contact, $this->emailInfo->email, $this->emailInfo->subject, $this->emailInfo->cfText ) ) {
			JError::raiseWarning( 0, $this->getError() );
			//$this->display();
			return $this->setDisplayError();
		}


		// All fields have already been validate, so we may continue with custom handlers
		$results	= $dispatcher->trigger('onValidateContact', array(&$this->emailInfo->contact, &$submittedFields, &$this->emailInfo));

		foreach ($results as $result) {
			if($result instanceof Exception) {
				$app->enqueueMessage($result->getMessage(), 'error');
				return $this->setDisplayError();
			}
		}

		$spamCheckData = array();
		$spamCheckData['name'] = $this->emailInfo->name;
		$spamCheckData['email'] = $this->emailInfo->email;
		$spamCheckData['subject'] = $this->emailInfo->subject;
		$spamCheckData['message'] = $this->emailInfo->cfText ;
		// Check with spamCheck plugins
		$results	= $dispatcher->trigger('onSpamCheck', array('com_contactenhanced.submit', &$spamCheckData));
		// Check for errors encountered while checking for spam
		if (count($results) && in_array(false, $results, true))
		{
			$app->enqueueMessage($dispatcher->getError(), 'error');
			return $this->setDisplayError();
		}

		//Do Registration
		if ( ($pparams->get( 'register', 0 ) > 0) AND !$user->get('id') ) { //  OR JRequest::getVar('username')
			$this->registration($pparams,$this->emailInfo);
		}

		/* Get date and the correct Timezone to be used in the recorded email and integration*/
		jimport('joomla.utilities.date');
		$tz	= new DateTimeZone(JFactory::getApplication()->getCfg('offset'));
		$date = new JDate(time());
		$date->setTimezone($tz);

		/**
		 * Integration with Other websites
		 */
		if($pparams->get('integration') == 'socket'
				AND $pparams->get('integration-socket-hostname')
				AND $pparams->get('integration-socket-method')
		){
			$method			= strtoupper($pparams->get('integration-socket-method'));
			$cookies		= array();
			$custom_headers	= array();
			$timeout		= 1000;
			$debug			= ($pparams->get('integration-socket-debug') ? true : false);

			if($pparams->get('integration-socket-variables') == 'id'){
				$vars	= JRequest::get('post');
			}else{
				$vars	= array();
				foreach ($submittedFields as $cf) {
					if($pparams->get('integration-socket-varname','urlsafe') == 'urlsafe'){
						$vars[JApplication::stringURLSafe($cf->name)]=	$cf->uservalue;
					}else{
						$varName		= str_replace(' ', '',ucwords($cf->name));
						$vars[$varName]	=	$cf->uservalue;
					}
				}
			}
			if($pparams->get('integration-socket-method') == 'post'){
				$post	= &$vars;
				$get	= array();
			}else{
				$post	= array();
				$get	= &$vars;
			}

			if($debug){
				echo $method.' '.ceHelper::print_r($vars).'<br /><br />';
			}
			$result 	= ceHelper::http_request(
									$method,
									$pparams->get('integration-socket-hostname'),
									80,
									$pparams->get('integration-socket-uri','/'),
									$get,
									$post,
									$cookies,
									$custom_headers,
									$timeout //
									,$debug
								);
			if($debug){
				echo '$result '.ceHelper::print_r($result).'<br /><br />'; exit;
			}
		}

		/**
		 * Integration with Google Spreadsheets
		 */
		if($pparams->get('gdata') == 'spreadsheet'  ) {

			$vars	= array('timestamp'=> $date->toSQL());
			foreach ($this->customfields as $cf) {
				$var	= (isset($submittedFields[$cf->id]->uservalue) ? $submittedFields[$cf->id]->uservalue : '');
				if ($cf->type == 'subject') {
					$var	= (isset($submittedFields[$cf->type]->uservalue) ? $submittedFields[$cf->type]->uservalue : '');
				}
				if(is_array($var)){
					$var= JArrayHelper::toString($var,', ');
				}
				if($pparams->get('gdata-spreadsheet-variables') == 'id'){
					$vars[$cf->alias]=	$var;
				}else{
					$vars[JApplication::stringURLSafe($cf->name)]=	$var;
				}
			}

			if($pparams->get('gdata-spreadsheet-csv') ){
				require_once(JPATH_ADMIN_COMPONENT.'helpers/csvhandler.php');
				$csv	= new csvHandler();
				$csv->addHeaderLine($vars);
				echo $csv->render('google-spreadsheet-setup-file','UTF-8', 'auto');
				exit;
			}elseif($pparams->get('gdata-spreadsheet-account-username')
					AND $pparams->get('gdata-spreadsheet-account-password')
					AND $pparams->get('gdata-spreadsheet-key')
					AND $pparams->get('gdata-spreadsheet-worksheet','Sheet 1'))
			{
				require_once (JPATH_COMPONENT.'/helpers/googleSpreadsheet.php');
				$ss = new googleSpreadsheet($pparams->get('gdata-spreadsheet-account-username'),$pparams->get('gdata-spreadsheet-account-password'));
				$ss->setSpreadsheetId($pparams->get('gdata-spreadsheet-key'));
				$ss->useWorksheet($pparams->get('gdata-spreadsheet-worksheet','Sheet 1'));

				if(!$ss->addRow($vars) AND ($pparams->get('debug_mode') OR $app->getCfg('debug')) ){
					Throw new Exception(JText::_('COM_CONTACTENHANCED_GDATA_SPREADSHEET_ERROR_UNABLE_TO_ADD_ROW'));
				}
			}else{
				//Missing info
				Throw new Exception(JText::_('COM_CONTACTENHANCED_ERROR_GDATA_SPREADSHEET_INFORMATION_MISSING'));
			}
		}

		/**
		 * Integration with Salesforce using Web to lead
		 **/
		if($pparams->get('salesforce') == 'webtolead' AND $pparams->get('salesforce-webtolead-oid') ) {
			require_once (JPATH_COMPONENT.'/helpers/salesforce.php');
			$salesForce	= new SFWebtoLead($pparams->get('salesforce-webtolead-oid'), false, $app->getCfg('mailfrom'));
			$salesForce->send($submittedFields);
		}

		$MailFrom 	= $app->getCfg('mailfrom');
		$FromName 	= $app->getCfg('fromname');
		// Prepare email body
		$this->emailInfo->enquiry	= JText::sprintf('COM_CONTACTENHANCED_ENQUIRY_TEXT'
				, JHTML::_('link', $this->emailInfo->contact_url,$this->emailInfo->siteName)
				, $this->emailInfo->name. $surname
				, $this->emailInfo->email );
		$this->emailInfo->body 	= strip_tags($this->emailInfo->enquiry)."\n\n".$this->emailInfo->cfText."\r\n" ;

		$mainEmailBody	= ($this->emailInfo->body);

		//Get System Info (SO, Browser, Screen Resolution, IP, Referrers)
		$this->emailInfo->system_info	= ceHelper::getSystemInfo($pparams);
		$this->emailInfo->last_page		= ceHelper::getLastURL();
		$this->emailInfo->referrer		= JRequest::getVar('referrer');
		$this->emailInfo->user_ip		= ceHelper::getIP();
		$this->emailInfo->last_page_url	= ceHelper::decode(JRequest::getVar( 'content_url',$_SERVER['HTTP_REFERER'] ),'base64');
		$this->emailInfo->last_page_title	= ceHelper::decode(JRequest::getVar( 'content_title'),'base64');

		if($this->emailInfo->emailCopy){
			$this->emailInfo->system_info .= "\n\n\t<hr /><br />".JText::_('CE_EMAIL_USER_HAS_REQUESTED_A_COPY');
		}

		if ( $pparams->get( 'showuserinfo',1) ) {
			$mainEmailBody	= strip_tags($this->emailInfo->body.$this->emailInfo->system_info);
		}

		$this->emailInfo->subject = $this->getSubject($this->emailInfo->subject);

		if($pparams->get('emailTemplate',1) == 'plaintext'){
			$htmlEmail	= '';
		}else{
			$htmlEmail	=	$this->getEmailHTML($pparams->get('emailTemplate',1));
		}

		// Save contact if needed
		if($pparams->get( 'saveform',1 ) OR $totalFilesize >= 2000000){
			$emailData				= new stdClass();
			$emailData->id			= 0;
			$emailData->parent		= JRequest::getInt('reply_id',0);
			$emailData->from_name	= $this->emailInfo->name;
			$emailData->from_email	= $this->emailInfo->email;
			$emailData->from_id		= $user->id;
			$emailData->subject		= $this->emailInfo->subject;
			$emailData->contact_id	= $this->emailInfo->contact->id;
			$emailData->catid		= $this->emailInfo->contact->catid;
			$emailData->date		= JFactory::getDate()->toSql();
			$emailData->reply_date	= '';
			$emailData->replied_by	= '';
			$emailData->language	= $lang->getTag();
			$emailData->message		= $mainEmailBody;	// Plain Text Email message
			$emailData->message_html= $htmlEmail; 		// HTML Email message
			$emailData->user_ip		= ceHelper::getIP();

			if($pparams->get( 'saveform',1 ) == 'autopublish'){
				$emailData->published	= 1;
			}

			$emailData->files		= $filesToAttach;
			$emailData->fields		= $submittedFields;

			$emailData->id	= $this->saveForm($emailData);
			$emailData->message_id	= &$emailData->id;
			$this->emailInfo->message_id	= &$emailData->id;
			$this->emailInfo->id = $emailData->id;



			if( count($filesToAttach) > 0 ){
				$this->emailInfo->attachments .= '<div><strong>'.JText::_('COM_CONTACTENHANCED_ATTACHMENT_ATTACHMENTS').'</strong></div>';
				//Delete files if the contact will not be saved
				for($i=0; $i<count($filesToAttach);$i++){
					$filesToAttach[$i]	= $emailData->id.'_'.$filesToAttach[$i];

					if($totalFilesize <= 2000000){
						$mail->addAttachment(CE_UPLOADED_FILE_PATH.$filesToAttach[$i]);
					}else{
						$this->emailInfo->plainTextAttachments	.= 	ceHelper::formatAttachment($filesToAttach[$i],$emailData->id, 'plain');
					}

					$this->emailInfo->attachments	.= '<br />'.ceHelper::formatAttachment($filesToAttach[$i],$emailData->id);
				}

				$filesToAttach	= array(); // reset array
			}
		}elseif( count($filesToAttach) > 0 ){
			//Delete files if the contact will not be saved
			foreach($filesToAttach as $fileToAttach){
				$mail->addAttachment(CE_UPLOADED_FILE_PATH.$fileToAttach);
			}
		}


		// Add linked files at last
		$htmlEmail 	= str_ireplace( '{attachments}', $this->emailInfo->attachments, $htmlEmail );

		// Get Subject Again in order to get {message_id}
		// This duplicates the prefix.
		//$this->emailInfo->subject = $this->getSubject($this->emailInfo->subject);

		$mail->setSubject( $this->emailInfo->subject );

		if (!$pparams->get( 'custom_reply' ))
		{
			if($this->emailInfo->plainTextAttachments != ''){
				$mainEmailBody	= $mainEmailBody."\n\n".JText::_('Attachments').':'.$this->emailInfo->plainTextAttachments;
			}

			$mail->setBody( $mainEmailBody);

			if($pparams->get('emailTemplate') != 'plaintext'){
				$mail->MsgHTML( $htmlEmail);
				$mail->AltBody= $mainEmailBody;
			}

			if($pparams->get('emailSender') == 'contact'){
				$mail->setSender(	array( $this->emailInfo->email, $this->emailInfo->name.$surname ) );
				$mail->addReplyTo(	array( $this->emailInfo->email, $this->emailInfo->name.$surname ) );
			}else{
				$mail->setSender(	array($app->getCfg('mailfrom'), 	$this->emailInfo->name.$surname.' - '.$app->getCfg('fromname') ));
				$mail->addReplyTo( 	array($this->emailInfo->email,		$this->emailInfo->name.$surname.' - '.$app->getCfg('fromname') ));
			}



			if(is_array($recipient)){
				foreach ($recipient as $recipientEmail){
					$mail->ClearAddresses();
					$mail->addRecipient($recipientEmail );
					$sent = $mail->Send();
				}
			}else{
				$mail->addRecipient($recipient );
				$sent = $mail->Send();
			}

			if($pparams->get('email_bcc')){
				$mail->ClearAddresses();
				$mail->addBCC(explode(',', $pparams->get('email_bcc')));
				$sent = $mail->Send();
			}

			// Send to group only if it was correctly sent to teh default recipient
			if($pparams->get('link_usergroup') > 1 AND $sent){
				$link_usergroup	= $this->_getUsersByGroup($pparams->get('link_usergroup'));
				if(is_array($link_usergroup)){
					foreach ($link_usergroup as $user){
						$mail->ClearAddresses();
						$mail->addRecipient($user->email );
						$sent = $mail->Send();
					}
				}
			}

			if($pparams->get('debug_mode') OR $app->getCfg('debug')){
				$this->sendDebugMessage($this->emailInfo->subject);
				if (!$sent) {
					$app->enqueueMessage('MAILER -> ERROR: ' . $this->error['error'] );
				}
			}

			if($pparams->get('copy_plain_text')){
				$copyPlainTextEmails	= (explode(',', $pparams->get('copy_plain_text')));
				$mail->IsHTML(false);
				$mail->setBody( $mainEmailBody);
				foreach ($copyPlainTextEmails as $copyPlainTextEmail){
					$mail->ClearAddresses();
					$mail->addRecipient($copyPlainTextEmail );
					$sent = $mail->Send();
				}
			}

			/*
			 * If we are supposed to copy the sender, do so.
			 */
			// parameter check
			$emailcopyCheck = $this->emailInfo->contact->params->get( 'show_email_copy', 1 );

			// check whether email copy function activated
			if ( $this->emailInfo->emailCopy && $emailcopyCheck )
			{

				$copyText 		= JText::sprintf('COM_CONTACTENHANCED_COPYTEXT_OF', $this->emailInfo->contact->name, $this->emailInfo->siteName);
				$copyText 		.= "\r\n\r\n".$this->emailInfo->body;
				if(isset($this->submittedFields['subject']) AND is_object(($this->submittedFields['subject']))){
					$copySubject 	= JText::sprintf(
							$this->submittedFields['subject']->params->get('copysubject','COM_CONTACTENHANCED_COPYSUBJECT_OF')
							,$this->emailInfo->subject);
				}else{
					$copySubject 	= JText::sprintf('COM_CONTACTENHANCED_COPYSUBJECT_OF',$this->emailInfo->subject);
				}

				$mail = JFactory::getMailer();

				if(is_array($recipient)){
					if(count($recipient) > 1){
						$recipient	= $MailFrom;
					}else{
						$recipient	= $recipient[0];
					}
				}
				$mail->addRecipient( $this->emailInfo->email );
				$mail->addReplyTo( array( $recipient, $FromName ) );

				if($pparams->get('emailSender') == 'contact'){
					$mail->setSender( array( $recipient, $FromName ) );
				}else{
					$mail->setSender( array( $MailFrom, $FromName ) );
				}


				$mail->setSubject( $copySubject );
				$mail->setBody( $copyText );

				if($pparams->get('emailCopyTemplate') != 'plaintext'){
					// reset system info
					$this->emailInfo->system_info = '';
					$this->emailInfo->enquiry	= JText::sprintf('COM_CONTACTENHANCED_COPYSUBJECT_OF',$this->emailInfo->enquiry);
					$mail->MsgHTML( $this->getEmailHTML($pparams->get('emailCopyTemplate',1)));
					$mail->AltBody= $mainEmailBody;
				}

				$sent = $mail->Send();
			}
		}

		// Passed Validation: Process the contact plugins to integrate with other applications
		$results = $dispatcher->trigger('onAfterSendForm', array(&$this->emailInfo->contact, &$submittedFields, &$this->emailInfo));

		//No more need for cookies: Destroy them
		$this->detroyPostCookies();
		// Reset the Error Session variable:
		ceHelper::setSession('errors', array());

		if( count($filesToAttach) > 0 ){
			//Delete files if the contact will not be saved
			foreach($filesToAttach as $fileToDelete){
				JFile::delete(CE_UPLOADED_FILE_PATH.$fileToDelete);
			}
		}

		if (JError::isError($sent)) {
			$msg = JText::_( 'COM_CONTACTENHANCED_ERROR_EMAIL_NOT_SENT');
		}elseif(JRequest::getVar('show_system_message',true)){
			$msg = JText::_('COM_CONTACTENHANCED_EMAIL_THANKS');
		}else{
			$msg = null;
		}
		$session->set('contactenhanced_form_submitted', $this->emailInfo->contact->id);
		

		$template	= (JRequest::getVar('template') ? '&template='.JRequest::getVar('template') : '' );

		$link = $pparams->get('redirect',
					JRoute::_('index.php?option=com_contactenhanced&view=contact&id='
							.$this->emailInfo->contact->slug
							.'&catid='.$this->emailInfo->contact->catslug
							.$tmplURL
							.$template
							.'&submitted=1'
						, false)
				);
		$linkAppend = '';
		if(substr($pparams->get('redirect'), -1) == '?' OR substr($pparams->get('redirect'), -1) == '&'){
			$linkAppendContactInfo  = $this->emailInfo->contact;
			$linkAppendContactInfo->contact_name = $linkAppendContactInfo->name;
			$linkAppendContactInfo->contact_alias = $linkAppendContactInfo->alias;
			unset($linkAppendContactInfo->name);
			unset($linkAppendContactInfo->alias);
			unset($linkAppendContactInfo->articles);
			unset($linkAppendContactInfo->id);
			unset($linkAppendContactInfo->slug);
			unset($linkAppendContactInfo->catslug);
			unset($linkAppendContactInfo->params);
			$linkAppend = $post;
			$linkAppend['visitor_name']	= $linkAppend['name'];
			$linkAppend['referrer']		= base64_encode($linkAppend['referrer']);
			$linkAppend['return']		= base64_encode($linkAppend['return']);
			$linkAppend['content_url']	= base64_encode($linkAppend['return']);
			unset($linkAppend['task']);
			unset($linkAppend['name']);
			unset($linkAppend['option']);
			unset($linkAppend['view']);
			unset($linkAppend['id']);
			unset($linkAppend['category']);
			$linkAppend	= http_build_query($linkAppend).'&amp;'.http_build_query($linkAppendContactInfo);
		}
		

		if($this->emailInfo->return_url){
			if(substr($this->emailInfo->return_url, 0, 4) == 'http' OR ($input->getCmd('after_submit') == 'javascript') AND $this->emailInfo->return_url){
				$this->setRedirect($this->emailInfo->return_url.$linkAppend);
			}else{
				$this->setRedirect($this->emailInfo->return_url.$linkAppend, $msg);
			}
		}elseif ( $pparams->get( 'thankyoupageType' ) == 'html' AND !$pparams->get('redirect')) {
			// Add Compatibility with Google Analytics.
			$doc	= JFactory::getDocument();
			$doc->addScriptDeclaration("
jQuery(document).ready(function($){
	if(typeof(pageTracker) != 'undefined'){
		pageTracker._trackPageview('/".JText::_("CE_FORM_GA_CONTACT_FORM")."/".$this->emailInfo->contact->alias."');
		console.log('pageTracker :: Google Analytics Page tracked');
	}else if(typeof(_gaq) != 'undefined'){
		_gaq.push(['_trackPageview','/".JText::_("CE_FORM_GA_CONTACT_FORM")."/".$this->emailInfo->contact->alias."']);
		console.log('_gaq.push :: Google Analytics Page tracked');
	}
});
");

			echo '<div class="ce-modal-container">';
			if ( $pparams->get( 'show_page_heading', 0 ) ) : ?>
				<h2 class="ce<?php echo $pparams->get( 'pageclass_sfx' ); ?>">
					<?php echo $pparams->get( 'page_title' ); ?></h2>
			<?php endif;
				// Get the document object.
				$tmpl =  $this->getHTMLTemplate($pparams->get('thankyoupageTemplate',1));

				echo $tmpl->html;

			echo '</div>';
		}else if ( $pparams->get( 'thankyoupageType' ) == 'alert' ) {
			$this->setRedirect($link.$linkAppend); //, $msg
		}else{
			if(substr($link, 0, 4) == 'http'){
				$this->setRedirect($link.$linkAppend);
			}else{
				$this->setRedirect($link.$linkAppend, $msg);
			}
		}
	}

	/**
	 * Validates some inputs based on component configuration
	 *
	 * @param Object	$contact	JTable Object
	 * @param String	$email		Email address
	 * @param String	$subject	Email subject
	 * @param String	$body		Email body
	 * @return Boolean
	 * @access protected
	 * @since 1.5
	 */
	function _validateInputs($contact, $email, $subject, $body)
	{
		$app	= JFactory::getApplication();
		$session= JFactory::getSession();

		// Get params and component configurations
		$params = new JRegistry;
		$params->loadString($contact->params);
		$pparams	= $app->getParams('com_contactenhanced');

		// check for session cookie
		$sessionCheck	= $pparams->get('validate_session', 0);
		$sessionName	= $session->getName();
		if  ($sessionCheck) {
			if (!isset($_COOKIE[$sessionName])) {
				$this->setError(JText::_('JERROR_ALERTNOAUTHOR'));
				return false;
			}
		}

		// Determine banned emails
		$configEmail	= $pparams->get('banned_email', '');
		$paramsEmail	= $params->get('banned_mail', '');
		$bannedEmail	= $configEmail . ($paramsEmail ? ';'.$paramsEmail : '');

		// Prevent form submission if one of the banned text is discovered in the email field
		if (false === $this->_checkText($email, $bannedEmail)) {
			$this->setError(JText::sprintf('COM_CONTACTENHANCED_EMAIL_BANNEDTEXT', JText::_('JGLOBAL_EMAIL')));
			return false;
		}

		// Determine banned subjects
		$configSubject	= $pparams->get('banned_subject', '');
		$paramsSubject	= $params->get('banned_subject', '');
		$bannedSubject	= $configSubject . ($paramsSubject ? ';'.$paramsSubject : '');

		// Prevent form submission if one of the banned text is discovered in the subject field
		if (false === $this->_checkText($subject, $bannedSubject)) {
			$this->setError(JText::sprintf('COM_CONTACTENHANCED_EMAIL_BANNEDTEXT',JText::_('COM_CONTACTENHANCED_CONTACT_MESSAGE_SUBJECT')));
			return false;
		}

		// Determine banned Text
		$configText		= $pparams->get('banned_text', '');
		$paramsText		= $params->get('banned_text', '');
		$bannedText	= $configText . ($paramsText ? ';'.$paramsText : '');

		// Prevent form submission if one of the banned text is discovered in the text field
		if (false === $this->_checkText($body, $bannedText)) {
			$this->setError(JText::sprintf('COM_CONTACTENHANCED_EMAIL_BANNEDTEXT', JText::_('COM_CONTACTENHANCED_CONTACT_ENTER_MESSAGE')));
			return false;
		}

		// test to ensure that only one email address is entered
		$check = explode('@', $email);
		if (strpos($email, ';') || strpos($email, ',') || strpos($email, ' ') || count($check) > 2) {
			$this->setError(JText::_('COM_CONTACTENHANCED_NOT_MORE_THAN_ONE_EMAIL_ADDRESS', true));
			return false;
		}

		// Determine banned IP
		$configIP		= $pparams->get('banned_ip', '');
		$paramsIP		= $params->get('banned_ip', '');
		$bannedIP	= $configIP . ($paramsIP ? ';'.$paramsIP : '');

		// Prevent form submission if one of the banned text is discovered in the text field
		if (false === $this->_checkText(ceHelper::getIP(), $bannedIP)) {
			$this->setError(JText::sprintf('COM_CONTACTENHANCED_EMAIL_BANNEDTEXT', JText::_('CE_USER_INFO_IP_ADDRESS')));
			return false;
		}

		$errors	= ceHelper::getSession('errors', array(), false);
		if(count($errors)){
			$this->setError(JText::_('CE_FORM_INVALID_FIELDS_MSG', true));
			return false;
		}

		return true;
	}

	/**
	 * Checks $text for values contained in the array $array, and sets error message if true...
	 *
	 * @param String	$text		Text to search against
	 * @param String	$list		semicolon (;) seperated list of banned values
	 * @return Boolean
	 * @access protected
	 * @since 1.5.4
	 */
	function _checkText($text, $list) {
		if (empty($list) || empty($text)) return true;
		$array = explode(';', $list);
		foreach ($array as $value) {
			$value = trim($value);
			if (empty($value)) continue;
			if (JString::stristr($text, $value) !== false) {
				return false;
			}
			$domain	= substr($text, strrpos($text, "@")+1);
			if($domain == trim($value)){
				return false;
			}
		}
		return true;
	}
	function saveForm(&$emailData){
		JTable::addIncludePath(JPATH_ROOT.'/administrator/components/com_contactenhanced/tables');
		require_once JPATH_ROOT.'/administrator/components/com_contactenhanced/tables/message.php';
		// Initialize variables
		$db		= JFactory::getDBO();
		$table	= JTable::getInstance('message', 'ContactenhancedTable');
		$app	= JFactory::getApplication();
		$message_id = null;

		// Ignore if Message table is not found
		if($table){
			if (!$table->bind( $emailData )) {
				$app->enqueueMessage($row->getError(), 'error');
				return $this->setDisplayError();
			}
			if (!$table->store()) {
				$app->enqueueMessage($row->getError(), 'error');
				return $this->setDisplayError();
			}
			$message_id	= $table->id;
			if( count($emailData->files) > 0 ){
				for($i=0; $i < count($emailData->files); $i++){
					$file = $emailData->files[$i];
					$emailData->files[$i]	= $message_id.'_'.$file;
					rename(CE_UPLOADED_FILE_PATH.$file, CE_UPLOADED_FILE_PATH.$emailData->files[$i]);
				}
			}

			foreach($emailData->fields as $cf){
				$table	= JTable::getInstance('Messagefields', 'ContactenhancedTable');
				$field				= new stdClass();
				$field->id			= 0;
				$field->message_id	= $message_id;
				$field->field_id	= $cf->id;
				$field->field_type	= $cf->type;
				$field->modified	= 0;
				if($cf->type == 'multiplefiles'){
					$field->value	= 	$cf->getMySQLOutput();
				}elseif($cf->type == 'sql'){
					$field->value	= 	$cf->getMySQLOutput();
				}else{
					$field->value	= $cf->uservalue;
				}

				if (!$table->bind( $field )) {
					$app->enqueueMessage($row->getError(), 'error');
					return $this->setDisplayError();
				}
				if (!$table->store()) {
					$app->enqueueMessage($row->getError(), 'error');
					return $this->setDisplayError();
				}

			}
		}

		return $message_id;

	}

	public function getSubject($subject){
		$params	= new JRegistry();

		if(isset($this->customfields['subject'])){
			$params	= $this->customfields['subject']->params;
		}
		if($params->get('prefix') == 'none'){
			// Do nothing
		}else if($params->get('prefix') == 'text'){
			$subject	= $params->get('prefix-text-value'). ' '.$subject;
		}else if($params->get('prefix') == 'content-title'){
			$subject	= $this->emailInfo->last_page_title. ($subject ? ': '.$subject : '');
		}else{
			$app		= JFactory::getApplication();
			$subject	= htmlspecialchars_decode($app->getCfg('sitename')). ': '.$subject;
		}
		$post		= (object)JRequest::get('post');
		$subject	= ceHelper::replaceTags($subject,$post);
		$subject	= ceHelper::replaceTags($subject,$this->emailInfo);
		return $subject;
	}

	function getEmailHTML($tmpl){
		$tmpl = $this->getHTMLTemplate($tmpl);
		return '<html><body style="margin:0">'.$tmpl->html.'</body></html>';
	}

	public function getHTMLTemplate($tmpl = 1) {
		if(isset($this->HTMLtemplate[$tmpl])){
			return $this->HTMLtemplate[$tmpl];
		}
		$app	= JFactory::getApplication();
		$pparams= $app->getParams('com_contactenhanced');
		$jinput = $app->input;
		$userID	= JFactory::getUser()->get('id');


		$db		= JFactory::getDbo();
		$ModelTmpl = JModelLegacy::getInstance('Template', 'ContactenhancedModel', array('ignore_request' => true));

		if(($tmpl = $ModelTmpl->getItem($tmpl))){

			$registry = new JRegistry();
			$registry->loadString($tmpl->params);
			$tmpl->params = &$registry;

			//language replacements
			// expression to search for
			$regex = "#{txt(.*?)}#s";
			// find all instances of plugin and put in $matches
			preg_match_all( $regex, $tmpl->html, $matches );
			$count	= count( $matches[0] );
			//testArray($matches[0]);
			if($count){
				for ( $i=0; $i < $count; $i++ )
				{
					//$txt = str_replace( '{txt:'	, '', $matches[0][$i] );
					//$txt = str_replace( '}'		, '', $txt );
					$txt = preg_replace( '/\{txt: */'	   , '', $matches[0][$i] );
					$txt = preg_replace( '/\}/'			 , '', $txt);
					$tmpl->html 	= str_replace($matches[0][$i], JText::_(trim( $txt )), $tmpl->html);
				}
			}

			//POST replacements

			// expression to search for
			$regex = "#{post(.*?)}#s";
			// find all instances of plugin and put in $matches
			preg_match_all( $regex, $tmpl->html, $matches );
			$count	= count( $matches[0] );
			if($count){
				$db =JFactory::getDBO();
				for ( $i=0; $i < $count; $i++ ){
					$post = preg_replace( '/\{post: */'	 , '', $matches[0][$i] );
					$postVar = preg_replace( '/\}/'			, '', $post);
					$post = $jinput->get($postVar,null, 'html');
					//$post =	JRequest::getVar($post,null,'post',null );
					if(is_array($post)  OR $post == 'Array'){
						$post		= $jinput->post->get($postVar, array(), 'array');
						if(isset($post['value']) AND isset($post['value'][0])){
							$post	= $post['value'][0];
						}elseif (count($post)){
							$post	= ceHelper::implodeRecursive(', ', $post);
						}
					}
					if(is_string($post)){
						$post	= nl2br($post);
					}
					$tmpl->html 	= str_ireplace($matches[0][$i], $post, $tmpl->html);
				}
			}

			// replace tags
			$tmpl->html	= ceHelper::replaceTags($tmpl->html,$this->emailInfo, '', '{', '}', array('attachments'));
			//$date			=JFactory::getDate(time());
			jimport('joomla.utilities.date');
			$tz	= new DateTimeZone(JFactory::getApplication()->getCfg('offset'));
			$date = new JDate(time());
			$date->setTimezone($tz);

			$this->emailInfo->timestamp			= $date->format(JText::_('DATE_FORMAT_LC2'),true);
			$this->emailInfo->DATE_FORMAT_LC	= $date->format(JText::_('DATE_FORMAT_LC'),true);
			$this->emailInfo->DATE_FORMAT_LC1	= $date->format(JText::_('DATE_FORMAT_LC1'),true);
			$this->emailInfo->DATE_FORMAT_LC2	= $this->emailInfo->timestamp;
			$this->emailInfo->DATE_FORMAT_LC3	= $date->format(JText::_('DATE_FORMAT_LC3'),true);
			$this->emailInfo->DATE_FORMAT_LC4	= $date->format(JText::_('DATE_FORMAT_LC4'),true);

			$regex = "#{date(.*?)}#s";
			// find all instances of plugin and put in $matches
			preg_match_all( $regex, $tmpl->html, $matches );
			$count	= count( $matches[0] );
			//testArray($matches[0]);
			if($count){
				for ( $i=0; $i < $count; $i++ )
				{
					//$txt = str_replace( '{txt:'	, '', $matches[0][$i] );
					//$txt = str_replace( '}'		, '', $txt );
					$txt = preg_replace( '/\{date: */'	   , '', $matches[0][$i] );
					$txt = preg_replace( '/\}/'			 , '', $txt);
					if (strpos($matches[0][$i], '|')) {
						list($dateFormat, $timestamp)	= explode('|', $txt);
						$timestamp	= time()+$timestamp;
					}else{
						list($dateFormat, $timestamp)	= array( $txt, time());
					}
					$date = new JDate($timestamp);
					$date->setTimezone($tz);
					$tmpl->html 	= str_replace($matches[0][$i], $date->format($dateFormat), $tmpl->html);
				}
			}

			//SQL replacements
			// expression to search for
			$regex = "#{sql(.*?)}#s";
			// find all instances of plugin and put in $matches
			preg_match_all( $regex, $tmpl->html, $matches );
			$count	= count( $matches[0] );
			if($count){
				for ( $i=0; $i < $count; $i++ )
				{
					// $sql = str_ireplace( '{sql:'	, '', $matches[0][$i] );
					// $sql = str_ireplace( '{sql:'	, '', $matches[0][$i] );
					// $sql = str_ireplace( '}'		, '', $sql );
					// Modified by Daniel V. Maglione - Allows run queries on different databases
					$sql = preg_replace( '/\{sql: */'	, '', $matches[0][$i] );
					$sql = preg_replace( '/\}/'		, '', $sql);

					preg_match('/(.+)\|(.+)\|(.+)\|(.+)\|(.+)/', $sql, $db_tokens);
					if (count($db_tokens) == 6) {
						$sql		 = $db_tokens[1];

						# Reference: http://docs.joomla.org/How_to_connect_to_an_external_database
						$option = array(); //prevent problems
						$config	= JFactory::getConfig();
						$option['driver']   = $config->get('config.dbtype','mysql');		// Database driver name
						$option['host']	 = $db_tokens[2];	// Database host name
						$option['user']	 = $db_tokens[3];	// User for database authentication
						$option['password'] = $db_tokens[4];	// Password for database authentication
						$option['database'] = $db_tokens[5];	// Database name
						$option['prefix']   = '';				// Database prefix (may be empty)

						// connecting to another database
						$db = JDatabase::getInstance( $option );

					}else{
						// Connect to Joomla default database
						$db =JFactory::getDBO();
					}
					// Set query
					$db->setQuery($sql);

					if(substr($sql, 0, (strpos($sql, ' '))) == 'SELECT'){
						$tmpl->html 	= str_ireplace($matches[0][$i], $db->loadResult(), $tmpl->html);
					}else{
						$db->query($sql);
						$tmpl->html 	= str_ireplace($matches[0][$i], '', $tmpl->html);
					}
				}
				unset($db);
			}


			// Custom Fields replacements
			// expression to search for
			$regex = "#{form_fields(.*?)}#s";

			$tmpl->html = str_ireplace("{custom_fields", "{form_fields",$tmpl->html); // Will remove all {custom_fields

			// find all instances of plugin and put in $matches
			preg_match_all( $regex, $tmpl->html, $matches );

			$count	= count( $matches[0] );
			if($count){

				for ( $i=0; $i < $count; $i++ )
				{
					$format = 'div'; // setting default format

					$inline_params = str_replace( '{form_fields', '', $matches[0][$i] );
					$inline_params = str_replace( '}', '', $inline_params );
					$inline_params = trim( $inline_params );

					if(strpos($inline_params, '|') === false AND strlen($inline_params) > 2)
					{ // Has to at least display 2 fields
						// make sure there is no spaces
						$allowedCustomFields = str_replace( ' ', '', $inline_params);
					}
					elseif(strpos($inline_params, '|') !== false)
					{
						$format_matches = array();
						preg_match( "#format=\|(.*?)\|#s", $inline_params, $format_matches );
						if (isset($format_matches[1]) ){
							$format = $format_matches[1];
						}

						$id_matches = array();
						preg_match( "#ids=\|(.*?)\|#s", $inline_params, $id_matches );
						if (isset($id_matches[1]) ){
							$allowedCustomFields = str_replace( ' ', '', $id_matches[1]);
						}
					}


					if(!empty($allowedCustomFields))
					{
						$allowedCustomFields = explode(',', $allowedCustomFields);
					}
					else
					{
						$allowedCustomFields = array();
					}
					$custom_fields	= '';
					$fieldLables = array();
					$fieldValues = array();
					foreach ($this->submittedFields as $cf){
						if(!count($allowedCustomFields)
							OR in_array($cf->id, $allowedCustomFields)
						){
							if($format == 'table')
							{
								$custom_fields .= "\n".'<tr><td>'.$cf->getName().'</td><td>'.$cf->getSubmittedValue().'</td></tr>';
							}
							elseif($format == '2tables')
							{
								$fieldLables[] = '<tr><td  style="text-align:right">'.$cf->getName().'</td></tr>';
								$fieldValues[] = '<tr><td>'.$cf->getSubmittedValue().'</td></tr>';
							}
							else
							{
								$custom_fields .= $cf->getEmailOutput(
														', '
														, 'html'
														, array(
																'label'=>$tmpl->params->get('style-cf-label')
																,'value'=>$tmpl->params->get('style-cf-value')
														)
												);
							}
						}
					}
					if($format == 'table')
					{ // Compatible with Bootstrap (for front-end purposes
						$custom_fields = '<table class="table table-striped table-bordered table-hover">'.$custom_fields.'</table>';
					}
					elseif($format == '2tables')
					{
						$fieldLables = "\n".'<table class="table table-striped table-bordered table-hover span6 col-md-6" style="width:45%;float:left;font-weight:bolder">'.implode("\n",$fieldLables).'</table>';
						$fieldValues = "\n".'<table class="table table-striped table-bordered table-hover span6 col-md-6" style="width:45%;float:left">'.implode("\n",$fieldValues).'</table>';
						$custom_fields = $fieldLables.$fieldValues.'<br style="clear:both" />';
					}
					$tmpl->html 	= str_replace($matches[0][$i], $custom_fields, $tmpl->html);
				}
			}
			
			// Custom Fields replacements
			// expression to search for
			$regex = "#{microdata(.*?)}#s";
			
			// find all instances of plugin and put in $matches
			preg_match_all( $regex, $tmpl->html, $matches );
			
			$count	= count( $matches[0] );
			if($count){
				jimport('joomla.microdata.microdata');
			
				for ( $i=0; $i < $count; $i++ )
				{
					$format = 'div'; // setting default format
			
					$inline_params = str_replace( '{microdata', '', $matches[0][$i] );
					$inline_params = str_replace( '}', '', $inline_params );
					$inline_params = trim( $inline_params );
			
					$type_matches = array();
					preg_match( "#type=\|(.*?)\|#s", $inline_params, $type_matches );
					if (isset($type_matches[1]) ){
						$type = $type_matches[1];
					}
					
					$scope_matches = array();
					preg_match( "#scope=\|(.*?)\|#s", $inline_params, $scope_matches );
					if (isset($scope_matches[1]) ){
						$scope = $scope_matches[1];
					}
					
					$microdataHTML = '';
					if($type == 'contact_info'){
						if (empty($scope)){
							$scope = 'Person';
						}
						$contact = &$this->emailInfo->contact;
						
						$microdata = new JMicrodata($scope);
						$microdataHTML .= '<div '.$microdata->displayScope().'>';
						if(!empty($contact->image)){
							$microdataHTML .= JHtml::_('image', JUri::root().$contact->image, ''
										, array('class' => 'pull-right', 'itemprop' => "image", 'style'=>'float:right')
									);
						}
						if(!empty($contact->name)){
							$microdataHTML .= $microdata->content($contact->name)->property('Employee')->fallback('Person', 'name')->display();
						}
						if(!empty($contact->con_position)){
							$microdataHTML .= $microdata->content($contact->con_position)->property('jobTitle')->display('div');
						}
						$microdataHTML .= "\n".ceHelper::getFormattedContactAddress($contact, $pparams);
						
						if(!empty($contact->telephone)){
							$microdataHTML .= $microdata->content($contact->telephone)->property('telephone')->display().' | ';
						}
						if(!empty($contact->mobile)){
							$microdataHTML .= $microdata->content($contact->mobile)->property('telephone')->display().' ';
						}
						if(!empty($contact->webpage)){
							$microdataHTML .= $microdata->content($contact->webpage)->property('url')->display('div');
						}
						
						$microdataHTML .= '</div>';
					}else if($type == 'contact_info'){
						
					}
					$tmpl->html 	= str_replace($matches[0][$i], $microdataHTML, $tmpl->html);
				}
			}

			// replace tags
			$tmpl->html	= ceHelper::replaceTags($tmpl->html,$this->emailInfo, '', '{', '}', array('attachments'));

			// Replace Post Tags
			$post		= (object)JRequest::get('post');
			$tmpl->html 	= ceHelper::replaceTags($tmpl->html ,$post);

			// Process Content plugins at last
			if($tmpl->params->get('processplugins')){
				$param = JComponentHelper::getParams('com_contactenhanced');
				$tmpl->text = &$tmpl->html;
				ceHelper::processContentPlugin($param, $tmpl);
			}

			$this->HTMLtemplate[$tmpl->name] = $tmpl;
			return $tmpl;
		}else{
			JError::raiseError('500', JText::sprintf('CE_ERROR_TEMPLATE_NOT_FOUND', $tmpl));
		}
	}

	private function registration(&$pparams,&$obj){

		$app		=JFactory::getApplication();
		$lang		=JFactory::getLanguage();
		$lang->load('com_users');
		jimport('joomla.user.helper');

		$email	= $obj->email;
		$name	= $obj->name;
		// Initialize some variables
		$authorize	= JFactory::getACL();
		$db			= JFactory::getDBO();
		$MailFrom 	= $app->getCfg('mailfrom');
		$FromName 	= $app->getCfg('fromname');
		$SiteName	= $app->getCfg('sitename');

		// If user registration is not allowed, show notify Site Administrator.
		$usersConfig = JComponentHelper::getParams( 'com_users' );
		if($usersConfig->get('allowUserRegistration') == '0') {

			$mail = JFactory::getMailer();
			$mail->addRecipient( $MailFrom );
			$mail->setSender( array( $MailFrom, $FromName ) );
			$mail->setSubject( $SiteName .': '.JText::_('CE_REGISTRATION_NOT_ALLOWED') );
			$body = JText::_('CE_REGISTRATION_NOT_ALLOWED'). "\n\n"
					. JText::_('CE_REGISTRATION_NOT_ALLOWED_DESC');
			$mail->setBody( $body );
			$mail->Send();

			return false;
		} //end if

		// Remove the domain from the email
		$username	= preg_replace( "/^([^@]+)(@.*)$/", "$1", $email);
		$username	= JRequest::getVar('username',$username);

		$query	= $db->getQuery(true);
		$query->select('count(id)');
		$query->from('#__users');
		$query->where('username = '.$db->Quote($username). ' OR email = '.  $db->Quote($email));

		$db->setQuery( $query );
		//   Abort operation if the user is already registered
		if($db->loadResult() > 0){
			$app->enqueueMessage(JText::sprintf('CE_REGISTRATION_USER_REGISTERED_OR_USERNAME_NOT_AVAILABLE',$email,$username),'notice');
			return false;
		}

		$password 		= ceHelper::generateToken(8);
		$password		= JRequest::getVar('password',$password);

		$info	= array();
		$info['email']	= $email;
		$info['email1']	= $email;
		$info['name']	= $name;
		$info['username']	= $username;
		$info['password']	= $password;
		$info['password1']	= $password;
		$info['password2']	= $password;

		require_once (JPATH_ROOT.'/components/com_users/models/registration.php');
		$uModel	= $this->getModel('Registration', 'UsersModel');
		$return	= $uModel->register($info);

		// Check for errors.
		if($return === false) {
			// Save the data in the session.
			$app->setUserState('com_users.registration.data', $info);

			$mail = JFactory::getMailer();
			$mail->addRecipient( $MailFrom );
			$mail->setSender( array( $MailFrom, $FromName ) );
			$mail->setSubject( $SiteName .': '.JText::_('CANNOT SAVE THE USER INFORMATION') );

			$body = JText::_('CANNOT SAVE THE USER INFORMATION'). "\n\n";
			$body .= JText::_('User info'). ":\n";
			$body .= JText::_('Name').":\t".$info['name']."\n";
			$body .= JText::_('Email').":\t".$info['email']."\n";
			$body .= JText::_('Username').":\t".$info['username']."\n";

			$mail->setBody( $body );
			$mail->Send();

			// Redirect back to the edit screen.
			$app->enqueueMessage(JText::sprintf('COM_USERS_REGISTRATION_SAVE_FAILED', $uModel->getError()), 'warning');

			return false;
		}

		// Flush the data from the session.
		$app->setUserState('com_users.registration.data', null);

		// Redirect to the profile screen.
		if($return === 'adminactivate'){
			$app->enqueueMessage(JText::_('COM_USERS_REGISTRATION_COMPLETE_VERIFY'));
		} else if($return === 'useractivate') {
			$app->enqueueMessage(JText::_('COM_USERS_REGISTRATION_COMPLETE_ACTIVATE'));
		}else{
			$app->enqueueMessage(JText::_('COM_USERS_REGISTRATION_SAVE_SUCCESS'));
		}


	}


	function sendDebugMessage($subject='') {
		// Initialize some variables
		jimport('joomla.mail.helper');
		$app	= JFactory::getApplication();
		$mail 	= JFactory::getMailer();
		// Create the JConfig object
		$config = new JConfig();
		//debug_mode
		$MailFrom 	= $app->getCfg('mailfrom');
		$FromName 	= $app->getCfg('fromname');

		$mail->addRecipient( $MailFrom);
		$mail->setSender( array( $MailFrom, $FromName ) );
		$mail->setSubject( JText::sprintf('COM_CONTACTENHANCED_DEBUG_MSG_SUBJECT',$subject) );
		$bodyTXT	= '';
		$bodyHTML	= '';
		$recomemdedSettings	= '';


		$bodyTXT	.= JText::_('COM_CONTACTENHANCED_DEBUG_MSG_NOTE');
		$bodyHTML	.= '<div>'.JText::_('COM_CONTACTENHANCED_DEBUG_MSG_NOTE').'</div>';



		//Remove all secret information
		$config->ftp_user	= ($config->ftp_user ? "**************" : JText::_("JNONE"));
		$config->ftp_pass	= ($config->ftp_pass ? "**************" : JText::_("JNONE"));
		$config->ftp_root	= ($config->ftp_root ? "**************" : JText::_("JNONE"));
		$config->ftp_host	= ($config->ftp_host ? "**************" : JText::_("JNONE"));
		$config->ftp_port	= ($config->ftp_port ? "**************" : JText::_("JNONE"));
		$config->smtppass	= ($config->smtppass ? "**************" : JText::_("JNONE"));
		$config->smtpuser	= ($config->smtpuser ? "**************" : JText::_("JNONE"));
		$config->secret		= ($config->secret	 ? "**************" : JText::_("JNONE"));
		$config->user		= ($config->user	 ? "**************" : JText::_("JNONE"));
		$config->db			= ($config->db		 ? "**************" : JText::_("JNONE"));
		$config->password	= ($config->password ? "**************" : JText::_("JNONE"));

		$bodyTXT	.= "\n\n ------------- JOOMLA CONFIG ------------\n";
		$bodyTXT	.= JText::_("COM_CONTACTENHANCED_DEBUG_JOOMLA_CONFIG_REMOVED_SENSITIVE_INFORMATION")."\n\n";
		$bodyTXT	.= "".JText::_("COM_CONTACTENHANCED_DEBUG_JOOMLA_CONFIG_ACCESS")."\n\n";
		$var	= '';
		$key	= '';

		ceHelper::array2string($config,$var,$key);
		$bodyTXT	.=	$var;

		$bodyHTML	.= '<h3>------------- JOOMLA CONFIG ------------</h3>';
		$bodyHTML	.= "<h5>".JText::_("COM_CONTACTENHANCED_DEBUG_JOOMLA_CONFIG_REMOVED_SENSITIVE_INFORMATION")."</h5>";
		$bodyHTML	.= "<div>".JText::_("COM_CONTACTENHANCED_DEBUG_JOOMLA_CONFIG_ACCESS")."</div>";

		if($config->mailer !='smtp'){
			$bodyHTML	.= '<br /><strong>'.JText::_("COM_CONTACTENHANCED_DEBUG_RECOMMENDED").':</strong>';
			$bodyHTML	.= '<table width="100%" boder="1" style="border:1px dashed #DDD">';
			if($config->mailer !='smtp'){
				$bodyHTML	.= '<tr><td style="width:40%">'
								.JText::_("COM_CONTACTENHANCED_DEBUG_JOOMLA_CONFIG_MAILER_LABEL")
								.': </td><td style="color:red;"><strong>SMTP</strong>'.'</td></tr>';
			}
			$bodyHTML	.= '</table>';
		}
		if((int)$config->error_reporting != 6143 OR (int)$config->debug == 0){
			$bodyHTML	.= '<br /><strong>'.JText::_("COM_CONTACTENHANCED_DEBUG_RECOMMENDED_WHILE_DEVELOPMENT").':</strong>';
			$bodyHTML	.= '<table width="100%" border="1" style="border:1px dashed #DDD">';
			if((int)$config->error_reporting != 6143){
				$bodyHTML	.= '<tr><td style="width:40%">'
								.JText::_("COM_CONTACTENHANCED_DEBUG_JOOMLA_CONFIG_ERROR_REPORTING_LABEL")
								.': </td><td style="color:orange;"><strong>'
										.JText::_('COM_CONTACTENHANCED_FIELD_VALUE_MAXIMUM').'</strong>'.'</td></tr>';
			}
			if((int)$config->debug == 0){
				$bodyHTML	.= '<tr><td style="width:40%">'
								.JText::_("COM_CONTACTENHANCED_DEBUG_JOOMLA_CONFIG_DEBUG_MODE_LABEL")
								.': </td><td style="color:orange;"><strong>'
										.JText::_('JYES').'</strong>'.'</td></tr>';
			}
			$bodyHTML	.= '</table>';
		}
		$bodyHTML	.= ceHelper::print_r($config);


		$pparams = $app->getParams('com_contactenhanced');
		$var	= "\n\n ------------- COMPONENT PARAMETERS ------------\n";
		$key	= '';
		ceHelper::array2string($pparams,$var,$key);
		$bodyTXT	.=	$var;

		$bodyHTML	.= '<h3>------------- COMPONENT PARAMETERS ------------</h3>';
		$bodyHTML	.= ceHelper::print_r($pparams);

		$bodyTXT	.= "\n\n ------------- PHP VERSION ------------\n";
		$bodyTXT	.= phpversion();

		$bodyHTML	.= '<h3>------------- PHP VERSION ------------</h3>';
		$bodyHTML	.= phpversion();

		$var	= "\n\n ------------- POST ------------\n";
		$key	= '';
		ceHelper::array2string(JRequest::get('post'),$var,$key);
		$bodyTXT	.=	$var;

		$bodyHTML	.= '<h3>------------- POST ------------</h3>';
		$bodyHTML	.= ceHelper::print_r(JRequest::get('post'));

		$var	= "\n\n ------------- SESSION ------------\n";
		$key	= '';
		ceHelper::array2string($_SESSION,$var,$key);
		$bodyTXT	.=	$var;

		$bodyHTML	.= '<h3>------------- SESSION ------------</h3>';
		$bodyHTML	.= ceHelper::print_r(JRequest::get('session'));

		$var	= "\n\n ------------- COOKIE ------------\n";
		$key	= '';
		ceHelper::array2string($_COOKIE,$var,$key);
		$bodyTXT	.=	$var;

		$var	= "\n\n ------------- GET ------------\n";
		$key	= '';
		ceHelper::array2string($_GET,$var,$key);
		$bodyTXT	.=	$var;

		$bodyHTML	.= '<h3>------------- GET ------------</h3>';
		$bodyHTML	.= ceHelper::print_r(JRequest::get('get'));

		/*	$var	= "\n\n ------------- GLOBALS ------------\n";
		 $key	= '';
		 ceHelper::array2string($GLOBALS,$var,$key);
		 $bodyTXT	.=	$var;*/

		$var	= "\n\n ------------- SERVER ------------\n";
		$key	= '';
		ceHelper::array2string($_SERVER,$var,$key);
		$bodyTXT	.=	$var;

		$bodyHTML	.= '<h3>------------- SERVER ------------</h3>';
		$bodyHTML	.= ceHelper::print_r($_SERVER);

		$var	= "\n\n ------------- ENV ------------\n";
		$key	= '';
		ceHelper::array2string($_ENV,$var,$key);
		$bodyTXT	.=	$var;

		$bodyHTML	.= '<h3>------------- ENV ------------</h3>';
		$bodyHTML	.= ceHelper::print_r($_ENV);

		$bodyTXT	.= strip_tags(ceHelper::getSystemInfo(array()));
		$bodyHTML	.= '<br/><br/>'.ceHelper::getSystemInfo(array());

		$mail->setBody( $bodyTXT );
		$mail->MsgHTML( $bodyHTML );
		$mail->AltBody= $bodyTXT;

		$mail->Send();
	}

	public function _getUsersByGroup($groups) {
		jimport('joomla.application.component.model');
		JModelLegacy::addIncludePath(JPATH_SITE.'/administrator/components/com_users/models');

		// Get an instance of the generic users model
		$users = JModelLegacy::getInstance('Users', 'UsersModel', array('ignore_request' => true));

		// Set the filters based on the module params
		$users->setState('list.start', 0);
		$users->setState('list.limit', 9999999);
		$users->setState('filter.published', 1);

		if (isset($groups)){
			for($i=0;$i<count($groups);$i++){
				if(empty($groups[$i]) OR $groups[$i] < 1 OR $groups[$i] == ''){
					unset($groups[$i]);
				}
			}
			JArrayHelper::toInteger($groups);
		}
		$users->setState('filter.groups', $groups);

		$users	= $users->getItems();
		return $users;
	}

	private function setDisplayError(){
		if(JRequest::getVar('content_url')
			AND (JRequest::getVar('formType') == 'plugin' OR JRequest::getVar('formType') == 'module'
				OR JRequest::getVar('plugin_load_method') == 'embedded')
		){
			$this->setRedirect(ceHelper::decode(JRequest::getVar('content_url'),'base64'));
			return true;
		}elseif($this->emailInfo->return_url AND (JRequest::getVar('formType') == 'plugin' OR JRequest::getVar('formType') == 'module') ){
			$this->setRedirect($this->emailInfo->return_url);
			return true;
		}else{
			$this->display();
			return false;
		}
	}
}

