<?php
/**
 * @package		com_contactenhanced
 * @copyright	Copyright (C) 2006 - 2015 IdealExtensions.com. All rights reserved
 * @author	 Douglas Machado {@link http://idealExtensions.com}
 * @author	 Created on 28-Jul-09
 * @license		GNU/GPL, see license.txt
 */
defined( '_JEXEC' ) or die( 'Restricted access' );

JHtml::_('jquery.framework', true, null, false);

/**
 *
 * Abstract ceFieldType class.
 *
 */
class ceFieldType {
	var $id 		= null;
	var $name 		= null;
	var $value		= null;
	var $type 		= null;
	var $attributes	= null;
	var $uservalue	= null;
	var $arrayFieldElements = null;
	var $allowHTML	= false;
	var $params		= null;
	var $errors		= array();
	var $required	= false;
	var $attr 		= null;

	function ceFieldType( $data,&$params ) {

		if( !empty($data) ){
			foreach( $data AS $key => $value ) {
				switch($key){
					case 'value':
						$this->arrayFieldElements = explode("|",$data->$key);
						$this->$key = $value;
						break;
					default:
						$this->$key = $value;
						break;
				}
			}
		}
		if(!empty($this->alias)){
			$this->field_value = JFactory::getApplication()->input->get($this->alias);
		}
		
		$this->params	= $params;
		$this->session 	= JFactory::getSession();
		$this->session	= $this->session->get('com_contactenhanced');

		$this->getFieldAttributes();
	}

	function validateField() {
		if($this->isRequired() AND empty($this->uservalue) AND (int)$this->uservalue !=0){
			return false;
		}
		return true;
	}

	public function getValidationRule(){

	}
	protected function addValidationRule(){
		//decided NOT to add additional-methods.js in order to save bandwidth and one more http request
		$doc	= JFactory::getDocument();
		switch ($this->params->get('validation')){
			case 'numberic':
			case 'number':
				return 'number';
				break;
			case 'integer':
				return 'digits';
				break;
			case 'digits':
				$doc->addScriptDeclaration("
jQuery(document).ready(function($){
	jQuery.validator.addMethod('digits_extended',function(value,element){
		return this.optional(element) || /^[\d() .:\-\+#]+$/.test(value);
	},'".JText::_('COM_CONTACTENHANCED_VALIDATION_ERROR_DIGITS')."');
});
");
				return 'digits_extended';
				break;
			case 'alpha':
				$doc->addScriptDeclaration("
jQuery(document).ready(function($){
	jQuery.validator.addMethod('alpha',function(value,element){
		return this.optional(element) || /^[a-zA-Z]+$/.test(value);
	},'".JText::_('COM_CONTACTENHANCED_VALIDATION_ERROR_ALPHA')."');
});
");
				return 'alpha';
				break;
			case 'alphanum':
				$doc->addScriptDeclaration("
jQuery(document).ready(function($){
	jQuery.validator.addMethod('alphanum',function(value,element){
		return this.optional(element) || !(/\W/).test(value);
	},'".JText::_('COM_CONTACTENHANCED_VALIDATION_ERROR_ALPHANUM')."');
});
");
				return 'alphanum';
				break;

			default:
				return $this->params->get('validation');
		}
	}

	function getFieldClass() {
		$session		= JFactory::getSession();
		$ce_session		= $session->get('com_contactenhanced');
		$errors			= (isset($ce_session['errors']) ? $ce_session['errors'] : array());
		return ($this->isRequired() ? ' required ':'')
			. (in_array($this->getInputName(), $errors) ? ' error ': '')
			. $this->attr->get('class')
		;
	}

	function getFieldAttributes() {
		$xml = new SimpleXMLElement("<element $this->attributes />");
		$this->attr = new JObject();
		foreach($xml->attributes() as $var => $value) {
			$this->attr->$var 	= (string)$value;
		}
		$this->attributes = preg_replace('#\s(id|class)="[^"]+"#', '', $this->attributes);
		$required = ('');
		if($this->isRequired()){
			$required .= ( ' required '); //data-rule-required="true"
		}
		if( trim( $this->params->get('minLength') ) ){
			$required	.= ' data-rule-minLength="'.$this->params->get('minLength',0).'" ';
		}
		if( trim( $this->params->get('maxLength') ) ){
			$required	.= ' data-rule-maxLength="'.$this->params->get('maxLength').'" ';
		}
		if( $this->params->get('placeholder')){
			$this->attributes	.= ' placeholder="'. $this->params->get('placeholder-1-text',$this->name).'" ';
		}
		// Adds placeholder support for older browsers that do not support HTML5, including IE6
		if(strpos($this->attributes, 'placeholder="') AND !defined('CE_PLACEHOLDER_SCRIPT_LOADED')){
			define('CE_PLACEHOLDER_SCRIPT_LOADED',1);
			$doc =JFactory::getDocument();
			$doc->addScript(JURI::root().'components/com_contactenhanced/assets/js/jquery.placeholder.js');
			//$doc->addScriptDeclaration("jQuery('input,textarea').placeholder();");
		}
		$this->attributes .= $required;
	}

	function getEmailOutput($delimiter= ', ',$format='text',$style=array('label'=>'','value'=>'')){
		if($format == 'html'){
			// Line breaks added because of an incompatibility with MS Outlook
			$html	= '
			<div class="ce-cf-container">';
			if( is_array($this->uservalue) ){
				$this->uservalue	= implode($delimiter,$this->uservalue);
			}
			$html .= '
			<span class="ce-cf-html-label" style="'.$style['label'].'">'.
						JText::sprintf("COM_CONTACTENHANCED_LABEL_OUTPUT",($this->getInputFieldName())).'</span>' ;
			if($this->type == 'checkbox'
				OR $this->type == 'selectlist'
				OR $this->type == 'radiobutton'
				OR $this->type == 'selectmultiple'
			){
				$html .= '
				<span class="ce-cf-html-field" style="'.$style['value'].'"> '
					.($this->uservalue).'</span>' ;
			}else{
				$html .= '
				<span class="ce-cf-html-field" style="'.$style['value'].'"> '
					.($this->uservalue).'</span>' ;
			}
			$html	.= '
			</div>';
			return $html;
		}else{
			if( is_array($this->uservalue) ){
				if(isset($this->uservalue[0]) AND is_array($this->uservalue[0])){
					$this->uservalue = implode($delimiter,$this->uservalue[0]);
				}else{
					$this->uservalue = implode($delimiter,$this->uservalue);
				}
			}
			return $this->getInputFieldName() .":\t ".($this->uservalue)."\n";
		}
	}
	function getMySQLOutput(){
		if( is_array($this->uservalue) ){
			return implode('|',$this->uservalue);
		}else{
			return $this->uservalue;
		}
	}

	public function getSubmittedValue(){
		$value = $this->getMySQLOutput();
		$value = str_replace('|', ', ', $value);
		return $value;
	}

	function isRequired() {
		if($this->required){ return true;}else{ return false;}
	}

	public function getAppendPrepend($input){
		$html = '';
		if($this->params->get('prepend') OR $this->params->get('append')){
			$divClass = 'input-group '.($this->params->get('prepend') ? ' input-prepend ': '')
			.($this->params->get('append') ? ' input-append ': '');
			$html .= '<div class="'.$divClass.'">';
			if($this->params->get('prepend')){
				$html .= '<span class="input-group-addon add-on">'.$this->params->get('prepend').'</span>';
			}
			$html .= $input;
			if($this->params->get('append')){
				$html .= '<span class="input-group-addon add-on">'.$this->params->get('append').'</span>';
			}
			$html .= '</div>';
			$html .= '<label class="error" for="'.$this->getInputId().'"></label>';
		}else{
			$html = $input;
		}
		return $html;
	}

	function parseValue( $value ) { if ( is_array($value) ) { return ($this->allowHTML) ? implode("|",$value) : strip_tags(implode("|",$value));}else{ $value = trim($value); return ($this->allowHTML) ? $value : strip_tags($value);}
	}
	public function isValidUrl($url) {
		return preg_match("/\b(?:(?:https?|ftp):\/\/|www\.)[-a-z0-9+&@#\/%?=~_|!:,.;]*[-a-z0-9+&@#\/%=~_|]/i", $url);
	}
	function getFieldType() { return $this->type;}
	function getValue($arg=null) {

		$savedSessionVar = ceHelper::getSession($this->alias, JRequest::getVar($this->getInputName(),$this->value,'default', 'none', JREQUEST_ALLOWHTML), false);
	
		if($savedSessionVar){
			return $savedSessionVar;
		}else{
			return $this->value;
		}

	}
	function getInputHTML()
	{
		$title 	='';
		if(strpos($this->attributes, 'title=') !== false){
			//$title 	= 'title="'.$this->name.'"';
		}

		$input = '<input '.$title.' class="inputbox text_area cf-input-text '.($this->getFieldClass()).'"
					type="text" name="' . $this->getInputName() . '"
					id="' . $this->getInputName() . '"
					value="' . htmlspecialchars($this->getValue()) . '" '.$this->attributes.' />'
				//.'<br />'
				;
		$html = '';
		$html .= $this->getAppendPrepend($input);
		return $html;

	}
	function getName()
	{
		return ($this->name);
	}
	function getInputFieldName($count=1)
	{
		if($count == 1) {
			return $this->getName();
		} else if($count <= $this->numOfInputFields ) {
			return $this->getName() . '_' . $count;
		}
	}

	function getInputName($count=1) {
		return (isset($this->alias) ? $this->alias : 'cf_'.$this->id);
	}
	function getLastError(){
		return end($this->errors);
	}

	function getOutput($view=1)
	{
		return $this->getValue();
	}

	function stripTags($value, $allowedTags='u,b,i,a,ul,li,pre,br,blockquote')
	{
		if (!empty($allowedTags)) {
			$tmp = explode(',',$allowedTags);
			array_walk($tmp,'trim');
			$allowedTags = '<' . implode('><',$tmp) . '>';
		}else{
			$allowedTags = '';
		}
		return strip_tags($value, $allowedTags );
	}

	function strlen_utf8($str)
	{
		return strlen(utf8_decode($this->utf8_html_entity_decode($str)));
	}
	function utf8_replaceEntity($result)
	{
		$value = intval($result[1]);
		$string = '';
		$len = round(pow($value,1/8));
		for ($i=$len; $i>0; $i--) {
			$part = ($value AND(255>>2)) | pow(2,7);
			if($i == 1 ) {
				$part |= 255<<(8-$len);
			}
			$string = chr($part) . $string;
			$value >>= 6;
		}
		return $string;
	}
	function utf8_html_entity_decode($string)
	{
		return preg_replace_callback('/&#([0-9]+);/u',array($this,'utf8_replaceEntity'),$string);
	}
	function html_cutstr($str, $len)
	{
		if (!preg_match('/\&#[0-9]*;.*/i', $str)) {
			return substr($str,0,$len);
		}
		$chars = 0;
		$start = 0;
		for ($i=0; $i < strlen($str); $i++) {
			if($chars >= $len) {
				break;
			}
			$str_tmp = substr($str, $start, $i-$start);
			if (preg_match('/\&#[0-9]*;.*/i', $str_tmp)) {
				$chars++;
				$start = $i;
			}
		}
		$rVal = substr($str, 0, $start);
		if (strlen($str) > $start) {
			return $rVal;
		}
	}
	function html_substr($str, $start, $length = NULL)
	{
		if($length === 0) {
			return '';
		}
		if (strpos($str, '&') === false) {
			if($length === NULL) {
				return substr($str, $start);
			}else{
				return substr($str, $start, $length);
			}
		}
		$chars = preg_split('/(&[^;\s]+;)|/', $str, -1, PREG_SPLIT_NO_EMPTY | PREG_SPLIT_DELIM_CAPTURE | PREG_SPLIT_OFFSET_CAPTURE);
		$html_length = count($chars);
		if (($html_length === 0) or($start >= $html_length) or(isset($length) and($length <= -$html_length)) ) {
			return '';
		}
		if($start >= 0) {
			$real_start = $chars[$start][1];
		}else{
			$start = max($start,-$html_length);
			$real_start = $chars[$html_length+$start][1];
		}
		if (!isset($length)) {
			return substr($str, $real_start);
		} else if($length > 0) {
			if($start+$length >= $html_length) {
				return substr($str, $real_start);
			}else{
				return substr($str, $real_start, $chars[max($start,0)+$length][1] - $real_start);
			}
		}else{
			return substr($str, $real_start, $chars[$html_length+$length][1] - $real_start);
		}
	}
	function html_strlen($str)
	{
		$chars = preg_split('/(&[^;\s]+;)|/', $str, -1, PREG_SPLIT_NO_EMPTY | PREG_SPLIT_DELIM_CAPTURE);
		return count($chars);
	}
	function getObjectVars()
	{
		var_dump(get_object_vars($this));
	}

	function getLabel($output='site'){
		$html	= '';
		$class	= '';
		JHtml::_('bootstrap.tooltip');
		$errors	= ceHelper::getSession('errors', array());
		if(in_array($this->alias, $errors)){
			$class = ' invalid';
		}
		if(($this->params->get('hide_field_label',0) ==0 )){
			$tooltip_image	= '';

			if($this->tooltip AND $this->params->get('tooltip_behavior','mouseover') == 'image'){
				$tooltip_image = JHtml::_('image'
										, 'components/com_contactenhanced/assets/images/tooltip/'.$this->params->get('tooltip_behavior-image-image','default-blue-help-icon.png')
										, ' ? '
										);
				$tooltip_image = ' <span class="ce-tooltip-image hasTooltip"  title="'. JText::_( $this->tooltip ). '">'
									. $tooltip_image
								. '</span>';
			}

			$label= '<label
							class="cf-label'.$class.($this->isRequired() ? ' requiredField':'').'"
							for="'.$this->getInputId().'"
							id="l'.$this->getInputId().'">'
						.( $this->getInputFieldName() )
						.($this->isRequired() ? ' <span class="requiredsign">'.JText::_('CE_FORM_REQUIRED_SIGN').'</span>' : '')
						.$tooltip_image
					.'</label>';
			if($this->tooltip AND $this->params->get('tooltip_behavior','mouseover') == 'mouseover'){
				$html .= '<span class="hasTooltip" title="'. JText::_( $this->tooltip ). '">'
						. $label
						. '</span>';

			}elseif($this->tooltip AND $this->params->get('tooltip_behavior') == 'inline'){
				$html .= $label;
				$html .= '<div class="ce-tooltip"><small class="muted text-muted" >'. JText::_( $this->tooltip ). '</small></div>';
			}else{
				$html .= $label;
			}
		}
		return $html;
	}
	function getInputId() {
		return $this->getInputName();
	}
	public function getFieldHTML(){
		$input = JFactory::getApplication()->input;
		$html	= '';
		if($this->published AND $this->type != 'hidden' AND $this->type != 'freetext' OR (!$this->params->get('isAdmin')) ){
			$style	= ($this->params->get('hide_field',0) ? 'display:none;' : ''	);

			$containerClass = 'ce-cf-container cf-type-'.$this->type. ' ';
			if($this->params->get('field_width_type') == 'bootstrap'){
				$col = intval($this->params->get('field_width_type-bootstrap-width')); // old option was span12 instead of 12
				$containerClass	.= ' span'.$col.' col-md-'.$col.' '; // Compatible with Bootstrap 2 and 3
				if($input->getCmd('tmpl') == 'component'){
					$containerClass	.= ' col-sm-'.$col;
				}
			}else{
				//ensure compatibility with old versions
				$containerClass	.= 'ce-fltwidth-'.round($this->params->get('field_width_type-percentage-width',$this->params->get('field-width',100)));
			}

			$html .= "\n".'<div class="'.$containerClass.'" id="ce-cf-container-'.$this->id.'" style="'.$style.'">';
			$html .= "\n\t".$this->getLabel();
			$html .= "\n\t".$this->getInputHTML();
			$html .= "\n".'</div>';
		}else{
			$html .= $this->getLabel();
			$html .= $this->getInputHTML();
		}
		if($this->params->get('isAdmin')){
			$html .= $this->getRecordedFieldId();
		}
		return $html;
	}
	function getRecordedFieldId(){
		return '<input type="hidden" name="'.$this->getInputName().'_id" value="'.$this->field_id.'" />';
	}
	public function getValidationScript() {
		$script = '';

		return $script;
	}
	public function escapeJSText($string) {
		return addslashes($string);
		//return str_replace("\n", '\n', str_replace('"', '\"', addcslashes(str_replace("\r", '', (string)$string), "\0..\37'\\")));
	}
}

class ceFieldType_gmapsaddress extends ceFieldType {
	function getInputHTML() {
		$html		= '';

		$map 		= ceHelper::loadMap($this, $this->params);
		$map->loadJS();
		$mapCanvas	= $map->get('mapCanvas');
		require_once(JPATH_ROOT.'/components/com_contactenhanced/helpers/geoplugin.class.php');
		$geoplugin = new geoPlugin(ceHelper::getIP());
		//locate the IP
		$geoplugin->locate();

		$fieldValues = ceHelper::getSession($this->alias, array());
		
		$lat 	= (isset($fieldValues['lat']) 	? $fieldValues['lat'] : ($this->params->get('gmaps_lat',	$geoplugin->latitude) ? $this->params->get('gmaps_lat',	$geoplugin->latitude) : '40.689167'));
		$lng 	= (isset($fieldValues['lng']) 	? $fieldValues['lng'] : ($this->params->get('gmaps_lng',	$geoplugin->longitude)? $this->params->get('gmaps_lng',	$geoplugin->longitude): '-74.044444'));
		$zoom	= (isset($fieldValues['zoom']) 	? $fieldValues['zoom']: $this->params->get('gmaps_zoom',	'10'));

		$doc	= JFactory::getDocument();

	$script	= "


jQuery(document).ready(function($){
	function addMarker(latLng) {
		$('#{$mapCanvas}').gmap('clear', 'markers');
		$('#{$mapCanvas}').gmap('addMarker', {
				'id': 		'm_1',
				'position':	latLng,
				'draggable':true,
				'bounds':	true
			}).dragend( function(event) {
				setFormLatLng(event.latLng);
			});
		setFormLatLng(latLng);
	}
	function findLocation(address) {
		jQuery('#{$mapCanvas}').gmap('search',
					{'address':address},
					function(results, status) {
						if ( status === 'OK' ) {
							var marker	= jQuery('#{$mapCanvas}').gmap('get', 'markers > m_1');
							var latLng	= results[0].geometry.location;
							if(marker == null ){
								addMarker(latLng);
								$('#{$mapCanvas}').gmap('option', 'zoom', 15);
							}else{
								marker.set('position',latLng);
							}
							setFormLatLng(latLng);
							var map		= jQuery('#{$mapCanvas}').gmap('get', 'map');
							map.panTo(latLng);
						}
					});

	}
	$('#{$mapCanvas}').gmap().bind('init', function(event, map) {
		google.maps.event.addListener(map, 'zoom_changed', function() {
			$('#".$this->getInputName()."zoom').val(map.getZoom());
		});"
		.(
			($lat AND $lng) ? "
			var latLng = new google.maps.LatLng({$lat}, {$lng});
			addMarker(latLng);"
			: ""
		)
		."".(
			($zoom) ? "
			$('#{$mapCanvas}').gmap('option', 'zoom', {$zoom});"
			: ""
		)
		."
		var flag = false;
		$(map).mouseover( function(event){
			if(!flag){
				$('#{$mapCanvas}').gmap('refresh');
				flag = true;
			}
		});
		var marker	= map.get('markers > m_1');
		$('#{$mapCanvas}').gmap('autocomplete','googleaddress',marker, function(ui,marker){
			findLocation(document.getElementById('googleaddress').value);
		});
	});
	function setFormLatLng(latLng) {
		$('#".$this->getInputName()."lat').val(latLng.lat());
		$('#".$this->getInputName()."lng').val(latLng.lng());
	}


	function mapLatLng() {
		var latLng	= new google.maps.LatLng($('#".$this->getInputName()."lat').val(),$('#".$this->getInputName()."lng').val());
		var marker	= $('#{$mapCanvas}').gmap('get', 'markers > m_1');
		if(marker == null ){
			addMarker(latLng);
			$('#{$mapCanvas}').gmap('option', 'zoom', 15);
		}else{
			marker.set('position',latLng);
		}
		var map		= $('#{$mapCanvas}').gmap('get', 'map');
		map.panTo(latLng);
	}

	$('#".$this->getInputName()."lat').blur(function(e) {
		mapLatLng();
	});
	$('#".$this->getInputName()."lng').blur( function(e) {
		mapLatLng();
	});
	setTimeout(function(){ $('#{$mapCanvas}').gmap('refresh');}, 3000);
	$('#locateinmap').click(function(e){
		findLocation(document.getElementById('googleaddress').value);
	});
	$('#googleaddress').keydown(function(e){
		 if ( e.which == 13 ) {
			e.preventDefault();
			findLocation(document.getElementById('googleaddress').value);
		}
	});

});
";
	$doc->addScriptDeclaration($script);
	$html 	.= ' <input 	type="text" 	value="" class="inputbox" id="googleaddress" name="'.$this->getInputName().'[address]" style="width:98%"/>';
	$html 	.= '<input 	type="button" 	value="'.JText::_('CE_CONTACT_LOCATE_IN_MAP').'" id="locateinmap"  /> ';
	$html 	.= "\n<!-- DIV container for the map -->";
	$html 	.= '
				<div class="cemap_container">
					<div id="'.$mapCanvas.'"
						style="height:300px"
						class="cemap_canvas">
					</div>
				</div>
				';



		$html	.= '<input name="'.$this->getInputName().'[lat]" id="'.$this->getInputName().'lat"
							type="hidden"
							value="'.(isset($fieldValues['lat']) ? $fieldValues['lat'] : $lat).'" />';
		$html	.= '<input name="'.$this->getInputName().'[lng]" id="'.$this->getInputName().'lng"
							type="hidden"
							value="'.(isset($fieldValues['lng']) ? $fieldValues['lng'] : $lng).'" />';
		$html	.= '<input type="hidden" name="'.$this->getInputName().'[zoom]" id="'.$this->getInputName().'zoom"
						value="'.(isset($fieldValues['zoom']) ? $fieldValues['zoom'] : $zoom).'" />';

		$doc =JFactory::getDocument();

		$script	= "jQuery(document).ready(function($){".$script."});";
		$doc->addScriptDeclaration($script);
		return $html;
	}

	function getInputId(){
		return parent::getInputName().'address';
	}
	public function getSubmittedValue() {
		$html = '';
		$html .= '
		<span class="ce-cf-html-field" style="'.$style['value'].'"> '.JText::sprintf('CE_GMAPS_LOCATION_FROM_MAP',$this->uservalue['address']).'</span>' ;
		$html .= '<br />';
		$link	= JHtml::_('link',
						"http://maps.google.com/maps?q={$this->uservalue['lat']},+{$this->uservalue['lng']}+(".str_replace(' ', '+',$this->uservalue['address']).")"
						.($this->params->get('gmaps_linkToGoogleEarth') == 'gearth' ? '&t=k&z=18&om=1&output=kml&ge_fileext=.kml' : ''),
		JText::sprintf('CE_GMAPS_COORDINATES_FROM_MAP_VALUE',$this->uservalue['lat'],$this->uservalue['lng']),
						'target="_blank"'
						);
		$html .= '<span  class="ce-cf-html-feild" style="'.$style['value'].'"> '. JText::_('CE_GMAPS_COORDINATES_FROM_MAP') .$link.'</span>' ;
		$html	.= '</div>';
		return $html;
	}

	function getEmailOutput($delimiter= ', ',$format='text',$style=array('label'=>'','value'=>'')){
		if($format == 'html'){
			$html	= '<div class="ce-cf-container">';
			$html .= '
			<span class="ce-cf-html-label" style="'.$style['label'].'">'.JText::_($this->getInputFieldName()).'</span>' ;
			$html .= $this->getSubmittedValue();
			return $html;
		}else{
			return 	$this->getInputFieldName() .": "
			."\n\t\t".JText::sprintf('CE_GMAPS_LOCATION_FROM_MAP',$this->uservalue['address'])
			."\n\t\t".JText::_('CE_GMAPS_COORDINATES_FROM_MAP')
			.JText::sprintf('CE_GMAPS_COORDINATES_FROM_MAP_VALUE',$this->uservalue['lat'],$this->uservalue['lng'])."\n";
		}
	}
}

class ceFieldType_text extends ceFieldType {

	function getInputHTML() {
		$doc	=JFactory::getDocument();
		$class	= '';
		$alt	= '';
		$js		= '';
		$dataValidators	='';
		$validationRule	= $this->addValidationRule();

		if($this->params->get('validation')
			AND $this->params->get('validation') != 'custom'
			AND $this->params->get('validation') != 'iMask'
		){
			$dataValidators 	= ' data-rule-'.$validationRule.'="true" ';
		}elseif($this->params->get('validation') == 'custom'
					AND $this->params->get('validation-custom-name')
					AND $this->params->get('validation-custom-errorMsg')
					AND $this->params->get('validation-custom-test')
		){
			$dataValidators = JApplication::stringURLSafe($this->params->get('validation-custom-name'));
			$dataValidators = ' data-rule-'.$dataValidators.'="true" ';
		}

		$input = '<input
					class="'.$class.' inputbox cf-input-text '.($this->getFieldClass()).'"
					type="'.$this->getFieldType().'"
					name="' . $this->getInputName() . '" id="' . $this->getInputName() . '"
					value="' . htmlspecialchars($this->getValue()) . '" '.$this->attributes.'
					alt="'.$alt.'"
					'.$dataValidators.'
					'.$js.' />'
				//.'<br />'
				;
		$html	= '';
		$html .= $this->getAppendPrepend($input);
		return $html;
	}

	function getFieldType(){
		switch ($this->params->get('validation')){
			case 'integer':
				return 'number';
				break;
			case 'url':
				return 'url';
				break;
			case 'date':
				return 'date';
				break;
			case 'email':
				return 'email';
				break;
			default:
				return $this->type;
		}
	}
	function getValue($arg=null) {
		$value = parent::getValue($arg);
		if(!strpos($value, '}')){
			//--The tag is not found in content - abort..
			return $value;
		}

		$doc	= JFactory::getDocument();
		$value = str_ireplace('{current_page_title}', $doc->getTitle(), $value);
		if(JRequest::getVar('content_title')){
			$value = str_ireplace('{referrer_page_title}', ceHelper::decode(JRequest::getVar('content_title')), $value);
		}else{
			$value = str_ireplace('{referrer_page_title}', '', $value);
		}
		return $value;

	}

	function getFieldClass() {
		return parent::getFieldClass()
			. ($this->params->get('check') ? ' validate-'.$this->params->get('check') : '')
			;
	}

	public function jsonExecute() {
		/* Will be removed from future versions */
		if($this->params->get('check') == 'coupon'
			AND strpos($this->params->get('check-coupon-sql'),'SELECT') !== FALSE){
			$sql	=  $this->params->get('check-coupon-sql');
			$user		= JFactory::getUser();
			$regex = '/{user_id}/i';
			$sql  = preg_replace( $regex, $user->id, $sql );

			$regex = '/{user_email}/i';
			$sql  = preg_replace( $regex, $user->email, $sql );

			$regex = '/{username}/i';
			$sql  = preg_replace( $regex, $user->username, $sql );

			$regex = '/{selectresult}/i';
			$sql  = preg_replace( $regex, JRequest::getVar('q'), $sql);


			$db		= JFactory::getDbo();
			$db->setQuery($sql );
			if(!$db->loadObjectList()){
				return array('action'=> 'error','msg' => $this->params->get('check-coupon-error_no_code'));
			}else{
				$query	= $db->getQuery(true);
				$query->select('value');
				$query->from('#__ce_message_fields');
				$query->where('field_id = '.$db->Quote($this->id));
				$query->where('value = '.$db->Quote(JRequest::getVar('q')));

				if($db->loadObjectList()){
					return array('action'=> 'error','msg' => $this->params->get('check-coupon-error_code_already_used'));
				}else{
					return array('action'=> 'success');
				}
			}
		}
		return true;
	}

	public function getValidationScript() {
		$script = parent::getValidationScript();

		$validationRule	= $this->addValidationRule();
		if($this->params->get('validation') == 'iMask'  ){
			$doc	= JFactory::getDocument();
			$doc->addScript(JURI::root().'components/com_contactenhanced/assets/js/jquery.maskedinput.js');
			$script 	.= ("\n	$('#{$this->getInputName()}').mask('{$this->params->get('validation-iMask-mask')}');");
		}elseif($this->params->get('validation') == 'custom'
				AND $this->params->get('validation-custom-name')
				AND $this->params->get('validation-custom-errorMsg')
				AND $this->params->get('validation-custom-test')
		){
			$customValidatorName	= JApplication::stringURLSafe($this->params->get('validation-custom-name'));
			$customValidatorError	= addslashes($this->params->get('validation-custom-errorMsg'));
			$customValidatorTest	= $this->params->get('validation-custom-test');
			$script 	.= ("
jQuery.validator.addMethod('{$customValidatorName}',function(value,element){
	return this.optional(element) || {$this->params->get('validation-custom-test')};
},'{$customValidatorError}');
");
		}
		/* Will be removed from future versions */
		if($this->params->get('check') == 'coupon'
			AND strpos($this->params->get('check-coupon-sql'), 'SELECT') !== FALSE){
			$doc	= JFactory::getDocument();
			$doc->addScript(JURI::root().'components/com_contactenhanced/assets/js/json_validate.js');
			$script	.= "\n\t"."jsonvalidate('{$this->id}','');"."\n";
		}
		return $script;
	}
	function validateField() {
		if(parent::validateField()){
			if($this->params->get('check') == 'coupon'
				AND strpos($this->params->get('check-coupon-sql'), 'SELECT') !== FALSE){
				JRequest::setVar('q', $this->uservalue);
				$ret	= $this->jsonExecute();
				if (is_array($ret) AND isset($ret['action']) AND $ret['action'] == 'error') {
					JFactory::getApplication()->enqueueMessage($ret['msg'],'error');
					return false;
				}
			}
			return true;
		}else{
			return false;
		}
	}
}
class ceFieldType_multitext extends ceFieldType {
	function getInputHTML() {
		$maxlenField	= '';
		$fieldClass		= 'inputbox text_area '.($this->getFieldClass());
		// Not compatible with validation script
		// Limit Characters Box JS does not work well with the MinLength after the validation is called for the field
		if(FALSE AND $this->params->get('maxLength',0) > 1 AND !$this->params->get('minLength')){
			// textlimiter JS added to the jquery.validate.js
			$script	= "jQuery(document).ready(function($){ $('#{$this->getInputName()}').textlimiter();});
		";
			$doc	= JFactory::getDocument();
			$doc->addScriptDeclaration($script);

			$maxlenField .= '<div class="limit_char"><span>'.$this->params->get('maxLength').'</span> ';
				$maxlenField .= JText::_('COM_CONTACTENHANCED_CF_MULTITEXT_CHARACTERS_LEFT');
			$maxlenField .= '</div>';
		}
		if($this->params->get('height')
				AND $this->params->get('width')
				AND $this->attr->get('style') == ''
		){
			$size = ' style="height:'.$this->params->get('height', '130px').';width:'.$this->params->get('width', '95%').';" ';
		}else{
			$size = ' cols="40" rows="8" ';
		}

		$html = '<textarea
						name="' . $this->getInputName() . '"
						id="' . $this->getInputName() . '"
						class="'.$fieldClass.'" '
						.$this->attributes.' '
						.($this->params->get('maxLength',0) > 1 ? ' data-rule-maxlength="'.$this->params->get('maxLength').'" ' : '')
						.($this->params->get('minLength',0) > 1 ? ' data-rule-minlength="'.$this->params->get('minLength').'" ' : '')
						.( $size)
					.' >'
							. $this->getValue()
				. '</textarea>
		';
		$html .= $maxlenField;
		return $html;
	}
}

class ceFieldType_weblink extends ceFieldType {
	function getInputHTML() {
		$showGo = $this->getParam('showGo',0);
		$html	= '<input  '.$this->attributes.'   class="inputbox  cf-input-text  text_area'.($this->getFieldClass()).'"
					type="text" name="' . $this->getInputName() . '" id="' . $this->getInputName() . '"
					size="' . $this->getSize() . '" value="' . htmlspecialchars($this->getValue()) . '" />';
		if($showGo){
			$html .= '';
			$html .= ' <input type="button" class="button" onclick=\'';
			$html .= 'javascript:window.open("index2.php?option=com_contactenhanced&amp;task=openurl&amp;url="+escape(document.getElementById("' . $this->getInputName() . '").value))\'';
			$html .= ' value="' . JText::_('Go') . '"  '.$this->attributes.' />';
		}
		return $html;
	}

}
class ceFieldType_selectlist extends ceFieldType{
	function getInputHTML() {
		$javascript	= '';
		if($this->params->get('chain_select') AND $this->params->get('chain_select-enabled-option')){
			$javascript	= "onchange=\"JsonSelect.updateSelect('".$this->params->get('chain_select-enabled-option')."',this,'".JURI::root()."', '".$this->params->get('catid')."');\"";
			$doc	=JFactory::getDocument();
			$doc->addScript(JURI::root().'components/com_contactenhanced/assets/js/chainSelectList.js');
		}

		$input = '<select name="' . $this->getInputName() . '" id="' . $this->getInputName() . '"'
		.	$javascript. ' class="inputbox text_area'.($this->getFieldClass()).'" '.$this->attributes.' >';
		if($this->params->get('first_element','option') == 'option'){
			$input .= '<option value="">'.JText::_($this->params->get('first_element-option-text', 'CE_PLEASE_SELECT_ONE')).'</option>';
		}
		foreach($this->arrayFieldElements AS $fieldElement) {
			if(strpos($fieldElement, '::') !== false){
				$fieldElement = explode('::', $fieldElement);
			}else{
				$fieldElement = array($fieldElement,$fieldElement);
			}
			if(substr($fieldElement[0],0,2) == '--'){
				if(substr($fieldElement[1],0,2) == '--'){
					$fieldElement[1]	= substr($fieldElement[1],2);
				}
				$input .= '<optgroup label="'.$fieldElement[1].'"> </optgroup>';
			}else{
				$input .= '<option value="'.JText::_($fieldElement[0]).'"';
				if( $fieldElement[0] == $this->getValue() ) {
					$input .= ' selected';
				}
				$input .= '>' . JText::_($fieldElement[1]) . '</option>';
			}

		}
		$input .= '</select>';

		$html	= '';
		$html .= $this->getAppendPrepend($input);
		return $html;
	}
}
class ceFieldType_selectmultiple extends ceFieldType_checkbox {

	function getInputHTML() {
		$javascript	= '';
		$numRows	= $this->params->get('max_number_rows',8);
		$html = '<select name="' . $this->getInputName() . '[]" id="' . $this->getInputName() . '" '
		.	$javascript
		. ' class="inputbox text_area'.($this->getFieldClass()).'" '
		. $this->attributes
		. ' size="'.( count($this->arrayFieldElements) > $numRows ? $numRows : count($this->arrayFieldElements) ).'"'
		. ' multiple >';

		$valueArray	= array();
		if(isset($this->field_value)){
			$valueArray	= (explode(", ", $this->field_value));

		}

		foreach($this->arrayFieldElements AS $fieldElement) {
			if(strpos($fieldElement, '::') > 0){
				$fieldElement = explode('::', $fieldElement);
			}else{
				$fieldElement = array($fieldElement,$fieldElement);
			}
			$html .= '<option value="'.JText::_($fieldElement[0]).'"';
			if( $fieldElement[0] == $this->getValue() OR in_array($fieldElement, $valueArray)  === true) {
				$html .= ' selected';
			}
			$html .= '>' . JText::_($fieldElement[1]) . '</option>';
		}
		$html .= '</select>';
		return $html;
	}
	function getMySQLOutput(){
		return implode(', ',$this->uservalue);
	}
}
/**
 * @author douglas
 * @deprecated
 */
class ceFieldType_selectrecipient extends ceFieldType_recipient{

}
/**
 * Gets a recipient select list
 * @author douglas
 * @since 1.5.8.1
 */
class ceFieldType_recipient extends ceFieldType_selectlist{
	function getInputName($count=1){
		return parent::getInputName($count);
	}

	function getInputHTML() {
		if($this->params->get('display_type', 'select') == 'select'){
			$html	= $this->getInputHTMLSelect();
		}else{ // if checkbox OR radio
			$html	= $this->getInputHTMLCheckbox();
		}
		return $html;
	}

	private function getContactEmails() {
		if(!$this->params->get('load_contact_emails')){
			return false;
		}
		$db			= JFactory::getDBO();
		$query	= $db->getQuery(true);
		//sqlsrv changes
		$case_when = ' CASE WHEN a.user_id <> 0 THEN (u.email ) ELSE email_to END ';
		$case_when = $query->concatenate(array($case_when, 'a.name'), '::');

		$query->select($case_when.' as recipient');
		$query->from('#__ce_details a');
		$query->where("a.email_to <> '' OR a.user_id > 0");
		$query->join('LEFT','#__users u ON u.id = a.user_id');

		$db->setQuery( $query );
		return $db->loadColumn();
	}

	function getInputHTMLCheckbox() {
		$this->_selectCounter = 0;
		$cols	= $this->params->get('display_type-checkbox-number_of_columns',1);
		$width	= number_format( (99/$cols), 1);
		$displayType	= $this->params->get('display_type');
		$html = '';
		$html .= '<div class="ce-checkbox-container">';


		$valueArray	= array();
		if(isset($this->field_value)){
			$valueArray	= (explode(", ", $this->field_value));

		}

		if (($contactEmails = $this->getContactEmails())) {
			$this->arrayFieldElements	= array_merge($this->arrayFieldElements, $contactEmails);
		}
		$classid =	JApplication::getHash(microtime());
		if($displayType == 'checkbox'){
			$html .=	$this->getSelectAllLink($classid);
		}


		foreach($this->arrayFieldElements AS $fieldElement) {
			if(strpos($fieldElement, '::') > 0){
				$fieldElement = explode('::', $fieldElement);
				$fieldElement = array($fieldElement[1],$fieldElement[1]);
			}else{
				if (!strpos($fieldElement, '@')) {
					continue;
				}
				$fieldElement = array($fieldElement,$fieldElement);
			}


			$html .= '<div style="width:'.$width.'%;float:left">';

			$html .= '<input type="'.$displayType.'" '
					.' class="cf-input-'.$displayType.' check-me-'
							.$classid.$this->getFieldClass()
							.($this->isRequired() ? ' validate-'.$displayType:'').'"'
					.' name="' . $this->getInputName() . '[]" '
					.' id="' . $this->getInputName() . '_' . $this->_selectCounter . '" ';




			if( $fieldElement[1] == $this->getValue()
			OR in_array($fieldElement[1], $valueArray)  === true
			OR ($this->_selectCounter== 0 AND $this->params->get('checkbox_first_selected',0)) )
			{
				$html .= ' checked="checked"  ';
			}
			$html .= ' value="'.strip_tags($fieldElement[1]).'" ';
			$html .= ' '.$this->attributes.' ';
			$html .= '/> <label for="' . $this->getInputId(). '_' . $this->_selectCounter . '">'.JText::_($fieldElement[1]).'</label>';
			$this->_selectCounter++;
			$html .= '</div>';
		}
		$html .= '</div>';
		return $html;
	}

	function getInputHTMLSelect() {
		$javascript	= '';
		if($this->params->get('chain_select') AND $this->params->get('chain_select-enabled-option')){
			JHtml::_('jquery.framework', true, null, false);
			$javascript	= "onchange=\"JsonSelect.updateSelect('".$this->params->get('chain_select-enabled-option')."',this,'".JURI::root()."', '".$this->params->get('catid')."');\"";
			$doc	=JFactory::getDocument();
			$doc->addScript(JURI::root().'components/com_contactenhanced/assets/js/chainSelectList.js');
		}
		$input = '<select name="' . $this->getInputName() . '" id="' . $this->getInputId() . '"'
		.	$javascript. ' class="inputbox text_area'.($this->getFieldClass()).'" '.$this->attributes.' >';
		$input .= '<option value="">'.JText::_($this->params->get('first_option', 'CE_PLEASE_SELECT_ONE')).'</option>';

		if (($contactEmails = $this->getContactEmails())) {
			$this->arrayFieldElements	= array_merge($this->arrayFieldElements, $contactEmails);
		}

		foreach($this->arrayFieldElements AS $fieldElement) {
			if(strpos($fieldElement, '::') > 0){
				$fieldElement = explode('::', $fieldElement);
				$fieldElement = array($fieldElement[1],$fieldElement[1]);
			}else{
				$fieldElement = array($fieldElement,$fieldElement);
			}
			$input .= '<option value="'.JText::_(trim($fieldElement[0])).'"';
			if( $fieldElement[0] == $this->getValue() ) {
				$input .= ' selected';
			}
			$input .= '>' . JText::_(trim($fieldElement[1])) . '</option>';
		}
		$input .= '</select>';
		$html	= '';
		$html .= $this->getAppendPrepend($input);
		return $html;
	}

	function getSelectAllLink($classid){
		if($this->params->get('display_type-checkbox-select_all_button', 0)){
			$doc	=JFactory::getDocument();
			$buttonid	= 'check-all-'.$classid;
			$script = "
jQuery(document).ready(function($){
	$('#".$buttonid."').on('click',function(){
		$('.check-me-".$classid."').not(this).prop('checked', this.checked);
	});
});";
			$doc->addScriptDeclaration($script);
			return '<div class="check-all"><input type="checkbox" class="cf-input-checkbox" name="'.$buttonid.'" id="'.$buttonid.'" />
				<label for="'.$buttonid.'" id="labelcheckall-'.$classid.'">'.JText::_('CE_CF_CHECKBOX_SELECT_ALL').'</label></div>';
		}
		return '';
	}
	/**
	 * Used to get the value of a submitted field
	 * @param string	$text
	 */
	function getSelectedValue($text) {
		$recipient	= array();

		if (($contactEmails = $this->getContactEmails())) {
			$this->arrayFieldElements	= array_merge($this->arrayFieldElements, $contactEmails);
		}

		foreach($this->arrayFieldElements AS $fieldElement) {
			$fieldElement	= explode('::', $fieldElement);
			if(is_array($text)){
				foreach ($text as $email){
					if(isset($fieldElement[1]) AND stristr($fieldElement[1], trim($email))){
						$recipient[]	= trim($fieldElement[0]);
						continue;
					}
				}
			}elseif(isset($fieldElement[1]) AND stristr($fieldElement[1], trim($text))){
				$recipient[]	= trim($fieldElement[0]);
			}
		}
		return implode(',',$recipient);
	}
}

class ceFieldType_radiobutton extends ceFieldType {
	var $_selectCounter	= 0;
	function getInputHTML() {
		$comParams = JComponentHelper::getParams('com_contactenhanced');

		$javascript	= '';
		if($this->params->get('chain_select') AND $this->params->get('chain_select-enabled-option')){
			$javascript	= " onclick=\"JsonSelect.updateSelect('".$this->params->get('chain_select-enabled-option')."',this,'".JURI::root()."');\" ";
			$doc	=JFactory::getDocument();
			$doc->addScript(JURI::root().'components/com_contactenhanced/assets/js/chainSelectList.js');
		}
		$html 	= '';
		$containerClass	= $this->params->get('number_of_columns','span12 col-md-12');
		if(is_int($containerClass) AND $containerClass > 0 AND $containerClass < 12){
			$containerClass = 'span'.(12/$containerClass);
		}

		$i = 0;
		$html .= '<div class="ce-radiobox-container row-fluid row">';
		$this->_selectCounter = 0;

		$valueArray	= array();
		if(isset($this->field_value)){
			$valueArray	= (explode(", ", $this->field_value));
		}
	//	echo ceHelper::print_r($valueArray); exit; 
		$i		= 0;
		$count	= count($this->arrayFieldElements);
		foreach($this->arrayFieldElements AS $fieldElement) {

			if(!empty($fieldElement)) {
				$html .= '<div class="'.$containerClass.'">';

				if(strpos($fieldElement, '::') > 0){
					$fieldElement = explode('::', $fieldElement);
				}else{
					$fieldElement = array(($fieldElement),($fieldElement));
				}
				// Removing extra spaces
				$fieldElement[0] = trim($fieldElement[0]);
				$fieldElement[1] = trim($fieldElement[1]);

				$class 	= 'ce-radiobox-'.JApplication::stringURLSafe($fieldElement[0]);

				$input = '';
				$input .= '<input type="radio" '
				.' class="cf-input-radio '
						.$this->getFieldClass()
						.'" '
					.' name="' . $this->getInputName() . '" '
					.' id="' . $this->getInputId()  . '" ';


				$input .= ' value="'.strip_tags(($fieldElement[0])).'" ';

				if( $fieldElement[0] == $this->getValue()
					OR in_array(JText::_($fieldElement[0]), $valueArray)  === true
					OR ($this->_selectCounter== 0 AND $this->params->get('radiobutton_first_selected', 0)) )
				{
					$input .= ' checked="checked"  ';
				}
				$input .= ' '.$this->attributes.' '.$javascript;
				$input .= '/> ';


				if ($comParams->get('load_bootstrap',1)) {
					$html .= '
					<label class="'.$class.'-lbl '.$containerClass.'"
							for="' . $this->getInputId(). '" >';
					$html .= $input;
					$html .= ' '.JText::_(($fieldElement[1])).'</label>';

				}else{
					//$html .= $input;
					$html .= '
					<label class="'.$class.'-lbl '.$containerClass.'"
							for="' . $this->getInputId(). '" >';
					$html .= $input;
					$html .= ' '.JText::_(($fieldElement[1])).'</label>';
				}


				$html .= '</div>'; $i++;
				$this->_selectCounter++;
			}
		}
		$html 	.= '<label class="error" for="'.$this->getInputName().'" style="display:none"></label>';
		$html .= '</div>';

		return $html;
	}
	function getRecordedFieldId(){
		return '<input type="hidden" name="'.parent::getInputName().'_id" value="'.$this->field_id.'" />';
	}
	function getInputId(){
		return parent::getInputName().'_'.$this->_selectCounter;
	}
	function getLabel($output='site'){
		$html	= '';
		if($this->published AND $this->params->get('hide_field_label',0) == 0
			AND $this->params->get('hide_field_label',0) != 'overtext'){
			$label= '<label class="cf-label'.($this->isRequired() ? ' requiredField':'').'"
					id="l'.parent::getInputId().'"
					for="'.parent::getInputId().'">'
					.JText::_( $this->getInputFieldName() )
					.($this->isRequired() ? ' <span class="requiredsign">'.JText::_('CE_FORM_REQUIRED_SIGN').'</span>' : '')
					.'</label>';
			if($this->tooltip AND $this->params->get('tooltip_behavior','mouseover') == 'mouseover'){
				$html .= '<span class="hasTooltip" title="'. JText::_( $this->tooltip ). '">'
						. $label
						. '</span>';
				JHtml::_('bootstrap.tooltip');
			}elseif($this->tooltip AND $this->params->get('tooltip_behavior','mouseover') == 'inline'){
				$html .= $label;
				$html .= '<div class="ce-tooltip" >'. JText::_( $this->tooltip ). '</div>';
			}else{
				$html .= $label;
			}
		}
		return $html;
	}
}
class ceFieldType_checkbox extends ceFieldType{
	var $_selectCounter	= 0;

	function ceFieldType_checkbox( $data,&$params ) {

		if( !is_null($data) ){
			foreach( $data AS $key => $value ) {
				switch($key){
					case 'value':
						$this->arrayFieldElements = explode("|",$data->$key);
						$this->$key = '';
						break;
					default:
						$this->$key = $value;
						break;
				}
			}
		}
		$this->params	= $params;
		$this->session 	= JFactory::getSession();
		$this->session	= $this->session->get('com_contactenhanced');

		$this->getFieldAttributes();
	}

	function getFieldClass() {
		return parent::getFieldClass(); //.' validate-one-required';
	}

	function getInputHTML() {

		$this->_selectCounter = 0;
		$comParams = JComponentHelper::getParams('com_contactenhanced');
		$containerClass	= $this->params->get('number_of_columns','span12');

		$html = '';
		$html .= '<div class="ce-checkbox-container row-fluid">'; // add class="row" for bootstrap 3

		$valueArray	= array();
		if(isset($this->field_value)){
			$valueArray	= (explode(", ", $this->field_value));

		}
		$value 	= $this->getValue();
		$classid =	JApplication::getHash(microtime());
		$html	.=	$this->getSelectAllLink($classid);

		$count	= count($this->arrayFieldElements);
		foreach($this->arrayFieldElements AS $fieldElement) {
			if( substr($fieldElement,0,2) == '--'){
				$html .= '<div class="checkbox-subtitle">
							<p class="muted  text-muted">'. str_replace('--','',$fieldElement) .'</p></div>';
				continue 1;
			}
			if(strpos($fieldElement, '::') > 0){
				$fieldElement = explode('::', $fieldElement);
			}else{
				$fieldElement = array($fieldElement,$fieldElement);
			}

			$class 	= 'ce-checkbox-'.JApplication::stringURLSafe($fieldElement[0]);



			$input = '';
			$input .= '
					<input type="checkbox" '
						.' class="cf-input-checkbox check-me-'.$classid.'"'
						.' name="' . $this->getInputName() . '" '
						.' id="' . $this->getInputId() . '" ';

			if( $fieldElement[0] == $value
				OR (is_array($valueArray) 		AND in_array($fieldElement[0], $valueArray)  === true)
				OR (is_array($this->getValue()) AND in_array($fieldElement[0], $this->getValue())  === true)
				OR ($this->_selectCounter== 0 AND $this->params->get('checkbox_first_selected',0)) )
			{
				$input .= ' checked="checked"  ';
			}
			$input .= ' value="'.strip_tags($fieldElement[0]).'" ';
			$input .= ' '.$this->attributes.' ';
			$input .= '/> ';


			if ($comParams->get('load_bootstrap',1)) {
				$html .= '
					<label class="'.$class.'-lbl '.$containerClass.'"
							for="' . $this->getInputId(). '" >';
				$html .= $input;
				$html .= ' '.JText::_($fieldElement[1]).'</label>';

			}else{
				//$html .= $input;
				$html .= '
					<label class="'.$class.'-lbl '.$containerClass.'"
							for="' . $this->getInputId(). '" >';
				$html .= $input;
				$html .= ' '.JText::_($fieldElement[1]).'</label>';
			}

			$this->_selectCounter++;


		}
		$html .= '</div>';
		$html 	.= '<label class="error" for="'.$this->getInputName().'" style="display: none;"></label>';

		return $html;
	}
	function getInputName($type=''){
		if($type=='cookie'){
			return parent::getInputName().'_'.$this->_selectCounter;
		}elseif($type=='submission'){
			return parent::getInputName();
		}else{
			return parent::getInputName()."[]";
			return parent::getInputName();
		}
	}
	function getInputId(){
		return parent::getInputName().'_'.$this->_selectCounter;
	}
	function getRecordedFieldId(){
		return '<input type="hidden" name="'.parent::getInputName().'_id" value="'.$this->field_id.'" />';
	}
	function getMySQLOutput(){
		if(is_array($this->uservalue)){
			return implode(', ',$this->uservalue);
		}else{
			return $this->uservalue;
		}
	}
	function getSelectAllLink($classid){
		if($this->params->get('select_all_button', 0)){
			$doc	=JFactory::getDocument();
			$buttonid	= 'check-all-'.$classid;
			$script = "
jQuery(document).ready(function($){
	$('#".$buttonid."').on('click', function() {
		$('.check-me-".$classid."').not(this).prop('checked', this.checked);
	});
});";
			$doc->addScriptDeclaration($script);
			return '<div class="check-all"><input type="checkbox" class="cf-input-checkbox" name="'.$buttonid.'" id="'.$buttonid.'" />
			<label for="'.$buttonid.'" id="labelcheckall-'.$classid.'">'.JText::_('CE_CF_CHECKBOX_SELECT_ALL').'</label></div>';
		}
		return '';
	}

}


class ceFieldType_constantcontact extends ceFieldType{
	var $_selectCounter = 0;
	var $ctct 			= null;
	var $apiKey			= null;
	var $token			= null;
	var $list			= null;

	function ceFieldType_constantcontact($data,&$params ) {
		parent::ceFieldType( $data,$params );

		// If class was already included by another script
		if(!class_exists('ConstantContact')){
			require_once JPATH_ROOT.'/components/com_contactenhanced/helpers/constant_contact/Ctct/autoload.php';
			require_once(JPATH_ROOT.'/components/com_contactenhanced/helpers/constant_contact/Ctct/ConstantContact.php');
		}

		if (is_string($this->params)) {
			$registry	= new JRegistry();
			$registry->loadString($this->params);
			$this->params = $registry;
		}

		$this->apiKey	= trim($this->params->get('constantcontact_api_key'));
		$this->token	= trim($this->params->get('constantcontact_token'));
		$this->list		= explode(',', $this->params->get('constantcontact_list', null) );

		for ( $i=0; $i < count($this->list); $i++ ){
			$this->list[$i] = trim($this->list[$i]);
			if (empty($this->list[$i])) {
				unset($this->list[$i]); // Remove empty values
			}
		}

		$this->ctct = ctctGetObject( $this->apiKey);

	}

	function getInputHTML() {
		$app	= JFactory::getApplication();
		$this->_selectCounter = 0;

		$html		= '<div class="cf-constantcontact">';

		if(!$this->token OR !$this->apiKey){
			$html	.= '<h1>'.JText::_('You must enter a valid API Key and a Token').'</h1>';
		}
		try {
			$listDetails	= $this->ctct->getLists($this->token);

		} catch (CtctException $ex) {
			foreach ($ex->getErrors() as $error) {
				$app->enqueueMessage($error, 'warning');
			}
			return '';
		}

		$this->getOption($html,$listDetails,'id','name');

		$html		.= '</div>';
		return $html;
	}

	function getEmailOutput($delimiter= ', ',$format='text',$style=array('label'=>'','value'=>'')) {
		$errors = array();
		$app	= JFactory::getApplication();
		$input = $app->input;

		$this->uservalue	= (array) $this->uservalue;
		if($this->token AND $this->apiKey AND count($this->uservalue) > 0){
			$first_name	= JRequest::getString( 'name', 		null, 'post');
			$last_name	= JRequest::getString( 'surname', 	'', 'post');
			$email		= JRequest::getString( 'email', 	null, 'post');

			try {

				// check to see if a contact with the email addess already exists in the account
				$response = $this->ctct->getContactByEmail($this->token, $email);

				// create a new contact if one does not exist
				if (empty($response->results)) {
					$isNew	= true;
					$action = "Creating Contact";
					$contact = ctctGetContactObject();
					$contact->addEmail((ctctGetContactEmailObject($email, $this->params, $isNew)) );
				}else{
					$isNew	= false;
					$action = "Updating Contact";
					$contact = $response->results[0];
				}
				foreach ($this->uservalue as $list) {
					$contact->addList($list);
				}
				$contact->first_name = $first_name;
				$contact->last_name = $last_name;

				$address_flag		= 0;
				$ctct_corefields	= array('middle_name','last_name', 'prefix_name', 'job_title', 'company_name', 'home_phone', 'work_phone', 'cell_phone', 'fax');
				$ctct_ignorefields	= array('name','surname', 'constantcontact', 'email', 'recipient');
				$ctct_addressfields	= array('address','address_line1', 'line1', 'address_line2', 'line2', 'address_line3', 'line3', 'sub_postal_code', 'postal_code', 'country', 'country_code', 'state', 'state_code', 'address_type', 'city');
				foreach(ceHelper::$submittedfields as $field){
					if(in_array($field->alias, $ctct_corefields)){
						$ctct_corefield	= $field->alias;
						$contact->$ctct_corefield = $input->get($field->alias);
					}elseif($isNew AND in_array($field->alias, $ctct_addressfields) AND !$address_flag){
						$ctct_address = array();
						$ctct_address['line1']			= $input->get('address', $input->get('address_line1', $input->get('line1', '')));
						$ctct_address['line2']			= $input->get('address_line2', $input->get('line2', ''));
						$ctct_address['line3']			= $input->get('address_line3', $input->get('line3', ''));
						$ctct_address['city']			= $input->get('city', '');
						$ctct_address['address_type']	= $input->get('address_type','PERSONAL');
						$ctct_address['state_code']		= strtolower(substr($input->get('state_code', $input->get('state', '')),0,2));
						$ctct_address['country_code']	= strtolower(substr($input->get('country_code', $input->get('country', '')),0,2));
						$ctct_address['postal_code']	= $input->get('postal_code', '');
						$ctct_address['sub_postal_code']= $input->get('sub_postal_code', '');
						++$address_flag;

						$contact->addAddress(ctctCreateAddress($ctct_address));
					}elseif(in_array($field->type, $ctct_ignorefields)){
						// do nothing
					}else{
						// Really complicated to edit Custom Fields and sinchronize them
					}
					//notes
				}
				if (empty($response->results)) {

					$returnContact = $this->ctct->addContact($this->token, $contact, true);
					// update the existing contact if address already existed
				}else{
					$returnContact = $this->ctct->updateContact($this->token, $contact, true);
				}

				// catch any exceptions thrown during the process and print the errors to screen
			} catch (CtctException $ex) {
				$app->enqueueMessage('Error ' . $action , 'warning');
				foreach ($ex->getErrors() as $error) {
					$app->enqueueMessage($error, 'warning');
				}
				return '';
			}
		}
		return '';
	}

	function getInputName($type=''){
		if($type=='cookie'){
			return parent::getInputName().'_'.$this->_selectCounter;
		}elseif($type=='submission'){
			return parent::getInputName();
		}else{
			return parent::getInputName()."[".($this->_selectCounter)."]";
		}
	}

	function getMySQLOutput(){
		return implode(', ',$this->uservalue);
	}

	function getOption(&$html,$list,$value_name='id', $text_name='name') {

		if(is_array($list)){
			foreach ($list as $value){
				$this->getOption($html,$value,$value_name,$text_name);
			}
		}elseif (is_object($list)
				AND isset($list->status)
				AND $list->status == 'ACTIVE'
				AND (count($this->list) == 0 OR in_array(trim($list->name), $this->list))
		){
			$inputType	= $this->params->get('input_type','checkbox');

			$cols	= $this->params->get('number_of_columns',1);
			$width	= number_format( (100/$cols), 1);
			$html .= "\n".'<div style="width:'.$width.'%;float:left">';
			$html .= '<input type="'.$inputType.'" class="cf-input-checkbox'.$this->getFieldClass().($this->isRequired() ? ' required validate-checkbox':'').'" '
			.' name="' . $this->getInputName(). '" '
			.' value="'.$list->$value_name.'" '
			.' id="' . $this->getInputName() . '_' . $this->_selectCounter . '" ';
			if( $list->$value_name == $this->getValue()
					OR ($inputType == 'checkbox' AND $this->params->get('input_type-checkbox-allchecked'))
			){
				$html .= '  checked="checked"  ';
			}
			$html .= ' '.$this->attributes.' ';
			$html .= '/>
			<label for="' . $this->getInputName() . '_' . $this->_selectCounter . '">'
			.JText::_($list->$text_name).'</label>';
			$html .= '</div>';
			$this->_selectCounter++;
		}
	}

}



class ceFieldType_campaignmonitor extends ceFieldType{
	var $_selectCounter = 0;
	var $cm 			= null;
	var $apiKey			= null;
	var $clientID		= null;
	var $list			= null;

	function ceFieldType_campaignmonitor($data,&$params ) {
		parent::ceFieldType( $data,$params );
		$app	= JFactory::getApplication();
		$jinput = $app->input;

		$this->apiKey	= trim($this->params->get('campaignmonitor_api_key', $jinput->get('elemVar1')));
		$this->clientID	= trim($this->params->get('campaignmonitor_api_client', $jinput->get('elemVar2')));
		$this->list		= $this->params->get('campaignmonitorlist');

	}

	function getInputHTML() {
		$this->_selectCounter = 0;

		$html		= '<div class="cf-campaignmonitor">';


		if(!$this->clientID OR !$this->apiKey){
			$html	.= '<h1>'.JText::_('You must enter a valid Campaign Monitor API Key and a API Client ID').'</h1>';
		}

		if($this->list){
			$listDetails	= $this->getList($this->list);
			$html			.= $this->getOption($html,$listDetails,'id','title');

		}else{
			$listTypes		= $this->getLists($this->clientID);
			$this->getOption($html,$listTypes,'id','title');
		}

		$html		.= '</div>';
		return $html;
	}

	/**
	 * Subscribes the user to the selected lists. Does not show an email output as the name sugests
	 * @return	error message(s)
	 * 0: Success
	 * 1: Invalid email address
	 * The email value passed in was invalid.
	 * 100: Invalid API Key
	 * The API key pass was not valid or has expired.
	 * 101: Invalid ListID
	 * The ListID value passed in was not valid.
	 * 204: In Suppression List
	 * Address exists in suppression list. Subscriber is not added.
	 * 205: Is Deleted
	 * Email Address exists in deleted list. Subscriber is not added.
	 * 206: Is Unsubscribed
	 * Email Address exists in unsubscribed list. Subscriber is not added.
	 * 207: Is Bounced
	 * Email Address exists in bounced list. Subscriber is not added.
	 * 208: Is Unconfirmed
	 * Email Address exists in unconfirmed list. Subscriber is not added.
	 */
	function getEmailOutput($delimiter= ', ',$format='text',$style=array('label'=>'','value'=>'')) {
		// Initialize variables
		$app	= JFactory::getApplication();
		$jinput = $app->input;

		require_once JPATH_ROOT.'/components/com_contactenhanced/helpers/campaign_monitor/csrest_subscribers.php';

		$this->uservalue	= (array) $this->uservalue;
		if($this->clientID AND $this->apiKey AND count($this->uservalue) > 0){
			$name	= $jinput->post->getString( 'name');
			$email	= $jinput->post->getString( 'email');
			$auth	= array('api_key' => $this->apiKey);
			/**
			 * @var array Campaign Monitor Custom Fields
			 */
			$cmcf	= array();
			foreach(ceHelper::$submittedfields as $field){
				$Key	= $field->name;
				if(is_array($field->uservalue)){
					foreach ($field->uservalue as $Value){
						$cmcf[] 	= array('Key' => $Key, 'Value' => $Value);
					}
				}else{
					$Value	= $field->uservalue;
					$cmcf[] 	= array('Key' => $Key, 'Value' => $Value);
				}

			}

			// Whether to update subscriber or not
			$update	= ($this->params->get('campaignmonitor_always_update',1) ? true : false );
			// Subscribe user in the chosen lists
			foreach ($this->uservalue as $list) {
				$wrap = new CS_REST_Subscribers($list, $auth);
				$result = $wrap->add(array(
					'EmailAddress'	=> $email,
					'Name'			=> $name,
					'CustomFields' 	=> $cmcf,
					'Resubscribe'	=> $update
				));
				if(!$result->was_successful()) {
					JFactory::getApplication()->enqueueMessage("Campaign Monitor failed with code {$result->response->Code} ({$result->http_status_code}) {$result->response->Message}",'warning');
				}
			}
		}
		return '';
	}

	function getInputName($type=''){
		if($type=='cookie'){
			return parent::getInputName().'_'.$this->_selectCounter;
		}elseif($type=='submission'){
			return parent::getInputName();
		}else{
			return parent::getInputName()."[".($this->_selectCounter)."]";
		}
	}
	function getMySQLOutput(){
		return implode(', ',$this->uservalue);
	}
	function getOption(&$html,$list,$value_name='ListID', $text_name='Name') {
		//testArray($list);
		if(is_array($list) AND !isset($list[$value_name])){
			foreach ($list as $value)
			$this->getOption($html,$value,$value_name,$text_name);
			//return	$this->getOption($html,$value,$value_name,$text_name);
		}elseif (is_object($list)){
			$cols	= $this->params->get('number_of_columns',1);
			$width	= number_format( (100/$cols), 1);
			$html .= '<div style="width:'.$width.'%;float:left">';

			$checkbox = '<input type="checkbox"
					class="cf-input-checkbox'.$this->getFieldClass().($this->isRequired() ? ' required validate-checkbox':'').'" '
			.' name="' . $this->getInputName(). '" '
			.' value="'.$list->$value_name.'" '
			.' id="' . $this->getInputName() . '_' . $this->_selectCounter . '" ';
			if( $list->$value_name == $this->getValue() OR $this->params->get('cm-all-checked')){
				$checkbox .= '  checked="checked"  ';
			}
			$checkbox .= ' '.$this->attributes.' ';
			$checkbox .= '/> ';

			$html .= '<label for="' . $this->getInputName() . '_' . $this->_selectCounter
						. '">'.$checkbox. JText::_($list->$text_name).'</label>';
			$html .= '</div>';
			$this->_selectCounter++;
		}

		//return $html;
	}

	public function getLists()
	{
		// Initialize variables
		$app	= JFactory::getApplication();
		$jinput = $app->input;
		$rows	= array();

		require_once JPATH_ROOT.'/components/com_contactenhanced/helpers/campaign_monitor/csrest_clients.php';

		$auth = array('api_key' => $this->apiKey);
		$wrap = new CS_REST_Clients($this->clientID, $auth);
		$listTypes	= $wrap->get_lists();
		$this->getListsInfo($rows,$listTypes->response);

		return $rows;
	}
	function getListsInfo(&$rows,$list,$value_name='ListID', $text_name='Name') {
		if(is_array($list) AND !isset($list[$value_name])){
			foreach ($list as $value)
			$this->getListsInfo($rows,$value,$value_name,$text_name);
		}elseif (is_object($list) AND isset($list->$value_name)){
			$row		= new JObject();
			$row->id	= $list->$value_name;
			$row->title	= $list->$text_name;
			$rows[]		= $row;
		}
	}

	public function getList($listID = null)
	{
		// Initialize variables
		$app	= JFactory::getApplication();
		$jinput = $app->input;
		$rows	= array();

		require_once JPATH_ROOT.'/components/com_contactenhanced/helpers/campaign_monitor/csrest_lists.php';

		if(empty($listID)){
			$listID = $this->params->get('campaignmonitorlist');
		}

		if(!$this->clientID OR !$this->apiKey OR empty($listID)){
			JFactory::getApplication()->enqueueMessage(JText::_('You must enter a valid Campaign Monitor API Key and a API Client ID'),'warning');
		}
		$auth = array('api_key' => $this->apiKey);
		$wrap = new CS_REST_Lists($listID, $auth);
		$result = $wrap->get();
		if($result->was_successful()) {
			$row		= new JObject();
			$row->id	= $result->response->ListID;
			$row->title	= $result->response->Title;
			return $row;
		}else{
			JFactory::getApplication()->enqueueMessage("Campaign Monitor failed with code {$result->response->Code} {$result->response->Message}",'warning');
		}
		return false;
	}
}


class ceFieldType_date extends ceFieldType {

	function getInputHTML() {
		$doc	= JFactory::getDocument();
		$lang	= JFactory::getLanguage();

		$this->getJavascript();
		// Avoid incompatibility with Bootstrap 3
		$doc->addStyleDeclaration('select.ui-datepicker-month,select.ui-datepicker-year{display:inline;padding:0}');

	// Field
	$fieldAttributes	= ' class="inputbox cf-input-date '.($this->getFieldClass()).'" '.$this->attributes;
	$value	= $this->getValue();
	if (is_array($value) ) {
		if(isset($value[$this->_selectCounter])){
			$value	= $value[$this->_selectCounter];
		}
	}
	$input	= '<input
						'.$fieldAttributes.'
						type="text"
						name="' . $this->getInputName() . '"
						id="'	. $this->getInputId() . '"
						value="'. ($this->getValue()) . '"
					/>
					';

	$html = '';
	if(!$this->params->get('datepicker-range')
		AND ($this->params->get('prepend') OR $this->params->get('append'))
	){
		$html .= $this->getAppendPrepend($input);
	}else{
		$html = $input;
	}
	if($this->params->get('datepicker-range')){
		$html	.= '<div></div>'; //fix
	}
	return $html;

	}

	public function getJavascript() {
		$lang	= JFactory::getLanguage();
		$doc 	= JFactory::getDocument();

		ceHelper::loadJqueryUI();

		$dateFormat	= $this->params->get('date-format',JText::_('CE_CF_DATE_FORMAT'));
		// Remove % and replace Y with yy from old version options
		// Added on
		$dateFormat	= str_replace(array('%','Y','-'),array('','yy',$this->params->get('date-format-separator','-') ),$dateFormat);

		$js_properties	= array();

		$js_properties[]	= "firstDay:	".$this->params->get('datepicker-startDay',0);
		$js_properties[]	= "numberOfMonths:".$this->params->get('datepicker-columns',1);

		$widgetClass	= "datepicker";
		if($this->params->get('datepicker-timePicker',0) AND !$this->params->get('datepicker-range')){
			$widgetClass	= "datetimepicker";
			$doc->addStyleSheet(JURI::root(true).'/components/com_contactenhanced/assets/css/jquery.ui.timepicker-addon.css');
			$doc->addScript(JURI::root(true).'/components/com_contactenhanced/assets/js/jquery.ui.timepicker-addon.js');

		}

		if( ($defaultDate = trim($this->params->get('datepicker-default'))) != '' ){
			if(strtolower($defaultDate) == 'today'){
				$js_properties[]= "defaultDate: new Date())";
			}elseif(strlen($defaultDate) > 0 AND strlen($defaultDate)< 10){
				$defaultDate	= intval($defaultDate);
				$js_properties[]= "defaultDate:	{$defaultDate}";
			}
		}

		if( ($min = trim($this->params->get('datepicker-minDate'))) != '' ){
			if(strtolower($min) == 'today' OR $min==0){
				$min	= 0;
				$js_properties[]= "minDate: new Date()";
			}elseif(strlen($min) > 0 AND strlen($min)< 10){
				$min	= intval($min);
				$js_properties[]= "minDate:	{$min}";
			}elseif(strpos($min, '-')){
				$js_properties[]= "minDate: '$min'";
				$date = $this->jsToDateTimeFormat($min, $dateFormat);
				$datetime1 = new DateTime($date);
				$datetime2 = new DateTime(date('Y-m-d'));
				$interval = $datetime2->diff($datetime1);
				$min = $interval->format('%r%a');
			}
			if( (($min/365)<1 AND ($min/365) >= 0) OR strtolower($min) == 'today'){ // number between 0 and 1, so it is less than one year
				$minYear = date('Y');
			}else{
				$minYear = date('Y')+intval(($min/365));
			}

		}

		if( ($max = trim($this->params->get('datepicker-maxDate'))) != '' ){
			if(strtolower($max) == 'today' OR $max==0){
				$max	= 0;
				$js_properties[]= "maxDate: new Date()";
			}elseif(strlen($max) > 0 AND strlen($max)< 10){
				$max	= intval($max);
				$js_properties[]= "maxDate:	{$max}";
			}elseif(strpos($max, '-')){
				$js_properties[]= "maxDate: '$max'";
				$date = $this->jsToDateTimeFormat($max, $dateFormat);
				$datetime1 = new DateTime($date);
				$datetime2 = new DateTime(date('Y-m-d'));
				$interval = $datetime2->diff($datetime1);
				$max = $interval->format('%r%a');
			}
			if( (($max/365)<1 AND ($max/365) >= 0)){ // number between 0 and 1, so it is less than one year
				$maxYear	= date('Y');
			}else{
				$maxYear	= date('Y')+intval(($max/365));
			}
		}

		if (isset($maxYear) AND isset($minYear) AND $maxYear != $minYear) {
			$js_properties[]= "yearRange:	'{$minYear}:{$maxYear}'";
		}

		if( (trim($this->params->get('datepicker-weeknumbers'))) != 'false' ){
			$js_properties[]= "showWeek:true";
		}

		$availableDays = explode(',',str_replace(' ','', $this->params->get('datepicker-availableDays', '1,2,3,4,5,6,7') ) );
		$days = array();
		foreach ($availableDays as $day){
			$days[] = "date.getDay() == ".($day-1);
		}
		$days = implode(' || ', $days);

		$monthNames = "['".JText::_('JANUARY_SHORT',	true)."'"
						.",'".JText::_('FEBRUARY_SHORT',true)."'"
						.",'".JText::_('MARCH_SHORT',	true)."'"
						.",'".JText::_('APRIL_SHORT',	true)."'"
						.",'".JText::_('MAY_SHORT',		true)."'"
						.",'".JText::_('JUNE_SHORT',	true)."'"
						.",'".JText::_('JULY_SHORT',	true)."'"
						.",'".JText::_('AUGUST_SHORT',	true)."'"
						.",'".JText::_('SEPTEMBER_SHORT',true)."'"
						.",'".JText::_('OCTOBER_SHORT',	true)."'"
						.",'".JText::_('NOVEMBER_SHORT',true)."'"
						.",'".JText::_('DECEMBER_SHORT',true)."'"
					."]";
		$DayNamesShort = "['".JText::_('SUN',	true)."'"
						.",'".JText::_('MON',	true)."'"
						.",'".JText::_('TUE',	true)."'"
						.",'".JText::_('WED',	true)."'"
						.",'".JText::_('THU',	true)."'"
						.",'".JText::_('FRI',	true)."'"
						.",'".JText::_('SAT',	true)."'"
					."]";
		$DayNames =	 "['".JText::_('SUNDAY',		true)."'"
						.",'".JText::_('MONDAY',	true)."'"
						.",'".JText::_('TUESDAY',	true)."'"
						.",'".JText::_('WEDNESDAY',	true)."'"
						.",'".JText::_('THURSDAY',	true)."'"
						.",'".JText::_('FRIDAY',	true)."'"
						.",'".JText::_('SATURDAY',	true)."'"
					."]";

		$isRTL		= ($lang->isRTL() ? 'true': 'false');
		$javascript = "jQuery(document).ready(function($){
	jQuery.datepicker.regional['{$lang->getTag()}'] = {
		currentText:'"	.JText::_('COM_CONTACTENHANCED_CF_DATE_NOW',	true)."',
		closeText:	'"	.JText::_('COM_CONTACTENHANCED_CF_DATE_DONE',	true)."',
		timeOnlyTitle: '".JText::_('COM_CONTACTENHANCED_CF_DATE_CHOOSE_TIME',	true)."',
		timeText:	'"	.JText::_('COM_CONTACTENHANCED_CF_DATE_TIME',	true)."',
		hourText:	'"	.JText::_('COM_CONTACTENHANCED_CF_DATE_HOUR',	true)."',
		minuteText:	'"	.JText::_('COM_CONTACTENHANCED_CF_DATE_MINUTE',	true)."',
		secondText:	'"	.JText::_('COM_CONTACTENHANCED_CF_DATE_SECOND',	true)."',
		timezoneText:'"	.JText::_('COM_CONTACTENHANCED_CF_DATE_TIME_ZONE',	true)."',
		weekHeader:	'#',
		prevText:	'<".JText::_('JPREV',	true)."',
		nextText:	'".JText::_('JNEXT',	true).">',
		isRTL:		{$isRTL},
		showMonthAfterYear: false,
		amNames:	['AM', 'A'],
		pmNames:	['PM', 'P'],
		timeSuffix:	'',
		yearSuffix:	'',
		monthNames: {$monthNames},
		monthNamesShort: {$monthNames},
		dayNames:	{$DayNames},
		dayNamesShort:{$DayNamesShort},
		dayNamesMin:{$DayNamesShort},
		controlType:'select',
	//	changeMonth:true,
	 //   changeYear: true,

	}
	jQuery.datepicker.setDefaults($.datepicker.regional['{$lang->getTag()}']);
});
";



		if($this->params->get('datepicker-range')){
			// code from http://www.benknowscode.com/2012/11/selecting-ranges-jquery-ui-datepicker.html
			$javascript 	.= "jQuery(document).ready(function($){
$.datepicker._defaults.onAfterUpdate = null;

var datepicker__updateDatepicker = $.datepicker._updateDatepicker;
$.datepicker._updateDatepicker = function( inst ) {
   datepicker__updateDatepicker.call( this, inst );

   var onAfterUpdate = this._get(inst, 'onAfterUpdate');
   if (onAfterUpdate)
	  onAfterUpdate.apply((inst.input ? inst.input[0] : null),
		 [(inst.input ? inst.input.val() : ''), inst]);
}

   var cur{$this->id} = -1, prv{$this->id} = -1;
   $('#ce-cf-container-{$this->id} div')
	  .datepicker({
	  		".(implode(",\n\t\t",$js_properties)).",
	  		weekHeader:	'".JText::_('JGLOBAL_NUM')."',
			dateFormat:	'{$dateFormat}',
			timeFormat:	'".$this->params->get('datepicker-timePicker')."',
			showButtonPanel:	true,
			 beforeShowDay: function ( date ) {
				  return [$days, ( (date.getTime() >= Math.min(prv{$this->id}, cur{$this->id}) && date.getTime() <= Math.max(prv{$this->id}, cur{$this->id})) ? 'date-range-selected' : '')];
			   },

			onSelect: function ( dateText, inst ) {
				  var d1, d2;

				  prv{$this->id} = cur{$this->id};
				 	var dateFormat = $('#ce-cf-container-{$this->id} div').datepicker('option', 'dateFormat');
				  cur{$this->id} = (new Date(inst.selectedYear, inst.selectedMonth, inst.selectedDay)).getTime();
				  if ( prv{$this->id} == -1 || prv{$this->id} == cur{$this->id} ) {
					 prv{$this->id} = cur{$this->id};
					 $('#ce-cf-container-{$this->id} input').val( dateText );
				  }else{
					 d1 = $.datepicker.formatDate( dateFormat, new Date(Math.min(prv{$this->id},cur{$this->id})), {} );
					 d2 = $.datepicker.formatDate( dateFormat, new Date(Math.max(prv{$this->id},cur{$this->id})), {} );
					 $('#ce-cf-container-{$this->id} input').val( d1+' - '+d2 );
				  }
			   },
			onChangeMonthYear: function ( year, month, inst ) {
				  //prv{$this->id} = cur{$this->id} = -1;
			   },
			onAfterUpdate: function ( inst ) {
				if($('#ce-cf-container-{$this->id} .ui-datepicker-close').length < 1){
				  $('<button type=\"button\" class=\"ui-datepicker-close ui-state-default ui-priority-primary ui-corner-all\" data-handler=\"hide\" data-event=\"click\">".JText::_('COM_CONTACTENHANCED_CF_DATE_DONE')."</button>')
					 .appendTo($('#ce-cf-container-{$this->id} div .ui-datepicker-buttonpane'))
					 .on('click', function () { $('#ce-cf-container-{$this->id} div').hide(); });
			 	}
		   }
		 })
	  .position({
			my: 'left top',
			at: 'left bottom',
			of: $('#ce-cf-container-{$this->id} input')
		 })
	  .hide();

   $('#ce-cf-container-{$this->id} input').on('focus', function (e) {
		 var v = this.value,
			 d;

		 try {
			if ( v.indexOf(' - ') > -1 ) {
			   d = v.split(' - ');
				var dateFormat = $('#ce-cf-container-{$this->id} div').datepicker('option', 'dateFormat');
			   prv{$this->id} = $.datepicker.parseDate( dateFormat, d[0] ).getTime();
			   cur{$this->id} = $.datepicker.parseDate( dateFormat, d[1] ).getTime();

			} else if ( v.length > 0 ) {
			   prv{$this->id} = cur{$this->id} = $.datepicker.parseDate( dateFormat, v ).getTime();
			}
		 } catch ( e ) {
			cur{$this->id} = prv{$this->id} = -1;
		 }

		 if ( cur{$this->id} > -1 )
			$('#ce-cf-container-{$this->id} div').datepicker('setDate', new Date(cur{$this->id}));

		 $('#ce-cf-container-{$this->id} div').datepicker('refresh').show();
	  });

});";

		}else{
			$javascript 	.= "jQuery(document).ready(function($){
	$('#{$this->getInputId()}').{$widgetClass}({
		".(implode(",\n\t\t",$js_properties)).",
		dateFormat:	'{$dateFormat}',
		changeMonth: true,
      	changeYear: true,
		timeFormat:	'".$this->params->get('datepicker-timePicker')."',
		beforeShowDay: function ( date ) {
			return [$days,''];
		}
	});
});";
		}
		$doc->addScriptDeclaration(" {$javascript} ");

	}

	protected function jsToDateTimeFormat($jsDate,$jsFormat) {
		$date = explode('-', $jsDate);
		$dateParts = explode('-', $jsFormat);
		$date = array($dateParts[0] => $date[0], $dateParts[1] => $date[1], $dateParts[2] => $date[2]);
		$date = $date['yy'].'-'.($date['m'] ? $date['m'] : $date['MM']).'-'.$date['d'];
		return $date;
	}
}

class ceFieldType_multiplefiles extends ceFieldType {
	public static $uploadedFiles = array();
	function getInputHTML() {
		
		$app		= JFactory::getApplication();
		$jinput		= $app->input;
				
		$max_file_size	= (int) $this->params->get('max_file_size',300);
		$max_file_size	= $max_file_size * 1024;
		$number_of_files= (int) $this->params->get('mf_number_of_files',3);
		
		$allowedMimeTypes = ceFileHelper::getMimeFromExtensions($this->params->get('mf_filter_file_extensions','doc,docx,ppt,pptx,xls,xlsx,pdf,jpg,gif,png,zip'));
		 
		$fileInput = '<input type="file"
							class="cf-input-file inputbox '.$this->getFieldClass().'"
							name="'.$this->getInputName().'[]"
							id="'.$this->getInputName().'" '
							.str_replace('required', '', $this->attributes) .'
							'.($number_of_files > 1 ? 'multiple' : '').'
							accept="'.$allowedMimeTypes.'"
							data-url="'.JURI::root(true).'/components/com_contactenhanced/ajax.php?&task=jsonExecuteCF&cf='.$this->id.'"
						/>
						<input type="hidden" name="MAX_FILE_SIZE" value="'.$max_file_size.'" />';
		
		if(!class_exists('iBrowser')){
			require_once(JPATH_ROOT.'/components/com_contactenhanced/helpers/browser.php');
		}
		$browser = new iBrowser();
		$comParams = JComponentHelper::getParams('com_contactenhanced');
		
		// IF IE < 10 (9 or older)
		if($browser->checkBrowserInternetExplorer() 
				AND version_compare($browser->getVersion(), '10') < 0
				OR !$comParams->get('load_jqueryUI',1) // if jQuery UI is disabled load regular HTML file input
				OR !$this->params->get('mf_use_ajax',1) // if Ajax is disabled
		){
			return $fileInput;
		}

		// It's not IE 9, so load jQuery 
		ceHelper::loadJqueryUI();
		$salt 		= time().'_'.hash('sha256',mt_rand());
		/**
		 * Adds a session variable to verify later
		* */
		if(!ceHelper::getSession('fileupload_'.$this->alias, false)){
			ceHelper::setSession('fileupload_'.$this->alias,$salt, false);
		}
		$lang		= JFactory::getLanguage();
		$lang->load('com_media', JPATH_ROOT);

		$doc	= JFactory::getDocument();
		$doc->addStyleSheet(JURI::root(true).'/components/com_contactenhanced/assets/jquery.fileupload/css/jquery.fileupload.css');
		$doc->addStyleSheet(JURI::root(true).'/components/com_contactenhanced/assets/jquery.fileupload/css/jquery.fileupload-ui.css');
		$doc->addCustomTag('<noscript><link rel="stylesheet" href="'.JURI::root(true).'/components/com_contactenhanced/assets/jquery.fileupload/css/jquery.fileupload-noscript.css"></noscript>');
		$doc->addScript(JURI::root(true).'/components/com_contactenhanced/assets/jquery.fileupload/js/jquery.fileupload.js' );
		$doc->addScript(JURI::root(true).'/components/com_contactenhanced/assets/jquery.fileupload/js/jquery.fileupload-process.js' );
		$doc->addScript(JURI::root(true).'/components/com_contactenhanced/assets/jquery.fileupload/js/jquery.fileupload-ui.js' );

		
		
		if($this->params->get('mf_filter_type','whitelist')){
			$allowedFileTypes	=  str_replace(array(',','  ',' ','.'),array('|','','',''),$this->params->get('mf_filter_file_extensions','doc,docx,ppt,pptx,xls,xlsx,pdf,jpg,jpeg,gif,png,zip'));
			$allowedFileTypes	= "/(\.|\/)({$allowedFileTypes})$/i";
		}else{
			$allowedFileTypes 	= '@';
		}

		$html	= '
	<span class="btn btn-default fileinput-button">
		<span>'.JText::_('COM_MEDIA_UPLOAD_FILE').'...</span>
		'.$fileInput.'
	</span>
';
		$filesLeftStyle = ' style="display:none" ';
		if($this->params->get('mf_show_number_of_files_allowed',1)) {
			$filesLeftStyle = '';
		}
		$html	.= ' <small id="'.$this->getInputName().'_files_left" class="mf-number-files muted text-muted" '.$filesLeftStyle.'>'
					.JText::_('CF_MULTIPLE_FILES_FILES_LEFT')
					.' <strong>'.$number_of_files.'</strong></small> ';
	if($this->isRequired()){
		$html 	.= '<input type="text"
				data-rule-jqueryfileupload="true"
				id="'.$this->getInputName().'_validator"
				class="'.($this->isRequired() ? 'required' : '').'"
				style="position:absolute;left:-9999px;top:0;"
				name="'.$this->getInputName().'_validator" value="'.$number_of_files.'" />
		<label for="'.$this->getInputName().'_validator" class="error"></label>';
	}

	$html	.= '
	<div class="progress progress-success progress-striped">
	  <div class="progress-bar bar progress-success progress-bar-success" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100">
		<span class="sr-only"></span>
	  </div>
	</div>



	<p>'.JText::_('CF_MULTIPLE_FILES_FILES').':</p>';
	//Switch to ul.list-group in Bootstrap 3
	$html	.= '<ul class="filelist unstyled list-unstyled"></ul>';

	$script = '';

		$script .= "
		'use strict';
		$('#{$this->getInputName()}').fileupload({
			filesContainer: $('#ce-cf-container-{$this->id} .filelist'),
			filesLeftContainer: $('#{$this->getInputName()}_files_left'),
			".
			($this->isRequired() ? "fileValidator: $('#{$this->getInputName()}_validator')," : '')
			."fieldAlias:	'{$this->getInputName()}',
			acceptFileTypes: 	{$allowedFileTypes},
			maxFileSize: 		{$max_file_size},
			maxNumberOfFiles:	{$number_of_files},
			limitMultiFileUploads:{$number_of_files},
			required: 	".($this->isRequired() ? 'true' : 'false').",
			messages : {
				uploadedBytes:	'Uploaded bytes exceed file size',
				removeFile: 	'".JText::_('CF_MULTIPLE_FILES_REMOVE_FILE')."',
				error: 			'".JText::_('JERROR_ERROR')."',
				fieldRequired: 	'".JText::_('COM_CONTACTENHANCED_VALIDATION_ERROR_FILE_REQUIRED')."',
				maxNumberOfFiles:'".JText::_('CF_MULTIPLE_FILES_MAX_NUMBER_OF_FILES_EXCEEDED')."',
				acceptFileTypes:'".JText::_('CF_MULTIPLE_FILES_FILE_TYPE_NOT_ALLOWED')."',
				maxFileSize: 	'".JText::_('CF_MULTIPLE_FILES_FILE_TOO_LARGE')."',
				minFileSize: 'File is too small'
			}
		});

		$('#{$this->getInputName()}').bind('fileuploadstart',function(e){ 
				var submitButton = $('.ce-form button[type=\"submit\"]');
				submitButton.attr('disabled', 'disabled');
				submitButton.data('default-title', submitButton.html());
				submitButton.html('".JText::_('COM_CONTACTENHANCED_FILES_UPLOADING_FILES')."');
			})
			.bind('fileuploadprogressall',function(e,data){
				if(data.loaded == data.total){
					var submitButton = $('.ce-form button[type=\"submit\"]');
					submitButton.removeAttr('disabled');
					submitButton.html(submitButton.data('default-title'));
				}
			});
		
		
		$.ajax({
			url:  $('#{$this->getInputName()}').fileupload('option', 'url')+'&action=getFileList',
			dataType: 'json',
			context: $('#{$this->getInputName()}')[0]
		}).always(function () {
			$(this).removeClass('fileupload-processing');
		}).done(function (result) {
			$(this).fileupload('option', 'done')
				.call(this, $.Event('done'), {result: result});
		});

		$('#ceForm".$this->params->get('form_id')." [type=\"reset\"]').click(function() {
			$.ajax({
				url:  $('#{$this->getInputName()}').fileupload('option', 'url')+'&action=deleteList',
				dataType: 'json',
				context: $('#{$this->getInputName()}')[0]
			}).done(function (result) {
				$('#ce-cf-container-{$this->id} .filelist').empty();
				$('#ce-cf-container-{$this->id} .progress-bar').css('width', 0);
			});
		});

";


		$doc->addScriptDeclaration("jQuery(document).ready(function($){ {$script} });");
		return $html;
	}

	function getUploadedFiles(&$totalFilesize){
		if(!class_exists('iBrowser')){
			require_once(JPATH_ROOT.'/components/com_contactenhanced/helpers/browser.php');
		}
		$browser = new iBrowser();
		$comParams = JComponentHelper::getParams('com_contactenhanced');
		
		if(empty(self::$uploadedFiles[$this->alias]) 
			AND $salt = ceHelper::getSession('fileupload_'.$this->alias)
			AND $comParams->get('load_jqueryUI',1)
			AND $this->params->get('mf_use_ajax',1) // if Ajax is enabled
		){
			jimport('joomla.filesystem.file');
			jimport('joomla.filesystem.folder');
			$tmpDir	= JPATH_ROOT.'/cache/com_contactenhanced_form_files_temp/'.$salt.'/';
			if(is_dir($tmpDir)){
				$files	= JFolder::files($tmpDir, '.', false,false, array('.svn', 'CVS', '.DS_Store', '__MACOSX', 'index.html'));
				foreach ($files as $file){
					$uploadedFile = JFile::makeSafe($file);
					rename($tmpDir.$file, CE_UPLOADED_FILE_PATH.$uploadedFile);
					$totalFilesize += filesize(CE_UPLOADED_FILE_PATH.$uploadedFile);
					self::$uploadedFiles[$this->alias][] = $uploadedFile;
				}

				return !empty(self::$uploadedFiles[$this->alias]) ? self::$uploadedFiles[$this->alias] : array();
			}
		// IE 8 or older
		} 
		elseif(empty(self::$uploadedFiles[$this->alias]) 
				AND $browser->checkBrowserInternetExplorer() 
				AND version_compare($browser->getVersion(), '10') < 0
				OR !$comParams->get('load_jqueryUI',1)
				OR !$this->params->get('mf_use_ajax',1) // if Ajax is disabled
		){
			return $this->uploadFile($totalFilesize);
		}
		elseif (!empty(self::$uploadedFiles[$this->alias])){
			return self::$uploadedFiles[$this->alias];
		}
	}
	function validateField() {
		if(!class_exists('iBrowser')){
			require_once(JPATH_ROOT.'/components/com_contactenhanced/helpers/browser.php');
		}
		$browser = new iBrowser();
		$comParams = JComponentHelper::getParams('com_contactenhanced');
		
		if($browser->checkBrowserInternetExplorer() 
				AND version_compare($browser->getVersion(), '10') < 0
				OR !$comParams->get('load_jqueryUI',1)
				OR !$this->params->get('mf_use_ajax',1) // if Ajax is disabled
		){
			// Get the uploaded file information
			$userfile = JRequest::getVar($this->alias, null, 'files', 'array');
			$userfile = ceFileHelper::reArrayFiles($userfile);
			if($this->isRequired() AND empty($userfile[0]['name'])){
				return false;
			}
		}
		
		return true;
	}
	
	public function getMySQLOutput(){
		return !empty(self::$uploadedFiles[$this->alias]) ? implode('|', self::$uploadedFiles[$this->alias]) : '';
	}
	/**
	 * uploads the file
	 *
	 * @return 
	 */
	protected function uploadFile(&$totalFilesize)
	{
		// Get the uploaded file information
		$userfile = JRequest::getVar($this->alias, null, 'files', 'array');
	
		// Make sure that file uploads are enabled in php
		if (!(bool) ini_get('file_uploads'))
		{
			JError::raiseWarning('', JText::_('Make sure that file uploads are enabled in php'));
			return false;
		}
	
		// If there is no uploaded file, we have a problem...
		if (!is_array($userfile) AND $this->isRequired())
		{
			JError::raiseWarning('', JText::_('COM_CONTACTENHANCED_VALIDATION_ERROR_FILE_REQUIRED'));
			return false;
		}elseif (!is_array($userfile)){
			return false;
		}
	
		$allowedFileTypes	= str_replace(array(',','  ',' ','.'),array('|','','',''),$this->params->get('mf_filter_file_extensions','doc,docx,ppt,pptx,xls,xlsx,pdf,jpg,jpeg,gif,png,zip'));
		$allowedFileTypes	= explode('|', $allowedFileTypes);
		$max_file_size	= (int) $this->params->get('max_file_size',300);
		$max_file_size	= $max_file_size * 1024;
		$number_of_files= (int) $this->params->get('mf_number_of_files',3);
		
		$userfiles = ceFileHelper::reArrayFiles($userfile);
		
		jimport('joomla.filesystem.file');
		$count = 0;
		foreach ($userfiles as $userfile){
			$fileExt = JFile::getExt($userfile['name']);
			// Check if there was a problem uploading the file.
			if ( ($userfile['error']) AND $this->isRequired() )
			{
				JError::raiseWarning('', ceFileHelper::file_upload_error_message($userfile['error']));
				return array();
			}elseif ( ($userfile['size'] < 1) AND $this->isRequired() )
			{
				JError::raiseWarning('', JText::_('FILE IS TOO SMALL'));
				return array();
			}elseif(!in_array($fileExt, $allowedFileTypes)){
				JError::raiseWarning('', JText::_('CF_MULTIPLE_FILES_FILE_TYPE_NOT_ALLOWED')." ({$fileExt})");
				continue;
			}elseif (filesize($userfile['tmp_name']) > $max_file_size){
				JError::raiseWarning('', JText::_('CF_MULTIPLE_FILES_FILE_TOO_LARGE')." ({$userfile['name']})");
				continue;
			}elseif ($number_of_files <= $count++ ){
				JError::raiseWarning('', JText::_('CF_MULTIPLE_FILES_MAX_NUMBER_OF_FILES_EXCEEDED')
									."<br />"
									.JText::sprintf('FILEUPLOAD_UPLOADED_FILES', implode(', ', self::$uploadedFiles[$this->alias]))
				);
				break;
			}
			
			// Build the appropriate paths
			$uploadedFile = JFile::makeSafe($userfile['name']);
			$tmp_dest	= CE_UPLOADED_FILE_PATH.$uploadedFile;
			$tmp_src	= $userfile['tmp_name'];
			// Move uploaded file
			JFile::upload($tmp_src, $tmp_dest);
			
			$totalFilesize += filesize(CE_UPLOADED_FILE_PATH.$uploadedFile);
			self::$uploadedFiles[$this->alias][] = $uploadedFile;
		}
		
	
		return self::$uploadedFiles[$this->alias];
	}

	public function jsonExecute() {
		/**
		 * Will only upload if Session Variable was generated.
		 * This Variable will be the upload directory in order to increase security
		 */
		if($salt = ceHelper::getSession('fileupload_'.$this->alias)){
			jimport('joomla.filesystem.file');
			jimport('joomla.filesystem.folder');

			$app		= JFactory::getApplication();
			$jinput 	= $app->input;
			$options	= array();
			$options['param_name'] 			= $this->getInputName();
			$max_file_size					= (int) $this->params->get('max_file_size',300);
			$options['max_file_size'] 		= $max_file_size * 1024;
			$options['download_via_php'] 	= false;
			// Add 1 in order to ignore the index.html file
			$max_number_of_files	= $this->params->get('mf_number_of_files',3) +1;
			$options['max_number_of_files'] = $max_number_of_files;
			$options['upload_dir'] 			= JPATH_ROOT.'/cache/com_contactenhanced_form_files_temp/'.$salt.'/';
			$options['upload_url'] 			= '';
			/**
			 * Creates an index.html file in the uploaded folder for extra safety
			 */
			$filename 	= JPATH_ROOT.'/cache/com_contactenhanced_form_files_temp/index.html';
			$content 	= '<html><body></body></html>';
			if (!JFile::exists($filename)){
				JFile::write($filename,$content);
			}
			$filename = $options['upload_dir'].'index.html';
			if (!JFile::exists($filename)){
				JFile::write($filename,$content);
			}

			require(JPATH_ROOT.'/components/com_contactenhanced/assets/jquery.fileupload/UploadHandler.php');

			$options['image_library'] = 0;
			$options['auto_orient']		= array(
												''			=> array('auto_orient' => false),
												'thumbnail'	=> array('max_width' => 80,	'max_height' => 80)
											);
			$upload_handler = new UploadHandler($options, false);
			if($jinput->get('action') == 'getFileList'){
				$result = ($upload_handler->get(false));
				//print_r($result); exit;
			}elseif($jinput->get('action') == 'deleteList'){
				JFolder::delete($options['upload_dir']);
				$result = ($upload_handler->get(false));
			}else{
				$result = ($upload_handler->post(false));
			}

			header('Content-type: application/json; charset=UTF-8');
			echo json_encode( $result ); exit();

		}
		return JText::_('JERROR_ERROR').': No seession';
	}
	public function getEmailOutput($delimiter= ', ',$format='text',$style=array('label'=>'','value'=>'')) {
		return '';
	}
	function getFieldClass() {
		return str_replace('required', '', parent::getFieldClass()); //validate-file
	}
}

class ceFieldType_file extends ceFieldType {
	function getInputHTML() {
		$html	= '<input type="file" class="cf-input-file" name="'.$this->getInputName().'" id="'.$this->getInputName().'" '.$this->attributes
		. ' class="inputbox '.$this->getFieldClass().(($this->isRequired()) ? ' validate-file':'').'" '
		.' />'
		.'<input type="hidden" name="MAX_FILE_SIZE" value="102400" /><br/>';
		return $html;
	}
}

class ceFieldType_name extends ceFieldType {

	public function getValidationScript() {
		$script = parent::getValidationScript();

		$validationRule	= $this->addValidationRule();
		if($this->params->get('validation') == 'iMask'  ){
			$doc	= JFactory::getDocument();
			$doc->addScript(JURI::root().'components/com_contactenhanced/assets/js/jquery.maskedinput.js');
			$script 	.= ("\n	$('#{$this->getInputName()}').mask('{$this->params->get('validation-iMask-mask')}');");
		}elseif($this->params->get('validation') == 'custom'
				AND $this->params->get('validation-custom-name')
				AND $this->params->get('validation-custom-errorMsg')
				AND $this->params->get('validation-custom-test')
		){
			$customValidatorName	= JApplication::stringURLSafe($this->params->get('validation-custom-name'));
			$customValidatorError	= addslashes($this->params->get('validation-custom-errorMsg'));
			$customValidatorTest	= $this->params->get('validation-custom-test');
			$script 	.= ("
jQuery.validator.addMethod('{$customValidatorName}',function(value,element){
	return this.optional(element) || {$this->params->get('validation-custom-test')};
},'{$customValidatorError}');
");
		}
		/* Will be removed from future versions */
		if($this->params->get('check') == 'coupon'
				AND strpos($this->params->get('check-coupon-sql'), 'SELECT') !== FALSE){
				$doc	= JFactory::getDocument();
				$doc->addScript(JURI::root().'components/com_contactenhanced/assets/js/json_validate.js');
				$script	.= "\n\t"."jsonvalidate('{$this->id}','');"."\n";
		}
		return $script;
	}

	function getInputHTML() {
		$class	= 'inputbox cf-input-text '.($this->published ? $this->getFieldClass() : '');

		$dataValidators	='';
		$validationRule	= $this->addValidationRule();
		if($this->params->get('validation')
			AND $this->params->get('validation') != 'custom'
			AND $this->params->get('validation') != 'iMask'
		){
			$dataValidators 	= ' data-rule-'.$validationRule.'="true" ';
		}elseif($this->params->get('validation') == 'custom'
				AND $this->params->get('validation-custom-name')
				AND $this->params->get('validation-custom-errorMsg')
				AND $this->params->get('validation-custom-test')
		){
			$dataValidators 	= ' data-rule-'.$customValidatorName.'="true" ';
		}

		$user		= JFactory::getUser();
		$input = '<input
					class="'.$class.' inputbox cf-input-text '.($this->getFieldClass()).'"
					type="'.($this->published ? 'text' : 'hidden').'"
					name="name" id="name" '
					. ' value="'. ($this->getValue() ? $this->getValue() : $user->get('name') ). '" '
					.$this->attributes
					.$dataValidators
					.' />'
					//.'<br />'
					;
		$html = '';
		if($this->params->get('prepend') OR $this->params->get('append')){
			$divClass = 'input-group '.($this->params->get('prepend') ? ' input-prepend ': '')
						.($this->params->get('append') ? ' input-append ': '');
			$html .= '<div class="'.$divClass.'">';
			if($this->params->get('prepend')){
				$html .= '<span class="input-group-addon add-on">'.$this->params->get('prepend').'</span>';
			}
			$html .= $input;
			if($this->params->get('append')){
				$html .= '<span class="input-group-addon add-on">'.$this->params->get('append').'</span>';
			}
			$html .= '</div>';
			$html .= '<label class="error" for="'.$this->getInputId().'"></label>';
		}else{
			$html = $input;
		}
		return $html;

	}
	function getInputName($count=1){
		return 'name';
	}
}
class ceFieldType_surname extends ceFieldType {
	function getInputName($count=1){
		return 'surname';
	}
}
class ceFieldType_email extends ceFieldType {
	function getInputHTML() {
		$value	= '';
		if($this->getValue() AND !$this->params->get('plugin_active')){
			$value	= $this->getValue();
		}elseif(!$this->params->get('plugin_active')){
			$user		= JFactory::getUser();
			$value	= $user->get('email');
		}

		$input	= '<input
				type="email"
				id="email"
				name="email" '
			. ' class="inputbox cf-input-text'.$this->getFieldClass().'" '
			. ' value="'.$value. '"
			'.$this->attributes.' />';


		$html = '';
		$html .= $this->getAppendPrepend($input);

		return $html;
	}
	function getInputName($count=1){
		return 'email';
	}
	public function getValidationScript() {

	}
	public function getValidationRule(){
		$script 	= '';
		if(	$this->isRequired()
			AND ($this->params->get('email_registration') OR  $this->params->get('email_validation')) )
		{
			$script .= "
			email:{
				required:	true,
				email:		true,
				remote:	{
						url: '".JURI::root()."index.php?option=com_contactenhanced&task=checkemail&tmpl=raw&registration=".$this->params->get('email_registration')."',
						type: 'post'
		        }
			}";
		}
		return $script;
	}
	function validateField(){
		JRequest::setVar('registration',$this->params->get('email_registration'));
		$botScoutAPIKey	= ( ($this->params->get('botScout-api-key')) ? $this->params->get('botScout-api-key') : false);
		$ret	= ceHelper::checkEmail(JRequest::getVar('email'), $botScoutAPIKey);

		if( ($ret['action'] == 'error' AND JRequest::getVar('email'))
				OR ($this->isRequired() AND $ret['action'] == 'error'))
		{
			JFactory::getApplication()->enqueueMessage($ret['msg'],'notice');
			return false;
		}

		return parent::validateField();
	}
}


class ceFieldType_subject extends ceFieldType {

	function getInputHTML() {
		if(count($this->arrayFieldElements) > 1){
			$input = '<select name="' . $this->getInputName() . '" id="' . $this->getInputName() . '"'
			.	' class="inputbox text_area'.($this->published ? $this->getFieldClass() : '').'" '.$this->attributes.' >';
			$input .= '<option value="">'.JText::_($this->params->get('first_option', 'CE_PLEASE_SELECT_ONE')).'</option>';
			foreach($this->arrayFieldElements AS $fieldElement) {
				if(strpos($fieldElement, '::') > 0){
					$fieldElement = explode('::', $fieldElement);
				}else{
					$fieldElement = array($fieldElement,$fieldElement);
				}
				$input .= '<option value="'.JText::_($fieldElement[0]).'"';
				if( $fieldElement[0] == $this->getValue() ) {
					$input .= ' selected';
				}
				$input .= '>' . JText::_($fieldElement[1]) . '</option>';
			}
			$input .= '</select>';
		}else{
			$input	= '<input  type="'.($this->published ? 'text' : 'hidden').'" name="subject" id="subject" '
			. ' class="inputbox cf-input-text'.($this->published ? $this->getFieldClass() : '').'" '
			. ' value="'. ($this->getValue() ? $this->getValue() : '' ). '" '.$this->attributes.' />';
		}

		$html = '';
		$html .= $this->getAppendPrepend($input);

		return $html;
	}
	function getInputName($count=1){
		return 'subject';
	}
	function getValue($arg=null){

		if($this->value){
			return $this->value;
		}else{
			return parent::getValue($arg);
		}
	}
}
class ceFieldType_numberrange extends ceFieldType{
	var $_selectCounter = 0;
	function getInputHTML() {
		$html = '';
		$this->_selectCounter = 0;
		foreach($this->arrayFieldElements AS $fieldElements) {

			$fieldElement = explode('-',preg_replace("/[^0-9-]/", "", $fieldElements));  // removes any char other than numbers and dash -
			if(!isset($fieldElement[1])){
				$fieldElement[1] = $fieldElement[0];
			}elseif (($fieldElement[0]-$fieldElement[1]) > 200 ){
				return JText::sprintf('CE_CF_NUMBER_ERROR_FIELD_RANGE_TOO_WIDE',($fieldElement[0]-$fieldElement[1]));
			}
			if(count($this->arrayFieldElements) == 1){
				$nrLabel = JText::_('CE_PLEASE_SELECT_ONE');
			}elseif($this->_selectCounter > 0){
				$nrLabel = JText::_('CE_CF_NUMBER_RANGE_TO');
			}else{
				$nrLabel = JText::_('CE_CF_NUMBER_RANGE_FROM');
			}

			$input = '';
			$input .= '<select name="' . $this->getInputName() . '" id="' . $this->getInputName() . '" class="inputbox text_area'.($this->getFieldClass()).'" '.$this->attributes.' >';
			$input .= '<option value="">'.$nrLabel.'</option>';
			for($i=$fieldElement[0]; $i <= $fieldElement[1]; $i++){
				$input .= 	'<option value="'.$i.'"';
				if( $i == $this->getValue() ) {
					$input .= ' selected';
				}
				$input .=	' >'.$i.'</option>';
			}
			$input .= '</select> ';

			$html .= $this->getAppendPrepend($input);
			$this->_selectCounter++;
		}
		return $html;
	}
	function getInputName($type=''){
		if($type=='cookie'){
			return parent::getInputName().'_'.$this->_selectCounter;
		}elseif($type=='submission'){
			return parent::getInputName();
		}else{
			return parent::getInputName()."[".($this->_selectCounter)."]";
		}
	}
	function getRecordedFieldId(){
		return '<input type="hidden" name="'.parent::getInputName().'_id" value="'.$this->field_id.'" />';
	}

	function getEmailOutput($delimiter= ', ',$format='text',$style=array('label'=>'','value'=>'')){
		return parent::getEmailOutput(' '.JText::_('CE_CF_NUMBER_RANGE_TO').' ', $format, $style);
	}
}
class ceFieldType_number extends ceFieldType_numberrange{

	function getInputName($type=''){
		return $this->alias;
	}
}

class ceFieldType_freetext extends ceFieldType {
	function getInputHTML() {
		return '<div class="ce-freetext-container" '.$this->attributes.' >'.JText::_($this->getValue()).'</div>';
	}
	function getFieldHTML() {
		if(strpos($this->getValue(), '<fieldset>') !== false
		OR strpos($this->getValue(), '</fieldset>') !== false){
			return $this->getValue();
		}else{
			return parent::getFieldHTML();
		}
	}
	function getValue($arg=null){
		if($this->params->get('parse_content_plugins',0)){
			/*
			 * Handle display events
			 */
			// add full article object to avoid problems with plugins
			$article = new stdClass();
			$article->id	= $this->params->get('contactId',0);
			$article->text	= $this->value;
			$article->event = new stdClass();

			ceHelper::processContentPlugin($this->params, $article);

			return $article->text;
		}else{
			return $this->value;
		}
	}
	public function getLabel($output='site'){
		return '';
	}
}


class ceFieldType_password extends ceFieldType {
	function getInputHTML() {
		$fieldAttributes	= ' class="inputbox cf-input-text cf-input-password password '.($this->getFieldClass()).'" '.$this->attributes;
		$input	= '<input type="password" name="' . $this->getInputName() . '" id="' . $this->getInputName() . '"  '
		.$fieldAttributes.' value="'.htmlspecialchars($this->getValue()).'" />';

		$html	= '';
		$html .= $this->getAppendPrepend($input);

		return $html;
	}
	function getInputName($count=1){
		return 'password';
	}
}
class ceFieldType_password_verify extends ceFieldType {
	function getInputHTML() {
		$doc	=JFactory::getDocument();
		$doc->addScriptDeclaration("
jQuery(document).ready(function($){
	jQuery.validator.addMethod('password_verify',function(value,element){
		return this.optional(element) || value === $('#password').val();
	},'".JText::_('COM_CONTACTENHANCED_CF_PASSWORD_VERIFY_VALIDATION_ERROR_MSG')."');
});
");
		$fieldAttributes 	= ' data-rule-password_verify="true" ';
		$fieldAttributes	.= ' class="inputbox cf-input-text cf-input-password_verify validate-passverify '.($this->getFieldClass()).'" '
								.$this->attributes;
		$input	= '<input
							type="password" name="' . $this->getInputName() . '"
							id="' . $this->getInputName() . '"  '
							.$fieldAttributes.  '
							value="'.htmlspecialchars($this->getValue()).'" />';
		$html	= '';
		$html .= $this->getAppendPrepend($input);

		return $html;
	}
	function getInputName($count=1){
		return 'password_verify';
	}

	function validateField(){
		if($this->isRequired() AND (JRequest::getVar('password') != JRequest::getVar('password_verify'))){
			return false;
		}
		return true;
	}
}

class ceFieldType_username extends ceFieldType {
	public function getValidationRule(){
		$script 	= '';
		if(	$this->isRequired()){
			$script .= "
			".$this->getInputName().": {
				required: true,
				remote: '".JURI::root()."index.php?option=com_contactenhanced&amp;task=checkusername&amp;tmpl=raw&amp;registration=".$this->params->get('username_registration')."'
			}
			";

		}
		return $script;
	}
	function getInputHTML() {
		$doc =JFactory::getDocument();
		$logDiv	= 'CElog_res';
		$success	= array();
		$success['class'] = 'success';
		$failure	= array();
		$failure['class'] = 'invalid';
		$script = "
jQuery(document).ready(function($){
	$('#".$this->getInputName()."').on('blur',function(e){
		var self = $(this);
		$.ajax({
			url:  '".JURI::root()."index.php?option=com_contactenhanced&amp;task=checkusername&amp;returntype=json&amp;tmpl=raw&amp;registration=".$this->params->get('username_registration')."&amp;username='+self.val(),
			dataType: 'json',
		}).always(function (result) {
			self.removeClass('success');
			if(result.action == 'success'){
				self.addClass(result.class);
			}
		});
	});
});

";
		$doc->addScriptDeclaration($script);
		$fieldAttributes	= ' class="inputbox cf-input-text cf-input-username'.($this->getFieldClass()).' validate-username"'
		.$this->attributes;
		$input	= '<input type="text"
					name="'.$this->getInputName().'"
					id="'.$this->getInputName().'"
				  '.$fieldAttributes.' value="'.htmlspecialchars($this->getValue()).'" />';
		$html	= '';
		$html .= $this->getAppendPrepend($input);
		$html	.= '<div id="'.$logDiv.'" ></div>';
		return $html;
	}
	function getInputName($count=1){
		return 'username';
	}
	function getEmailOutput($delimiter= ', ',$format='text',$style=array('label'=>'','value'=>'')){
		return parent::getEmailOutput($delimiter,$format,$style);
	}
	function validateField(){
		if($this->params->get('username_registration') AND $this->isRequired()){
			$email		= JRequest::getVar('email','');
			$username	= preg_replace( "/^([^@]+)(@.*)$/", "$1", $email);
			$username	= JRequest::getVar('username',$username);
			$db			= JFactory::getDBO();
			$query		= $db->getQuery(true);
			$query->select('count(id)');
			$query->from('#__users');
			$query->where('username = '.$db->Quote($username));
			$db->setQuery( $query );

			// Abort operation if the user is already registered
			if($db->loadResult()){
				JFactory::getApplication()->enqueueMessage(JText::sprintf('USER_REGISTERED_USERNAME_NOT_AVAILABLE',$username),'notice');
				return false;
			}else{
				return parent::validateField();
			}
		}
		return true;
	}
}

class ceFieldType_hidden extends ceFieldType {
	function getInputHTML() {
		$html	= '<input type="hidden" name="' . $this->getInputName() . '" id="' . $this->getInputName() . '"  value="' . htmlspecialchars($this->getValue()) . '" '.$this->attributes.' />';
		return $html;
	}
	public function getLabel($output='site'){
		return '';
	}
}

class ceFieldType_sql extends ceFieldType {
	function getInputHTML() {
		$doc	= JFactory::getDocument();
		$doc->addScript( JURI::root(). 'components/com_contactenhanced/assets/js/jquery.elementcloner.js' );
		$db		= JFactory::getDBO();
		$query	= $db->getQuery(true);
		$isChainSelect	= false;

		$javascript	= '';
		if($this->params->get('chain_select') AND $this->params->get('chain_select-enabled-option')){
			$javascript	= "onchange=\"JsonSelect.updateSelect('".$this->params->get('chain_select-enabled-option')."',this,'".JURI::root()."', '".$this->params->get('catid')."');\"";
			$doc->addScript(JURI::root().'components/com_contactenhanced/assets/js/chainSelectList.js');
		}

		if($this->value){

			if($this->params->get('isAdmin')){
				$query->select('m.from_id');
				$query->from('#__ce_messages m');
				$query->join('INNER', '#__ce_message_fields mf ON mf.message_id = m.id');
				$query->where('mf.id = '.$db->Quote($this->field_id));

				$db->setQuery($query);
				$user	= $db->loadResult();
				$user	= JFactory::getUser($user);
			}else{
				$user	= JFactory::getUser();
			}


			$regex = '/{user_id}/i';
			$this->value  = preg_replace( $regex, $user->id, $this->value );

			$regex = '/{user_email}/i';
			$this->value  = preg_replace( $regex, $user->email, $this->value );

			$regex = '/{username}/i';
			$this->value  = preg_replace( $regex, $user->username, $this->value );

			$regex = '/{selectresult}/i';
			$isChainSelect  = preg_match( $regex, $this->value );
			if($isChainSelect){
				$this->value  = preg_replace( $regex, '', $this->value );
			}
			$db->setQuery( $this->value);
			$rows = $db->loadObjectList();
		}else{
			return JText::_($this->params->get('sql_no_result_msg','There is no SQL in the Value field'));
		}
		if(!isset($rows) OR
			(count($rows) <= 0 AND !$this->params->get('hide_field') AND !$isChainSelect)){
			return JText::_($this->params->get('sql_no_result_msg',''));
		}else if( (is_array($rows) AND count($rows) ) OR $isChainSelect){
			$options	= array();
			$options[]	= JHTML::_('select.option',  '', JText::_($this->params->get('first_option', 'CE_PLEASE_SELECT_ONE')) );
			$fieldClass	= 'inputbox cf-input-text ce-cf-sql '.($this->getFieldClass());
			if(is_array($rows) AND count($rows)){
				foreach($rows as $row){
					if( substr($row->text,0,2) == '--'){
						$options[]	=	JHTML::_('select.optgroup',  str_replace('--','',JText::_( $row->text ) ) );
					}else{
						$options[]	=	JHTML::_('select.option',  $row->value, JText::_( $row->text ) );
					}
				}
			}
			if(isset($this->field_value)){
				$valueArray	= explode("\n", $this->field_value);
			}else{
				$valueArray	= array($this->getValue());
			}
			$html	= '';
			$deleteButtonStyle = 'style="display:none"';

			if(count($valueArray) > 1){
				$deleteButtonStyle = "";
			}
			$addButton	= 	' <a href="#"
									class="multi-row-add btn btn-default"
									data-action="add"
									title="'.JText::_( 'CF_SQL_ADD' ).'"
								>'.JText::_( 'CF_SQL_ADD_ITEM' ).'</a>'
							.' <a href="#"
									class="multi-row-delete btn btn-default"
									data-action="delete"
									 title="'.JText::_( 'CF_SQL_REMOVE' ).'"
									'.$deleteButtonStyle.'>'.JText::_( 'CF_SQL_REMOVE_ITEM' ).'</a>'
							;
			$html	.= '<div id="'.parent::getInputName().'-container">';

			for($i=1;$i<=count($valueArray);$i++){
				if(is_array($valueArray[($i-1)])){
					if(isset($valueArray[($i-1)]['value']) AND is_array($valueArray[($i-1)]['value'])){
						$value	= explode('::', $valueArray[($i-1)]['value'][0]);
					}else{
						$value	= explode('::', $valueArray[($i-1)]['value']);
					}
				}else{
					$value	= explode('::', $valueArray[($i-1)]);
				}
				$option	= JHTML::_('select.genericlist'
										,   $options, $this->getInputName().'[value][]'
										, $javascript.' size="1" '.$this->attributes. ' class="'.$fieldClass.' ce-cf-field-row"'
										, 'value', 'text', trim($value[0]) );

				$secondField = '';
				if($this->params->get('sql_quantity',0)){
					$scondFieldValidation = $this->params->get('sql_quantity-show-validation', '');
					$secondField .= '<input type="text"
						placeholder="'.JText::_($this->params->get('sql_quantity-show-label','CF_SQL_QUANTITY')).'"
						name="'.$this->getInputName().'[quantity][]"
						class="'.$fieldClass.' ce-cf-sql-quantity" '
						.$scondFieldValidation
						. ' value="'.(isset($value[1]) ? trim($value[1]) : '').'" />';
				}

				$html	.= '<div>'.$option.$secondField;
				if($this->params->get('sql_allow_multiple_lines',0)){
					$html	.= $addButton;
				}
				$html	.= '</div>';
			}
			$html	.='</div>';

			$doc->addScriptDeclaration("jQuery(document).ready(function($){ $('#".parent::getInputName()."-container').find('a').on('click',elementCloner)});");
			return $html;
		}else if($isChainSelect > 0){ //
		}
	}

	public function getSubmittedValue() {
		$html = '';
		for($i=0; $i < count($this->uservalue['value']); $i++){
			$html	.= '<br />
					<span class="ce-cf-html-field ce-cf-html-field-sql">'
						.$this->uservalue['value'][$i].''
						.( isset($this->uservalue['quantity'][$i]) ? ":: \t".$this->uservalue['quantity'][$i] : '')
					.'</span>';
		}
		return $html;
	}

	function getEmailOutput($delimiter= ', ',$format='text',$style=array('label'=>'','value'=>'')){
		$html	= '';
		if($format == 'html'){
			$html	.= '<div class="ce-cf-container"> ';
			$html .= '
			<span  class="ce-cf-html-label" style="'.$style['label'].'"> '.$this->getInputFieldName().'</span> ' ;
			$html .= $this->getSubmittedValue();
			$html	.= '</div>';

		}else{
			$sqlValues = array();
			//if there is more than one value, add a break line between the label and values
			if(count($this->uservalue['value']) > 1){
				$html	.= "\n ";
			}
			for($i=0; $i < count($this->uservalue['value']); $i++){
				$sqlValues[]	= $this->uservalue['value'][$i].( isset($this->uservalue['quantity'][$i]) ? ":: \t".$this->uservalue['quantity'][$i] : '');
				$sqlValues[]	= "\n";
			}
			$html .= implode("\n", $sqlValues);
		}
		return $html;
	}

	function getMySQLOutput(){
		$html	= '';
		for($i=0; $i < count($this->uservalue['value']); $i++){
			$html	.= $this->uservalue['value'][$i].( isset($this->uservalue['quantity'][$i]) ? ":: \t".$this->uservalue['quantity'][$i] : '');
		}
		return $html;
	}
}

class ceFieldType_autocomplete extends ceFieldType {
	var $_selectCounter =1;
	function getInputId(){
		return parent::getInputName().'_value_'.$this->_selectCounter;
	}

	function getInputHTML() {
		$doc	= JFactory::getDocument();
		$doc->addScript( JURI::root(). 'components/com_contactenhanced/assets/js/jquery.elementcloner.js' );
		$db		=JFactory::getDBO();
		// include Bootstrap
		JHtml::_('bootstrap.framework');
		// Typeahead has been dropped in Bootstrap 3, in favor of using Twitter Typeahead.
		$javascript	= "
	ceTypeahead('#".$this->getInputId()."');";
			if(isset($this->field_value)){
				$valueArray	= explode("\n", $this->field_value);
			}else{
				$valueArray	= array('');
			}


			$html	= '';
			$deleteButtonStyle = 'style="display:none"';

			if(count($valueArray)){
				$deleteButtonStyle = "";
			}

			$html	.= '<div id="'.parent::getInputName().'-container" data-autocomplete="1">';

			$fieldClass	= 'inputbox cf-input-text ce-cf-autocomplete '.($this->getFieldClass());
			for($i=1;$i<=count($valueArray);$i++){


				if(is_array($valueArray[($i-1)])){
					if(isset($valueArray[($i-1)]['value']) AND is_array($valueArray[($i-1)]['value'])){
						$value	= explode('::', $valueArray[($i-1)]['value'][0]);
					}else{
						$value	= explode('::', $valueArray[($i-1)]['value']);
					}
				}else{
					$value	= explode('::', $valueArray[($i-1)]);
				}


				$this->_selectCounter	= $i;
				$option	= '<input type="text"
								autocomplete="off"
								placeholder="'.JText::_($this->params->get('autocomplete_item_placeholder','CF_SQL_ITEM')).'"
								name="'.$this->getInputName().'[value][]"
								data-link="'.JURI::root().'index.php?option=com_contactenhanced&task=jsonExecuteCF&cf='.$this->id.'"
								id="'.$this->getInputId().'" '
								.$this->attributes.'
								class="'.$fieldClass.' ce-cf-field-row"
								value="'.trim($value[0]).'" />';

				$secondField = '';
				if($this->params->get('autocomplete_quantity',0)){
					$secondFieldValidation = $this->params->get('autocomplete_quantity-show-validation', '');
					$secondField .= '<input type="text"
						autocomplete="off"
						placeholder="'.JText::_($this->params->get('autocomplete_quantity-show-label','CF_SQL_QUANTITY')).'"
						name="'.$this->getInputName().'[quantity][]"
						class="'.$fieldClass.' ce-cf-autocomplete-quantity" '
						.$secondFieldValidation
						.($this->isRequired() ? ' required ' : '')
						. ' value="'.(isset($value[1]) ? trim($value[1]) : '').'" />';
				}

				$html	.= '<div>'.$option.$secondField;

				if($this->params->get('autocomplete_allow_multiple_lines',0)){
					$addButton	= 	' <a href="#"
									class="multi-row-add btn btn-default"
									data-action="add"
									title="'.JText::_( 'CF_SQL_ADD' ).'"
								>'.JText::_( 'CF_SQL_ADD_ITEM' ).'</a>'
															.' <a href="#"
									class="multi-row-delete btn btn-default"
									data-action="delete"
									 title="'.JText::_( 'CF_SQL_REMOVE' ).'"
									'.$deleteButtonStyle.'>'.JText::_( 'CF_SQL_REMOVE_ITEM' ).'</a>'
																;
					$html	.= $addButton;
					$javascript .= "
							$('#".parent::getInputName()."-container').find('a').on('click',elementCloner);";
				}
				$html .= '</div>'
				;
			}

			$html	.='</div>';

			$javascript	= "jQuery(document).ready(function($){{$javascript}});";
			$doc->addScriptDeclaration($javascript);
			return $html;
	}

	public function jsonExecute() {
		if($this->value){
			$user		= JFactory::getUser();
			$regex = '/{user_id}/i';
			$this->value  = preg_replace( $regex, $user->id, $this->value );

			$regex = '/{user_email}/i';
			$this->value  = preg_replace( $regex, $user->email, $this->value );

			$regex = '/{username}/i';
			$this->value  = preg_replace( $regex, $user->username, $this->value );

			$regex = '/{selectresult}/i';
			$this->value  = preg_replace( $regex, JRequest::getVar('query'), $this->value );

			$db		= JFactory::getDbo();
			$db->setQuery($this->value );
			return $db->loadObjectList();
		}
		return '';
	}

	public function getSubmittedValue() {
		$html = '';
		for($i=0; $i < count($this->uservalue['value']); $i++){
			$html	.= '<br />
					<span class="ce-cf-html-field ce-cf-html-field-sql" style="'.$style['value'].'">'
						.$this->uservalue['value'][$i].''
						.( isset($this->uservalue['quantity'][$i]) ? ":: \t".$this->uservalue['quantity'][$i] : '')
					.'</span>';
		}
		return $html;
	}

	function getEmailOutput($delimiter= ', ',$format='text',$style=array('label'=>'','value'=>'')){
		$html	= '';
		if($format == 'html'){
			$html	.= '<div class="ce-cf-container"> ';
			$html .= '
			<span  class="ce-cf-html-label" style="'.$style['label'].'"> '.$this->getInputFieldName().'</span> ' ;
			$html .= $this->getSubmittedValue();
			$html	.= '</div>';
		}else{
			$html .= $this->getInputFieldName().": ";
			//if there is more than one value, add a break line between the label and values
			if(count($this->uservalue['value']) > 1){
				$html .= "\n ";
			}
			for($i=0; $i < count($this->uservalue['value']); $i++){
				$html	.= $this->uservalue['value'][$i].( isset($this->uservalue['quantity'][$i]) ? ":: \t".$this->uservalue['quantity'][$i] : '');
				$html	.= "\n";
			}
		}
		return $html;
	}

	function getMySQLOutput(){
		$html	= '';
		for($i=0; $i < count($this->uservalue['value']); $i++){
			$html	.= $this->uservalue['value'][$i].( isset($this->uservalue['quantity'][$i]) ? ":: \t".$this->uservalue['quantity'][$i] : '');
		}
		return $html;
	}
}

class ceFieldType_sqlmultiple extends ceFieldType {
	function getInputHTML() {
		$doc	= JFactory::getDocument();
		$doc->addScript( JURI::root(). 'components/com_contactenhanced/assets/js/addtablerow.js' );
		$row	= array();
		if($this->value){
			$fields	= $this->getFields();
		}
		if(count($fields) < 1 AND !$this->params->get('hide_field') AND !$isChainSelect){
			return JText::_($this->params->get('sql_no_result_msg',''));

		}else if($this->params->get('hide_field') ){
			$html	= '';
			$i = 0;
			foreach($fields as $row){
				$html	.= '<input type="hidden" value="'.$row->value.'" name="'.$this->getInputName().'['.$i++.']" />';
			}
			return $html;

		}else if(count($fields) > 0 OR $isChainSelect){
			$html	= '';
			$addButton	='<div>'
			.' <a href="javascript:void(0);" onclick="inject_row(\''.parent::getInputName().'\')">'.JText::_( 'CF_SQL_ADD_ITEM' ).'</a>'
			.' <a href="javascript:void(0);" onclick="remove_row(\''.parent::getInputName().'\')">'.JText::_( 'CF_SQL_REMOVE_ITEM' ).'</a>'
			.'</div>';


			$html	.= '<div id="'.parent::getInputName().'-container">';
			$html .= '<table id="'.parent::getInputName().'_table">'
			. '<tbody id="'.parent::getInputName().'_table_body">';
			if($this->params->get('sql_show_heading',1)){
				$html	.= '<tr>';
				$html	.= $this->getFieldsHeading($fields);
				$html	.= '</tr>';
			}
			$html	.= $this->getFieldsHTML($fields);

			$html	.= '</tbody>'
			. '</table> ';
			$html	.='</div>';
			if($this->params->get('sql_allow_multiple_lines',1)){
				$html	.= $addButton;
			}
			return $html;
		}else if($isChainSelect > 0){ //
		}
	}

	function getFieldsHeading(&$fields){
		$html	= '';
		foreach ($fields as $field) {
			$html	.= '<th class="sectiontableheader">'.$field[0].'</th>';
		}
		$html	.= ($this->params->get('sql_quantity',1) ? '<th class="sectiontableheader">'.JText::_($this->params->get('sql_quantity-show-label','CF_SQL_QUANTITY')).'</th>' : '');
		return $html;
	}

	function getFieldsHTML(&$fields) {

		$html	= '';
		$db		=JFactory::getDBO();

		$javascript	= '';
		if($this->params->get('chain_select') AND $this->params->get('chain_select-enabled-option')){
			$javascript	= "onchange=\"JsonSelect.updateSelect('".$this->params->get('chain_select-enabled-option')."',this,'".JURI::root()."', '".$this->catid."');\"";
			$doc->addScript(JURI::root().'components/com_contactenhanced/assets/js/chainSelectList.js');
		}
		$value	= $this->getValue();

		if(isset($value[0])){
			$rowCount	= count($value[0]);
		}else{
			$rowCount	= 1;
		}
		$k=1;
		$html	.= '<input type="hidden" name="'.parent::getInputName().'_row_count" id="'.parent::getInputName().'_row_count" value="'.($rowCount).'" />';
		for($i=1;$i<=$rowCount;$i++){
			$html	.= '<tr id="'.parent::getInputName().'_tr['.$i.']" class="sectiontableentry'.($k).'">';

			$fieldClass	= ' class="inputbox cf-input-select ce-cf-sqlmultiple'.($this->isRequired() ? ' required' : '').'" ';

			for($j=0; $j < count($fields); $j++){
				$field	= $fields[$j][1];
				$option	= JHTML::_('select.genericlist',   $field, $this->getInputName().'['.$j.'][]', $javascript.' size="1" '.$this->attributes.$fieldClass.' ce-cf-field-row', 'value', 'text', ( isset($value[$j][$i-1]) ? trim($value[$j][$i-1]) : '' ));
				$html	.=	'<td>'.$option.'</td>';
			}

			$fieldClass	= ' class="inputbox cf-input-text ce-cf-sql-quantity'.($this->isRequired() ? ' required' : '').'" ';
			$html	.= ($this->params->get('sql_quantity',1) ? '<td>'
			.'<input type="text" name="'.$this->getInputName().'['.($j).'][]" '.$fieldClass
			. ($this->params->get('sql_quantity-show-validation') ? ' onkeydown="return '.$this->params->get('sql_quantity-show-validation').'(event);" ' : '' )
			. ' value="'.(isset($value[$j][$i-1]) ? trim($value[$j][$i-1]) : '').'" '
			.' /></td>'
			: '')
			;

			$html	.= '</tr>';
			$k	= ($k == 2 ? $k =1 : ++$k);
		}

		return $html;
	}

	function getFieldOptions($rows) {
		if(count($rows) > 0){
			$options	= array();
			$options[]	= JHTML::_('select.option',  '', JText::_($this->params->get('first_option', 'CE_PLEASE_SELECT_ONE')) );
			$fieldClass	= ' class="inputbox cf-input-text ce-cf-sql-quantity'.($this->isRequired() ? ' required' : '').'" ';
			foreach($rows as $row){
				if( substr($row->text,0,2) == '--'){
					$options[]	=	JHTML::_('select.optgroup',  str_replace('--','',JText::_( $row->text ) ) );
				}else{
					$options[]	=	JHTML::_('select.option',  $row->value, JText::_( $row->text ) );
				}
			}
		}
	}

	function getFields() {
		$db		=JFactory::getDBO();
		$user	= JFactory::getUser();
		$fields	= array();
		//Cast to make sure it is an array
		$this->arrayFieldElements	= (array) $this->arrayFieldElements;

		foreach ($this->arrayFieldElements as $fieldElement) {
			$regex = '/{user_id}/i';
			$value  = preg_replace( $regex, $user->id, $fieldElement );

			$regex = '/{user_email}/i';
			$value  = preg_replace( $regex, $user->email, $fieldElement );

			$regex = '/{username}/i';
			$value  = preg_replace( $regex, $user->username, $fieldElement );

			$regex = '/{selectresult}/i';
			$isChainSelect  = preg_match( $regex, $fieldElement );

			if(strpos($fieldElement, '::') > 0){
				$fieldElement = explode('::', $fieldElement);
			}else{
				$fieldElement = array('CF_SQL_ITEM',$fieldElement);
			}

			$db->setQuery( $fieldElement[1] );
			$rows		= $db->loadObjectList();
			$fields[]	= array(JText::_($fieldElement[0]),$rows);
		}
		return $fields;
	}

	public function getSubmittedValue() {
		$html = '';
		$html	.= '<div id="'.parent::getInputName().'-container"> ';
			$html .= '<table id="'.parent::getInputName().'_table" cellpadding="3" cellspacing="4">'
			. '<tbody id="'.parent::getInputName().'_table_body">';
			if($this->params->get('sql_show_heading',1)){
				if($this->value){
					$fields	= $this->getFields();
					$html	.= '<tr>';
					$html	.= $this->getFieldsHeading($fields);
					$html	.= '</tr>';
				}

			}
			for($i=0; $i < count($this->uservalue[0]); $i++){
				$html	.= '<tr id="'.parent::getInputName().'_tr['.$i.']" class="sectiontableentry'.($k).'">';
				for($j=0; $j < count($this->uservalue); $j++){
					$html	.=	'<td>'.$this->uservalue[$j][$i].' </td>';
				}
				$html	.= '</tr>';
				$k	= ($k == 2 ? $k =1 : ++$k);
			}

			$html	.= '</tbody>'
			. '</table> ';
			$html	.='</div>';
		return $html;
	}

	function getEmailOutput($delimiter= ', ',$format='text',$style=array('label'=>'','value'=>'')){
		$html	= '';
		$k		= 1;
		if($format == 'html'){
			$html	.= '<div class="ce-cf-container"> ';
			$html .= '
			<span class="ce-cf-html-label" style="'.$style['label'].'">'.$this->getInputFieldName().'</span> ' ;
			$html .= $this->getSubmittedValue();

			$html	.= '</div>';
		}else{
			$html .= $this->getInputFieldName().": ";
			//if there is more than one value, add a break line between the label and values
			if(count($this->uservalue[0]) > 1){
				$html .= "\n ";
			}
			for($i=0; $i < count($this->uservalue[0]); $i++){
				$fields	= array();
				for($j=0; $j < count($this->uservalue); $j++){
					if(isset($this->uservalue[$j][$i])){
						$fields[]	= $this->uservalue[$j][$i];
					}else
					echo "<br>this->uservalue[$j][$i]<br>";
				}
				$html	.= implode(" ::\t",$fields)."\n";
			}
		}
		return $html;
	}

	function getMySQLOutput(){
		$html	= '';
		for($i=0; $i < count($this->uservalue['value']); $i++){
			$html	.= $this->uservalue['value'][$i].( isset($this->uservalue['quantity'][$i]) ? ":: \t".$this->uservalue['quantity'][$i] : '');
		}
		return $html;
	}

	function getArrayElem(&$array, $key1=null, $key2=null) {
		if (isset($array[$key1][$key2])) {
			;
		}
	}
}
class ceFieldType_wysiwyg extends ceFieldType {
	function getInputHTML() {
		$this->editor = JFactory::getEditor();
		$html = '';
		// parameters : areaname, content, width, height, cols, rows
		$html .= $this->editor->display( $this->getInputName().'' ,  $this->getValue(), '90%', '200', '75', '20', false ) ;
		return $html;
	}
	function getValidationScript() {
		$script	= "\n var ".$this->getInputName().'_editor_text = '.$this->editor->getContent( $this->getInputName().'_editor' );
		//$script	.= "\n alert(".$this->getInputName()."_editor_text);";
		$script	.= "\n".'$("'.$this->getInputName().'").setProperty("value",'.$this->getInputName().'_editor_text);';
		return $script;
	}
}

class ceFieldType_mailchimp extends ceFieldType{
	var $_selectCounter = 0;
	var $mcapi 			= null;
	var $apiKey			= null;
	var $clientID		= null;
	var $list			= null;

	function ceFieldType_mailchimp($data,&$params ) {
		parent::ceFieldType( $data,$params );
		require_once JPATH_ROOT.'/components/com_contactenhanced/helpers/MailChimp.php';

		if (is_string($this->params)) {
			$registry	= new JRegistry();
			$registry->loadString($this->params);
			$this->params = $registry;
		}
		$this->apiKey	= trim($this->params->get('mailchimp_api_key'));
		$this->mclist	= explode(',',$this->params->get('mailchimplist'));

		for ($i = 0; $i < count($this->mclist); $i++) {
			$this->mclist[$i]	= trim($this->mclist[$i]);
			if(strlen($this->mclist[$i]) < 2 ){
				unset($this->mclist[$i]);
			}
		}


		$this->mcapi = new \Drewm\MailChimp($this->apiKey);
	}

	function getInputHTML() {
		$this->_selectCounter = 0;

		$html		= '<div class="cf-mailchimp">';

		if(!$this->apiKey){
			$html	.= '<h1>'.JText::_('CE_CF_MAILCHIMP_ERROR_EMPTY_API_KEY').'</h1>';
		}

		$lists= $this->mcapi->call('lists/list');

		if( $this->getError($lists) ) {
			JError::raiseWarning( 0, "Unable to load lists. ".$this->getError($lists) );
		}elseif(is_array($lists['data'])) {
			foreach ($lists['data'] as $list){
				$this->getOption($html,$list);
			}
		}
		$html		.= '</div>';
		return $html;
	}

	/**
	 * Subscribes the user to the selected lists. Does not show an email output as the name sugests
	 */
	function getEmailOutput($delimiter= ', ',$format='text',$style=array('label'=>'','value'=>'')) {
		$errors = array();
		$this->uservalue	= (array) $this->uservalue;
		if($this->apiKey AND count($this->uservalue) > 0){
			$email	= JRequest::getString( 'email', null,'post');
			$fname	= JRequest::getString( 'name', null,'post');
			$lname	= JRequest::getString( 'surname', null,'post');

			/**
			 * @var array MailChimp Custom Fields
			 */
			$cmcf	= array('fname'=>$fname, 'lname'=>$lname);
			foreach(ceHelper::$submittedfields as $field){
				if(count($field->arrayFieldElements) > 1 AND is_string($field->uservalue) ){
					$cmcf[$field->name]	= explode(', ',$field->uservalue);
				}else{
					$cmcf[$field->name]	= $field->uservalue;
				}

			}

			foreach ($this->uservalue as $listID => $list) {
				$cmcf['GROUPINGS']	= array();
				if(is_array($list)){
					foreach ($list as $groupingId => $group) {
						$cmcf['GROUPINGS'][] =	array('id'=>$groupingId, 'groups'=>implode(',',$group));
					}
					$list = $listID;
				}

				$retval = $this->mcapi->call('lists/subscribe', array(
						'id'                => $list,
					    'email'             => array( 'email' => $email ),
					    'merge_vars'        => $cmcf,
					    'double_optin'      => $this->params->get('mc-doubleOptIn',true),
					    'update_existing'   => $this->params->get('mc-update_existing',true),
					    'replace_interests' => true,
						'send_welcome' 		=> $this->params->get('mc-send_welcome',false),
						'email_type'		=> $this->params->get('mc-emailType','html')
					));
				if($this->getError($retval)){
					JError::raiseWarning( 0,
								"Unable to subscribe user. "
								.$this->getError($retval) );
				}
			}
		}

		return '';
	}

	function getInputName($type=''){
		if($type=='cookie'){
			return parent::getInputName().'_'.$this->_selectCounter;
		}elseif($type=='submission'){
			return parent::getInputName();
		}else{
			return parent::getInputName()."[".($this->_selectCounter)."]";
		}
	}
	function getMySQLOutput(){
		return implode(', ',$this->uservalue);
	}
	function getOption(&$html,$list) {
		//testArray($list);
		$inputType	= $this->params->get('input_type','checkbox');
		if(count($this->mclist) < 1 AND !isset($list['id'])){
			foreach ($list as $value)
			$this->getOption($html,$value);
		}elseif (is_array($list)
					AND (count($this->mclist) < 1 OR ( isset($list['id']) AND in_array($list['id'],$this->mclist)) )
		){

			$cols	= $this->params->get('number_of_columns',1);
			$width	= number_format( (100/$cols), 1);
			$html .= '<div style="width:'.$width.'%;float:left">';

			$groupings	= $this->mcapi->call('lists/interest-groupings',array('id'=>$list['id']));

			if($this->getError($groupings) OR $this->params->get('display_groupings',1) == 0){
				$html .= '<input type="'.$inputType.'" class="cf-input-'.$inputType.$this->getFieldClass().($this->isRequired() ? ' validate-boxes':'').'" '
						.' name="' . parent::getInputName().'['.$list['id'].']'. '" '
								.' value="'.$list['id'].'" '
										.' id="' . $this->getInputId() . '_' . $this->_selectCounter . '" ';
				if( $list['id'] == $this->getValue() OR $this->params->get('input_type-checkbox-allchecked',0)){
					$html .= '  checked="checked"  ';
				}
				$html .= ' '.$this->attributes.' ';
				$html .= '/>';
				$html .= ' <label for="' . $this->getInputId() . '_' . $this->_selectCounter . '">'.JText::_($list['name']).'</label>';

			}else{
				$html .= '<label class="ce-level-1">'.JText::_($list['name']).'</label><br />';
				foreach ($groupings as $grouping) {
					$html .= '<label class="ce-level-2">'.JText::_($grouping['name']).'</label><br />';
					foreach ($grouping as $groups) {
						if(is_array($groups)){
							foreach ($groups as $group) {
								//testArray($group);
								$fieldType	= ($grouping['form_field'] == 'checkboxes' ? 'checkbox' : 'radio');
								$html .= '<input type="'.$fieldType.'" class="ce-level-3 cf-input-checkbox'.$this->getFieldClass().($this->isRequired() ? ' validate-checkbox':'').'" '
										.' name="' . parent::getInputName().'['.$list['id'].']['.$grouping['id'].']['.$this->_selectCounter.']" '
												.' value="'.$group['name'].'" '
														.' id="' . $this->getInputId() . '_' . $this->_selectCounter . '" ';
								if( $group['name'] == $this->getValue() OR ($this->params->get('input_type-checkbox-allchecked',0) AND $fieldType == 'checkbox' )){
									$html .= '  checked="checked"  ';
								}
								$html .= ' '.$this->attributes.' ';
								$html .= '/>';
								$html .= ' <label for="' . $this->getInputId() . '_' . $this->_selectCounter . '">'.JText::_($group['name']).'</label><br />';
								$this->_selectCounter++;
							}
						}

					}
				}
			}
			$html .= '</div>';
			$this->_selectCounter++;
		}

		//return $html;
	}

	function getError($result) {
		if( isset($result->status) && $result->status == 'error' ) {
			return JText::_('JERROR').": ".$result->code."\t -".$result->name."\t -".$result->error."\n";
		}if( isset($result['status']) && $result['status'] == 'error' ) {
			return JText::_('JERROR').": ".$result['code']."\t -".$result['name']."\t -".$result['error']."\n";
		}elseif($result === false){
			//'Uncatchable error'
			return 0;
		}
		return false;
	}

	function getInputId() {
		return parent::getInputName();
	}

	function getLabel($output='site'){

		$html	= '';
		if($this->published
			AND $this->params->get('hide_field_label',0) == 0
			AND $this->params->get('hide_field_label',0) != 'overtext'){
			$label= '<label class="cf-label'.($this->isRequired() ? ' requiredField':'').'" >'
			.JText::_( $this->getInputFieldName() )
			.($this->isRequired() ? ' '.JText::_('CE_FORM_REQUIRED_SIGN') : '')
			.'</label>';
			if($this->tooltip AND $this->params->get('tooltip_behavior','mouseover') == 'mouseover'){
				$html .= '<span class="hasTooltip" title="'. JText::_( $this->tooltip ). '">'
						. $label
						. '</span>';
				JHtml::_('bootstrap.tooltip');
			}elseif($this->tooltip AND $this->params->get('tooltip_behavior','mouseover') == 'inline'){
				$html .= $label;
				$html .= '<div class="ce-tooltip" >'. JText::_( $this->tooltip ). '</div>';
			}else{
				$html .= $label;
			}
		}
		return $html;
	}

}

class ceFieldType_acymailing extends ceFieldType{
	var $_selectCounter = 0;
	var $cm 			= null;
	var $apiKey			= null;
	var $clientID		= null;
	var $list			= null;
	protected static $subscribed = false;

	function ceFieldType_acymailing($data,&$params ) {
		JFactory::getLanguage()->load('com_acymailing');
		parent::ceFieldType( $data,$params );
		
		if(!include_once(rtrim(JPATH_ADMINISTRATOR,DIRECTORY_SEPARATOR).'/components/com_acymailing/helpers/helper.php')){
			JError::raiseWarning( 0, 'The Newsletter AcyMailing <i>Custom Field</i> requires AcyMailing Component in order to work');
			return false;
		};
		
		$listClass = acymailing_get('class.list');

		$this->lists = $listClass->getLists();

		if (is_string($this->params)) {
			$this->params = new JParameter($this->params);
		}
		$this->acylist		= (array)$this->params->get('acylist',array());

	}

	function getInputHTML() {
		$this->_selectCounter = 0;

		$html		= '<div class="cf-newsletter">';

		//testArray($this->lists);
		if (count($this->lists)){
			foreach ($this->lists as $list){
				$this->getOption($html,$list);
			}
		}else{
			return '';
		}
		$html		.= '</div>';
		return $html;
	}

	/**
	 * Subscribes the user to the selected lists. Does not show an email output as the name suggests
	 */
	function getEmailOutput($delimiter= ', ',$format='text',$style=array('label'=>'','value'=>'')) {

		$errors = array();
		$db		= JFactory::getDBO();
		$app 	= JFactory::getApplication();
		$jinput	= $app->input;
		// Array with selected list IDs
		$this->uservalue	= (array) $this->uservalue;

		if(count($this->uservalue) > 0){
			if(self::$subscribed != true){
				self::$subscribed = true;

				$subscriberClass = acymailing_get('class.subscriber');

				$member = new JObject();
				$member->email	= $jinput->post->getString('email',	null);
				$member->name	= $jinput->post->getString('name',	null);
				/**
				 * Save AcyMailing Custom Fields
				 */

				$acyFields	= $db->getTableColumns('#__acymailing_subscriber', false);

				foreach(ceHelper::$submittedfields as $field){
					if(is_object($field) AND isset($field->alias)){
						$acy_cf_name	= str_replace('-', '', $field->alias);
						if(array_key_exists($acy_cf_name, $acyFields)){
							
							if($field->type == 'sql'){
								$member->$acy_cf_name	= str_replace("\n", '', strip_tags($field->getEmailOutput()) );
							}elseif(count($field->arrayFieldElements) > 1 AND is_string($field->uservalue) ){
								$member->$acy_cf_name	= $field->uservalue;
							}elseif(count($field->arrayFieldElements) > 1 AND is_array($field->uservalue) ){
								$member->$acy_cf_name	= implode(', ',$field->uservalue);
							}else{
								$member->$acy_cf_name	= $field->uservalue;
							}
						}
					}
				}

				/**/
				$subid = $subscriberClass->save($member);

				//the user could not be saved for whatever reason
				if(empty($subid)) return '';

				$newSubscription = array();
				if(!empty($this->uservalue)){
					foreach($this->uservalue as $listId){
						$newList = null;
						$newList['status'] = 1;
						$newSubscription[$listId] = $newList;
					}
				}
				//there is nothing to do...
				if(empty($newSubscription)) return '';

				$subscriberClass->saveSubscription($subid,$newSubscription);
			}


			/**
			 * Get List names
			*/
			$db->setQuery('SELECT name FROM #__acymailing_list WHERE listid IN ('.implode(',', $this->uservalue).')');
			$lists				= $db->loadColumn();
			$tempUserValue		= $this->uservalue;
			$this->uservalue	= implode(', ', $lists);
			$html				= parent::getEmailOutput($delimiter, $format ,$style);
			$this->uservalue	= $tempUserValue;

			return $html;
		}


		return '';
	}

	function getInputName($type=''){
		if($type=='cookie'){
			return parent::getInputName().'_'.$this->_selectCounter;
		}elseif($type=='submission'){
			return parent::getInputName();
		}else{
			return parent::getInputName()."[".($this->_selectCounter)."]";
		}
	}
	function getMySQLOutput(){
		return implode(', ',$this->uservalue);
	}
	function getOption(&$html,$list) {
		if((!$this->acylist OR (is_array($this->acylist) AND count($this->acylist)<1) ) AND !isset($list->listid)){
			foreach ($list as $value)
			$this->getOption($html,$value);
		}elseif (is_object($list)
			AND $list->published
			AND (
					!$this->acylist
					OR (isset($list->listid) AND is_array($this->acylist) AND in_array($list->listid, $this->acylist))
				)
		){
			$cols	= $this->params->get('number_of_columns',1);
			$width	= number_format( (100/$cols), 1);
			$html .= '<div style="width:'.$width.'%;float:left">';
			$input = '';
			$input .= '<input type="checkbox" class="cf-input-checkbox'.$this->getFieldClass().($this->isRequired() ? ' validate-checkbox':'').'" '
			.' name="' . $this->getInputName(). '" '
			.' value="'.$list->listid.'" '
			.' id="' . $this->getInputName() . '_' . $this->_selectCounter . '" ';
			if( $list->listid == $this->getValue() OR $this->params->get('acy-all-checked',0)){
				$input .= '  checked="checked"  ';
			}
			$input .= ' '.$this->attributes.' ';
			$input .= '/> '; 
			$html .=  '<label for="' . $this->getInputName() . '_' . $this->_selectCounter . '" 
					class="hastip" 
					title="'.JText::_('SUBSCRIBECAPTION').': '.JText::_($list->name).'">'
						.$input.' '
						.JText::_($list->name)
					.'</label>';
			if($this->params->get('acy-description')){
				$html .= '<br />'.$list->description;
			}
			$html .= '</div>';
			$this->_selectCounter++;
		}
	}

}

class ceFieldType_css extends ceFieldType {
	function getInputHTML() {
		return '';
	}
	function getValue($arg=null) {
		return $this->value;
	}
	function getFieldHTML() {
		$doc = JFactory::getDocument();
		$value = trim($this->getValue());
		if(substr($value, -4) == '.css' AND $this->isValidUrl($value)){
				$doc->addStyleSheet($value); // is a valid js file
		}elseif(substr($value, -4) == '.css' ){
				$doc->addStyleSheet(JURI::root().$value); // is a valid js file
		}elseif(trim($this->getValue())){
			$doc->addStyleDeclaration($this->getValue());
		}
	}
	function getLabel($output='site') {
		return '';
	}
	function getEmailOutput($delimiter= ', ',$format='text',$style=array('label'=>'','value'=>'')) {
		return '';
	}
}


class ceFieldType_js extends ceFieldType {
	function getInputHTML() {
		return '';
	}
	function getValue($arg=null) {
		return $this->value;
	}
	function getFieldHTML() {
		$value = trim($this->getValue());
		if($value){
			$doc = JFactory::getDocument();
			if(substr($value, -3) == '.js' AND $this->isValidUrl($value)){
				$doc->addScript($value); // is a valid js file
			}elseif(substr($value, -3) == '.js'){
				$doc->addScript(JURI::root().$value); // is a valid js file
			}elseif($this->params->get('position',1)){
				$doc->addScriptDeclaration($value);
			}else{
				return '<script type="text/javascript">/* <![CDATA[ */
				'.$value.'
/* ]]> */</script>';
			}
		}
	}

	function getLabel($output='site') {
		return '';
	}
	function getEmailOutput($delimiter= ', ',$format='text',$style=array('label'=>'','value'=>'')) {
		return '';
	}
}


class ceFieldType_php extends ceFieldType {
	function getInputHTML() {
		$html		= '';

		require_once (JPATH_ROOT.'/components/com_contactenhanced/helpers/safereval.class.php');

		$sEval = new SaferEval();
		$sEval->set('customfield',$this);
		if(($sEval->checkScript($this->getValue(), false) !== false)){
			return $sEval->checkScript($this->getValue(), true);
		}else{
			echo $sEval->htmlErrors(); exit;
		}
		//return self::safe_eval($this->getValue());
	}
	function getValue($arg=null) {
		return $this->value;
	}

}

class ceFieldType_pagination extends ceFieldType {
	function ceFieldType_pagination($data, &$params) {
		// Call parent constructor
		parent::ceFieldType($data, $params);
		require_once (JPATH_ROOT.'/components/com_contactenhanced/helpers/steps.php');
	}

	function getInputHTML() {
		return CEHtmlSteps::step($this->name, 'ceStep'.$this->id, 'ceStepGroup_'.$this->params->get('contactId'));
	}
	function getFieldHTML() {
		if(!class_exists('iBrowser')){
			require_once(JPATH_ROOT.'/components/com_contactenhanced/helpers/browser.php');
		}
		$browser = new iBrowser();
		if($browser->getBrowser() == 'Android' AND version_compare($browser->getVersion(), '2.3.3') <= 0){
			return '';
		}else{
			return $this->getInputHTML();
		}
	}

	function getEmailOutput($delimiter= ', ',$format='text',$style=array('label'=>'','value'=>'')) {
		return '';
	}

	function getLabel($output='site') {
		return '';
	}

	public function start($group = 'steps')
	{
		return CEHtmlSteps::start($group, $this->params);
	}
	public function end()
	{
		return CEHtmlSteps::end();
	}

	public function step($text, $id, $group = 'steps')
	{
		return CEHtmlSteps::step($text, $id, $group);
	}
	public function buttons($group = 'steps')
	{
		return CEHtmlSteps::buttons($group,  $this->params);
	}
	public function status($group = 'steps',$numberSteps)
	{
		return CEHtmlSteps::status($group, $numberSteps, $this->params);
	}
}

class ceFieldType_button extends ceFieldType {
	function ceFieldType_button($data,&$params ) {
		parent::ceFieldType( $data,$params );
		// If button is loaded
		if(is_null($data) ){
			$this->name		= JText::_('CE_FORM_SEND');
			$this->id		= 'ce-submit-button';
			$this->type		= 'button';
			$this->required	= false;
			$this->published= true;
		}
	}
	function getLabel($output='site') {
		return '';
	}
	function getInputHTML() {
		$html	= '';
		$html	.='<span>';

		$classSubmit	= 'button btn btn-primary ce-button-'.$this->params->get('buttonType','submit').' '.$this->attr->get('class');
		$classReset		= 'button btn btn-default  ce-button-reset'.' '.$this->attr->get('class');
		$this->attr->set('class','');
		$attributes = '';
		foreach ($this->attr as $key => $value) {
			$attributes .= ($value ? $key.'="'.$value.'" ' : '');
		}
		$html	.='
					<button type="'.$this->params->get('buttonType','submit').'"
							class="'.$classSubmit.'"
							id="'.$this->getInputId().'"
					'.$attributes.' >'
					//	.'<i class="icon-arrow-right glyphicon glyphicon-arrow-right"> </i> '
						.$this->getName()
					.'</button> '
					.'</span>'
					;
		if($this->params->get('buttonType-submit-reset',true) AND $this->params->get('buttonType','submit') == 'submit'){
			$html	.='<span >';
			$html	.=' <button type="reset" class="'.$classReset.'"  id="'.$this->getInputId().'_reset" >'
						.JText::_('CE_FORM_RESET')
					.'</button>'
					.'</span>'
					;
		}
		JFactory::getDocument()->addScriptDeclaration("
jQuery(document).ready(function($){
	$('.ce-button-reset').on('click', function(e){
		e.preventDefault();
		$('.ce-cf-container .inputbox').val('')
		$(':checkbox, :radio').prop('checked', false);
	});
});
");
		return $html;
	}
}