<?php
namespace Drewm;
/**
* Super-simple, minimum abstraction MailChimp API v2 wrapper
*
* Uses curl if available, falls back to file_get_contents and HTTP stream.
* This probably has more comments than code.
*
* Contributors:
* Michael Minor <me@pixelbacon.com>
* Lorna Jane Mitchell, github.com/lornajane
*
* @author Drew McLellan <drew.mclellan@gmail.com>
* @version 1.1.1
*/
class MailChimp
{
    private $api_key;
    private $api_endpoint = 'https://<dc>.api.mailchimp.com/2.0';
    private $verify_ssl = false;
    function __construct($api_key)
    {
        $this->api_key = $api_key;
        list(, $datacentre) = explode('-', $this->api_key);
        $this->api_endpoint = str_replace('<dc>', $datacentre, $this->api_endpoint);
    }
    public function call($method, $args=array())
    {
        return $this->makeRequest($method, $args);
    }
    private function makeRequest($method, $args=array())
    {
        $args['apikey'] = $this->api_key;

        $url = $this->api_endpoint.'/'.$method.'.json';

        if (function_exists('curl_init') && function_exists('curl_setopt')){
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
            curl_setopt($ch, CURLOPT_USERAGENT, 'PHP-MCAPI/2.0');
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_TIMEOUT, 10);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, $this->verify_ssl);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($args));
            $result = curl_exec($ch);
            curl_close($ch);
        }else{
            $json_data = json_encode($args);
            $result = file_get_contents($url, null, stream_context_create(array(
                'http' => array(
                    'protocol_version' => 1.1,
                    'user_agent' => 'PHP-MCAPI/2.0',
                    'method' => 'POST',
                    'header' => "Content-type: application/json\r\n".
                                          "Connection: close\r\n" .
                                          "Content-length: " . strlen($json_data) . "\r\n",
                    'content' => $json_data,
                ),
            )));
        }
        return $result ? json_decode($result, true) : false;
    }
}