<?php
/** Class to access a campaigns resources from the create send API.
 * This class includes functions to create and send campaigns,
 * along with accessing lists of campaign specific resources i.e reporting statistics
 * @author tobyb
 *
*/
require_once dirname(__FILE__).'/class/base_classes.php';
class CS_REST_Campaigns extends CS_REST_Wrapper_Base {
var $_campaigns_base_route;
function CS_REST_Campaigns (
$campaign_id,
$auth_details,
$protocol = 'https',
$debug_level = CS_REST_LOG_NONE,
$host = 'api.createsend.com',
$log = NULL,
$serialiser = NULL,
$transport = NULL){
$this->CS_REST_Wrapper_Base($auth_details, $protocol, $debug_level, $host, $log, $serialiser, $transport);
$this->set_campaign_id($campaign_id);
}
function set_campaign_id($campaign_id){
$this->_campaigns_base_route = $this->_base_route.'campaigns/'.$campaign_id.'/';
}
function create($client_id, $campaign_info){
return $this->post_request($this->_base_route.'campaigns/'.$client_id.'.json', $campaign_info);
}
function create_from_template($client_id, $campaign_info){
return $this->post_request($this->_base_route.'campaigns/'.$client_id.'/fromtemplate.json', $campaign_info);
}
function send_preview($recipients, $personalize = 'Random') { 
$preview_data = array(
'PreviewRecipients' => $recipients,
'Personalize' => $personalize
);
return $this->post_request($this->_campaigns_base_route.'sendpreview.json', $preview_data);
}
function send($schedule){
return $this->post_request($this->_campaigns_base_route.'send.json', $schedule);
}
function unschedule(){
return $this->post_request($this->_campaigns_base_route.'unschedule.json', NULL);
}
function delete(){
return $this->delete_request(trim($this->_campaigns_base_route, '/').'.json');
}
function get_recipients($page_number = NULL, $page_size = NULL, $order_field = NULL, 
$order_direction = NULL) { 
return $this->get_request_paged($this->_campaigns_base_route.'recipients.json', $page_number, 
$page_size, $order_field, $order_direction, '?');
}
function get_bounces($since = '', $page_number = NULL, $page_size = NULL, $order_field = NULL, 
$order_direction = NULL){
return $this->get_request_paged($this->_campaigns_base_route.'bounces.json?date='.urlencode($since),
$page_number, $page_size, $order_field, $order_direction);
}
function get_lists_and_segments(){
return $this->get_request($this->_campaigns_base_route.'listsandsegments.json');
}
function get_summary(){
return $this->get_request($this->_campaigns_base_route.'summary.json');
}
function get_email_client_usage(){
return $this->get_request($this->_campaigns_base_route.'emailclientusage.json');
}
function get_opens($since = '', $page_number = NULL, $page_size = NULL, $order_field = NULL, 
$order_direction = NULL){
return $this->get_request_paged($this->_campaigns_base_route.'opens.json?date='.urlencode($since), 
$page_number, $page_size, $order_field, $order_direction);
}
function get_clicks($since = '', $page_number = NULL, $page_size = NULL, $order_field = NULL, 
$order_direction = NULL){
return $this->get_request_paged($this->_campaigns_base_route.'clicks.json?date='.urlencode($since), 
$page_number, $page_size, $order_field, $order_direction);
}
function get_unsubscribes($since = '', $page_number = NULL, $page_size = NULL, $order_field = NULL, 
$order_direction = NULL){
return $this->get_request_paged($this->_campaigns_base_route.'unsubscribes.json?date='.urlencode($since), 
$page_number, $page_size, $order_field, $order_direction);
}
function get_spam($since = '', $page_number = NULL, $page_size = NULL, $order_field = NULL, 
$order_direction = NULL){
return $this->get_request_paged($this->_campaigns_base_route.'spam.json?date='.urlencode($since), 
$page_number, $page_size, $order_field, $order_direction);
}
}
