<?php
/** Class to access general resources from the create send API.
 * @author tobyb
 *
*/
require_once dirname(__FILE__).'/class/base_classes.php';
class CS_REST_General extends CS_REST_Wrapper_Base {
public static function authorize_url(
$client_id, $redirect_uri, $scope, $state = NULL){
$qs = "client_id=".urlencode($client_id);
$qs .= "&redirect_uri=".urlencode($redirect_uri);
$qs .= "&scope=".urlencode($scope);
if($state){
$qs .= "&state=".urlencode($state);
}
return CS_OAUTH_BASE_URI.'?'.$qs;
}
public static function exchange_token(
$client_id, $client_secret, $redirect_uri, $code){
$body = "grant_type=authorization_code";
$body .= "&client_id=".urlencode($client_id);
$body .= "&client_secret=".urlencode($client_secret);
$body .= "&redirect_uri=".urlencode($redirect_uri);
$body .= "&code=".urlencode($code);
$options = array('contentType' => 'application/x-www-form-urlencoded');
$wrap = new CS_REST_Wrapper_Base(
NULL, 'https', CS_REST_LOG_NONE, CS_HOST, NULL,
new CS_REST_DoNothingSerialiser(), NULL);
return $wrap->post_request(CS_OAUTH_TOKEN_URI, $body, $options);
}
function CS_REST_Wrapper_Base(
$auth_details,
$protocol = 'https',
$debug_level = CS_REST_LOG_NONE,
$host = 'api.createsend.com',
$log = NULL,
$serialiser = NULL,
$transport = NULL){
$this->CS_REST_Wrapper_Base($auth_details, $protocol, $debug_level, $host, $log, $serialiser, $transport); 
}
function get_timezones(){
return $this->get_request($this->_base_route.'timezones.json');
}
function get_systemdate(){
return $this->get_request($this->_base_route.'systemdate.json');
}
function get_countries(){
return $this->get_request($this->_base_route.'countries.json');
}
function get_apikey($username, $password, $site_url){
return $this->get_request($this->_base_route.'apikey.json?siteurl='.$site_url,
array('authdetails' => array('username' => $username, 'password' => $password))
);
}
function get_clients(){
return $this->get_request($this->_base_route.'clients.json');
}
function get_billing_details(){
return $this->get_request($this->_base_route.'billingdetails.json');
}
function get_administrators(){
return $this->get_request($this->_base_route.'admins.json');
}
function get_primary_contact(){
return $this->get_request($this->_base_route.'primarycontact.json');
}
function set_primary_contact($emailAddress){
return $this->put_request($this->_base_route.'primarycontact.json?email=' . urlencode($emailAddress), '');
}
function external_session_url($session_options){
return $this->put_request($this->_base_route.'externalsession.json', $session_options);
}
}
