<?php
/** Class to access a lists resources from the create send API.
 * This class includes functions to create lists and custom fields,
 * along with accessing the subscribers of a specific list
 * @author tobyb
 *
*/
require_once dirname(__FILE__).'/class/base_classes.php';
define('CS_REST_CUSTOM_FIELD_TYPE_TEXT', 'Text');
define('CS_REST_CUSTOM_FIELD_TYPE_NUMBER', 'Number');
define('CS_REST_CUSTOM_FIELD_TYPE_MULTI_SELECTONE', 'MultiSelectOne');
define('CS_REST_CUSTOM_FIELD_TYPE_MULTI_SELECTMANY', 'MultiSelectMany');
define('CS_REST_CUSTOM_FIELD_TYPE_DATE', 'Date');
define('CS_REST_CUSTOM_FIELD_TYPE_COUNTRY', 'Country');
define('CS_REST_CUSTOM_FIELD_TYPE_USSTATE', 'USState');
define('CS_REST_LIST_WEBHOOK_SUBSCRIBE', 'Subscribe');
define('CS_REST_LIST_WEBHOOK_DEACTIVATE', 'Deactivate');
define('CS_REST_LIST_WEBHOOK_UPDATE', 'Update');
define('CS_REST_LIST_UNSUBSCRIBE_SETTING_ALL_CLIENT_LISTS', 'AllClientLists');
define('CS_REST_LIST_UNSUBSCRIBE_SETTING_ONLY_THIS_LIST', 'OnlyThisList');
class CS_REST_Lists extends CS_REST_Wrapper_Base {
var $_lists_base_route;
function CS_REST_Lists (
$list_id,
$auth_details,
$protocol = 'https',
$debug_level = CS_REST_LOG_NONE,
$host = 'api.createsend.com',
$log = NULL,
$serialiser = NULL,
$transport = NULL){
$this->CS_REST_Wrapper_Base($auth_details, $protocol, $debug_level, $host, $log, $serialiser, $transport);
$this->set_list_id($list_id);
}
function set_list_id($list_id){
$this->_lists_base_route = $this->_base_route.'lists/'.$list_id.'/';
}
function create($client_id, $list_details){
return $this->post_request($this->_base_route.'lists/'.$client_id.'.json', $list_details);
}
function update($list_details){
return $this->put_request(trim($this->_lists_base_route, '/').'.json', $list_details);
}
function create_custom_field($custom_field_details){
return $this->post_request($this->_lists_base_route.'customfields.json', $custom_field_details);
}
function update_custom_field($key, $custom_field_details){
return $this->put_request($this->_lists_base_route.'customfields/'.rawurlencode($key).'.json',
$custom_field_details);
}
function update_field_options($key, $new_options, $keep_existing){
$options = array(
'KeepExistingOptions' => $keep_existing,
'Options' => $new_options
);
return $this->put_request($this->_lists_base_route.'customfields/'.rawurlencode($key).'/options.json', 
$options);
}
function delete(){
return $this->delete_request(trim($this->_lists_base_route, '/').'.json');
}
function delete_custom_field($key){
return $this->delete_request($this->_lists_base_route.'customfields/'.rawurlencode($key).'.json');
}
function get_custom_fields(){
return $this->get_request($this->_lists_base_route.'customfields.json');
}
function get_segments(){
return $this->get_request($this->_lists_base_route.'segments.json');
}
function get_active_subscribers($added_since = '', $page_number = NULL, 
$page_size = NULL, $order_field = NULL, $order_direction = NULL){
return $this->get_request_paged($this->_lists_base_route.'active.json?date='.urlencode($added_since), 
$page_number, $page_size, $order_field, $order_direction);
}
function get_unconfirmed_subscribers($added_since = '', $page_number = NULL, 
$page_size = NULL, $order_field = NULL, $order_direction = NULL){
return $this->get_request_paged($this->_lists_base_route.'unconfirmed.json?date='.urlencode($added_since), 
$page_number, $page_size, $order_field, $order_direction);
}
function get_bounced_subscribers($bounced_since = '', $page_number = NULL, 
$page_size = NULL, $order_field = NULL, $order_direction = NULL){
return $this->get_request_paged($this->_lists_base_route.'bounced.json?date='.urlencode($bounced_since), 
$page_number, $page_size, $order_field, $order_direction);
}
function get_unsubscribed_subscribers($unsubscribed_since = '', $page_number = NULL, 
$page_size = NULL, $order_field = NULL, $order_direction = NULL){
return $this->get_request_paged($this->_lists_base_route.'unsubscribed.json?date='.urlencode($unsubscribed_since), 
$page_number, $page_size, $order_field, $order_direction);
}
function get_deleted_subscribers($deleted_since = '', $page_number = NULL, 
$page_size = NULL, $order_field = NULL, $order_direction = NULL){
return $this->get_request_paged($this->_lists_base_route.'deleted.json?date='.urlencode($deleted_since), 
$page_number, $page_size, $order_field, $order_direction);
}
function get(){
return $this->get_request(trim($this->_lists_base_route, '/').'.json');
}
function get_stats(){
return $this->get_request($this->_lists_base_route.'stats.json');
}
function get_webhooks(){
return $this->get_request($this->_lists_base_route.'webhooks.json');
}
function create_webhook($webhook){
return $this->post_request($this->_lists_base_route.'webhooks.json', $webhook); 
}
function test_webhook($webhook_id){
return $this->get_request($this->_lists_base_route.'webhooks/'.$webhook_id.'/test.json');
} 
function delete_webhook($webhook_id){
return $this->delete_request($this->_lists_base_route.'webhooks/'.$webhook_id.'.json');
}
function activate_webhook($webhook_id){
return $this->put_request($this->_lists_base_route.'webhooks/'.$webhook_id.'/activate.json', '');
}
function deactivate_webhook($webhook_id){
return $this->put_request($this->_lists_base_route.'webhooks/'.$webhook_id.'/deactivate.json', '');
}
}