<?php
/**
 * @package	 com_contactenhanced
 * @author	 Douglas Machado {@link http://idealextensions.com}
 * @author	 Created on 28-Jul-09
 * @license		GNU/GPL, see license.txt
 */

defined( '_JEXEC' ) or die( 'Restricted access' );
require_once JPATH_ROOT.'/components/com_contactenhanced/helpers/helper.php';

/**
 *
 * helper class.
 *
 */
class ceModalHelper extends JObject {
	
	/**
	 * To be called onAfterRender 
	 * @param string 	$selector
	 * @param array 	$params
	 * @return string	HTML
	 */
	public static function jQueryDialog($selector = 'modal', $params = array())
	{
		$html = "\n";
		$html .= '<div id="'.$selector.'" title="'.$params['title'].'">';
		$html .= "<iframe ></iframe>";
		$html .= "</div>";
			
		$html .= "\n<script>";
		$html .= "
jQuery(document).ready(function($){
	$('#{$selector}').dialog({
		autoOpen: false,
		modal: true,
		height: {$params['height']},
		width: '{$params['width']}',
		maxwidth: {$params['width']},
		open: function(e,ui){
			$('#{$selector} iframe').attr('src','{$params['url']}');

			if($(window).width() < {$params['width']}){
				$('#{$selector}' ).dialog('option', 'width', $(window).width() );
			}else if($(window).width() > {$params['width']}){
				$('#{$selector}' ).dialog('option', 'width', {$params['width']} );
			}
			if($(window).height() < {$params['height']}){
				$('#{$selector}' ).dialog('option', 'height', $(window).height() );
			}else if($(window).height() > {$params['height']}){
				$('#{$selector}' ).dialog('option', 'height', {$params['height']} );
			}
		}
	});
	
	$('#{$selector}-button').click(function(){
		$('#{$selector}').dialog('open');
	});
});
	";
	$html .= "</script>";
	$html .= "<style>";
		$html .= "#{$selector} iframe{border:0 none;height:97%;width:100%}";
		$html .= "#{$selector}{padding:5px 0 0 9px;}";
		$html .= "</style>";
		return $html;
	}
	
	/**
	 * To be called onAfterDispatch
	 * @param JRegistry $params Plugin parameters
	 * @param string $selector
	 */
	public static function loadJS($params,$selector = 'modal'){
		if($params->get('modal',1) == 1){
			JHtml::_('jquery.framework');
			JHtml::_('bootstrap.framework');
			JHtml::_('bootstrap.loadCss');
		}elseif($params->get('modal') == 'jQueryDialog'){
			ceHelper::loadJqueryUI();
		}
		$js = '';
		// Bootstrap V2
		if($params->get('modal',1) == 1){ 
			$doc = JFactory::getDocument();
			$doc->addStyleDeclaration("#{$selector} .modal-body{overflow-y:hidden;padding:3px}#{$selector} iframe{border:0;max-height:400px}");
			$js		.= "\n\t jQuery('#{$selector}-button').on('click',function(e){e.preventDefault();jQuery('#{$selector}').modal('show');});\n";
			$doc->addScriptDeclaration("\n jQuery(document).ready(function($){
			{$js} \n });
			");
		}
	}
	
	public static function checkLoadPermissions($params, $allowOnRaw = false){
		// Checks if allowed to display in Mobile devices
		if(!class_exists('iBrowser')){
			if(is_file(JPATH_ROOT.'/components/com_contactenhanced/helpers/browser.php')){
				require_once(JPATH_ROOT.'/components/com_contactenhanced/helpers/browser.php');
			}else{
				return false; // Contact Enhanced is not installed;
			}
		}
		if(!is_file(JPATH_ROOT.'/components/com_contactenhanced/controller.php')){
			return false; // Contact Enhanced is not installed;
		}
		if (!$params->get('loadonmobile',0)) {
			$browser = new iBrowser();
			if($browser->isMobile() ){
				return false;
			}
		}
		$app = JFactory::getApplication();
		if(	$app->isAdmin()
				OR ($allowOnRaw == false AND (JRequest::getVar('tmpl') == 'component' OR JRequest::getVar('tmpl') == 'raw'))
				
				OR (
						is_array($params->get('avoid_menuitems',array())) AND
						in_array(JRequest::getInt( 'Itemid'),$params->get('avoid_menuitems',array()))
				)
				OR (
						is_array($params->get('avoid_components')) AND
						in_array(JRequest::getVar('option'),$params->get('avoid_components',array()))
				)
				OR (
						is_string($params->get('avoid_components')) AND
						strlen($params->get('avoid_components')) > 4 AND
						JRequest::getCmd('option') ==$params->get('avoid_components')
				)
	
				OR (
						is_string($params->get('avoid_menuitems')) AND
						strlen($params->get('avoid_menuitems')) > 0 AND
						JRequest::getInt( 'Itemid') == $params->get('avoid_menuitems')
				)
		){
			return false;
		}
	
		if($params->get('media') == 'ce' AND !$params->get('media-ce-id')){
			return false;
		}
		return true;
	}
}
