<?php
/** Represents a single Contact in Constant Contact
 *
 * @package		Components
 * @subpackage	 Contacts
 * @author		 Constant Contact
*/
namespace Ctct\Components\Contacts;
use Ctct\Components\Component;
use Ctct\Util\Config;
class Contact extends Component
{
public $id;
public $status;
public $first_name;
public $middle_name;
public $last_name;
public $confirmed;
public $source;
public $email_addresses = array();
public $prefix_name;
public $job_title;
public $addresses = array();
public $notes = array();
public $company_name;
public $home_phone;
public $work_phone;
public $cell_phone;
public $fax;
public $custom_fields = array();
public $lists = array();
public $source_details;
public static function create(array $props)
{
$contact = new Contact();
$contact->id = parent::getValue($props, "id");
$contact->status = parent::getValue($props, "status");
$contact->first_name = parent::getValue($props, "first_name");
$contact->middle_name = parent::getValue($props, "middle_name");
$contact->last_name = parent::getValue($props, "last_name");
$contact->confirmed = parent::getValue($props, "confirmed");
$contact->source = parent::getValue($props, "source");
foreach ($props['email_addresses'] as $email_address){
$contact->email_addresses[] = EmailAddress::create($email_address);
}
$contact->prefix_name = parent::getValue($props, "prefix_name");
$contact->job_title = parent::getValue($props, "job_title");
foreach ($props['addresses'] as $address){
$contact->addresses[] = Address::create($address);
}
foreach ($props['notes'] as $note){
$contact->notes[] = Note::create($note);
}
$contact->company_name = parent::getValue($props, "company_name");
$contact->home_phone = parent::getValue($props, "home_phone");
$contact->work_phone = parent::getValue($props, "work_phone");
$contact->cell_phone = parent::getValue($props, "cell_phone");
$contact->fax = parent::getValue($props, "fax");
foreach ($props['custom_fields'] as $custom_field){
$contact->custom_fields[] = CustomField::create($custom_field);
}
foreach ($props['lists'] as $contact_list){
$contact->lists[] = ContactList::create($contact_list);
}
$contact->source_details = parent::getValue($props, "source_details");
return $contact;
}
public function addList($contactList)
{
if (!$contactList instanceof ContactList){
$contactList = new ContactList($contactList);
}
$this->lists[] = $contactList;
}
public function addEmail($emailAddress)
{
if (!$emailAddress instanceof EmailAddress){
$emailAddress = new EmailAddress($emailAddress);
}
$this->email_addresses[] = $emailAddress;
}
public function addCustomField(CustomField $customField)
{
$this->custom_fields[] = $customField;
}
public function addAddress(Address $address)
{
$this->addresses[] = $address;
}
public function toJson()
{
unset($this->last_update_date);
return json_encode($this);
}
}
