<?php
/** Exposes all implemented Constant Contact API functionality
 *
 * @package Ctct
 * @version 1.1.0
 * @author Constant Contact
 * @link https://developer.constantcontact.com
*/
namespace Ctct;
use Ctct\Services\AccountService;
use Ctct\Services\ContactService;
use Ctct\Services\ListService;
use Ctct\Services\EmailMarketingService;
use Ctct\Services\CampaignScheduleService;
use Ctct\Services\CampaignTrackingService;
use Ctct\Services\ContactTrackingService;
use Ctct\Services\ActivityService;
use Ctct\Components\ResultSet;
use Ctct\Components\Activities\Activity;
use Ctct\Components\Contacts\Contact;
use Ctct\Components\Contacts\ContactList;
use Ctct\Components\EmailMarketing\Campaign;
use Ctct\Components\EmailMarketing\Schedule;
use Ctct\Components\EmailMarketing\TestSend;
use Ctct\Components\Tracking\TrackingSummary;
use Ctct\Components\Activities\AddContacts;
use Ctct\Components\Activities\ExportContacts;
use Ctct\Exceptions\IllegalArgumentException;
use Ctct\Util\Config;
class ConstantContact
{
private $apiKey;
protected $contactService;
protected $emailMarketingService;
protected $listService;
protected $activityService;
protected $campaignTrackingService;
protected $contactTrackingService;
protected $campaignScheduleService;
protected $accountService;
public function __construct($apiKey)
{
$this->apiKey = $apiKey;
$this->contactService = new ContactService($apiKey);
$this->emailMarketingService = new EmailMarketingService($apiKey);
$this->activityService = new ActivityService($apiKey);
$this->campaignTrackingService = new CampaignTrackingService($apiKey);
$this->contactTrackingService = new ContactTrackingService($apiKey);
$this->campaignScheduleService = new CampaignScheduleService($apiKey);
$this->listService = new ListService($apiKey);
$this->accountService = new AccountService($apiKey);
}
public function getContacts($accessToken, array $params = array())
{
return $this->contactService->getContacts($accessToken, $params);
}
public function getContact($accessToken, $contactId)
{
return $this->contactService->getContact($accessToken, $contactId);
}
public function getContactByEmail($accessToken, $email)
{
return $this->contactService->getContacts($accessToken, array('email' => $email));
}
public function addContact($accessToken, Contact $contact, $actionByVisitor = false)
{
$params = array();
if($actionByVisitor == true){
$params['action_by'] = "ACTION_BY_VISITOR";
}
return $this->contactService->addContact($accessToken, $contact, $params);
}
public function deleteContact($accessToken, $contact)
{
$contactId = $this->getArgumentId($contact, 'Contact');
return $this->contactService->deleteContact($accessToken, $contactId);
}
public function deleteContactFromLists($accessToken, $contact)
{
$contactId = $this->getArgumentId($contact, 'Contact');
return $this->contactService->deleteContactFromLists($accessToken, $contactId);
}
public function deleteContactFromList($accessToken, $contact, $list)
{
$contactId = $this->getArgumentId($contact, 'Contact');
$listId = $this->getArgumentId($list, 'ContactList');
return $this->contactService->deleteContactFromList($accessToken, $contactId, $listId);
}
public function updateContact($accessToken, Contact $contact, $actionByVisitor = false)
{
$params = array();
if($actionByVisitor == true){
$params['action_by'] = "ACTION_BY_VISITOR";
}
return $this->contactService->updateContact($accessToken, $contact, $params);
}
public function getLists($accessToken, array $params = array())
{
return $this->listService->getLists($accessToken, $params);
}
public function getList($accessToken, $listId)
{
return $this->listService->getList($accessToken, $listId);
}
public function addList($accessToken, ContactList $list)
{
return $this->listService->addList($accessToken, $list);
}
public function updateList($accessToken, ContactList $list)
{
return $this->listService->updateList($accessToken, $list);
}
public function getContactsFromList($accessToken, $list, $param = null)
{
$listId = $this->getArgumentId($list, 'ContactList');
$param = $this->determineParam($param);
return $this->listService->getContactsFromList($accessToken, $listId, $param);
}
public function getEmailCampaigns($accessToken, array $params = array())
{
return $this->emailMarketingService->getCampaigns($accessToken, $params);
}
public function getEmailCampaign($accessToken, $campaignId)
{
return $this->emailMarketingService->getCampaign($accessToken, $campaignId);
}
public function deleteEmailCampaign($accessToken, $campaign)
{
$campaignId = $this->getArgumentId($campaign, 'Campaign');
return $this->emailMarketingService->deleteCampaign($accessToken, $campaignId);
}
public function addEmailCampaign($accessToken, Campaign $campaign)
{
return $this->emailMarketingService->addCampaign($accessToken, $campaign);
}
public function updateEmailCampaign($accessToken, Campaign $campaign)
{
return $this->emailMarketingService->updateCampaign($accessToken, $campaign);
}
public function addEmailCampaignSchedule($accessToken, $campaign, Schedule $schedule)
{
$campaignId = $this->getArgumentId($campaign, 'Campaign');
return $this->campaignScheduleService->addSchedule($accessToken, $campaignId, $schedule);
}
public function getEmailCampaignSchedules($accessToken, $campaign)
{
$campaignId = $this->getArgumentId($campaign, 'Campaign');
return $this->campaignScheduleService->getSchedules($accessToken, $campaignId);
}
public function getEmailCampaignSchedule($accessToken, $campaign, $schedule)
{
$campaignId = $this->getArgumentId($campaign, 'Campaign');
$scheduleId = null;
if($schedule instanceof Schedule){
$scheduleId = $schedule->id;
} elseif (is_numeric($schedule)){
$scheduleId = $schedule;
}else{
throw new IllegalArgumentException(sprintf(Config::get('errors.id_or_object'), 'Schedule'));
}
return $this->campaignScheduleService->getSchedule($accessToken, $campaignId, $scheduleId);
}
public function updateEmailCampaignSchedule($accessToken, $campaign, Schedule $schedule)
{
$campaignId = $this->getArgumentId($campaign, 'Campaign');
return $this->campaignScheduleService->updateSchedule($accessToken, $campaignId, $schedule);
}
public function deleteEmailCampaignSchedule($accessToken, $campaign, $schedule)
{
$campaignId = $this->getArgumentId($campaign, 'Campaign');
$scheduleId = null;
if($schedule instanceof Schedule){
$scheduleId = $schedule->id;
} elseif (is_numeric($schedule)){
$scheduleId = $schedule;
}else{
throw new IllegalArgumentException(sprintf(Config::get('errors.id_or_object'), 'Schedule'));
}
return $this->campaignScheduleService->deleteSchedule($accessToken, $campaignId, $scheduleId);
}
public function sendEmailCampaignTest($accessToken, $campaign, TestSend $testSend)
{
$campaignId = $this->getArgumentId($campaign, 'Campaign');
return $this->campaignScheduleService->sendTest($accessToken, $campaignId, $testSend);
}
public function getEmailCampaignSends($accessToken, $campaign, array $params = array())
{
$campaignId = $this->getArgumentId($campaign, 'Campaign');
return $this->campaignTrackingService->getSends($accessToken, $campaignId, $params);
}
public function getEmailCampaignBounces($accessToken, $campaign, array $params = array())
{
$campaignId = $this->getArgumentId($campaign, 'Campaign');
return $this->campaignTrackingService->getBounces($accessToken, $campaignId, $params);
}
public function getEmailCampaignClicks($accessToken, $campaign, array $params = array())
{
$campaignId = $this->getArgumentId($campaign, 'Campaign');
return $this->campaignTrackingService->getClicks($accessToken, $campaignId, $params);
}
public function getEmailCampaignOpens($accessToken, $campaign, array $params = array())
{
$campaignId = $this->getArgumentId($campaign, 'Campaign');
return $this->campaignTrackingService->getOpens($accessToken, $campaignId, $params);
}
public function getEmailCampaignForwards($accessToken, $campaign, array $params = array())
{
$campaignId = $this->getArgumentId($campaign, 'Campaign');
return $this->campaignTrackingService->getForwards($accessToken, $campaignId, $params);
}
public function getEmailCampaignUnsubscribes($accessToken, $campaign, array $params = array())
{
$campaignId = $this->getArgumentId($campaign, 'Campaign');
return $this->campaignTrackingService->getUnsubscribes($accessToken, $campaignId, $params);
}
public function getEmailCampaignSummaryReport($accessToken, $campaign)
{
$campaignId = $this->getArgumentId($campaign, 'Campaign');
return $this->campaignTrackingService->getSummary($accessToken, $campaignId);
}
public function getContactSends($accessToken, $contact, array $params = array())
{
$contactId = $this->getArgumentId($contact, 'Contact');
return $this->contactTrackingService->getSends($accessToken, $contactId, $params);
}
public function getContactBounces($accessToken, $contact, array $params = array())
{
$contactId = $this->getArgumentId($contact, 'Contact');
return $this->contactTrackingService->getBounces($accessToken, $contactId, $params);
}
public function getContactClicks($accessToken, $contact, array $params = array())
{
$contactId = $this->getArgumentId($contact, 'Contact');
return $this->contactTrackingService->getClicks($accessToken, $contactId, $params);
}
public function getContactOpens($accessToken, $contact, array $params = array())
{
$contactId = $this->getArgumentId($contact, 'Contact');
return $this->contactTrackingService->getOpens($accessToken, $contactId, $params);
}
public function getContactForwards($accessToken, $contact, array $params = array())
{
$contactId = $this->getArgumentId($contact, 'Contact');
return $this->contactTrackingService->getForwards($accessToken, $contactId, $params);
}
public function getContactUnsubscribes($accessToken, $contact, array $params = array())
{
$contactId = $this->getArgumentId($contact, 'Contact');
return $this->contactTrackingService->getUnsubscribes($accessToken, $contactId, $params);
}
public function getVerifiedEmailAddresses($accessToken, $status = null)
{
$params = array();
if($status){
$params['status'] = $status;
}
return $this->accountService->getVerifiedEmailAddresses($accessToken, $params);
}
public function getContactSummaryReport($accessToken, $contact)
{
$contactId = $this->getArgumentId($contact, 'Contact');
return $this->contactTrackingService->getSummary($accessToken, $contactId);
}
public function getActivities($accessToken)
{
return $this->activityService->getActivities($accessToken);
}
public function getActivity($accessToken, $activityId)
{
return $this->activityService->getActivity($accessToken, $activityId);
}
public function addCreateContactsActivity($accessToken, AddContacts $addContactsActivity)
{
return $this->activityService->createAddContactsActivity($accessToken, $addContactsActivity);
}
public function addClearListsActivity($accessToken, Array $lists)
{
return $this->activityService->addClearListsActivity($accessToken, $lists);
}
public function addRemoveContactsFromListsActivity($accessToken, Array $emailAddresses, Array $lists)
{
return $this->activityService->addRemoveContactsFromListsActivity($accessToken, $emailAddresses, $lists);
}
public function addExportContactsActivity($accessToken, ExportContacts $exportContacts)
{
return $this->activityService->addExportContactsActivity($accessToken, $exportContacts);
}
private function getArgumentId($item, $className)
{
$id = null;
if (is_numeric($item)){
$id = $item;
} elseif (join('', array_slice(explode('\\', get_class($item)), -1)) == $className){
$id = $item->id;
}else{
throw new IllegalArgumentException(sprintf(Config::get('errors.id_or_object'), $className));
}
return $id;
}
private function determineParam($param)
{
$params = array();
if (substr($param, 0, 1) === '?'){
$param = substr($param, 1);
parse_str($param, $params);
}else{
$params['limit'] = $param;
}
return $params;
}
}
