<?php
/** Performs all actions pertaining to scheduling Constant Contact Account's
 *
 * @package Services
 * @author Constant Contact
*/
namespace Ctct\Services;
use Ctct\Util\RestClient;
use Ctct\Util\Config;
use Ctct\Components\Account\VerifiedEmailAddress;
class AccountService extends BaseService
{
public function getVerifiedEmailAddresses($accessToken, Array $params)
{
$baseUrl = Config::get('endpoints.base_url')
. sprintf(Config::get('endpoints.account_verified_addresses'));
$url = $this->buildUrl($baseUrl, $params);
$response = parent::getRestClient()->get($url, parent::getHeaders($accessToken));
$verifiedAddresses = array();
foreach (json_decode($response->body, true) as $verifiedAddress){
$verifiedAddresses[] = VerifiedEmailAddress::create($verifiedAddress);
}
return $verifiedAddresses;
}
}
