<?php
/** Performs all actions pertaining to scheduling Constant Contact Campaigns
 *
 * @package Services
 * @author Constant Contact
*/
namespace Ctct\Services;
use Ctct\Util\RestClient;
use Ctct\Util\Config;
use Ctct\Components\EmailMarketing\Schedule;
use Ctct\Components\EmailMarketing\TestSend;
class CampaignScheduleService extends BaseService
{
public function addSchedule($accessToken, $campaignId, Schedule $schedule)
{
$baseUrl = Config::get('endpoints.base_url') .
sprintf(Config::get('endpoints.campaign_schedules'), $campaignId);
$url = $this->buildUrl($baseUrl);
$response = parent::getRestClient()->post($url, parent::getHeaders($accessToken), $schedule->toJson());
return Schedule::create(json_decode($response->body, true));
}
public function getSchedules($accessToken, $campaignId)
{
$baseUrl = Config::get('endpoints.base_url') .
sprintf(Config::get('endpoints.campaign_schedules'), $campaignId);
$url = $this->buildUrl($baseUrl);
$response = parent::getRestClient()->get($url, parent::getHeaders($accessToken));
$schedules = array();
foreach (json_decode($response->body, true) as $schedule){
$schedules[] = Schedule::create($schedule);
}
return $schedules;
}
public function getSchedule($accessToken, $campaignId, $scheduleId)
{
$baseUrl = Config::get('endpoints.base_url') .
sprintf(Config::get('endpoints.campaign_schedule'), $campaignId, $scheduleId);
$url = $this->buildUrl($baseUrl);
$response = parent::getRestClient()->get($url, parent::getHeaders($accessToken));
return Schedule::create(json_decode($response->body, true));
}
public function updateSchedule($accessToken, $campaignId, Schedule $schedule)
{
$baseUrl = Config::get('endpoints.base_url') .
sprintf(Config::get('endpoints.campaign_schedule'), $campaignId, $schedule->id);
$url = $this->buildUrl($baseUrl);
$response = parent::getRestClient()->put($url, parent::getHeaders($accessToken), $schedule->toJson());
return Schedule::create(json_decode($response->body, true));
}
public function deleteSchedule($accessToken, $campaignId, $scheduleId)
{
$baseUrl = Config::get('endpoints.base_url') .
sprintf(Config::get('endpoints.campaign_schedule'), $campaignId, $scheduleId);
$url = $this->buildUrl($baseUrl);
$response = parent::getRestClient()->delete($url, parent::getHeaders($accessToken));
return ($response->info['http_code'] == 204) ? true : false;
}
public function sendTest($accessToken, $campaignId, TestSend $test_send)
{
$baseUrl = Config::get('endpoints.base_url') .
sprintf(Config::get('endpoints.campaign_test_sends'), $campaignId);
$url = $this->buildUrl($baseUrl);
$response = parent::getRestClient()->post($url, parent::getHeaders($accessToken), $test_send->toJson());
return TestSend::create(json_decode($response->body, true));
}
}
