<?php
/** Performs all actions pertaining to Constant Contact Campaign Tracking
 *
 * @package Services
 * @author Constant Contact
*/
namespace Ctct\Services;
use Ctct\Util\RestClient;
use Ctct\Util\Config;
use Ctct\Components\Tracking\BounceActivity;
use Ctct\Components\Tracking\TrackingActivity;
use Ctct\Components\Tracking\ClickActivity;
use Ctct\Components\Tracking\ForwardActivity;
use Ctct\Components\Tracking\OpenActivity;
use Ctct\Components\Tracking\UnsubscribeActivity;
use Ctct\Components\Tracking\SendActivity;
use Ctct\Components\Tracking\TrackingSummary;
use Ctct\Components\ResultSet;
class CampaignTrackingService extends BaseService
{
public function getBounces($accessToken, $campaign_id, array $params = array())
{
$baseUrl = Config::get('endpoints.base_url') .
sprintf(Config::get('endpoints.campaign_tracking_bounces'), $campaign_id);
$url = $this->buildUrl($baseUrl, $params);
$response = parent::getRestClient()->get($url, parent::getHeaders($accessToken));
$body = json_decode($response->body, true);
$bounces = array();
foreach ($body['results'] as $bounceActivity){
$contacts[] = BounceActivity::create($bounceActivity);
}
return new ResultSet($contacts, $body['meta']);
}
public function getClicks($accessToken, $campaignId, array $params = array())
{
$baseUrl = Config::get('endpoints.base_url') .
sprintf(Config::get('endpoints.campaign_tracking_clicks'), $campaignId);
$url = $this->buildUrl($baseUrl, $params);
$response = parent::getRestClient()->get($url, parent::getHeaders($accessToken));
$body = json_decode($response->body, true);
$clicks = array();
foreach ($body['results'] as $click_activity){
$clicks[] = ClickActivity::create($click_activity);
}
return new ResultSet($clicks, $body['meta']);
}
public function getForwards($accessToken, $campaignId, array $params = array())
{
$baseUrl = Config::get('endpoints.base_url') .
sprintf(Config::get('endpoints.campaign_tracking_forwards'), $campaignId);
$url = $this->buildUrl($baseUrl, $params);
$response = parent::getRestClient()->get($url, parent::getHeaders($accessToken));
$body = json_decode($response->body, true);
$forwards = array();
foreach ($body['results'] as $forward_activity){
$forwards[] = ForwardActivity::create($forward_activity);
}
return new ResultSet($forwards, $body['meta']);
}
public function getOpens($accessToken, $campaign_id, array $params = array())
{
$baseUrl = Config::get('endpoints.base_url') .
sprintf(Config::get('endpoints.campaign_tracking_opens'), $campaign_id);
$url = $this->buildUrl($baseUrl, $params);
$response = parent::getRestClient()->get($url, parent::getHeaders($accessToken));
$body = json_decode($response->body, true);
$opens = array();
foreach ($body['results'] as $open_activity){
$opens[] = OpenActivity::create($open_activity);
}
return new ResultSet($opens, $body['meta']);
}
public function getSends($accessToken, $campaignId, array $params = array())
{
$baseUrl = Config::get('endpoints.base_url') .
sprintf(Config::get('endpoints.campaign_tracking_sends'), $campaignId);
$url = $this->buildUrl($baseUrl, $params);
$response = parent::getRestClient()->get($url, parent::getHeaders($accessToken));
$body = json_decode($response->body, true);
$sends = array();
foreach ($body['results'] as $send_activity){
$sends[] = SendActivity::create($send_activity);
}
return new ResultSet($sends, $body['meta']);
}
public function getUnsubscribes($accessToken, $campaignId, array $params = array())
{
$baseUrl = Config::get('endpoints.base_url') .
sprintf(Config::get('endpoints.campaign_tracking_unsubscribes'), $campaignId);
$url = $this->buildUrl($baseUrl, $params);
$response = parent::getRestClient()->get($url, parent::getHeaders($accessToken));
$body = json_decode($response->body, true);
$optOuts = array();
foreach ($body['results'] as $opt_out_activity){
$optOuts[] = UnsubscribeActivity::create($opt_out_activity);
}
return new ResultSet($optOuts, $body['meta']);
}
public function getSummary($accessToken, $campaign_id)
{
$baseUrl = Config::get('endpoints.base_url') .
sprintf(Config::get('endpoints.campaign_tracking_summary'), $campaign_id);
$url = $this->buildUrl($baseUrl);
$response = parent::getRestClient()->get($url, parent::getHeaders($accessToken));
return TrackingSummary::create(json_decode($response->body, true));
}
}
