<?php
/**
 * @version		3.3
 * @copyright	Copyright (C) 2006 - 2015 IdealExtensions.com. All rights reserved
 * @license		GNU GPL2 or later; see LICENSE.txt
 */
// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die;

/**
 * This models supports retrieving lists of contact categories.
 *
 * @package		com_contactenhanced
* @since		1.6
 */
class ContactenhancedModelCategories extends JModelLegacy
{
	/**
	 * Model context string.
	 *
	 * @var		string
	 */
	public $_context = 'com_contactenhanced.categories';

	/**
	 * The category context (allows other extensions to derived from this model).
	 *
	 * @var		string
	 */
	protected $_extension = 'com_contactenhanced';

	private $_parent = null;

	private $_items = null;

	/**
	 * Constructor.
	 *
	 * @param	array	An optional associative array of configuration settings.
	 * @see		JController
	 * @since	1.6
	 */
	public function __construct($config = array())
	{
		if (empty($config['filter_fields'])) {
			$config['filter_fields'] = array(
					'id', 'a.id',
					'name', 'a.name',
					'alias', 'a.alias',
					'checked_out', 'a.checked_out',
					'checked_out_time', 'a.checked_out_time',
					'catid', 'a.catid', 'category_title',
					'state', 'a.published',
					'access', 'a.access', 'access_level',
					'created', 'a.created',
					'created_by', 'a.created_by',
					'ordering', 'a.ordering',
					'featured', 'a.featured',
					'language', 'a.language',
					'hits', 'a.hits',
					'publish_up', 'a.publish_up',
					'publish_down', 'a.publish_down',
					'con_position', 'a.con_position',
					'department',	'a.department',
					'address', 		'a.address',
					'suburb', 		'a.suburb',
					'state', 		'a.state',
					'country', 		'a.country',
					'postcode', 	'a.postcode',
					'telephone', 	'a.telephone',
					'birthdate', 	'a.birthdate',
					'extra_field_1','a.extra_field_1',
					'extra_field_2','a.extra_field_2',
					'extra_field_3','a.extra_field_3',
					'extra_field_4','a.extra_field_4',
					'extra_field_5','a.extra_field_5',
					'extra_field_6','a.extra_field_6',
					'extra_field_7','a.extra_field_7',
					'extra_field_8','a.extra_field_8',
					'extra_field_9','a.extra_field_9',
					'extra_field_10','a.extra_field_10'
			);
			$this->filter_fields 	= $config['filter_fields'];
		}

		parent::__construct($config);
	}

	/**
	 * Method to auto-populate the model state.
	 *
	 * Note. Calling getState in this method will result in recursion.
	 *
	 * @since	1.6
	 */
	protected function populateState($ordering = 'ordering', $direction = 'ASC')
	{
		$app = JFactory::getApplication();
		$params	= $app->getParams();

		$this->setState('filter.extension', $this->_extension);

		// Get the parent id if defined.
		$parentId = JRequest::getInt('id');
		$this->setState('filter.parentId', $parentId);

		$params = $app->getParams();
		$this->setState('params', $params);
		// List state information
		$format = JRequest::getWord('format');
		if($format=='feed') {
			$limit = $app->getCfg('feed_limit');
		}
		else{
			$limit = $app->getUserStateFromRequest('global.list.limit', 'limit', $app->getCfg('list_limit'));
		}

		// No limit for this view
		$limit = 99999;
		$limit = $app->getUserStateFromRequest('global.list.limit', 'limit', $limit);
		$this->setState('list.limit', $limit);

		$limitstart = JRequest::getVar('limitstart', 0, '', 'int');
		$this->setState('list.start', $limitstart);

		//Get default value from parameters
		$ordering	= explode(' ', $params->get('category_ordering','ordering ASC'));

		$orderCol	= JRequest::getCmd('filter_order', $ordering[0]);
		if (!in_array($orderCol, $this->filter_fields)) {
			$orderCol = 'a.ordering';
		}
		$this->setState('list.ordering', $orderCol);

		$listOrder	=  JRequest::getCmd('filter_order_Dir', $ordering[1]);
		if (!in_array(strtoupper($listOrder), array('ASC', 'DESC', ''))) {
			$listOrder = 'ASC';
		}
		$this->setState('list.direction', $listOrder);

		$this->setState('filter.published',	1);
		$this->setState('filter.access',	true);
	}

	/**
	 * Method to get a store id based on model configuration state.
	 *
	 * This is necessary because the model is used by the component and
	 * different modules that might need different sets of data or different
	 * ordering requirements.
	 *
	 * @param	string		$id	A prefix for the store id.
	 *
	 * @return	string		A store id.
	 */
	protected function getStoreId($id = '')
	{
		// Compile the store id.
		$id	.= ':'.$this->getState('filter.extension');
		$id	.= ':'.$this->getState('filter.published');
		$id	.= ':'.$this->getState('filter.access');
		$id	.= ':'.$this->getState('filter.parentId');

		return parent::getStoreId($id);
	}

	/**
	 * redefine the function an add some properties to make the styling more easy
	 *
	 * @return mixed An array of data items on success, false on failure.
	 */
	public function getItems()
	{
		if(!count($this->_items))
		{
			$app = JFactory::getApplication();
			$menu = $app->getMenu();
			$active = $menu->getActive();
			$params = new JRegistry();
			if($active)
			{
				$params->loadString($active->params);
			}
			$options = array();
			$options['countItems'] = $params->get('show_cat_items_cat', 1) || !$params->get('show_empty_categories_cat', 0);
			$categories = JCategories::getInstance('Contactenhanced', $options);
			$this->_parent = $categories->get($this->getState('filter.parentId', 'root'));
			if(is_object($this->_parent))
			{
				$this->_items = $this->_parent->getChildren();
			}else{
				$this->_items = false;
			}
		}

		return $this->_items;
	}

	/**
	 * Gets a list of categories and contacts
	 * @param array
	 * @return array
	 */
	function getCategoriesContacts( $options=array() )
	{
		$app	= JFactory::getApplication();
		$params	= $app->getParams();
		if(!count($this->_items))
		{
			$categories	= $this->getItems();
		}else
		{
			$categories	= $this->_items;
		}

		require_once (JPATH_SITE.'/components/com_contactenhanced/models/category.php');
		$exclude_categories	= JRequest::getVar('exclude-categories',$params->get('exclude-contact-categories'));

		if(!is_array($exclude_categories)){
			$exclude_categories	= explode( ',', $exclude_categories);
		}

		$k = 0;
		for($i=0;$i<count($categories); $i++){
			$category =& $categories[$i];
			if(in_array($category->id,$exclude_categories)){
				continue;
			}
			JRequest::setVar('category_id', $category->id);
			$catModel	= new ContactenhancedModelCategory();
			//remove limit/pagination
			$limit = 99999;
			$limit = $app->setUserState('global.list.limit',  $limit);
			$this->setState('list.limit', $limit);
			$category->contacts =   $catModel->getItems();
			$category->link = JRoute::_('index.php?option=com_contactenhanced&view=category&catid='.$category->slug);
			$category->odd	= $k;
			$category->count= $i;
			$k = 1 - $k;
		}
		JRequest::setVar('category_id',null);
		return $categories;
	}

	public function getParent()
	{
		if(!is_object($this->_parent))
		{
			$this->getItems();
		}
		return $this->_parent;
	}
}