<?php
/**
 * @version		3.3
 * @package		com_contactenhanced
 * @copyright	Copyright (C) 2006 - 2015 IdealExtensions.com. All rights reserved
 * @license		GNU GPL2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

jimport('joomla.application.component.modelitem');

/**
 * @package		com_contactenhanced
 * @since 1.5
 */
class ContactenhancedModelCustomfields extends JModelItem
{

	/**
	 * Model context string.
	 *
	 * @var		string
	 */
	protected $_context = 'com_contactenhanced.customfields';

	/**
	 * Method to auto-populate the model state.
	 *
	 * Note. Calling getState in this method will result in recursion.
	 *
	 * @since	1.6
	 */
	protected function populateState()
	{
			// Initialise variables.
		$app	= JFactory::getApplication();
		$this->setState('filter.language',$app->getLanguageFilter());

	}

	/**
	 * Gets a list of contacts
	 * @param array
	 * @return mixed Object or null
	 */
	public function &getItems($catid = null)
	{
		// Initialise variables.
		$catid = (!empty($catid)) ? $catid : 0;

		if($this->_item === null) {
			$this->_item = array();
		}

		if (!isset($this->_item[$catid])) {
			try
			{
				$data 	= $this->getCustomFields($catid);
				$params	= JComponentHelper::getParams('com_contactenhanced');

				if($params->get('cascade_fields',1)){ // Get Form Fields from parent categories
					// We cannot have two fields with the same alias;
					$fieldAliases 	= array();
					// The first run is just to populate the $fieldAliases
					$this->removeFieldsWithMatchingAliases($data,$data,$fieldAliases);
					$tempCatid 		= new stdClass();
					$tempCatid->id 	= $catid;
					while (($tempCatid = JCategories::getInstance('Contactenhanced')->get($tempCatid->id)->getParent())) {
						$tempData	= $this->getCustomFields($tempCatid->id);
						// We cannot have two fields with the same alias and feed $FieldAliases
						// ALL variables are passed by reference
						$this->removeFieldsWithMatchingAliases($tempData,$data,$fieldAliases);

						// Form Fields from parent Categories will display first
						$data 		= array_merge($tempData,$data);
					}
				}

				if (empty($data) AND $params->get('cascade_fields') != 1) { // If cascade fields is enabled, then we already tried to get parent Form Fields
					$tempCatid 		= new stdClass();
					$tempCatid->id 	= $catid;
					while (empty($data)
							AND ($tempCatid = JCategories::getInstance('Contactenhanced')->get($tempCatid->id)->getParent())
					){
						$data	= $this->getCustomFields($tempCatid->id);
					}
				}

				if (empty($data)) {
					throw new Exception(JText::_('CE_CF_ERROR_CUSTOM_FIELDS_NOT_FOUND'), 500);
				}

				$this->_item[$catid] = $data;
			}
			catch (RuntimeException $e)
			{
				$this->setError($e->getMessage());
				$this->_item[$catid] = false;
			}

		}

  		return $this->_item[$catid];

	}
	public function getCustomFields($catid){
		$catid = (!empty($catid)) ? $catid : 0;
		$params	= JComponentHelper::getParams('com_contactenhanced');
		try {
			$user	= JFactory::getUser();
			$groups	= implode(',', $user->getAuthorisedViewLevels());

			// Create a new query object.
			$db		= JFactory::getDbo();
			$query	= $db->getQuery(true);

			// Select required fields from the categories.
			$query->select('cf.*');
			$query->from('#__ce_cf AS cf');
			$query->where('cf.access IN ('.$groups.')');

			if($params->get('cascade_fields',1)){
				$query->where('(cf.catid = '.$db->Quote($catid).')');
			}else{
				$query->where('(cf.catid = '.$db->Quote($catid).' OR cf.catid = 0)');
			}

			$query->where('(cf.published > 0 OR (cf.published = 0 AND cf.iscore = 1) )');

			// Filter by language
			//	if($this->getState('filter.language')) {
			$query->where('cf.language IN (' . $db->Quote(JFactory::getLanguage()->getTag()) . ',' . $db->Quote('*') . ')');
			//	}
			// Add the list ordering clause.
			$query->order('cf.catid, cf.ordering ASC');

			$db->setQuery($query);
			//echo nl2br(str_replace('#__','jos_',$query)); exit;

			$data = $db->loadObjectList();

			if($error = $db->getErrorMsg()) {
				throw new Exception($error);
			}
		} catch (RuntimeException $e)
		{
			$this->setError($e->getMessage());
		}
		return $data;
	}
	public function removeFieldsWithMatchingAliases(&$parentFields,&$childFields,&$fieldAliases){
		for ($i=0;$i < count($parentFields); $i++){
			// Shortcut for $parentFields[$i]
			$pField = &$parentFields[$i];
			// this IF is to improve performance, so it will only interate with $childFields if the alias match
			if(in_array($pField->alias, $fieldAliases)){
				for ($k=0;$k < count($childFields); $k++){
					// Shortcut for $childFields[$k]
					$cField = &$childFields[$k];
					if($pField->alias == $cField->alias){
						// replace the ordering of the Child field with the ordeing of the Parent field
						$cField->ordering = $pField->ordering;
						// Replace the Parent Field with the Child field
						$pField = $cField;
						// Now Child is the same as Parent field
						// remove Child field
						unset($childFields[$k]);
					}
				}
			}else{
				$fieldAliases[] = $pField->alias;
			}
		}
	}// end function
}

