<?php
/**
 * @version		3.3
 * @package		com_contactenhanced
 * @copyright	Copyright (C) 2006 - 2015 IdealExtensions.com. All rights reserved
 * @license		GNU GPL2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

JHTML::_('behavior.framework');

	$listOrder	= $this->state->get('list.ordering');
	$listDirn	= $this->state->get('list.direction');
?>
<?php if (empty($this->category->contacts)) : ?>
	<p> <?php echo JText::_('COM_CONTACTENHANCED_NO_CONTACTS'); ?>	 </p>
<?php else : ?>

<?php if(!defined('CE_CATEGORY_CONTACT_BEGIN_FORM')) :

?>
	<form action="<?php echo htmlspecialchars(JFilterOutput::ampReplace(JFactory::getURI()->toString())); ?>"
		method="post" name="adminForm" id="adminForm">

<?php
define('CE_CATEGORY_CONTACT_BEGIN_FORM',true);
endif; ?>

	<table class="category table table-bordered table-striped">
		<?php if($this->params->get('show_headings')) :
		$allowOrdering = ($this->params->get('show_headings') == 'ordering' ? true : false);
		?>
		<thead><tr>

			<th class="item-title">
				<?php
				$label = $this->params->get('lang_override_name','COM_CONTACTENHANCED_CONTACT_EMAIL_NAME');
				if($allowOrdering){
					echo JHtml::_('grid.sort',$label , 'a.name', $listDirn, $listOrder);
				}else{
					echo JText::_($label);
				}
				?>
			</th>

			<?php if($this->params->get('show_department_headings')) : ?>
			<th class="item-department  hidden-phone hidden-xs">
				<?php
				$label = $this->params->get('lang_override_department','COM_CONTACTENHANCED_DEPARTMENT');
				if($allowOrdering){
					echo JHtml::_('grid.sort', $label, 'a.department', $listDirn, $listOrder);
				}else{
					echo JText::_($label);
				}
				?>
			</th>
			<?php endif; ?>

			<?php if($this->params->get('show_position_headings')) : ?>
			<th class="item-position">
				<?php
				$label = $this->params->get('lang_override_position','COM_CONTACTENHANCED_POSITION');
				if($allowOrdering){
					echo JHtml::_('grid.sort', $label, 'a.con_position', $listDirn, $listOrder);
				}else{
					echo JText::_($label);
				}
				?>
			</th>
			<?php endif; ?>
			<?php if($this->params->get('show_email_headings')) : ?>
			<th class="item-email   hidden-phone hidden-xs">
				<?php
				$label = $this->params->get('lang_override_email','JGLOBAL_EMAIL');
				echo JText::_($label); ?>
			</th>
			<?php endif; ?>
			<?php if($this->params->get('show_telephone_headings')) : ?>
			<th class="item-phone">
				<?php
				$label = $this->params->get('lang_override_telephone','COM_CONTACTENHANCED_TELEPHONE');
				echo JText::_($label); ?>
			</th>
			<?php endif; ?>

			<?php if($this->params->get('show_mobile_headings')) : ?>
			<th class="item-phone   hidden-phone hidden-xs">
				<?php
				$label = $this->params->get('lang_override_mobile','COM_CONTACTENHANCED_MOBILE');
				echo JText::_($label); ?>
			</th>
			<?php endif; ?>

			<?php if($this->params->get('show_fax_headings')) : ?>
			<th class="item-phone   hidden-phone hidden-xs">
				<?php
				$label = $this->params->get('lang_override_fax','COM_CONTACTENHANCED_FAX');
				echo JText::_($label); ?>
			</th>
			<?php endif; ?>

			<?php if($this->params->get('show_street_address_headings')) : ?>
			<th class="item-street-address   hidden-phone hidden-xs">
				<?php
				$label = $this->params->get('lang_override_address','COM_CONTACTENHANCED_ADDRESS');
				if($allowOrdering){
					echo JHtml::_('grid.sort', $label, 'a.address', $listDirn, $listOrder);
				}else{
					echo JText::_($label);
				}
				?>
			</th>
			<?php endif; ?>

			<?php if($this->params->get('show_suburb_headings')) : ?>
			<th class="item-suburb  hidden-phone hidden-xs">
				<?php
				$label = $this->params->get('lang_override_suburb','COM_CONTACTENHANCED_SUBURB');
				if($allowOrdering){
					echo JHtml::_('grid.sort', $label, 'a.suburb', $listDirn, $listOrder);
				}else{
					echo JText::_($label);
				}
				?>
			</th>
			<?php endif; ?>

			<?php if($this->params->get('show_state_headings')) : ?>
			<th class="item-state  hidden-phone hidden-xs">
				<?php
				$label = $this->params->get('lang_override_state','COM_CONTACTENHANCED_STATE');
				if($allowOrdering){
					echo JHtml::_('grid.sort', $label, 'a.state', $listDirn, $listOrder);
				}else{
					echo JText::_($label);
				}
				?>
			</th>
			<?php endif; ?>

			<?php if($this->params->get('show_postcode_headings')) : ?>
			<th class="item-postcode   hidden-phone hidden-xs">
				<?php
				$label = $this->params->get('lang_override_postcode','COM_CONTACTENHANCED_POSTCODE');
				if($allowOrdering){
					echo JHtml::_('grid.sort', $label, 'a.postcode', $listDirn, $listOrder);
				}else{
					echo JText::_($label);
				}
				?>
			</th>
			<?php endif; ?>

			<?php if($this->params->get('show_country_headings')) : ?>
			<th class="item-country   hidden-phone hidden-xs">
				<?php
				$label = $this->params->get('lang_override_country','COM_CONTACTENHANCED_COUNTRY');
				if($allowOrdering){
					echo JHtml::_('grid.sort', $label, 'a.country', $listDirn, $listOrder);
				}else{
					echo JText::_($label);
				}
				?>
			</th>
			<?php endif; ?>

			<?php if($this->params->get('show_webpage_headings')) : ?>
			<th class="item-webpage   hidden-phone hidden-xs">
				<?php
				$webpageLabel = $this->params->get('lang_override_webpage','COM_CONTACTENHANCED_WEBPAGE');
				echo JText::_($webpageLabel); ?>
			</th>
			<?php endif; ?>
			<?php for ($i = 1; $i <= 10; $i++): ?>
				<?php if($this->params->get('show_extrafield_'.$i.'_headings')) : ?>
				<th class="item-extra_field_<?php echo $i; ?>">
					<?php
					$label = $this->params->get('lang_override_extrafield_'.$i,'COM_CONTACTENHANCED_FIELD_INFORMATION_EXTRA_FIELD_'.$i.'_LABEL');
					if($allowOrdering){
						echo JHtml::_('grid.sort', $label, 'a.extra_field_'.$i, $listDirn, $listOrder);
					}else{
						echo JText::_($label);
					}
					?>
				</th>
				<?php endif; ?>
			<?php endfor; ?>

			</tr>
		</thead>
		<?php endif; ?>

		<tbody>

			<?php foreach($this->category->contacts as $i => $item) : ?>
				<?php if($this->category->contacts[$i]->published_state < 1) : ?>
					<tr class="system-unpublished info cat-list-row<?php echo $i % 2; ?>">
				<?php else: ?>
					<tr class="cat-list-row<?php echo $i % 2; ?>" >
				<?php endif; ?>

					<td class="item-title">
						<?php
						$item->link = JRoute::_(ContactenchancedHelperRoute::getContactRoute($item->slug, $item->catid));
						if($this->params->get( 'show_contact_image' ) == '1' AND $item->image ){
							$image = JHtml::_('image',  JURI::base(). $item->image, JText::sprintf('COM_CONTACTENHANCED_CONTACT_IMAGE_ALT',$item->name ), array('align' => 'middle', 'class'=> 'ce-contact-img-cat'));
							echo JHtml::_('link',$item->link,$image, array('class'=>'category'.$this->params->get( 'pageclass_sfx' )) );
							echo JHtml::_('link',$item->link,$item->name, array('class'=>'category'.$this->params->get( 'pageclass_sfx' )) );
						}elseif($this->params->get( 'show_contact_image','tooltip' ) == 'tooltip' AND $item->image){
							$image = JHtml::_('image',  JURI::base(). $item->image, JText::sprintf('COM_CONTACTENHANCED_CONTACT_IMAGE_ALT',$item->name ), array('align' => 'middle', 'class'=> 'ce-contact-img-tooltip'));
							JHtml::_('bootstrap.tooltip');
							echo JHTML::_('link',$item->link,$image, array('class'=>'hasTooltip category'.$this->params->get( 'pageclass_sfx' )) );
						}else{
							echo JHtml::_('link',$item->link,$item->name, array('class'=>'category'.$this->params->get( 'pageclass_sfx' )) );
						}
					?>
					</td>

					<?php if($this->params->get('show_department_headings')) : ?>
						<td class="item-department  hidden-phone hidden-xs">
							<?php echo $item->department; ?>
						</td>
					<?php endif; ?>

					<?php if($this->params->get('show_position_headings')) : ?>
						<td class="item-position">
							<?php echo $item->con_position; ?>
						</td>
					<?php endif; ?>

					<?php if($this->params->get('show_email_headings')) : ?>
						<td class="item-email   hidden-phone hidden-xs">
						<?php
							if(!empty($item->email_to)){
								if($this->params->get('show_email_headings') == 'label'){
									$item->email_to = JHtml::_('email.cloak', $item->email_to, true, JText::_('JGLOBAL_EMAIL'), false);
								}elseif($this->params->get('show_email_headings') == 'link'){
									$item->email_to = JHtml::_('email.cloak', $item->email_to);
								}
							}
						?>
							<?php echo $item->email_to; ?>
						</td>
					<?php endif; ?>

					<?php if($this->params->get('show_telephone_headings')) : ?>
						<td class="item-phone">
							<?php
								$tel	= nl2br($item->telephone);
								if($this->browser->isMobile()){
									$telLink= 'tel:'.preg_replace('[(?!\+\b)\D]', '', $tel);
									$tel	= JHtml::_('link'
														,$telLink
														,$tel
														, array('title' => JText::sprintf('COM_CONTACTENHANCED_CALL_USING_YOUR_PHONE',$tel))
														);
								}
								echo ($tel);
							?>
						</td>
					<?php endif; ?>

					<?php if($this->params->get('show_mobile_headings')) : ?>
						<td class="item-phone  hidden-phone hidden-xs">
							<?php
								$tel	= nl2br($item->mobile);
								if($this->browser->isMobile()){
									$telLink= 'tel:'.preg_replace('[(?!\+\b)\D]', '', $tel);
									$tel	= JHtml::_('link'
														,$telLink
														,$tel
														, array('title' => JText::sprintf('COM_CONTACTENHANCED_CALL_USING_YOUR_PHONE',$tel))
														);
								}
								echo ($tel);
							?>
						</td>
					<?php endif; ?>

					<?php if($this->params->get('show_fax_headings')) : ?>
					<td class="item-phone  hidden-phone hidden-xs">
						<?php echo $item->fax; ?>
					</td>
					<?php endif; ?>

					<?php if($this->params->get('show_street_address_headings')) : ?>
					<td class="item-street-address   hidden-phone hidden-xs">
						<?php echo $item->address; ?>
					</td>
					<?php endif; ?>

					<?php if($this->params->get('show_suburb_headings')) : ?>
					<td class="item-suburb  hidden-phone hidden-xs">
						<?php echo $item->suburb; ?>
					</td>
					<?php endif; ?>

					<?php if($this->params->get('show_state_headings')) : ?>
					<td class="item-state  hidden-phone hidden-xs">
						<?php echo $item->state; ?>
					</td>
					<?php endif; ?>

					<?php if($this->params->get('show_postcode_headings')) : ?>
					<td class="item-postcode   hidden-phone hidden-xs">
						<?php echo $item->postcode; ?>
					</td>
					<?php endif; ?>

					<?php if($this->params->get('show_country_headings')) : ?>
					<td class="item-country   hidden-phone hidden-xs">
						<?php echo $item->country; ?>
					</td>
					<?php endif; ?>

					<?php if($this->params->get('show_webpage_headings')) : ?>
					<td class="item-webpage   hidden-phone hidden-xs">
						<?php if($item->webpage): ?>
							<a href="<?php echo $item->webpage; ?>" title="<?php echo $item->webpage; ?>" target="_blank">
							<?php
								if($this->params->get('show_webpage_headings') == 'trim'){
									 echo ceHelper::trimURL(JStringPunycode::urlToUTF8($item->webpage));
								}elseif($this->params->get('show_webpage_headings') == 'label'){
									 echo JText::_($webpageLabel);
								}else{
									echo JStringPunycode::urlToUTF8($item->webpage);
								}
							?></a>
						<?php endif;  ?>
					</td>
					<?php endif; ?>

					<?php for ($i = 1; $i <= 10; $i++): ?>
						<?php if($this->params->get('show_extrafield_'.$i.'_headings')) : ?>
						<td class="item-extra_field_<?php echo $i; ?>">
							<?php
							$field	= "extra_field_".$i;
							 echo $item->$field; ?>
						</td>
						<?php endif; ?>
					<?php endfor; ?>

				</tr>
			<?php endforeach; ?>

		</tbody>
	</table>
<?php if(!defined('CE_CATEGORY_CONTACT_END_FORM')) :?>
	<div>
		<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
		<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
		<input type="hidden" name="state"	value="<?php echo $this->filter_state; ?>" />
		<input type="hidden" name="country" value="<?php echo $this->filter_country; ?>" />
		<input type="hidden" name="suburb"	value="<?php echo $this->filter_suburb; ?>" />
	</div>
</form>

	<?php
	define('CE_CATEGORY_CONTACT_END_FORM',true);
	endif; ?>
<?php endif; ?>