<?php
/**
 * @package     Joomla.Site
 * @subpackage  com_contact
 *
 * @copyright   Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

JHtml::_('behavior.framework');

$listOrder	= $this->escape($this->state->get('list.ordering'));
$listDirn	= $this->escape($this->state->get('list.direction'));
?>
<?php if (empty($this->items)) : ?>
	<p> <?php echo JText::_('COM_CONTACTENHANCED_NO_CONTACTS'); ?>	 </p>
<?php else : ?>

	<form action="<?php echo htmlspecialchars(JUri::getInstance()->toString()); ?>" method="post" name="adminForm" id="adminForm">
	<?php if ($this->params->get('filter_field') || $this->params->get('show_pagination_limit')) :?>
	<fieldset class="filters btn-toolbar">
		<?php if ($this->params->get('filter_field')) :?>
			<div class="btn-group">
				<label class="filter-search-lbl element-invisible" for="filter-search"><span class="label label-warning"><?php echo JText::_('JUNPUBLISHED'); ?></span><?php echo JText::_('COM_CONTACTENHANCED_FILTER_LABEL').'&#160;'; ?></label>
				<input type="text" name="filter-search" id="filter-search" value="<?php echo $this->escape($this->state->get('list.filter')); ?>" class="inputbox" onchange="document.adminForm.submit();" title="<?php echo JText::_('COM_CONTACTENHANCED_FILTER_SEARCH_DESC'); ?>" placeholder="<?php echo JText::_('COM_CONTACTENHANCED_FILTER_SEARCH_DESC'); ?>" />
			</div>
		<?php endif; ?>

		<?php if ($this->params->get('show_pagination_limit')) : ?>
			<div class="btn-group pull-right">
				<label for="limit" class="element-invisible">
					<?php echo JText::_('JGLOBAL_DISPLAY_NUM'); ?>
				</label>
				<?php echo $this->pagination->getLimitBox(); ?>
			</div>
		<?php endif; ?>
	</fieldset>
	<?php endif; ?>

		<ul class="category list-striped">
			<?php foreach ($this->items as $i => $item) : 
				$this->item = &$item;
				$this->contact = &$this->item;
				$this->contact->link = JRoute::_(ContactenchancedHelperRoute::getContactRoute($item->slug, $item->catid));
				$this->row = $i % 2;
				?>

				<?php if (in_array($item->access, $this->user->getAuthorisedViewLevels())) : ?>
					<?php if ($this->items[$i]->published == 0) : ?>
						<li class="system-unpublished cat-list-row<?php echo $this->row; echo ($this->row == 0 ? ' list-row-even' : ' list-row-odd') ?>">
					<?php else: ?>
						<li class="cat-list-row<?php echo $this->row; echo ($this->row == 0 ? ' list-row-even' : ' list-row-odd') ?> " 
							itemscope itemtype="http://data-vocabulary.org/Person" >
					<?php endif; ?>
							<div class="contact-block">
							
							<<?php echo $this->params->get('item_heading', 'h4'); ?> class="list-title">
								<a 	itemprop="name" 
									href="<?php echo $item->link; ?>">
									<?php echo $item->name; ?></a>
								<?php if ($this->items[$i]->published == 0) : ?>
									<span class="label label-warning"><?php echo JText::_('JUNPUBLISHED'); ?></span>
								<?php endif; ?>
							</<?php echo $this->params->get('item_heading', 'h4'); ?>>
							<?php echo $this->loadTemplate('image'); ?>
						<div class="contact-details">
							<?php echo $this->loadTemplate('position'); ?>
							<?php echo $this->loadTemplate('phone_and_social'); ?>
							<?php echo $this->loadTemplate('address'); ?>
							<?php echo $this->loadTemplate('extrafields'); ?>
							
							<?php if ($this->params->get('show_misc_label_headings') AND $item->misc) : ?>
							<div  class="contact-misc">
								<?php 
								if ($this->params->get('show_misc_label_headings')){
									echo '<h4>'.JText::_($this->params->get('show_misc_label_headings')).'</h4>';
								}
								?>
								<?php echo $item->misc; ?>
							</div>
							<?php endif; ?>
						</div>
						<br class="clearfix" style="clear:both" />
						</div>
					</li>
				<?php endif; ?>
			<?php endforeach; ?>
		</ul>

		<?php if ($this->params->get('show_pagination')) : ?>
		<div class="pagination">
			<?php if ($this->params->def('show_pagination_results', 1)) : ?>
			<p class="counter">
				<?php echo $this->pagination->getPagesCounter(); ?>
			</p>
			<?php endif; ?>
			<?php echo $this->pagination->getPagesLinks(); ?>
		</div>
		<?php endif; ?>
		<div>
			<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
			<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
		</div>
</form>
<?php endif; ?>
