<?php
/**
 * @version		3.3
 * @package		com_contactenhanced
 * @copyright	Copyright (C) 2006 - 2015 IdealExtensions.com. All rights reserved
 * @license		GNU GPL2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;
jimport('joomla.application.component.view');

class ContactenhancedViewContact extends JViewLegacy
{
	protected $state;
	protected $item;

	public function display($tpl = null)
	{
		// Get model data.
		$state = $this->get('State');
		$item = $this->get('Item');

		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseWarning(500, implode("\n", $errors));
			return false;
		}

		//JFactory::getDocument()->setMetaData('Content-Type', 'text/directory', true);
		JFactory::getDocument()->setMetaData('Content-Type', 'text/directory; charset=utf-8;', true);

		// Initialise variables.
		$app		= JFactory::getApplication();
		$params 	= $app->getParams();
		$user		= JFactory::getUser();
		$dispatcher = JDispatcher::getInstance();

		// Compute lastname, firstname and middlename
		$item->name = trim($item->name);

		// "Lastname, Firstname Midlename" format support
		// e.g. "de Gaulle, Charles"
		$namearray = explode(',', $item->name);
		if (count($namearray) > 1 ) {
			$lastname = $namearray[0];
			$card_name = $lastname;
			$name_and_midname = trim($namearray[1]);

			$firstname = '';
			if (!empty($name_and_midname)) {
				$namearray = explode(' ', $name_and_midname);

				$firstname = $namearray[0];
				$middlename = (count($namearray) > 1) ? $namearray[1] : '';
				$card_name = $firstname . ' ' . ($middlename ? $middlename . ' ' : '') .  $card_name;
			}
		}
		// "Firstname Middlename Lastname" format support
		else{
			$namearray = explode(' ', $item->name);

			$middlename = (count($namearray) > 2) ? $namearray[1] : '';
			$firstname = array_shift($namearray);
			$lastname = count($namearray) ? end($namearray) : '';
			$card_name = $firstname . ($middlename ? ' ' . $middlename : '') . ($lastname ? ' ' . $lastname : '');
		}

		$rev = date('c', strtotime($item->modified));

		$vcard = array();
		$vcard[].= 'BEGIN:VCARD';
		//$vcard[].= 'VERSION:3.0';
		$vcard[].= 'VERSION:4.0';
		$vcard[] = 'N;CHARSET=utf-8:'.$lastname.';'.$firstname.';'.$middlename;
		$vcard[] = 'FN;CHARSET=utf-8:'. $item->name;
		$vcard[] = 'TITLE;CHARSET=utf-8:'.$item->con_position;
		$vcard[] = 'TEL;TYPE=WORK,VOICE:'.$item->telephone;
		$vcard[] = 'TEL;TYPE=WORK,FAX:'.$item->fax;
		$vcard[] = 'TEL;TYPE=WORK,MOBILE:'.$item->mobile;
		$vcard[] = 'ADR;CHARSET=utf-8;TYPE=WORK:";;'.$item->address.';'.$item->suburb.';'.$item->state.';'.$item->postcode.';'.$item->country.'"'
					.';LABEL:"'.$item->address."\n".$item->suburb."\n".$item->state."\n".$item->postcode."\n".$item->country.'"';

		$vcard[] = 'EMAIL;TYPE=PREF,INTERNET:'.$item->email_to;
		$vcard[] = 'URL;WORK:'.$item->webpage;
		$vcard[] = 'REV:'.$rev.'Z';
		$vcard[] = 'ORG;CHARSET=utf-8:'.$app->getCfg('sitename');
		if($item->birthdate){
			$vcard[] = 'BDAY:'.str_replace(array('/','-'),'',$item->birthdate);
		}
		if($item->lat AND $item->lng) {
			$vcard[] = "GEO:geo:{$item->lat},{$item->lng}";
		}

		if (is_readable(JPATH_BASE.'/'.$item->image)){
			jimport('joomla.filesystem.file');
			//$vcard[]= "PHOTO;VALUE=uri:".JURI::root().$item->image;
			$vcard[]= "PHOTO;MEDIATYPE=image/jpeg:".JURI::root().$item->image;

		}
		$vcard[] = 'END:VCARD';

		JFactory::getApplication()->setHeader('Content-disposition', 'attachment; filename="'.$card_name.'.vcf"', true);
		echo implode("\n",$vcard);
//		return true;
	}
}

