<?php
/**
 * @version		3.3
 * @package		com_contactenhanced
 * @copyright	Copyright (C) 2006 - 2015 IdealExtensions.com. All rights reserved
 * @license		GNU GPL2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

JHTML::_('behavior.framework');
JHTML::_('behavior.tooltip');

$listOrder	= $this->state->get('list.ordering');
$listDirn	= $this->state->get('list.direction');
?>

<form action="<?php echo htmlspecialchars(JFactory::getURI()->toString()); ?>" method="post" name="adminForm" id="adminForm">
<?php if($this->params->get('show_pagination_limit')  OR $this->params->get('filter_field')) : ?>
	<fieldset class="filters">
	<?php if($this->params->get('filter_field')) :?>
			<div class="btn-group  pull-left">
			<?php if($this->params->get('filter_field') ==2 AND !empty($this->search_fields)): ?>
				<select name="search-field" id="search_field" class="input-medium">
					<option value=""><?php echo JText::_('JGLOBAL_FILTER_LABEL');?></option>
					<?php echo JHtml::_('select.options', $this->search_fields, 'value', 'text', $listOrder);?>
				</select>

			<?php else: ?>
				<label	class="filter-search-lbl element-invisible"
						for="filter-search"><?php  echo JText::_('JGLOBAL_FILTER_LABEL').'&#160;'; ?></label>
			<?php endif; ?>
				<input type="search"
					name="filter-search"
					id="filter-search"
					value="<?php echo $this->escape($this->state->get('filter.search')); ?>"
					class="inputbox"
					onchange="document.adminForm.submit();"
					title="<?php echo JText::_('JGLOBAL_FILTER_LABEL'); ?>"
					placeholder="<?php echo JText::_('JGLOBAL_FILTER_LABEL'); ?>" />
			</div>
		<?php endif; ?>
	<?php if (!empty($this->items)) : ?>
		<?php if($this->params->get('show_pagination_limit')) : ?>
			<div class="display-limit  pull-right">
				<?php echo JText::_('JGLOBAL_DISPLAY_NUM'); ?>&#160;
				<?php echo $this->pagination->getLimitBox(); ?>
			</div>
		<?php endif; ?>
	<?php endif; ?>
	</fieldset>
<?php endif; ?>

<?php if (empty($this->items)) : ?>
<p class="text-warning"> <?php echo JText::_('COM_CONTACTENHANCED_MESSAGES_NO_MESSAGE_FOUND'); ?>	 </p>
<?php else : ?>
	<table class="category table table-bordered table-striped">
		<?php if($this->params->get('show_headings')) :
		$allowOrdering = ($this->params->get('show_headings') == 'ordering' ? true : false);
		?>
		<thead><tr>

			<th class="item-subject">
				<?php
				if($allowOrdering){
					echo JHtml::_('grid.sort', 'CE_MSG_SUBJECT', 'msg.subject', $listDirn, $listOrder);
				}else{
					echo JText::_('CE_MSG_SUBJECT');
				}
				?>
			</th>

			<?php if($this->params->get('show_contact_form_headings')) : ?>
			<th class="item-contact">
				<?php
				if($allowOrdering){
					echo JHtml::_('grid.sort', 'COM_CONTACTENHANCED_EMAIL_FORM', 'con.name', $listDirn, $listOrder);
				}else{
					echo JText::_('COM_CONTACTENHANCED_EMAIL_FORM');
				}
				?>
			</th>
			<?php endif; ?>
			<?php if($this->params->get('show_date_headings')) : ?>
			<th class="item-date">
				<?php
				if($allowOrdering){
					echo JHtml::_('grid.sort', 'JDATE', 'msg.date', $listDirn, $listOrder);
				}else{
					echo JText::_('JDATE');
				}
				?>
			</th>
			<?php endif; ?>
			<?php if($this->params->get('show_category_headings')) : ?>
			<th class="item-category">
				<?php echo JText::_('JCATEGORY'); ?>
			</th>
			<?php endif; ?>
			<?php if($this->params->get('show_id_headings')) : ?>
			<th class="item-id">
				<?php
				if($allowOrdering){
					echo JHtml::_('grid.sort', 'JGRID_HEADING_ID', 'msg.id', $listDirn, $listOrder);
				}else{
					echo JText::_('JGRID_HEADING_ID');
				}
				?>
			</th>
			<?php endif; ?>

			</tr>
		</thead>
		<?php endif; ?>

		<tbody>
			<?php foreach($this->items as $i => $item) : ?>
				<?php if($this->items[$i]->published == 0) : ?>
					<tr class="system-unpublished cat-list-row<?php echo $i % 2; ?>">
				<?php else: ?>
					<tr class="cat-list-row<?php echo $i % 2; ?>" >
				<?php endif; ?>

					<td class="item-subject">
						<?php
						$item->message_slug = $item->id.':'.JApplication::stringURLSafe($item->subject);
						$item->link = JRoute::_('index.php?option=com_contactenhanced&view=message&id='.$item->message_slug);
						if($this->params->get( 'show_link', 1 ) == '1' ){
							echo JHTML::_('link',$item->link,$item->subject, array('class'=>'category'.$this->params->get( 'pageclass_sfx' )) );
						}else{
							echo $item->subject;
						}
					?>
					</td>
					<?php if($this->params->get('show_contact_form_headings')) : ?>
					<td class="item-contact-form">
						<?php
						$item->contact_slug = $item->contact_id.':'.$item->contact_alias;
						$item->contact_link = JRoute::_(ContactenchancedHelperRoute::getContactRoute($item->contact_slug, $item->catid));
						if($this->params->get( 'show_contact_image' ) == '1' AND $item->contact_image ){
							$image = JHTML::_('image',  JURI::base(). $item->contact_image, JText::sprintf('COM_CONTACTENHANCED_CONTACT_IMAGE_ALT',$item->contact_name ), array('align' => 'middle', 'class'=> 'ce-contact-img-cat'));
							echo JHTML::_('link',$item->contact_link,$image, array('class'=>'category'.$this->params->get( 'pageclass_sfx' )) );
							echo JHTML::_('link',$item->contact_link,$item->contact_name, array('class'=>'category'.$this->params->get( 'pageclass_sfx' )) );
						}elseif($this->params->get( 'show_contact_image','tooltip' ) == 'tooltip' AND $item->contact_image){
							$image = JHTML::_('image',  JURI::base(). $item->contact_image, JText::sprintf('COM_CONTACTENHANCED_CONTACT_IMAGE_ALT',$item->contact_name ), array('align' => 'middle', 'class'=> 'ce-contact-img-cat'));
							$image	= JHTML::tooltip($image,$item->contact_name,'',$item->contact_name);
							echo JHTML::_('link',$item->contact_link,$image, array('class'=>'category'.$this->params->get( 'pageclass_sfx' )) );
						}else{
							echo JHTML::_('link',$item->contact_link,$item->contact_name, array('class'=>'category'.$this->params->get( 'pageclass_sfx' )) );
						}
					?>
					</td>
					<?php endif; ?>
					<?php if($this->params->get('show_date_headings')) :
					$date = JFactory::getDate($item->date); ?>
					<td class="item-date" title="<?php echo $date->format(JText::_('DATE_FORMAT_LC2')); ?>">
						<?php echo ceHelper::timeDifference($item->date, 'short');?>
					</td>
					<?php endif; ?>
					<?php if($this->params->get('show_category_headings')) : ?>
					<td class="item-category">
						<?php echo $item->category_title; ?>
					</td>
					<?php endif; ?>
					<?php if($this->params->get('show_id_headings')) : ?>
					<td class="item-id">
						<?php echo $item->id; ?>
					</td>
					<?php endif; ?>

				</tr>
			<?php endforeach; ?>

		</tbody>
	</table>

	<?php if($this->params->get('show_pagination')) : ?>
	<div class="pagination">
		<?php if($this->params->def('show_pagination_results', 1)) : ?>
		<p class="counter">
			<?php echo $this->pagination->getPagesCounter(); ?>
		</p>
		<?php endif; ?>
		<?php echo $this->pagination->getPagesLinks(); ?>
	</div>
	<?php endif; ?>
<?php endif; ?>
	<div>
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
		<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
	</div>
</form>
