<?php
/**
 * @version		3.3.2
 * @package		com_contactenhanced
 * @copyright	Copyright (C) 2006 - 2015 IdealExtensions.com. All rights reserved
 * @license		GNU GPL2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

JHTML::_('behavior.framework');
JHTML::_('behavior.tooltip');

$listOrder	= $this->state->get('list.ordering');
$listDirn	= $this->state->get('list.direction');
$app		= JFactory::getApplication();
?>
<?php if (empty($this->items)) : ?>
	<p> <?php echo JText::_('COM_CONTACTENHANCED_SEARCH_RESULT_EMPTY'); ?>	 </p>
<?php else : ?>

<form action="<?php echo htmlspecialchars(JFilterOutput::ampReplace(JFactory::getURI()->toString())); ?>" method="post" name="adminForm" id="adminForm">

	<table class="category  table table-bordered table-striped">
		<?php if($this->params->get('show_headings')) :
		$allowOrdering = ($this->params->get('show_headings') == 'ordering' ? true : false);
		?>

		<thead><tr>

			<th class="item-title">
				<?php
				if($allowOrdering){
					echo JHtml::_('grid.sort', 'COM_CONTACTENHANCED_CONTACT_EMAIL_NAME', 'a.name', $listDirn, $listOrder);
				}else{
					echo JText::_('COM_CONTACTENHANCED_CONTACT_EMAIL_NAME');
				}
				?>
			</th>

			<?php if($this->params->get('show_department_headings')) : ?>
			<th class="item-department hidden-phone hidden-xs">
				<?php
				if($allowOrdering){
					echo JHtml::_('grid.sort', 'COM_CONTACTENHANCED_DEPARTMENT', 'a.department', $listDirn, $listOrder);
				}else{
					echo JText::_('COM_CONTACTENHANCED_DEPARTMENT');
				}
				?>
			</th>
			<?php endif; ?>

			<?php if($this->params->get('show_position_headings')) : ?>
			<th class="item-position">
				<?php
				if($allowOrdering){
					echo JHtml::_('grid.sort', 'COM_CONTACTENHANCED_POSITION', 'a.con_position', $listDirn, $listOrder);
				}else{
					echo JText::_('COM_CONTACTENHANCED_POSITION');
				}
				?>
			</th>
			<?php endif; ?>


			<?php if($this->params->get('show_email_headings')) : ?>
			<th class="item-email hidden-phone hidden-xs">
				<?php echo JText::_('JGLOBAL_EMAIL'); ?>
			</th>
			<?php endif; ?>
			<?php if($this->params->get('show_telephone_headings')) : ?>
			<th class="item-phone">
				<?php echo JText::_('COM_CONTACTENHANCED_TELEPHONE'); ?>
			</th>
			<?php endif; ?>

			<?php if($this->params->get('show_mobile_headings')) : ?>
			<th class="item-phone hidden-phone hidden-xs">
				<?php echo JText::_('COM_CONTACTENHANCED_MOBILE'); ?>
			</th>
			<?php endif; ?>

			<?php if($this->params->get('show_fax_headings')) : ?>
			<th class="item-phone hidden-phone hidden-xs">
				<?php echo JText::_('COM_CONTACTENHANCED_FAX'); ?>
			</th>
			<?php endif; ?>

			<?php if($this->params->get('show_street_address_headings')) : ?>
			<th class="item-street-address hidden-phone hidden-xs">
				<?php
				if($allowOrdering){
					echo JHtml::_('grid.sort', 'COM_CONTACTENHANCED_ADDRESS', 'a.address', $listDirn, $listOrder);
				}else{
					echo JText::_('COM_CONTACTENHANCED_ADDRESS');
				}
				?>
			</th>
			<?php endif; ?>

			<?php if($this->params->get('show_suburb_headings')) : ?>
			<th class="item-suburb hidden-phone hidden-xs">
				<?php
				if($allowOrdering){
					echo JHtml::_('grid.sort', 'COM_CONTACTENHANCED_SUBURB', 'a.suburb', $listDirn, $listOrder);
				}else{
					echo JText::_('COM_CONTACTENHANCED_SUBURB');
				}
				?>
			</th>
			<?php endif; ?>

			<?php if($this->params->get('show_state_headings')) : ?>
			<th class="item-state hidden-phone hidden-xs">
				<?php
				if($allowOrdering){
					echo JHtml::_('grid.sort', 'COM_CONTACTENHANCED_STATE', 'a.state', $listDirn, $listOrder);
				}else{
					echo JText::_('COM_CONTACTENHANCED_STATE');
				}
				?>
			</th>
			<?php endif; ?>

			<?php if($this->params->get('show_postcode_headings')) : ?>
			<th class="item-postcode  hidden-phone hidden-xs">
				<?php
				if($allowOrdering){
					echo JHtml::_('grid.sort', 'COM_CONTACTENHANCED_POSTCODE', 'a.postcode', $listDirn, $listOrder);
				}else{
					echo JText::_('COM_CONTACTENHANCED_POSTCODE');
				}
				?>
			</th>
			<?php endif; ?>

			<?php if($this->params->get('show_country_headings')) : ?>
			<th class="item-country  hidden-phone hidden-xs">
				<?php
				if($allowOrdering){
					echo JHtml::_('grid.sort', 'COM_CONTACTENHANCED_COUNTRY', 'a.country', $listDirn, $listOrder);
				}else{
					echo JText::_('COM_CONTACTENHANCED_COUNTRY');
				}
				?>
			</th>
			<?php endif; ?>

			<?php if($this->params->get('show_webpage_headings')) : ?>
			<th class="item-webpage  hidden-phone hidden-xs">
				<?php echo JText::_('COM_CONTACTENHANCED_WEBPAGE'); ?>
			</th>
			<?php endif; ?>
			<?php for ($i = 1; $i <= 10; $i++): ?>
				<?php if($this->params->get('show_extrafield_'.$i.'_headings')) : ?>
				<th class="item-extra_field_<?php echo $i; ?>">
					<?php
					if($allowOrdering){
						echo JHtml::_('grid.sort', 'COM_CONTACTENHANCED_FIELD_INFORMATION_EXTRA_FIELD_'.$i.'_LABEL', 'a.extra_field_'.$i, $listDirn, $listOrder);
					}else{
						echo JText::_('COM_CONTACTENHANCED_FIELD_INFORMATION_EXTRA_FIELD_'.$i.'_LABEL');
					}
					?>
				</th>
				<?php endif; ?>
			<?php endfor; ?>

			</tr>
		</thead>
		<?php endif; ?>

		<tbody>
			<?php foreach($this->items as $i => $item) : ?>
				<?php if($this->items[$i]->published == 0) : ?>
					<tr class="system-unpublished cat-list-row<?php echo $i % 2; ?>">
				<?php else: ?>
					<tr class="cat-list-row<?php echo $i % 2; ?>" >
				<?php endif; ?>

					<td class="item-title">
						<?php
						$item->link = JRoute::_(ContactenchancedHelperRoute::getContactRoute($item->slug, $item->catid));
						if($this->params->get( 'show_contact_image' ) == '1' AND $item->image ){
							$image = JHTML::_('image',  JURI::base(). $item->image, JText::sprintf('COM_CONTACTENHANCED_CONTACT_IMAGE_ALT',$item->name ), array('align' => 'middle', 'class'=> 'ce-contact-img-cat'));
							echo JHTML::_('link',$item->link,$image, array('class'=>'category'.$this->params->get( 'pageclass_sfx' )) );
							echo JHTML::_('link',$item->link,$item->name, array('class'=>'category'.$this->params->get( 'pageclass_sfx' )) );
						}elseif($this->params->get( 'show_contact_image','tooltip' ) == 'tooltip' AND $item->image){
							$image = JHTML::_('image',  JURI::base(). $item->image, JText::sprintf('COM_CONTACTENHANCED_CONTACT_IMAGE_ALT',$item->name ), array('align' => 'middle', 'class'=> 'ce-contact-img-cat'));
							$image	= JHTML::tooltip($image,$item->name,'',$item->name);
							echo JHTML::_('link',$item->link,$image, array('class'=>'category'.$this->params->get( 'pageclass_sfx' )) );
						}else{
							echo JHTML::_('link',$item->link,$item->name, array('class'=>'category'.$this->params->get( 'pageclass_sfx' )) );
						}
					?>
					</td>

					<?php if($this->params->get('show_department_headings')) : ?>
						<td class="item-department hidden-phone hidden-xs">
							<?php echo $item->department; ?>
						</td>
					<?php endif; ?>

					<?php if($this->params->get('show_position_headings')) : ?>
						<td class="item-position">
							<?php echo $item->con_position; ?>
						</td>
					<?php endif; ?>

					<?php if($this->params->get('show_email_headings')) : ?>
						<td class="item-email hidden-phone hidden-xs">
							<?php echo $item->email_to; ?>
						</td>
					<?php endif; ?>

					<?php if($this->params->get('show_telephone_headings')) : ?>
						<td class="item-phone">
							<?php
								$tel	= nl2br($item->telephone);
								if($this->browser->isMobile()){
									$telLink= 'tel:'.preg_replace('[(?!\+\b)\D]', '', $tel);
									$tel	= JHtml::_('link'
														,$telLink
														,$tel
														, array('title' => JText::sprintf('COM_CONTACTENHANCED_CALL_USING_YOUR_PHONE',$tel))
														);
								}
								echo ($tel);
							?>

						</td>
					<?php endif; ?>

					<?php if($this->params->get('show_mobile_headings')) : ?>
						<td class="item-phone   hidden-phone hidden-xs">
							<?php
								$tel	= nl2br($item->mobile);
								if($this->browser->isMobile()){
									$telLink= 'tel:'.preg_replace('[(?!\+\b)\D]', '', $tel);
									$tel	= JHtml::_('link'
														,$telLink
														,$tel
														, array('title' => JText::sprintf('COM_CONTACTENHANCED_CALL_USING_YOUR_PHONE',$tel))
														);
								}
								echo ($tel);
							?>
						</td>
					<?php endif; ?>

					<?php if($this->params->get('show_fax_headings')) : ?>
					<td class="item-phone   hidden-phone hidden-xs">
						<?php echo $item->fax; ?>
					</td>
					<?php endif; ?>

					<?php if($this->params->get('show_street_address_headings')) : ?>
					<td class="item-street-address">
						<?php echo $item->address; ?>
					</td>
					<?php endif; ?>

					<?php if($this->params->get('show_suburb_headings')) : ?>
					<td class="item-suburb hidden-phone hidden-xs">
						<?php echo $item->suburb; ?>
					</td>
					<?php endif; ?>

					<?php if($this->params->get('show_state_headings')) : ?>
					<td class="item-state hidden-phone hidden-xs">
						<?php echo $item->state; ?>
					</td>
					<?php endif; ?>

					<?php if($this->params->get('show_postcode_headings')) : ?>
					<td class="item-postcode    hidden-phone hidden-xs">
						<?php echo $item->postcode; ?>
					</td>
					<?php endif; ?>

					<?php if($this->params->get('show_country_headings')) : ?>
					<td class="item-country   hidden-phone hidden-xs">
						<?php echo $item->country; ?>
					</td>
					<?php endif; ?>

					<?php if($this->params->get('show_webpage_headings')) : ?>
					<td class="item-webpage hidden-phone hidden-xs">
						<?php if($item->webpage): ?>
							<a href="<?php echo $item->webpage; ?>" title="<?php echo $item->webpage; ?>" target="_blank">
							<?php
								if($this->params->get('show_webpage_headings') == 'trim'){
									 echo ceHelper::trimURL(JStringPunycode::urlToUTF8($item->webpage));
								}elseif($this->params->get('show_webpage_headings') == 'label'){
									 echo JText::_('COM_CONTACTENHANCED_WEBPAGE_LABEL');
								}else{
									echo JStringPunycode::urlToUTF8($item->webpage);
								}
							?></a>
						<?php endif;  ?>
					</td>
					<?php endif; ?>

					<?php for ($i = 1; $i <= 10; $i++): ?>
						<?php if($this->params->get('show_extrafield_'.$i.'_headings')) : ?>
						<td class="item-extra_field_<?php echo $i; ?>">
							<?php
							$field	= "extra_field_".$i;
							 echo $item->$field; ?>
						</td>
						<?php endif; ?>
					<?php endfor; ?>

				</tr>
			<?php endforeach; ?>

		</tbody>
	</table>
<?php if($this->params->get('show_pagination_limit')) : ?>
	<fieldset class="filters">
	<legend class="hidelabeltxt"><?php echo JText::_('JGLOBAL_FILTER_LABEL'); ?></legend>

		<div class="display-limit">
			<?php echo JText::_('JGLOBAL_DISPLAY_NUM'); ?>&#160;
			<?php echo $this->pagination->getLimitBox(); ?>
		</div>
	</fieldset>
<?php endif; ?>
	<?php if($this->params->get('show_pagination')) : ?>
	<div class="pagination">
		<?php if($this->params->def('show_pagination_results', 1)) : ?>
		<p class="counter">
			<?php echo $this->pagination->getPagesCounter(); ?>
		</p>
		<?php endif; ?>
		<?php echo $this->pagination->getPagesLinks(); ?>
	</div>
	<?php endif; ?>
	<div>
		<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
		<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
		<input type="hidden" name="view" value="search" />
		<input type="hidden" name="option" value="com_contactenhanced" />
		<input type="hidden" name="q" value="<?php echo $this->state->get('filter.searchquery'); ?>" />
		<input type="hidden" name="state"	value="<?php echo $this->filter_state; ?>" />
		<input type="hidden" name="country" value="<?php echo $this->filter_country; ?>" />
		<input type="hidden" name="suburb"	value="<?php echo $this->filter_suburb; ?>" />
		
		<input type="hidden" name="category_filtering_type"	value="<?php echo $app->input->getCmd('category_filtering_type',$this->params->get('category_filtering_type','inclusive')); ?>" />
		<input type="hidden" name="maxLevel"		value="<?php echo $app->input->getCmd('maxLevel',$this->params->get('maxLevel',0)); ?>" />
		
		<?php if($app->input->getCmd('template')):?>
			<input type="hidden" name="template"	value="<?php echo $app->input->getCmd('template'); ?>" />
		<?php endif; ?>
		<?php if($app->input->getCmd('tmpl')):?>
			<input type="hidden" name="tmpl"		value="<?php echo $app->input->getCmd('tmpl'); ?>" />
		<?php endif; ?>
		<?php
		$catids = $app->input->getString('catids',  implode(',',(array)$this->params->get('catids')));
		if(!empty($catids)):?>
			<input type="hidden" name="catids"		value="<?php echo $catids; ?>" />
		<?php endif; ?>
	</div>
</form>
<?php endif; ?>