<?php
/**
 * @version		1.5.0
 * @package		Joomla
 * @subpackage	Doc Indexer
 * @author  Tuan Pham Ngoc
 * @copyright	Copyright (C) 2010 Ossolution Team
 * @license		GNU/GPL, see LICENSE.php
 */
class DixDocs {
	/**
	 * Get an indexer class
	 *
	 * @param string $type
	 */		
	function &getInstance($type) {
		static $instances ;
		if (!isset($instances[$type])) {
			require_once JPATH_ROOT.'/components/com_docindexer/helper/'.$type.'.php';
			$className = 'Dix'.strtoupper($type) ;
			$instances[$type] = new $className();
		}
		return $instances[$type] ;
	}
	/**
	 * Get text from selected documents
	 *
	 */
	function getText($fileName) {
		jimport('joomla.filesystem.file') ;
		$type = JString::strtolower(JFile::getExt($fileName)) ;
		$doc = $this->getInstance($type) ;
		return $doc->getText($fileName);
	}
}
?>