<?php
/**
 * @version		1.5.0
 * @package		Joomla
 * @subpackage	Doc Indexer
 * @author  Tuan Pham Ngoc
 * @copyright	Copyright (C) 2010 Ossolution Team
 * @license		GNU/GPL, see LICENSE.php
 */
global $supportedExtensions ;
$supportedExtensions = array('com_docman', 'com_edocman');
/**
 * Helper class for DocIndexer component
 *
 */
class DocIndexerHelper {
	/**
	 * Get configuration data and store in config object
	 *
	 * @return object
	 */
	public static function getConfig($nl2br = true) {
		$db = & JFactory::getDBO();
		$config = new stdClass ;
		$sql = 'SELECT * FROM #__dix_configs';
		$db->setQuery($sql);
		$rows = $db->loadObjectList();
		for ($i = 0 , $n = count($rows); $i < $n; $i++) {
			$row = $rows[$i];
			$key = $row->config_key;
			$value = stripslashes($row->config_value);
			if ($nl2br)
				$value = nl2br($value); 
			$config->$key = $value;	
		}
		return $config;
	}
	/**
	 * Get specify config value
	 *
	 * @param string $key
	 */
	public static function getConfigValue($key) {
		$db = & JFactory::getDBO() ;
		$sql = 'SELECT config_value FROM #__dix_configs WHERE config_key="'.$key.'"';
		$db->setQuery($sql) ;
		return $db->loadResult();
	}	
	/**
	 * Get Itemid of Joom Donation
	 *
	 * @return int
	 */
	public static function getItemid() {
		$db = & JFactory::getDBO();
		$sql = "SELECT id FROM #__menu WHERE link LIKE '%index.php?option=com_docindexer%'";
		$db->setQuery($sql) ;
		$itemId = $db->loadResult();		
		if (!$itemId) {
			global $Itemid ;
			if ($Itemid == 1)
				$itemId = 999999 ;
			else 
				$itemId = $Itemid ;	
		}			
		return $itemId ;	
	}
	/**
	 * Load language from main component
	 *
	 */
	public static function loadLanguage() {
		static $loaded ;
		if (!$loaded) {
			$lang = & JFactory::getLanguage() ;
			$tag = $lang->getTag();
			if (!$tag)
				$tag = 'en-GB' ;
			$lang->load('com_docindexer', JPATH_ROOT, $tag);
			$loaded = true ;	
		}		
	}
	
	
	public static function addSubMenus($vName) {
		JSubMenuHelper::addEntry(
			JText::_('Configuration'),
			'index.php?option=com_docindexer&view=configuration',
			$vName == 'configuration'
		);

		JSubMenuHelper::addEntry(
			JText::_('Documents'),
			'index.php?option=com_docindexer&view=docs',
			$vName == 'docs'
		);
	}	
	/**
	 * Format a filesize into short format
	 *
	 * @param int $size
	 * @return string
	 */
	public static function getSize($size)
    {
        $kb = 1024;
        $mb = 1024 * $kb;
        $gb = 1024 * $mb;
        $tb = 1024 * $gb;        
        if ($size) {
            if ($size < $kb) {
            	$final = round($size,2);
                $file_size = $final .' '.'Byte';
            }
            elseif ($size < $mb) {
                $final = round($size/$kb,2);
                $file_size = $final .' '. 'KB';
            }
            elseif ($size < $gb) {
                $final = round($size/$mb,2);
                $file_size = $final .' '. 'MB';
            }
            elseif($size < $tb) {
                $final = round($size/$gb,2);
                $file_size = $final .' '. 'GB';
            } else {
                $final = round($size/$tb,2);
                $file_size = $final .' '. 'TB';
            }
        } else {
	       if( $size == 0 ) {
	           $file_size = 'EMPTY';
           } else {
                $file_size = 'ERROR';
           }
        }
        return $file_size;
    }
  	/**
  	 * Get detail link to documents
  	 *
  	 * @param string $component
  	 * @return string link to the component
  	 */  
    public static function getDetailLink($component, $id) {
    	$db = & JFactory::getDBO();
    	$url = JRoute::_('index.php?option=com_docindexer&task=download&id='.$id);
    	$sql = "SELECT filename FROM #__dix_docs WHERE id=".$id ;
    	$db->setQuery($sql) ;
    	$filename = $db->loadResult();    	
    	switch ($component) {
    		case 'com_docman' :
    			$sql = 'SELECT id FROM #__docman where dmfilename="'.$filename.'"';
    			$db->setQuery($sql) ;
    			$docmanId = $db->loadResult();
    			if ($docmanId) {
    				$url = JRoute::_('index.php?option=com_docman&task=doc_details&gid='.$docmanId);	
    			}    				
    			break ;	
    	}
    	return $url ;    
    }
}
?>