<?php
/**
* @package		EasySocial
* @copyright	Copyright (C) 2010 - 2014 Stack Ideas Sdn Bhd. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* EasySocial is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/
defined( '_JEXEC' ) or die( 'Unauthorized Access' );

// Include the fields library
FD::import( 'admin:/includes/fields/dependencies' );

// Include helper file.
FD::import( 'fields:/user/joomla_username/helper' );

/**
 * Processes ajax calls for the Joomla_Username field.
 *
 * @since	1.0
 * @author	Jason Rey <jasonrey@stackideas.com>
 */
class SocialFieldsUserTerms extends SocialFieldItem
{
	/**
	 * Retrieves the terms and conditions text
	 *
	 * @since	1.3
	 * @access	public
	 * @param	string
	 * @return
	 */
	public function getTerms()
	{
		// Render the ajax lib.
		$ajax = FD::ajax();

		// Load the field
		$id   = $this->input->get('id', 0, 'int');
		$this->field = FD::table('Field');
		$this->field->load($id);

		// Get the field params
		$params = $this->getParams();


		$theme = FD::themes();

		$theme->set('params', $params);

		$output = $theme->output('fields/user/terms/dialog.terms');

		return $ajax->resolve($output);
	}

}
