<?php
/**
 * @version		1.6.0
 * @package		plg_captcha_securimage
 * @copyright	Copyright (C) 2006 - 2010 Ideal Custom Software Development
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('JPATH_BASE') or die;

jimport('joomla.html.html');
jimport('joomla.form.formfield');

/**
 * Form Field class for the Joomla Framework.
 *
 * @package		plg_captcha_securimage
* @since		1.6
 */

class JFormFieldImagethumbnails extends JFormField
{
	/**
	 * The form field type.
	 *
	 * @var		string
	 * @since	1.6
	 */
	protected $type = 'Imagethumbnails';

	function getInput()
	{
		jimport( 'joomla.filesystem.folder' );
		jimport( 'joomla.filesystem.file' );

		// path to images directory


		$options = (array) $this->getOptions();
		$name		= $this->name;

		$thumbImage		= $this->element['name'].'-thumbnail-image';
		$thumbContainer	= $this->element['name'].'-thumbnail-container';
		$functionName 	= str_replace('-', '', $this->element['name']).'Test';
		$doc = JFactory::getDocument();
		$doc->addScriptDeclaration("
function {$functionName}(el){
	var el = jQuery('#'+el);
	jQuery('#$thumbContainer .btn').remove();
	if(el.val().indexOf('bootstrap') == 0){
		var icon = el.val().replace('bootstrap ', '');
		jQuery('<i>',{
		    title: 'Bootstrap icon',
		    class: 'btn btn-default icon-'+icon+' glyphicon glyphicon-'+icon
		}).appendTo('#$thumbContainer');
		var imgSrc = '".JURI::root()."plugins/captcha/securimage/lib/images/transparent-dot.png';
	}else if(el.val() == -1 || el.val() == ''){
		var imgSrc = '".JURI::root()."plugins/captcha/securimage/lib/images/transparent-dot.png';
	}else{
		var imgSrc = '".JURI::root().$this->element['directory']."'+el.val();
	}
	jQuery('#{$thumbImage}').attr('src',imgSrc);
}
");
		$javascript=" onchange=\"{$functionName}(this.id); return false;\" ";
	//	$javascript=" onchange=\"$('".$thumbImage."').src='".JURI::root().$this->element['directory']."'+this.value;\" ";
		return JHtml::_('select.genericlist', $options, $this->name, 'class="inputbox"'.$javascript, 'value', 'text', $this->value, $this->id)
				.'<span id="'.$thumbContainer.'"><img id="'.$thumbImage.'" src="'
				.JURI::root().(($this->value != '-1' AND $this->value) ? $this->element['directory'].$this->value : 'plugins/captcha/securimage/lib/images/transparent-dot.png').'" /></span>'
				;
	}

	/**
	 * Method to get the field options.
	 *
	 * @return  array  The field option objects.
	 *
	 * @since   11.1
	 */
	protected function getOptions()
	{
		$options = array();

		if (!$this->element['hide_none'])
		{
			$options[] = JHTML::_('select.option', '-1', '- '.JText::_('Do not use').' -');
		}

		if (!$this->element['hide_default'])
		{
			$options[] = JHTML::_('select.option', '', '- '.JText::_('Use default').' -');
		}

			foreach ($this->element->children() as $option)
		{
			// Only add <option /> elements.
			if ($option->getName() != 'option')
			{
				continue;
			}

			// Filter requirements
			if ($requires = explode(',', (string) $option['requires']))
			{
				// Requires multilanguage
				if (in_array('multilanguage', $requires) && !JLanguageMultilang::isEnabled())
				{
					continue;
				}

				// Requires associations
				if (in_array('associations', $requires) && !JLanguageAssociations::isEnabled())
				{
					continue;
				}
			}

			$value = (string) $option['value'];

			$disabled = (string) $option['disabled'];
			$disabled = ($disabled == 'true' || $disabled == 'disabled' || $disabled == '1');

			$disabled = $disabled || ($this->readonly && $value != $this->value);

			// Create a new option object based on the <option /> element.
			$tmp = JHtml::_(
					'select.option', $value,
					JText::alt(trim((string) $option), preg_replace('/[^a-zA-Z0-9_\-]/', '_', $this->fieldname)), 'value', 'text',
					$disabled
			);

			// Set some option attributes.
			$tmp->class = (string) $option['class'];

			// Set some JavaScript option attributes.
			$tmp->onclick = (string) $option['onclick'];

			// Add the option object to the result set.
			$options[] = $tmp;
		}



		$path		= JPATH_ROOT.'/'.$this->element['directory'];

		//$filter		= $node->attributes('filter');
		$filter = '\.png$|\.gif$|\.jpg$|\.bmp$|\.ico$';
		$exclude	= $this->element['exclude'];
		$stripExt	= $this->element['stripext'];
		$files		= JFolder::files($path, $filter);

		if ( is_array($files) )
		{
			foreach ($files as $file)
			{
				if ($exclude)
				{
					if (preg_match( chr( 1 ) . $exclude . chr( 1 ), $file ))
					{
						continue;
					}
				}
				if ($stripExt)
				{
					$file = JFile::stripExt( $file );
				}
				$options[] = JHTML::_('select.option', $file, $file);
			}
		}

		reset($options);
		return $options;
	}
}
