<?php
/**
 * @package		com_contactenhanced
 * @copyright	Copyright (C) 2006 - 2015 IdealExtensions.com. All rights reserved.
 * @license		GNU GPL2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;
jimport('joomla.plugin.plugin');
/**
 * Editor Article buton
 *
 * @package Editors-xtd
 * @since 1.5
 */
class plgButtonContactenhanced extends JPlugin
{
	/**
	 * Constructor
	 *
	 * @access	  protected
	 * @param	   object  $subject The object to observe
	 * @param	   array   $config  An array that holds the plugin configuration
	 * @since	   1.5
	 */
	public function __construct(& $subject, $config)
	{
		parent::__construct($subject, $config);
		$this->loadLanguage();
		$lang =JFactory::getLanguage();
		$lang->load('com_contactenhanced');
		$lang->load('com_contactenhanced',JPATH_ROOT.'/components/com_contactenhanced');
		$lang->load('plg_editors-xtd_contactenhanced',JPATH_ROOT.'/plugin/editors-xtd/contactenhanced');
	}

	/**
	 * Display the button
	 *
	 * @return array A four element array of (article_id, article_title, category_id, object)
	 */
	function onDisplay($name)
	{
		$app = JFactory::getApplication();
		if(	!$app->isAdmin()){
		//	return false;
		}
		if(!is_file(JPATH_ROOT.'/components/com_contactenhanced/controller.php')){
			return false; // Contact Enhanced is not installed;
		}
		/*
		 * Javascript to insert the link
		 * View element calls jSelectArticle when an article is clicked
		 * jSelectArticle creates the link tag, sends it to the editor,
		 * and closes the select frame.
		 */
		if(
			(is_array($this->params->get('avoid_components'))
				AND in_array(JRequest::getVar('option'),$this->params->get('avoid_components',array())))
			OR (!is_array($this->params->get('avoid_components'))
				AND JRequest::getVar('option') == 'com_contactenhanced')
		){
			return '';
		}
		$js = "
		function jSelectContactPlugin(id, title, options) {
			var tag = '{loadcontact id=|'+id+'| '+options+'}';
			jInsertEditorText(tag, '".$name."');
			SqueezeBox.close();
		}";
		$doc = JFactory::getDocument();
		$doc->addScriptDeclaration($js);
		$doc->addStyleDeclaration(
			'.icon-contactenhanced:before{content:"\0022";color:#51A351}'
			);
		JHTML::_('behavior.modal');
		/*
		 * Use the built-in element view to select the article.
		 * Currently uses blank class.
		 */
		$link = 'index.php?option=com_contactenhanced&amp;view=contacts&amp;layout=modal&amp;tmpl=component&function=jSelectContactPlugin';
		$button = new JObject();
		$button->set('modal', true);
		$button->set('link', $link);
		$button->class = 'btn btn-default';
		$button->set('text', JText::_('PLG_CONTACTENHANCED_BUTTON_CE'));
		$button->set('name', 'contactenhanced');
		$button->set('options', "{handler: 'iframe', size: {x: 770, y: 400}}");
		return $button;
	}
}