<?php
/**
 * @package		CEFeedback
 * @author		Douglas Machado {@link http://idealextensions.com}
 * @author		Created on 22-Jan-2011
 * @license		GNU/GPL, see license.txt
 */
defined('_JEXEC') or die;
jimport('joomla.plugin.plugin');
/**
 * Example System Plugin
 *
 * @package		CEFeedback
 * @subpackage	Plugin
 */
class plgSystemCEFeedback extends JPlugin
{
	/**
	 * Object Constructor.
	 *
	 * @access	public
	 * @param	object	The object to observe -- event dispatcher.
	 * @param	object	The configuration object for the plugin.
	 * @return	void
	 * @since	1.0
	 */
	function __construct(&$subject, $config){
		parent::__construct($subject, $config);
	}
	/**
	 * Add style
	 */
	function onAfterDispatch(){
		require_once JPATH_ROOT.'/components/com_contactenhanced/helpers/ceModalHelper.php';
		$name = $this->get('_name');
		//CSS
		if (!ceModalHelper::checkLoadPermissions($this->params)) {
			return '';
		}
		$selector	= $name.'-modal-window';
		ceModalHelper::loadJS($this->params,$selector);
		$js			= '';
		$lang =JFactory::getLanguage();
		$imagePath		= '/plugins/system/cefeedback/images/';
		$imagePathHover	= $imagePath;
		$image			= $this->params->get('feedback-image',		'feedback-red.png');
		$imageHover		= $this->params->get('feedback-image-hover','feedback-orange.png');

		if(is_readable(JPATH_ROOT.$imagePath.$lang->getTag().'/'.$image)){
			$imagePath	.= $lang->getTag().'/';
		}else{
			$imagePath	.= 'en-GB/';
		}

		if(is_readable(JPATH_ROOT.$imagePathHover.$lang->getTag().'/'.$imageHover)){
			$imagePathHover	.= $lang->getTag().'/';
		}else{
			$imagePathHover	.= 'en-GB/';
		}

		// Keep compatibility with older versions
		if($this->params->get('feedback-link-width')){
			// Preload image after the DOM is ready for 2 seconds
			$js		= "setTimeout(function(){var img=new Image();img.src = '".JURI::base(true).$imagePathHover.$imageHover."';},2000);";

			// using JURI::base(true) instead of JURI::root() in order to work correctly with SSL
			$style	= ".cefeedback a{"
					.$this->params->get('position','right').":0;"
					.'background:url("'.JURI::base(true).$imagePath.$image.'") no-repeat scroll 0 50% transparent !important;'
					."outline:medium none;"
					."padding:0 !important;"
					."position:fixed;"
					."z-index:99995;"
					."text-indent:-9999px;"
					."top:".$this->params->get('feedback-link-distance',45)."%;"
					."width:".$this->params->get('feedback-link-width',26)."px;"
					."height:".$this->params->get('feedback-link-height',100)."px;"
			."}"
			."a.cefeedback:hover,a.cefeedback:focus,a.cefeedback:active{"
				.'background:url("'.JURI::base(true).$imagePathHover.$imageHover.'") no-repeat scroll 0 50% transparent !important;'
			."}";
		}else{
			$basesize 			= $this->params->get('feedback-font-size',20);
			$fontFamily			= $this->params->get('feedback-font-family','inherited');
			$backgroundColor 	= $this->params->get('feedback-background-color','FFB22E');
			$textColor 			= $this->params->get('feedback-text-color','FFF');
			$borderColor 		= $this->params->get('feedback-border-color','D59718');
			$boxShadow			= $this->hex2rgb($this->params->get('feedback-box-shadow','FFFFFF'), 65);

			$mouseOverBackgroundColor 	= $this->params->get('feedback-mouseover-background-color','FFB22E');
			$mouseOverTextColor 		= $this->params->get('feedback-mouseover-text-color','FFF');
			$mouseOverBorderColor 		= $this->params->get('feedback-mouseover-border-color','D59718');
			$mouseOverBoxShadow			= $this->hex2rgb($this->params->get('feedback-mouseover-box-shadow','FFFF00'), 75);
			$style	= "
.{$name} {
	width:40px;
	height: 100%;
	position: fixed;"
	.$this->params->get('position','right'). ":".($this->params->get('position') == 'left' ? '-10px' : 0). ";
	top:".$this->params->get('feedback-link-distance',45)."%;
	z-index: 9999;
}

.{$name} a {
	background-color:#".$backgroundColor.";
	border: 2px solid #".$borderColor.";
	border-radius:10px;
	white-space:nowrap;
	font-family: {$fontFamily};
	font-weight: 700;
	font-size: ".$basesize."px;
	display: block;
	color: #".$textColor.";
	text-decoration: none;
	padding-left: 20px;
	padding-right: 20px;
	padding-bottom: ".intval($basesize/3)."px;
	line-height: ".($basesize*2)."px;
	position: absolute;
	top: 0;
	text-align:center;
	transform: rotate(-90deg);
	transform-origin: 30px;
	-webkit-transform: rotate(-90deg);
	-webkit-transform-origin: 30px;
	-ms-transform: rotate(-90deg);
	-ms-transform-origin: 30px;
	-o-transform: rotate(-90deg);
	-o-transform-origin: 30px;
	filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=3);
	 /* IE8+ - must be on one line, unfortunately */
   -ms-filter: \"progid:DXImageTransform.Microsoft.Matrix(M11=3.061616999114022e-16, M12=1, M21=-1, M22=3.061616999114022e-16, SizingMethod='auto expand')\";
   /* IE6 and 7 */
   filter: progid:DXImageTransform.Microsoft.Matrix(
			M11=3.061616999114022e-16,
			M12=1,
			M21=-1,
			M22=3.061616999114022e-16,
			SizingMethod='auto expand');
	-moz-box-shadow:  3px 0 8px 1px {$boxShadow} inset;
	-webkit-box-shadow: 3px 0 8px 1px {$boxShadow} inset;
	box-shadow:  3px 0 8px 1px {$boxShadow} inset;
	z-index:99999;
}
.{$name} a:hover{
	background-color:#".$mouseOverBackgroundColor.";
	border: 2px solid #".$mouseOverBorderColor.";
	color: #".$mouseOverTextColor.";
	-moz-box-shadow:  3px 0 8px 1px {$mouseOverBoxShadow} inset;
	-webkit-box-shadow: 3px 0 8px 1px {$mouseOverBoxShadow} inset;
	box-shadow:  3px 0 8px 1px {$mouseOverBoxShadow} inset;
}
";
		}
		
		$doc	= JFactory::getDocument();
		$doc->addStyleDeclaration($style."\n".$this->params->get('css',''));

		
	}
	
	
	
	/**
	 * Add Link
	 */
	function onAfterRender()
	{
		if (!ceModalHelper::checkLoadPermissions($this->params)) {
			return '';
		}
		$name = $this->get('_name');
		$feedbackDesc = $name == 'cefeedback_copy' ? 'CE_PLUGIN_FEEDBACK_COPY_DESC' : 'CE_PLUGIN_FEEDBACK_DESC';
		$html	= array();
		$params	= array();
		$selector	= $name.'-modal-window';
		$browser	= new iBrowser();
		$document=JFactory::getDocument();
		$lang =JFactory::getLanguage();
		$lang->load('com_contactenhanced');
		$lang->load('com_contactenhanced',JPATH_ROOT.'/components/com_contactenhanced');
		$lang->load('plg_system_cefeedback',JPATH_ROOT.'/plugins/system/cefeedback');

		$attributes	= array();
		$attributes['id']	= $selector."-button";
		if($this->params->get('modal',1)){
			$attributes['data-toggle']	= "modal";
			$attributes['data-target']	= $selector;
		}
		$attributes['title']= '';
		$attributes['class']= 'no-print';

		// get link
		if($this->params->get('media') == 'url' AND $this->params->get('media-url-link')){
			$params['url']	= $this->params->get('media-url-link');
		}elseif ($this->params->get('media') == 'article' AND $this->params->get('media-article-id')){
			$params['url']	= JURI::base(true).'/index.php?option=com_content&view=article&id='
						.$this->params->get('media-article-id',1);
			if(!$browser->isMobile() OR $this->params->get('loadonmobile',0) != 'full' OR $this->params->get('modal',1) ){
				$params['url']	.= ($this->params->get('media-article-tmpl') ? '&tmpl='.$this->params->get('media-article-tmpl') : '');
			}

			$params['url']	.= ($this->params->get('template') ? '&amp;template='.$this->params->get('template') : '');
		// DEFAULT
		}else{
			if($this->params->get('modal',1) OR ($browser->isMobile() AND $this->params->get('loadonmobile',0) != 'full')){
				$tmpl	= '&amp;tmpl=component';
			}else{
				$tmpl	= '';
			}
			$params['url']	= JURI::root().('index.php?option=com_contactenhanced&amp;view=contact&amp;id='
					.$this->params->get('media-ce-id',1)
					.( isset($row->title) ? '&amp;content_title='.ceHelper::encode($row->title, 'base64') : '')
					.'&amp;content_url='.ceHelper::encode(ceHelper::getCurrentURL(),'base64')
					.$tmpl
					.($this->params->get('template')	? '&amp;template='.$this->params->get('template')	: '')
					.'&amp;plugin_load_method=modal'
			);
		}
		$html[] = '<span class="'.$name.'">'
					.JHtml::_('link',$params['url'], ' '.$this->params->get('feedback-text',JText::_($feedbackDesc)).' ',$attributes )
				.'</span>';
		if($this->params->get('modal',1)){
			
			$params['title']  = $this->params->get('modal-title', JText::_('CE_PLUGIN_FEEDBACK_DESC'));
			$params['height'] = $this->params->get('window-size-height',400);
			$params['width']  = $this->params->get('window-size-width',800);
			$footer = $this->params->get('modal-footer', '');

			if($this->params->get('modal') == 'jQueryDialog'){ 
				$html[] = ceModalHelper::jQueryDialog($selector, $params, $footer);
			}else{
				JHtml::_('bootstrap.framework');
				$html[] = JHtml::_('bootstrap.renderModal', $selector, $params, $footer);
			}
			
		}
		$html = implode("\n", $html);
		// Add link before the </body> tag
		$body = JResponse::getBody();
		$body = str_replace('</body>', $html.'</body>', $body);
		JResponse::setBody($body);
	}
	
	public function hex2rgb($hex, $opacity=100) {
		$hex = str_replace("#", "", $hex);

		if(strlen($hex) == 3) {
			$r = hexdec(substr($hex,0,1).substr($hex,0,1));
			$g = hexdec(substr($hex,1,1).substr($hex,1,1));
			$b = hexdec(substr($hex,2,1).substr($hex,2,1));
		} else {
			$r = hexdec(substr($hex,0,2));
			$g = hexdec(substr($hex,2,2));
			$b = hexdec(substr($hex,4,2));
		}
		if($opacity > 1){
			$opacity = $opacity/100;
		}
		$rgba = array($r, $g, $b, $opacity);
		return 'rgba('.implode(",", $rgba).')'; // returns the rgb values separated by commas
		//return $rgba; // returns an array with the rgb values
	}
}
