<?php
/**
 * @license		GNU GPL2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

jimport('joomla.application.component.controlleradmin');

/**
 * @package		com_contactenhanced
 * @since	1.6
 */
class ContactenhancedControllerTools extends JControllerAdmin
{

	/**
	 * Constructor.
	 *
	 * @param	array	$config	An optional associative array of configuration settings.
	 *
	 * @return	ContactControllerContacts
	 * @see		JController
	 * @since	1.6
	 */
	public function __construct($config = array())
	{
		parent::__construct($config);

	}

	/**
	 *
	 * @author Douglas Machado <http>//idealextensions.com>
	 * @copyright
	 */
	public function importcsv() {
		$app	= JFactory::getApplication();
		$db		= JFactory::getDbo();

		require_once (JPATH_COMPONENT.'/helpers/csvhandler.php');

		$modelContact=$this->getModel('Contact'		,'ContactenhancedModel', array('ignore_request' => true));

		$file	= JRequest::getVar('csv_file', false, 'FILES');
		jimport('joomla.filesystem.file');

		if(JFile::getExt($file['name']) != 'csv'){
			throw new Exception(JText::sprintf('COM_CONTACTENHANED_TOOLS_IMPORT_FILE_EXTENSION_IS_NOT_CSV', $file['name']));
		}else{
			$csv	= new csvHandler();
			$csv->readFile($file['tmp_name']);

			$contactsCount	= 0;
			foreach ($csv->itemList as $contact) {
				if(!isset($contact['name'])){
					continue;
				}
				
				
				$table		= $modelContact->getTable();

				if(!isset($contact['catid']) OR !$contact['catid']){
					$contact['catid']	= JRequest::getVar('catid');
				}
				if(!isset($contact['published']) OR (int)$contact['published'] != 0){
					$contact['published']	= 1;
				}

				if(!isset($contact['language']) OR $contact['language'] != 0){
					$contact['language']	= '*';
				}

				$contact['id']	= null;

				// Bind the data.
				if (!$table->bind($contact)) {
					$modelContact->setError($table->getError());
					JError::raiseWarning(0, JText::sprintf('COM_CONTACTENHANCED_IMPORT_ERROR_CONTACT_NOT_IMPORTED',$contact['name'],$table->getError()));
					continue;
				}

				// Check the data.
				if (!$table->check(true)) {
					$modelContact->setError($table->getError());
					JError::raiseWarning(0, JText::sprintf('COM_CONTACTENHANCED_IMPORT_ERROR_CONTACT_NOT_IMPORTED',$contact['name'],$table->getError()));
					continue;
				}

				// Store the data.
				if (!$table->store()) {
					$modelContact->setError($table->getError());
					JError::raiseWarning(0, JText::sprintf('COM_CONTACTENHANCED_IMPORT_ERROR_CONTACT_NOT_IMPORTED',$contact['name'],$table->getError()));
					continue;
				}
				$contactsCount++;
			}

			JError::raiseNotice('', JText::sprintf('COM_CONTACTENHANCED_IMPORT_UPLOAD_FROM_CSV_RESULT', $contactsCount,$file['name']));
		}
		$this->setRedirect('index.php?option=com_contactenhanced&view=tools');
	}

	public function exportContactsXLS(){

		$config			= JFactory::getConfig();
		$error_reporting_level	= $config->get('config.error_reporting');
		if($error_reporting_level != 'development' AND $error_reporting_level != 'maximum'){
			error_reporting(0);
		}
		$modelContact	= $this->getModel('Contact'		,'ContactenhancedModel', array('ignore_request' => true));

		$db				= JFactory::getDBO();
		$query			= $db->getQuery(true);

		require_once(JPATH_COMPONENT.'/helpers/php-export-data.class.php');
		$exporter = new ExportDataExcel('browser', 'contactenhanced__'.date('Y-m-d_Hi').'.xls');
		$exporter->initialize();

		$headerLine = array();

		$tableColumns 	= $db->getTableColumns('#__ce_details');

		foreach($tableColumns as $key => $value){
			if($key != 'params'){
				$headerLine[]	= $key;
			}
		}
		$exporter->addRow($headerLine);

		$query->clear();
		$query->select('*');
		$query->from('#__ce_details');
		$db->setQuery($query);
		$contacts	= $db->loadAssocList('id');

		foreach($contacts AS $row){
			$line = array();
			foreach ($row as $key => $value) {
				if($key != 'params'){
					$line[] = $value;
				}
			}
			$exporter->addRow($line);
		}
		$exporter->finalize();
		exit;
	}

	public function exportContactsCSV(){

		$config			= JFactory::getConfig();
		$error_reporting_level	= $config->get('config.error_reporting');
		if($error_reporting_level != 'development' AND $error_reporting_level != 'maximum'){
			error_reporting(0);
		}

		$modelContact	= $this->getModel('Contact'		,'ContactenhancedModel', array('ignore_request' => true));

		$db				= JFactory::getDBO();
		$query			= $db->getQuery(true);

		require_once(JPATH_COMPONENT.'/helpers/csvhandler.php');
		$csv	= new csvHandler();

		$headerLine		= array(
					JText::_('JGLOBAL_FIELD_ID_LABEL')
				,	JText::_('COM_CONTACTENHANCED_FIELD_INFORMATION_NAME_LABEL')
				,	JText::_('JFIELD_ALIAS_LABEL')
				,	JText::_('COM_CONTACTENHANCED_FIELD_LINKED_USER_LABEL')
				,	JText::_('JSTATUS')
				,	JText::_('JCATEGORY')
				,	JText::_('COM_CONTACTENHANCED_FIELD_SORTNAME1_LABEL')
				,	JText::_('COM_CONTACTENHANCED_FIELD_SORTNAME2_LABEL')
				,	JText::_('COM_CONTACTENHANCED_FIELD_SORTNAME3_LABEL')
				,	JText::_('COM_CONTACTENHANCED_FIELD_INFORMATION_DEPARTMENT_LABEL')
				,	JText::_('COM_CONTACTENHANCED_FIELD_INFORMATION_CON_POSITION_LABEL')
				,	JText::_('COM_CONTACTENHANCED_FIELD_INFORMATION_EMAIL_LABEL')
				,	JText::_('COM_CONTACTENHANCED_FIELD_INFORMATION_ADDRESS_LABEL')
				,	JText::_('COM_CONTACTENHANCED_FIELD_INFORMATION_SUBURB_LABEL')
				,	JText::_('COM_CONTACTENHANCED_FIELD_INFORMATION_STATE_LABEL')
				,	JText::_('COM_CONTACTENHANCED_FIELD_INFORMATION_POSTCODE_LABEL')
				,	JText::_('COM_CONTACTENHANCED_FIELD_INFORMATION_COUNTRY_LABEL')
				,	JText::_('COM_CONTACTENHANCED_FIELD_INFORMATION_TELEPHONE_LABEL')
				,	JText::_('COM_CONTACTENHANCED_FIELD_INFORMATION_MOBILE_LABEL')
				,	JText::_('COM_CONTACTENHANCED_FIELD_INFORMATION_FAX_LABEL')
				,	JText::_('COM_CONTACTENHANCED_FIELD_INFORMATION_SKYPE_LABEL')
				,	JText::_('COM_CONTACTENHANCED_FIELD_INFORMATION_TWITTER_LABEL')
				,	JText::_('COM_CONTACTENHANCED_FIELD_INFORMATION_FACEBOOK_LABEL')
				,	JText::_('COM_CONTACTENHANCED_FIELD_INFORMATION_LINKEDIN_LABEL')
				,	JText::_('COM_CONTACTENHANCED_FIELD_INFORMATION_WEBPAGE_LABEL')
				,	JText::_('COM_CONTACTENHANCED_FIELD_INFORMATION_BIRTHDATE_DESC')
				,	JText::_('COM_CONTACTENHANCED_FIELD_INFORMATION_MISC_LABEL')
				,	JText::_('COM_CONTACTENHANCED_FIELD_INFORMATION_SIDEBAR_LABEL')
				,	JText::_('CE_LATITUDE')
				,	JText::_('CE_LONGITUDE')
				,	JText::_('CE_ZOOM')
				,	JText::_('COM_CONTACTENHANCED_FIELD_PARAMS_IMAGE_LABEL')
				,	JText::_('JGLOBAL_FIELD_CREATED_BY_LABEL')
				,	JText::_('COM_CONTACTENHANCED_FIELD_CREATED_BY_ALIAS_LABEL')
				,	JText::_('COM_CONTACTENHANCED_FIELD_CREATED_LABEL')
				,	JText::_('JGLOBAL_FIELD_MODIFIED_LABEL')
				,	JText::_('JGLOBAL_FIELD_MODIFIED_BY_LABEL')
				,	JText::_('COM_CONTACTENHANCED_FIELD_PUBLISH_UP_LABEL')
				,	JText::_('COM_CONTACTENHANCED_FIELD_PUBLISH_DOWN_LABEL')
				,	JText::_('JFIELD_ORDERING_LABEL')
				,	JText::_('JFIELD_META_KEYWORDS_LABEL')
				,	JText::_('JFIELD_META_DESCRIPTION_LABEL')
				,	JText::_('JFIELD_LANGUAGE_LABEL')
				,	JText::_('COM_CONTACTENHANCED_FIELD_FEATURED_LABEL')
				,	JText::_('COM_CONTACTENHANCED_FIELD_INFORMATION_EXTRA_FIELD_1_LABEL')
				,	JText::_('COM_CONTACTENHANCED_FIELD_INFORMATION_EXTRA_FIELD_2_LABEL')
				,	JText::_('COM_CONTACTENHANCED_FIELD_INFORMATION_EXTRA_FIELD_3_LABEL')
				,	JText::_('COM_CONTACTENHANCED_FIELD_INFORMATION_EXTRA_FIELD_4_LABEL')
				,	JText::_('COM_CONTACTENHANCED_FIELD_INFORMATION_EXTRA_FIELD_5_LABEL')
				,	JText::_('COM_CONTACTENHANCED_FIELD_INFORMATION_EXTRA_FIELD_6_LABEL')
				,	JText::_('COM_CONTACTENHANCED_FIELD_INFORMATION_EXTRA_FIELD_7_LABEL')
				,	JText::_('COM_CONTACTENHANCED_FIELD_INFORMATION_EXTRA_FIELD_8_LABEL')
				,	JText::_('COM_CONTACTENHANCED_FIELD_INFORMATION_EXTRA_FIELD_9_LABEL')
				,	JText::_('COM_CONTACTENHANCED_FIELD_INFORMATION_EXTRA_FIELD_10_LABEL')
		);

		$headerLine = array();

		$tableColumns 	= $db->getTableColumns('#__ce_details');

		foreach($tableColumns as $key => $value){
			$headerLine[]	= $key;
		}
		$csv->addRow($headerLine);

		$query->clear();
		$query->select('*');
		$query->from('#__ce_details');
		$db->setQuery($query);
		$contacts	= $db->loadAssocList('id');

		foreach($contacts AS $row){
			$line = array();
			foreach ($row as $value) {
				$line[] = $value;
			}
			$csv->addRow($line);
		}
		//exit;
		echo $csv->render('contactenhanced__'.date('Y-m-d_Hi').'.csv','UTF-8');
		exit;
	}

	public function exportContactsXML(){
		$db				= JFactory::getDBO();
		header("Content-type: text/xml");
		header("Content-disposition:attachment;filename=contactenhanced__".date('Y-m-d_Hi').".xml");
		echo $this->buildXml('#__ce_details');
		exit;
	}

	/**
	 *  Copy from  /libraries/joomla/database/exporter.php
	 *  @todo check if Joomla's buildXml() is changed to public in order to use Joomla's code instead of teh 3 methods below
	 */
	protected function buildXml($table)
	{
		$buffer = array();

		$buffer[] = '<?xml version="1.0"?>';
		$buffer[] = '<mysqldump xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">';
		$buffer[] = ' <database name="">';

		$buffer = array_merge($buffer, $this->buildXmlStructure($table));
		$buffer = array_merge($buffer, $this->buildXmlTableValues($table));

		$buffer[] = ' </database>';
		$buffer[] = '</mysqldump>';

		return implode("\n", $buffer);
	}
	protected function buildXmlStructure($table)
	{
		$buffer = array();

		$db				= JFactory::getDBO();
		// Replace the magic prefix if found.
		$table = $this->getGenericTableName($table);

		// Get the details columns information.
		$fields = $db->getTableColumns($table, false);
		$keys = $db->getTableKeys($table);

		$buffer[] = '  <table_structure name="' . $table . '">';

		foreach ($fields as $field)
		{
			$buffer[] = '   <field Field="' . $field->Field . '"' . ' Type="' . $field->Type . '"' . ' Null="' . $field->Null . '"' . ' Key="' .
					$field->Key . '"' . (isset($field->Default) ? ' Default="' . $field->Default . '"' : '') . ' Extra="' . $field->Extra . '"' .
					' />';
		}

		foreach ($keys as $key)
		{
			$buffer[] = '   <key Table="' . $table . '"' . ' Non_unique="' . $key->Non_unique . '"' . ' Key_name="' . $key->Key_name . '"' .
					' Seq_in_index="' . $key->Seq_in_index . '"' . ' Column_name="' . $key->Column_name . '"' . ' Collation="' . $key->Collation . '"' .
					' Null="' . $key->Null . '"' . ' Index_type="' . $key->Index_type . '"' . ' Comment="' . htmlspecialchars($key->Comment) . '"' .
					' />';
		}

		$buffer[] = '  </table_structure>';

		return $buffer;
	}
	protected function buildXmlTableValues($table)
	{
		$buffer = array();

		// Replace the magic prefix if found.
		$table = $this->getGenericTableName($table);

		$db			= JFactory::getDBO();
		$query 		= $db->getQuery(true);
		$query->select('*');
		$query->from($table);
		$db->setQuery($query);
		$items	= $db->loadAssocList('id');

		foreach ($items as $key => $fields)
		{
			$buffer[] = '  <table name="' . $table . '" id="' . $key . '">';
			foreach ($fields as $key => $field)
			{
				$buffer[] = '   <column name="'.$key.'">'.htmlspecialchars($field).'</column>';
			}
		$buffer[] = '  </table>';
		}

		return $buffer;
	}
	protected function getGenericTableName($table)
	{
		$prefix = JFactory::getDbo()->getPrefix();

		// Replace the magic prefix if found.
		$table = preg_replace("|^$prefix|", '#__', $table);

		return $table;
	}
	
	public function uploadMapMarkers() {
		
		$marker_directory = JPATH_ROOT.'/images/com_contactenhanced/maps/marker';
		
		if(!is_readable($marker_directory.'/index.html')){
			jimport('joomla.filesystem.folder');
			// Create the images/com_contactenhanced/maps/marker/ directory
			JFolder::create($marker_directory);
			JFile::copy(JPATH_ROOT.'/components/com_contactenhanced/index.html', $marker_directory.'/index.html');
			JFolder::move(JPATH_ROOT.'/components/com_contactenhanced/assets/images/gmaps/marker',$marker_directory);
		}
		
		$mapMarkerZip = JPATH_ROOT.'/tmp/mapmarkers.zip';
		$downloadFile = 'https://idealextensions.com/media/com_contactenhanced/mapmarkers.zip';
		
		if($this->cURLdownload($downloadFile, $mapMarkerZip)){
				
			if(is_readable($mapMarkerZip)){
				jimport('joomla.filesystem.archive');
				// Do the unpacking of the archive
				try
				{
					if(JArchive::extract($mapMarkerZip, $marker_directory)){
						JFactory::getApplication()->enqueueMessage('Marker images were successfully uploaded to '.$marker_directory);
					}
				}
				catch (Exception $e)
				{
					JFactory::getApplication()->enqueueMessage('An error occurred. Please upload the markers manually.','error');
				}
			}else{
				JFactory::getApplication()->enqueueMessage('Failed to download file '.$downloadFile.'. Please upload markers manually.','error');
			}
		}
		
		$this->setRedirect('index.php?option=com_contactenhanced&view=tools');
	}
	
	public function cURLcheckBasicFunctions()
	{
		if( !function_exists("curl_init") &&
				!function_exists("curl_setopt") &&
				!function_exists("curl_exec") &&
				!function_exists("curl_close") ) return false;
		else return true;
	}
	
	/*
	 * Returns string status information.
	* Can be changed to int or bool return types.
	*/
	public function cURLdownload($url, $file)
	{
		if( !$this->cURLcheckBasicFunctions() ){
			JFactory::getApplication()->enqueueMessage('curl is not installed. Please upload the markers manually.','error');
			return false;
		}
		set_time_limit(0); // unlimited max execution time
		$ch = curl_init();
		if($ch)
		{
			$fp = fopen($file, "w");
			if($fp)
			{
				if( !curl_setopt($ch, CURLOPT_URL, $url) )
				{
					fclose($fp); // to match fopen()
					curl_close($ch); // to match curl_init()
					JFactory::getApplication()->enqueueMessage("FAIL: curl_setopt(CURLOPT_URL)",'error');
					return false;
				}
				if( !curl_setopt($ch, CURLOPT_FILE, $fp) ){
					JFactory::getApplication()->enqueueMessage("FAIL: curl_setopt(CURLOPT_FILE)",'error');
					return false;
				}
				if( !curl_setopt($ch, CURLOPT_HEADER, 0) ){
					JFactory::getApplication()->enqueueMessage("FAIL: curl_setopt(CURLOPT_HEADER)",'error');
					return false;
				}
				if( !curl_exec($ch) ){
					JFactory::getApplication()->enqueueMessage("FAIL: curl_exec()",'error');
					return false;
				}
				curl_close($ch);
				fclose($fp);
				return true;
			}
			else
			{
				JFactory::getApplication()->enqueueMessage("FAIL: fopen()",'error');
				return false;
			}
		}
		else
		{
			JFactory::getApplication()->enqueueMessage("FAIL: curl_init()",'error');
			return false;
		}
}
	
}