<?php
/**
 * @package		com_contactenhanced
* @copyright	Copyright (C) 2006 - 2015 IdealExtensions.com. All rights reserved
 * @author	 	Douglas Machado {@link http://idealextensions.com}
 * @license		GNU GPL2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

jimport('joomla.application.component.view');

/**
 * @since		1.5
 */
class ContactenhancedViewCustomvalue extends JViewLegacy
{
	protected $form;
	protected $item;
	protected $state;

	/**
	 * Display the view
	 */
	function display($tpl = null)
	{
		$this->form		= $this->get('form');
		$this->item		= $this->get('item');
		$this->state	= $this->get('state');
		$params			= JComponentHelper::getParams('com_contactenhanced');
		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}

		$this->addToolbar();
		$this->assignRef('params',	$params);
		
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since	1.6
	 */
	protected function addToolbar()
	{
		JRequest::setVar('hidemainmenu', true);

		$user		= JFactory::getUser();
		$isNew		= ($this->item->id == 0);
		JRequest::setVar('hidemainmenu', 1);

		JToolBarHelper::title(JText::_('CE_CV_MANAGER'), 'contact.png');
		JToolBarHelper::apply('customvalue.apply','JTOOLBAR_APPLY');
		JToolBarHelper::save('customvalue.save','JTOOLBAR_SAVE');
		JToolBarHelper::addNew('customvalue.save2new', 'JTOOLBAR_SAVE_AND_NEW');
				// If an existing item, can save to a copy.
		if (!$isNew) {
			JToolBarHelper::custom('customvalue.save2copy','save-copy.png', 'save-copy_f2.png', 'JTOOLBAR_SAVE_AS_COPY',false );
		}

		if (empty($this->item->id))  {
			JToolBarHelper::cancel('customvalue.cancel','JTOOLBAR_CANCEL');
		}else{
			JToolBarHelper::cancel('customvalue.cancel', 'JTOOLBAR_CLOSE');
		}
		//JToolBarHelper::divider();
		//JToolBarHelper::help('JHELP_COMPONENTS_CONTACTS_CONTACTS_EDIT');
	}
}
