<?php
/**
 * @version		1.5.0
 * @package		Joomla
 * @subpackage	Doc Indexer
 * @author  Tuan Pham Ngoc
 * @copyright	Copyright (C) 2010 Ossolution Team
 * @license		GNU/GPL, see LICENSE.php
 */
/** ensure this file is being included by a parent file */
defined('_JEXEC') or die('Direct Access to this location is not allowed.');

/**
 * Change the db structure of the previous version
 *
 */
class com_docindexerInstallerScript
{

	/**
	 * method to install the component
	 *
	 * @return void
	 */
	function install($parent)
	{
		com_install();
	}

	function update($parent)
	{
		com_install();
	}
}

function com_install()
{
	//Load config config data	
	$db = Jfactory::getDBO();
	jimport('joomla.filesystem.folder');
	jimport('joomla.filesystem.file');
	$sql = 'SELECT COUNT(*) FROM #__dix_configs';
	$db->setQuery($sql);
	$total = $db->loadResult();
	if (!$total)
	{
		$configSql = JPATH_ADMINISTRATOR . '/components/com_docindexer/sql/config.docindexer.sql';
		$sql = JFile::read($configSql);
		$queries = $db->splitSql($sql);
		if (count($queries))
		{
			foreach ($queries as $query)
			{
				if ($query != '' && $query{0} != '#')
				{
					$db->setQuery($query);
					$db->query();
				}
			}
		}
		$path = JPATH_ROOT . '/docindexer';
		if (!JFolder::exists($path))
		{
			JFolder::create($path, 0777);
			$sql = 'UPDATE #__dix_configs SET config_value="' . $path . '" WHERE config_key="documents_path";';
			$db->setQuery($sql);
			$db->query();
		}								
	}
	if (JFolder::exists(JPATH_ROOT . '/components/com_docman'))
	{
		$fields = array_keys($db->getTableColumns('#__docman_documents'));
		if (!in_array('indexed_content', $fields))
		{
			$sql = 'ALTER TABLE `#__docman_documents` ADD `indexed_content` LONGTEXT NULL';
			$db->setQuery($sql);
			$db->query();
		}
	}	
	//Change permission uppon install so that we won't have to do it manually each time customers use it
	@chmod(JPATH_ROOT.'/components/com_docindexer/lib/binaries/linux/pdftotext', 0777);	
}
