<?php
/**
 * @version		1.5.0
 * @package		Joomla
 * @subpackage	Doc Indexer
 * @author  Tuan Pham Ngoc
 * @copyright	Copyright (C) 2010 Ossolution Team
 * @license		GNU/GPL, see LICENSE.php
 */
// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die( 'Restricted access' );
/**
 * Doc Indexer Component Doc Model
 *
 * @package		Joomla
 * @subpackage	Joomla Donation
 * @since 1.5
 */
class DocIndexerModelDoc extends JModelLegacy
{
	/**
	 * Campaign id
	 *
	 * @var int
	 */
	var $_id = null;
	/**
	 * Campaign data
	 *
	 * @var array
	 */
	var $_data = null;

	/**
	 * Constructor
	 *
	 * @since 1.5
	 */
	function __construct()
	{
		parent::__construct();
		$array = JRequest::getVar('cid', array(0), '', 'array');
		$edit	= JRequest::getVar('edit',true);
		if($edit)
			$this->setId((int)$array[0]);
	}
	/**
	 * Method to set the Doc identifier
	 *
	 * @access	public
	 * @param	int Doc identifier
	 */
	function setId($id)
	{
		// Set doc id and wipe data
		$this->_id		= $id;
		$this->_data	= null;
	}
	/**
	 * Method to get a Doc
	 *
	 * @since 1.5
	 */
	function &getData()
	{
		if (empty($this->_data)) {			
			$this->_loadData();			
		}					
		return $this->_data;
	}
	/**
	 * Method to store a Doc
	 *
	 * @access	public
	 * @return	boolean	True on success
	 * @since	1.5
	 */
	function store(&$data)
	{		
		$row = & $this->getTable('DocIndexer', 'Table');
		if ($data['id'])
			$row->load($data['id']);			
		if (!$row->bind($data)) {
			$this->setError($this->_db->getErrorMsg());
			return false;
		}			
		if ($data['re_index']) {
			$documentsPath =  DocIndexerHelper::getConfigValue('documents_path') ;			
			require_once JPATH_ROOT.'/components/com_docindexer/helper/docs.php';			
			//Index this doc
			$indexer = new DixDocs();
			$row->doc_content = $indexer->getText($documentsPath.'/'.$row->filename) ;
		}
		
		if (!$row->store()) {
			$this->setError($this->_db->getErrorMsg());
			return false;
		}				
		return true;
	}	
	/**
	 * Load Doc data
	 *
	 */
	function _loadData() {
		$sql = 'SELECT * FROM #__dix_docs WHERE id='.$this->_id;
		$this->_db->setQuery($sql);			
		$this->_data = $this->_db->loadObject();
	}
	/**
	 * Method to remove  Docs
	 *
	 * @access	public
	 * @return	boolean	True on success
	 * @since	1.5
	 */
	function delete($cid = array())
	{		
		if (count( $cid ))
		{
			$cids =  implode(',', $cid);
			$sql = 'DELETE FROM #__dix_docs WHERE id IN ('.$cids.')';
			$this->_db->setQuery($sql);
			if (!$this->_db->query())
				return false;			
		}
		return true;
	}
	/**
	 * Change status of documents
	 *
	 * @param int $id
	 * @param int $state
	 */
	function publish($cid, $state) {
		if (count($cid)) {
			$cids = implode(',', $cid) ;
			$sql = 'UPDATE #__dix_docs SET published='.$state. ' WHERE id IN('.$cids.')';
			$this->_db->setQuery($sql);
			$this->_db->query();
			return true ;	
		} else {
			return false ;	
		}				
	}		
}