<?php
/**
 * @version		1.5.0
 * @package		Joomla
 * @subpackage	Doc Indexer
 * @author  Tuan Pham Ngoc
 * @copyright	Copyright (C) 2010 Ossolution Team
 * @license		GNU/GPL, see LICENSE.php
 */
// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');

/**
 * HTML View class for Doc Indexer component
 *
 * @static
 * @package		Joomla
 * @subpackage	Doc Indexer
 * @since 1.5
 */
class DocIndexerViewDocs extends JViewLegacy
{

	function display($tpl = null)
	{
		$documentsPath = DocIndexerHelper::getConfigValue('documents_path');
		$mainframe = & JFactory::getApplication();
		$db = JFactory::getDbo();
		$option = 'com_docindexer';
		$filter_order = $mainframe->getUserStateFromRequest($option . 'docs_filter_order', 'filter_order', 'a.id', 'cmd');
		$filter_order_Dir = $mainframe->getUserStateFromRequest($option . 'filter_order_Dir', 'filter_order_Dir', '', 'word');
		$search = $mainframe->getUserStateFromRequest($option . 'search', 'search', '', 'string');
		$search = JString::strtolower($search);
		$lists['search'] = $search;
		$items = & $this->get('Data');
		$pagination = & $this->get('Pagination');
		$lists['order_Dir'] = $filter_order_Dir;
		$lists['order'] = $filter_order;
		
		$sql = 'SELECT id, title FROM #__viewlevels';
		$db->setQuery($sql);
		$levels = $db->loadObjectList();
		$access = array();
		foreach ($levels as $level)
		{
			$access[$level->id] = $level->title;
		}
		$this->assignRef('lists', $lists);
		$this->assignRef('items', $items);
		$this->assignRef('pagination', $pagination);
		$this->assignRef('access', $access);
		
		parent::display($tpl);
	}
}