<?php
/**
 * @version		1.5.0
 * @package		Joomla
 * @subpackage	Doc Indexer
 * @author  Tuan Pham Ngoc
 * @copyright	Copyright (C) 2010 Ossolution Team
 * @license		GNU/GPL, see LICENSE.php
 */
// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');

/**
 * HTML View class for the Doc Indexer component
 *
 * @static
 * @package		Joomla
 * @subpackage	Doc Indexer
 * @since 1.0
 */
class DocIndexerViewIndex extends JViewLegacy
{

	function display($tpl = null)
	{
		$db = & JFactory::getDBO();
		$integration = DocIndexerHelper::getConfigValue('integration');
		$task = JRequest::getVar('task', '');
		$file = JRequest::getVar('file', '');
		$success = JRequest::getVar('success', true);
		$access = JRequest::getVar('access', 0);
		if (version_compare(JVERSION, '1.6.0', 'ge'))
		{
			$lists['access'] = JHTML::_('access.level', 'access', 0, ' class="inputbox" ', false);
		}
		else
		{
			$sql = 'SELECT id, name FROM #__groups';
			$db->setQuery($sql);
			$options = $db->loadObjectList();
			$lists['access'] = JHTML::_('select.genericlist', $options, 'access', ' class="inputbox" ', 'id', 'name');
		}
		if ($integration)
		{
			global $supportedExtensions;
			$options = array();
			$options[] = JHTML::_('select.option', '', JText::_('None'));
			foreach ($supportedExtensions as $component)
			{
				$options[] = JHTML::_('select.option', $component, $component);
			}
			$lists['component'] = JHTML::_('select.genericlist', $options, 'component', 'class="inputbox"', 'value', 'text');
		}
		$component = JRequest::getVar('component', '');
		$this->assignRef('lists', $lists);
		$this->assignRef('file', $file);
		$this->assignRef('success', $success);
		$this->assignRef('access', $access);
		$this->assignRef('task', $task);
		$this->assignRef('integration', $integration);
		$this->assignRef('component', $component);
		parent::display($tpl);
	}
}