<?php
/**
* @package		EasySocial
* @copyright	Copyright (C) 2010 - 2014 Stack Ideas Sdn Bhd. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* EasySocial is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/
defined( '_JEXEC' ) or die( 'Unauthorized Access' );

jimport('joomla.application.component.model');

FD::import( 'admin:/includes/model' );

class EasySocialModelOAuth extends EasySocialModel
{

	function __construct()
	{
		parent::__construct( 'people' );
	}

	/**
	 * Loads a record given the unique item id
	 *
	 * @since	1.0
	 * @access	public
	 * @param	string
	 * @return
	 */
	public function getRow( $options = array() )
	{
		$db		= FD::db();
		$sql	= $db->sql();

		$sql->select( '#__social_oauth', 'a' );
		$sql->column( 'a.*' );
		$sql->join( '#__users', 'b' );
		$sql->on( 'b.id', 'a.uid' );
		$sql->where( 'b.username', $options['username'] );

		$db->setQuery( $sql );

		$result 	= $db->loadObject();

		return $result;
	}

	/**
	 * Some desc
	 *
	 * @since	1.0
	 * @access	public
	 * @param	string
	 * @return
	 */
	public function getPullableClients()
	{
		$db 	= FD::db();
		$sql 	= $db->sql();

		$sql->select( '#__social_oauth' );
		$sql->where( 'pull' , 1 );

		$db->setQuery( $sql );

		$items 	= $db->loadObjectList();

		return $items;
	}

	/**
	 * Determines if the oauth user id exists on this site.
	 *
	 * @since	1.0
	 * @access	public
	 * @param	string
	 * @return
	 */
	// public function oauthUserE
}
