EasySocial.require()
.script( 'validate', 'admin/users/form' )
.done(function($)
{
	$( '[data-user-form]' ).implement( EasySocial.Controller.Users.Form, {
		userid: <?php echo $user->id; ?>
	});

	$.Joomla( 'submitbutton' , function(task){

		if( task == 'cancel' )
		{
			window.location 	= 'index.php?option=com_easysocial&view=users';

			return false;
		}

		// Create an array of deferreds so that any one else can add in their saving process before joomla submits to the controller
		var dfd = [];

		// Validate the custom fields
		dfd.push($('[data-user-form]').validate());

		$.when.apply(null, dfd)
			.done(function() {
				$.Joomla( 'submitform' , [task] );
			})
			.fail(function() {
				EasySocial.dialog(
				{
					content 	: EasySocial.ajax( 'admin/views/users/showFormError' )
				});
			});
	});

	// Deletes a user's badge
	$( '[data-delete-badge]' ).on( 'click' , function()
	{
		var id		= $( this ).data( 'id' ),
			userId	= $( this ).data( 'userid' );
		EasySocial.dialog( 
		{
			content 	: EasySocial.ajax( 'admin/views/users/confirmRemoveBadge' , { "id" : id , "userid" : userId } ),
			bindings	: 
			{
				"{deleteButton} click" : function()
				{
					this.deleteForm().submit();
				}
			}
		});
	});

	// Initiate ajax call to load the user's activity
	EasySocial.ajax( 'admin/views/users/getActivity' ,
	{ id : "<?php echo $user->id;?>"
	})
	.done(function( contents )
	{
		// Hide placeholder
		$( '[data-form-activity-loader]' ).remove();

		$( '[data-form-activity]' ).html( contents );
	});

});
