<?php
/**
* @package      EasySocial
* @copyright    Copyright (C) 2010 - 2014 Stack Ideas Sdn Bhd. All rights reserved.
* @license      GNU/GPL, see LICENSE.php
* EasySocial is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/
defined('_JEXEC') or die('Unauthorized Access');

FD::import('admin:/includes/maintenance/dependencies');

class SocialMaintenanceScriptRemoveKeyColumnFromFieldData extends SocialMaintenanceScript
{
    public static $title = 'Remove key column from field data';

    public static $description = 'Remove unused key column from field data.';

    public function main()
    {
        $db = FD::db();
        $sql = $db->sql();

        $table = '#__social_fields_data';

        $columns = $db->getTableColumns($table);

        if (in_array('key', $columns)) {
            $sql->raw('ALTER TABLE `#__social_fields_data` DROP COLUMN `key`');
            $db->setQuery($sql);
            $db->query();
        }

        return true;
    }
}
