<?php
/**
* @package Redirect-On-Login (com_redirectonlogin)
* @version 3.4.0
* @copyright Copyright (C) 2008 - 2015 Carsten Engel. All rights reserved.
* @license GPL versions free/trial/pro
* @author http://www.pages-and-items.com
* @joomla Joomla is Free Software
*/

// No direct access
defined('_JEXEC') or die;

jimport('joomla.plugin.plugin');

class plgUserRedirectonlogin extends JPlugin{	

	protected $rol_config;		
	protected $rol_version_type = 'pro';
	protected $grouplevel_redirect_url = '';
	protected $grouplevel_redirect_url_silent = '';
	protected $grouplevel_open_site_home = 0;
	protected $grouplevel_message = '';
	protected $grouplevel_message_type = '';
	protected $grouplevel_logout = 0;
	
	function init(){			
		$this->rol_config = $this->get_config();
	}
	
	function get_config(){	
		
		$database = JFactory::getDBO();
		
		$database->setQuery("SELECT config "
		."FROM #__redirectonlogin_config "
		."WHERE id='1' "
		."LIMIT 1"
		);		
		$raw = $database->loadResult();		
		
		$params = explode( "\n", $raw);
		
		for($n = 0; $n < count($params); $n++){		
			$temp = explode('=',$params[$n]);
			$var = $temp[0];
			$value = '';
			if(count($temp)==2){
				$value = trim($temp[1]);				
			}							
			$config[$var] = $value;	
		}	
		
		//reformat redirect urls		
		$config['redirect_url_backend'] = str_replace('[equal]','=',$config['redirect_url_backend']);	
		$config['redirect_component_backend'] = str_replace('[equal]','=',$config['redirect_component_backend']);
		$config['redirect_url_frontend'] = str_replace('[equal]','=',$config['redirect_url_frontend']);
		$config['redirect_url_frontend_logout'] = str_replace('[equal]','=',$config['redirect_url_frontend_logout']);
		$config['opening_site_url'] = str_replace('[equal]','=',$config['opening_site_url']);	
		$config['url_first'] = str_replace('[equal]','=',$config['url_first']);	
		$config['logoutbackend_url'] = str_replace('[equal]','=',$config['logoutbackend_url']);
		
		$lang = JFactory::getLanguage();
		
		//get default message frontend
		if($config['lang_type_login_front']=='custom'){
			//custom message
			if($config['logout_message_frontend']=='COM_REDIRECTONLOGIN_YOU_CANT_LOGIN'){
				$config['logout_message_frontend'] = JText::_('COM_REDIRECTONLOGIN_YOU_CANT_LOGIN');
			}
		}else{
			//from language file
			$lang->load('com_redirectonlogin', JPATH_ROOT, null, false);
			$config['logout_message_frontend'] = JText::_('COM_REDIRECTONLOGIN_YOU_CANT_LOGIN_FRONTEND');
		}
		
		//get default message backend
		if($config['lang_type_login_back']=='custom'){	
			//custom message
			if($config['logout_message_backend']=='COM_REDIRECTONLOGIN_YOU_CANT_LOGIN'){
				$config['logout_message_backend'] = JText::_('COM_REDIRECTONLOGIN_YOU_CANT_LOGIN');
			}
		}else{
			//from language file
			$lang->load('com_redirectonlogin', JPATH_ROOT, null, false);
			$config['logout_message_backend'] = JText::_('COM_REDIRECTONLOGIN_YOU_CANT_LOGIN_BACKEND');
		}	
				
		return $config;			
	}

	function onUserLogin($user, $options){	
	
		$database = JFactory::getDBO();
		$app = JFactory::getApplication();
		$helper = $this->get_helper();
		
		$this->init();	
		$this->clean_sessions();	
		
		//check if redirect is enabled		
		if($this->rol_config['enable_redirection']=='no'){
			return true;
		}			
		
		//check if trial version is expired
		if($this->rol_version_type=='trial'){
			if(!$this->rol_check_trial_version()){
				return true;
			}
		}
		
		$redirect_url = '';				
		$redirect_url_silent = '';
		$message = '';
		$message_type = '';
		$opening_site_home = 0;	
		$logout = 0;
		$silent = 0;		
		$return_url = base64_decode(JRequest::getVar('return'));
		
		//had no access to menuitem
		$return_url3 = $app->getUserState("com_redirectonlogin.return_url_after_unauthorised_access", '');
		$return_after_no_access_menuitem = 0;
		if($return_url3){			
			//if set to 'rol' this session would not be triggered at all
			if($this->rol_config['after_no_access_page']=='page'){
				$redirect_url = $return_url3;		
			}
			if($this->rol_config['after_no_access_page']=='pagerolno'){
				if(strpos($return_url, 'rol=no')){
					$redirect_url = $return_url3;
				}			
			}
			$return_after_no_access_menuitem = 1;		
			$app->setUserState("com_redirectonlogin.return_url_after_unauthorised_access", '');			
		}
		
		//had no access to some other page
		$return_url2 = $app->getUserState("com_redirectonlogin.return_url_after_unauthorised_access2", '');
		$return_after_no_access_page = 0;
		if($return_url2){
			if($app->getUserState("com_redirectonlogin.return_url_after_unauthorised_access_pageloads", '') > 0){
				$redirect_url = $return_url2;						
				$app->setUserState("com_redirectonlogin.return_url_after_unauthorised_access2", '');
				$app->setUserState("com_redirectonlogin.return_url_after_unauthorised_access_pageloads", '');	
			}	
			$return_after_no_access_page = 1;	
		}
		
		
		//no redirect when frontend rol=no
		if(
		$app->isSite() && 
		strpos($return_url, 'rol=no') && 
		!$return_after_no_access_menuitem && 
		!$return_after_no_access_page &&
		$this->rol_config['rolno_frontend_login']
		){
			$redirect_url = $return_url;
		}	
		
		//no redirect when backend rol=no
		if(
		$app->isAdmin() && 
		strpos($return_url, 'rol=no') && 		
		$this->rol_config['rolno_backend_login']
		){
			$redirect_url = $return_url;
		}	
		
		//no redirect when backend is deep linking	
		if($app->isAdmin() && strpos($return_url, 'option=')){
			//if set to 'rol' set redirect_url further down
			if($this->rol_config['deeplink']=='page'){
				return true;//let joomla do the redirect
			}elseif($this->rol_config['deeplink']=='pagerolno'){
				if(strpos($return_url, 'rol=no')){
					$redirect_url = $return_url;
				}
			}
		}
		
		$current_url = '';
		$current_url_base64 = '';
		if(isset($_SERVER['HTTP_REFERER'])){
			$current_url = $_SERVER['HTTP_REFERER'];				
			$current_url_base64 = base64_encode($current_url);							
		}				
		
		//no redirect when rol=no in request url on site open
		$uri = JFactory::getURI();
		$request_url = $uri->toString();
		if(strpos($request_url, 'rol=no') && $this->rol_config['rolno_frontend_open']){
			return true;
		}
		
		//$user_id = $user['id']; why on earth is the user id not parsed?	
		$user_email = $user['email'];	

		//get user id from email (as those are unique)
		$database->setQuery("SELECT id "
		."FROM #__users  "
		."WHERE email='$user_email' "
		."LIMIT 1 "
		);
		$rows = $database->loadObjectList();
		$user_id = 0;
		foreach($rows as $row){	
			$user_id = $row->id;	
		}	
				
		//check for user specific redirect
		$database->setQuery("SELECT * "
		."FROM #__redirectonlogin_users  "
		."WHERE user_id='$user_id' "
		."LIMIT 1 "
		);
		$rows = $database->loadObjectList();
		$user_backend_type = '';
		$user_frontend_type = '';
		$user_opening_site = 0;
		$user_opening_site_home = '';
		$user_open_type = '';
		$user_loginbackend_dynamic = 0;
		foreach($rows as $row){			
			$user_frontend_type = $row->frontend_type;	
			$user_frontend_url = $row->frontend_url;	
			$user_backend_type = $row->backend_type;	
			$user_backend_url = $row->backend_url;	
			$user_backend_component = $row->backend_component;	
			$user_opening_site = $row->opening_site;
			$user_opening_site_url = $row->opening_site_url;
			$user_opening_site_home = $row->opening_site_home;			
			$user_menuitem_login = $row->menuitem_login;	
			$user_menuitem_open = $row->menuitem_open;	
			$user_menuitem_logout = $row->menuitem_logout;	
			$user_dynamic_login = $row->dynamic_login;	
			$user_dynamic_open = $row->dynamic_open;	
			$user_dynamic_logout = $row->dynamic_logout;	
			$user_open_type = $row->open_type;	
			$user_first_type = $row->first_type;
			$user_first_menuitem = $row->first_menu;	
			$user_first_url = $row->first_url;	
			$user_first_dynamic = $row->first_dyna;	
			$user_loginbackend_dynamic = $row->loginbackend_dynamic;		
		}
		
		if ($app->isAdmin()){		
			//backend	
			
			//user specific
			if($user_backend_type!='' && $user_backend_type!='none' && $redirect_url==''){
				//user specific redirect	
				if($user_backend_type=='no'){							
					$redirect_url =	'no';				
				}							
				if($user_backend_type=='url' && $user_backend_url!=''){							
					$redirect_url =	$user_backend_url;				
				}
				if($user_backend_type=='component' && $user_backend_component!='0'){											
					$redirect_url = $user_backend_component;
				}
				if($user_backend_type=='dynamic' && $user_loginbackend_dynamic!='0'){											
					$dynamic_array = $helper->get_dynamic_link($user_loginbackend_dynamic, $user_id);
					$redirect_url = $dynamic_array[0];
					$message = $dynamic_array[1];
					$logout = $dynamic_array[2];
					$message_type = $dynamic_array[3];	
				}
				if($user_backend_type=='logout'){	
					//setcookie("com_redirectonlogin_message", $this->rol_config['logout_message_backend']);
					$message = $this->rol_config['logout_message_backend'];					
					//$this->logout();
					$logout = 1;
					$redirect_url = 'index.php';			
				}				
			}
			
			//usergroup specific
			if($redirect_url==''){
				//no user specific redirect set	
				//so check if there is a group redirect set							
				if($this->rol_config['frontend_u_or_a']=='a'){
					$grouplevel_id = $this->get_first_accesslevel($user_id);
				}else{
					$grouplevel_id = $this->get_first_usergroup($user_id, 'back');	
				}
				if($grouplevel_id){
					$this->set_grouplevel_redirect_url($grouplevel_id, 'index.php', 'login');
				}
				$redirect_url = $this->grouplevel_redirect_url;	
				

				
				$logout = $this->grouplevel_logout;	
				$message = $this->grouplevel_message;									
				
			}//end usergroup			
			
			//general redirect
			if($redirect_url==''){				
				if($this->rol_config['redirect_type_backend']!='none'){										
					if($this->rol_config['redirect_type_backend']=='url' && $this->rol_config['redirect_url_backend']!=''){								
						$redirect_url = $this->rol_config['redirect_url_backend'];				
					}
					if($this->rol_config['redirect_type_backend']=='no'){								
						$redirect_url = 'no';				
					}
					if($this->rol_config['redirect_type_backend']=='component' && $this->rol_config['redirect_component_backend']!='0'){
						$redirect_url = $this->rol_config['redirect_component_backend'];
					}
					if($this->rol_config['redirect_type_backend']=='dynamic'){
						$dynamic_array = $helper->get_dynamic_link($this->rol_config['loginbackend_dynamic'], $user_id);
						$redirect_url = $dynamic_array[0];
						$message = $dynamic_array[1];
						$logout = $dynamic_array[2];
						$message_type = $dynamic_array[3];							
					}
					if($this->rol_config['redirect_type_backend']=='logout'){						
						//setcookie("com_redirectonlogin_message", $this->rol_config['logout_message_backend']);	
						$message = $this->rol_config['logout_message_backend'];					
						//$this->logout();
						$logout = 1;
						$redirect_url = 'index.php';						
					}							
				}			
			}//end general
			
			if($redirect_url!='' && $redirect_url!='no'){
				//$redirect_url = 'administrator/'.$redirect_url;
				$redirect_url = $redirect_url;
			}			
						
			//end backend
		}else{
			//frontend	
			
			//first login			
			if($redirect_url==''){
				//check if first login
				if($this->get_first_time_login($user_id)){
				
					//user specific redirect first
					if($user_first_type!='none'){				
						if($user_first_type=='no'){						
							$redirect_url = 'no';					
						}										
						if($user_first_type=='menuitem'){						
							$redirect_url = $helper->get_link_from_menuitem($user_first_menuitem);					
						}				
						if($user_first_type=='url' && $user_first_url!=''){							
							$redirect_url = $user_first_url;								
						}				
						if($user_first_type=='dynamic'){							
							$dynamic_array = $helper->get_dynamic_link($user_first_dynamic, $user_id);
							$redirect_url = $dynamic_array[0];
							$message = $dynamic_array[1];
							$logout = $dynamic_array[2];
							$message_type = $dynamic_array[3];				
						}									
					}//end if user specific redirect first					
					
					//usergroup/accesslevel redirect first
					if($redirect_url==''){				
						if($this->rol_config['frontend_u_or_a']=='a'){
							$grouplevel_id = $this->get_first_accesslevel($user_id);
						}else{
							$grouplevel_id = $this->get_first_usergroup($user_id, 'front');	
						}						
						if($grouplevel_id){
					
							$this->set_grouplevel_redirect_url($grouplevel_id, $current_url, 'first', $user_id);
							$redirect_url = $this->grouplevel_redirect_url;	
							$message = $this->grouplevel_message;	
							$logout = $this->grouplevel_logout;	
							$message_type = $this->grouplevel_message_type;		
						}				
					}//end if redirect for group or level first
					
					//general redirect first
					if($redirect_url==''){										
						if($this->rol_config['type_first']!='none'){							
							if($this->rol_config['type_first']=='menuitem'){
								$redirect_url = $helper->get_link_from_menuitem($this->rol_config['menuitem_first']);				
							}
							if($this->rol_config['type_first']=='url' && $this->rol_config['url_first']!=''){
								$redirect_url = $this->rol_config['url_first'];				
							}					
							if($this->rol_config['type_first']=='dynamic'){
								$dynamic_array = $helper->get_dynamic_link($this->rol_config['dynamic_first'], $user_id);
								$redirect_url = $dynamic_array[0];
								$message = $dynamic_array[1];
								$logout = $dynamic_array[2];
								$message_type = $dynamic_array[3];							
							}
						}			
					}//end general redirect first
					
				}
			}//end if first login		
			
			//user specific redirect
			if($user_frontend_type!='' && $user_frontend_type!='none' && $redirect_url==''){				
				if($user_frontend_type=='no'){						
					$redirect_url = 'no';					
				}
				if($user_frontend_type=='same'){						
					$redirect_url = $current_url;					
				}				
				if($user_frontend_type=='menuitem'){						
					$redirect_url = $helper->get_link_from_menuitem($user_menuitem_login);					
				}				
				if($user_frontend_type=='url' && $user_frontend_url!=''){							
					$redirect_url = $user_frontend_url;								
				}				
				if($user_frontend_type=='dynamic'){						
					//$redirect_url = $helper->get_dynamic_link($user_dynamic_login);	
					$dynamic_array = $helper->get_dynamic_link($user_dynamic_login, $user_id);
					$redirect_url = $dynamic_array[0];
					$message = $dynamic_array[1];
					$logout = $dynamic_array[2];
					$message_type = $dynamic_array[3];				
				}
				if($user_frontend_type=='logout'){	
					//setcookie("com_redirectonlogin_message", $this->rol_config['logout_message_frontend']);
					$message = $this->rol_config['logout_message_frontend'];
					//$this->logout();
					$logout = 1;
					$redirect_url = $current_url;											
				}				
			}
			
			//usergroup/accesslevel redirect
			if($redirect_url==''){				
				if($this->rol_config['frontend_u_or_a']=='a'){
					$grouplevel_id = $this->get_first_accesslevel($user_id);
				}else{
					$grouplevel_id = $this->get_first_usergroup($user_id, 'front');	
				}
				if($grouplevel_id){
					$this->set_grouplevel_redirect_url($grouplevel_id, $current_url, 'login', $user_id);
					$redirect_url = $this->grouplevel_redirect_url;	
					$message = $this->grouplevel_message;	
					$logout = $this->grouplevel_logout;	
					$message_type = $this->grouplevel_message_type;		
				}				
			}//end if redirect for group or level
			
			//general redirect
			if($redirect_url==''){										
				if($this->rol_config['redirect_type_frontend']!='none'){					
					if($this->rol_config['redirect_type_frontend']=='no'){
						$redirect_url = 'no';					
					}
					if($this->rol_config['redirect_type_frontend']=='same'){
						$redirect_url = $current_url;					
					}
					if($this->rol_config['redirect_type_frontend']=='menuitem'){
						$redirect_url = $helper->get_link_from_menuitem($this->rol_config['menuitem_login']);				
					}
					if($this->rol_config['redirect_type_frontend']=='url' && $this->rol_config['redirect_url_frontend']!=''){
						$redirect_url = $this->rol_config['redirect_url_frontend'];				
					}					
					if($this->rol_config['redirect_type_frontend']=='dynamic'){
						$dynamic_array = $helper->get_dynamic_link($this->rol_config['dynamic_login'], $user_id);
						$redirect_url = $dynamic_array[0];
						$message = $dynamic_array[1];
						$logout = $dynamic_array[2];
						$message_type = $dynamic_array[3];							
					}
					if($this->rol_config['redirect_type_frontend']=='logout'){	
						$message = $this->rol_config['logout_message_frontend'];
						$logout = 1;
						$redirect_url = $current_url;											
					}
				}			
			}			
					
			//silent login
			if(isset($options['silent']) && $redirect_url_silent==''){
				//user was already logged in and opens the site	
								
				//user specific silent redirect				
				if($user_opening_site=='no'){						
					$redirect_url_silent = 'no';
				}
				if($user_opening_site=='yes'){
					$opening_site_home = $user_opening_site_home;
					if($user_open_type=='menuitem'){
						$redirect_url_silent = $helper->get_link_from_menuitem($user_menuitem_open);
					}
					if($user_open_type=='url' && $user_opening_site_url!=''){							
						$redirect_url_silent = $user_opening_site_url;													
					}
					if($user_open_type=='dynamic'){
						$dynamic_array = $helper->get_dynamic_link($user_dynamic_open, $user_id);
						$redirect_url_silent = $dynamic_array[0];
						$message = $dynamic_array[1];
						$logout = $dynamic_array[2];
						$message_type = $dynamic_array[3];	
					}				
				}
				//end user specific silent redirect					
				
				//grouplevel specific silent redirect
				if($redirect_url_silent==''){
					if($this->rol_config['frontend_u_or_a']=='a'){						
						$grouplevel_id = $this->get_first_accesslevel($user_id);						
					}else{
						$grouplevel_id = $this->get_first_usergroup($user_id, 'front');
					}
					if($grouplevel_id){
						$this->set_grouplevel_redirect_url_silent($grouplevel_id, $current_url, 'login');
					}	
					$redirect_url_silent = $this->grouplevel_redirect_url_silent;
					$opening_site_home = $this->grouplevel_open_site_home;						
					$message = $this->grouplevel_message;
					$logout = $this->grouplevel_logout;	
					$message_type = $this->grouplevel_message_type;
				}				
				//end grouplevel specific silent redirect
				
				//get general open redirect				
				if($redirect_url_silent==''){					
					if(
					$this->rol_config['opening_site']=='yes' && 
					$this->rol_config['opening_site_type']!='notloggedin'					
					){
						$opening_site_home = $this->rol_config['opening_site_home'];
						if($this->rol_config['opening_site_type2']=='menuitem'){						
							$redirect_url_silent = $helper->get_link_from_menuitem($this->rol_config['menuitem_open']);							
						}
						if($this->rol_config['opening_site_type2']=='url'){
							if($this->rol_config['opening_site_url']){
								$redirect_url_silent = $this->rol_config['opening_site_url'];
							}
						}
						if($this->rol_config['opening_site_type2']=='dynamic'){
							//$redirect_url_silent = $helper->get_dynamic_link($this->rol_config['dynamic_open']);
							$dynamic_array = $helper->get_dynamic_link($this->rol_config['dynamic_open'], $user_id);
							$redirect_url_silent = $dynamic_array[0];
							$message = $dynamic_array[1];
							$logout = $dynamic_array[2];
							$message_type = $dynamic_array[3];	
						}						
					}
				}
				//end get general open redirect
				
				if($redirect_url_silent){					
					$redirect_url = $redirect_url_silent;	
					$silent = 1;				
				}			
				
			}//end if silent login		
			
			
		}//end frontend	


		if($redirect_url!='' && $redirect_url!='no'){	

			$redirect_url = JRoute::_($redirect_url, false);
			
			//get session id
			$session_id = session_id();
			
			$message = addslashes($message);

			//if there is no session for this user yet, ceate one
			$database->setQuery("SELECT id FROM #__redirectonlogin_sessions WHERE session_id='$session_id' ");
			if(!$database->loadResult()){
				$time = time();	
				$database->setQuery( "INSERT INTO #__redirectonlogin_sessions SET session_id='$session_id', unixtime='$time' ");
				$database->query();	
			}
						
			//set redirect for this session	
			$database->setQuery( "UPDATE #__redirectonlogin_sessions SET url='$redirect_url', message='$message', message_type='$message_type', opening_site_home='$opening_site_home', logout='$logout', silent='$silent' WHERE session_id='$session_id' ");
			$database->query();	

		}	
	
		if($logout){
			//$this->logout(); //do not use here as it conflicts with Joomla sessions and gives a nasty error
			
			//return false; //Joomla ignores this ! User is logged in, even if this returns false.
		}else{		
			return true;
		}
				
	}
	
	function onUserLogout($user, $options = array()){
	
		$database = JFactory::getDBO();	
		$app = JFactory::getApplication();
		$helper = $this->get_helper();
		$ds = DIRECTORY_SEPARATOR;
		
		$this->init();
			
		//check if redirect is enabled		
		if($this->rol_config['enable_redirection']=='no'){
			return true;
		}			
		
		//check if trial version is expired
		if($this->rol_version_type=='trial'){
			if(!$this->rol_check_trial_version()){
				return true;
			}
		}		
		
		//no redirect when rol=no in url
		$uri = JFactory::getURI();
		$request_url = $uri->toString();		
		if(strpos($request_url, 'rol=no')){
			if(
			($app->isSite() && $this->rol_config['rolno_frontend_logout']) ||
			($app->isAdmin() && $this->rol_config['rolno_backend_logout'])
			){
				return true;
			}			
		}
					
		$current_url = '';
		if(isset($_SERVER['HTTP_REFERER'])){
			$current_url = $_SERVER['HTTP_REFERER'];							
		}
		
		$redirect_url = '';	
		$logout = 0;	
		$message = '';
		$message_type = '';				
		$user_id = $user['id'];	

		//get redirect data user
		$database->setQuery("SELECT * "
		."FROM #__redirectonlogin_users  "
		."WHERE user_id='$user_id' "
		."LIMIT 1 "
		);
		$rows = $database->loadObjectList();
		$user_frontend_type_logout = '';
		$user_logoutbackend_type = '';	
		$user_logoutbackend_menuitem = '';		
		$user_logoutbackend_url = '';	
		$user_logoutbackend_dynamic = '';			
		foreach($rows as $row){				
			$user_frontend_type_logout = $row->frontend_type_logout;
			$user_logoutbackend_type = $row->logoutbackend_type;
			$user_logoutbackend_menuitem = $row->logoutbackend_menu;
			$user_logoutbackend_url = $row->logoutbackend_url;
			$user_logoutbackend_dynamic = $row->logoutbackend_dyna;								
		}		
		
		if ($app->isSite()){
			//only at frontend	
				
			//user specific redirect
			if($user_frontend_type_logout!='' && $user_frontend_type_logout!='none'){	
				if($user_frontend_type_logout=='no'){											
					$redirect_url = 'no';					
				}
				if($user_frontend_type_logout=='same'){											
					$redirect_url = $current_url;					
				}	
				if($user_frontend_type_logout=='menuitem'){											
					$redirect_url = $helper->get_link_from_menuitem($row->menuitem_logout);				
				}
				if($user_frontend_type_logout=='url' && $row->frontend_url_logout!=''){										
					$redirect_url = $row->frontend_url_logout;				
				}
				if($user_frontend_type_logout=='dynamic'){
					$dynamic_array = $helper->get_dynamic_link($row->dynamic_logout, $user_id);
					$redirect_url = $dynamic_array[0];
					$message = $dynamic_array[1];
					$logout = $dynamic_array[2];	
					$message_type = $dynamic_array[3];				
				}						
			}			
			//end user specific redirect			
			
			//group or level redirect
			if($redirect_url==''){							
				if($this->rol_config['frontend_u_or_a']=='a'){
					//level					
					$grouplevel_id = $this->get_first_accesslevel($user_id);
				}else{
					//group
					$grouplevel_id = $this->get_first_usergroup($user_id, 'front');															
				}
				if($grouplevel_id){
					$this->set_grouplevel_redirect_url($grouplevel_id, $current_url, 'logout');
				}
				$redirect_url = $this->grouplevel_redirect_url;
				$message = $this->grouplevel_message;
				$logout = $this->grouplevel_logout;	
				$message_type = $this->grouplevel_message_type;
			}//end if redirect for group or level
				
			//general redirect							
			if($redirect_url==''){
				if($this->rol_config['redirect_type_frontend_logout']!='none'){					
					if($this->rol_config['redirect_type_frontend_logout']=='same'){
						$redirect_url = $current_url;										
					}
					if($this->rol_config['redirect_type_frontend_logout']=='menuitem'){
						$redirect_url = $helper->get_link_from_menuitem($this->rol_config['menuitem_logout']);									
					}					
					if($this->rol_config['redirect_type_frontend_logout']=='url' && $this->rol_config['redirect_url_frontend_logout']!=''){
						$redirect_url = $this->rol_config['redirect_url_frontend_logout'];	
					}
					if($this->rol_config['redirect_type_frontend_logout']=='dynamic'){						
						$dynamic_array = $helper->get_dynamic_link($this->rol_config['dynamic_logout'], $user_id);
						$redirect_url = $dynamic_array[0];
						$message = $dynamic_array[1];
						$logout = $dynamic_array[2];
						$message_type = $dynamic_array[3];									
					}
				}
			}	
			//end general redirect	
			
		}else{
			//backend
			//user specific redirect
			if($user_logoutbackend_type!='' && $user_logoutbackend_type!='none'){	
				if($user_logoutbackend_type=='no'){											
					$redirect_url = 'no';					
				}					
				if($user_logoutbackend_type=='menuitem'){											
					$redirect_url = $helper->get_link_from_menuitem($user_logoutbackend_menuitem);
					$redirect_url = str_replace('administrator/', '', $redirect_url);
				}
				if($user_logoutbackend_type=='url' && $user_logoutbackend_url!=''){										
					$redirect_url = $user_logoutbackend_url;				
				}
				if($user_logoutbackend_type=='dynamic'){
					$dynamic_array = $helper->get_dynamic_link($user_logoutbackend_dynamic, $user_id);
					$redirect_url = $dynamic_array[0];
					$message = $dynamic_array[1];
					$logout = $dynamic_array[2];	
					$message_type = $dynamic_array[3];				
				}						
			}			
			//end user specific redirect			
			
			//group or level redirect
			if($redirect_url==''){							
				if($this->rol_config['frontend_u_or_a']=='a'){
					//level					
					$grouplevel_id = $this->get_first_accesslevel($user_id);
				}else{
					//group
					$grouplevel_id = $this->get_first_usergroup($user_id, 'back');															
				}
				if($grouplevel_id){
					$this->set_grouplevel_redirect_url($grouplevel_id, $current_url, 'logout');
				}
				$redirect_url = $this->grouplevel_redirect_url;
				$message = $this->grouplevel_message;
				$logout = $this->grouplevel_logout;	
				$message_type = $this->grouplevel_message_type;
			}//end if redirect for group or level
				
			//general redirect							
			if($redirect_url==''){
				if($this->rol_config['logoutbackend_type']!='none'){					
					if($this->rol_config['logoutbackend_type']=='menuitem'){
						$redirect_url = $helper->get_link_from_menuitem($this->rol_config['logoutbackend_menuitem']);	
						$redirect_url = str_replace('administrator/', '', $redirect_url);								
					}					
					if($this->rol_config['logoutbackend_type']=='url' && $this->rol_config['logoutbackend_url']!=''){
						$redirect_url = $this->rol_config['logoutbackend_url'];	
					}
					if($this->rol_config['logoutbackend_type']=='dynamic'){						
						$dynamic_array = $helper->get_dynamic_link($this->rol_config['logoutbackend_dynamic'], $user_id);
						$redirect_url = $dynamic_array[0];
						$message = $dynamic_array[1];
						$logout = $dynamic_array[2];
						$message_type = $dynamic_array[3];									
					}
				}
			}	
			//end general redirect
		}	
			
		if($redirect_url=='no'){
			$redirect_url = '';
		}				
				
		$session_id = session_id();
		$message = addslashes($message);
		$ip = $_SERVER['REMOTE_ADDR'];
		$database->setQuery( "UPDATE #__redirectonlogin_sessions SET session_id='adopt_me', url='$redirect_url', logout='$logout', message='$message', message_type='$message_type', ip='$ip' WHERE session_id='$session_id' ");
		$database->query();	
		
		return true;				
	}
	
	function get_usergroups($user_id){
		$database = JFactory::getDBO();		
		$database->setQuery("SELECT m.group_id "
		."FROM #__user_usergroup_map AS m "	
		."WHERE m.user_id='$user_id' "		
		);
		$rows = $database->loadObjectList();		
		$group_ids = array();
		foreach($rows as $row){	
			$group_ids[] = $row->group_id;	
		}
		return $group_ids;
	}
	
	function get_first_usergroup($user_id, $front_back){	
		$database = JFactory::getDBO();				
		$database->setQuery("SELECT m.group_id "
		."FROM #__user_usergroup_map AS m "			
		."LEFT JOIN #__redirectonlogin_order_groups AS o "
		."ON o.group_id=m.group_id "			
		."WHERE m.user_id='$user_id' "
		."ORDER BY o.redirect_order_".$front_back." ASC "
		."LIMIT 1"
		);
		$usergroup = $database->loadResult();		
		return $usergroup;
	}	
	
	function get_link_from_menuitem($menu_id){

		$database = JFactory::getDBO();	
		$app = JFactory::getApplication();
		$router = $app->getRouter();
		
		$url = '';
		if ($menu_id!=''){
			
			$database->setQuery("SELECT link "
			." FROM #__menu "
			." WHERE id='$menu_id' "
			." limit 1 "
			);
			$rows = $database->loadObjectList();
			$link = '';
			foreach($rows as $row){	
				$link = $row->link;	
			}
			if($link!='') {
				if($router->getMode() == JROUTER_MODE_SEF) {
					$url = 'index.php?Itemid='.$menu_id;
				}else{
					$url = $link.'&Itemid='.$menu_id;
				}				
			}
		}	
		$url = JRoute::_($url, false);
		//$url = str_replace('&amp;','&',$url);
		return $url;
	}	
	
	function get_first_accesslevel($user_id){
	
		$db = JFactory::getDBO();
		$app = JFactory::getApplication();
		$first_level = 0;
	
		//get user levels from this user
		jimport( 'joomla.access.access' );
		$levels_array = JAccess::getAuthorisedViewLevels($user_id);
		$levels_array = array_unique($levels_array);
		
		$query = $db->getQuery(true);
		$query->select('level_id');
		$query->from('#__redirectonlogin_order_levels');	
		if($app->isSite()){
			$query->order('redirect_order');
		}else{
			$query->order('order_backend');
		}
		$rows = $db->setQuery($query);				
		$rows = $db->loadObjectList();
		
		$count_return_levels = 0;
		$first = 1;
		foreach($rows as $accesslevel){
			if(in_array($accesslevel->level_id, $levels_array)){
				if($first){
					$first_level = $accesslevel->level_id;
					$first = 0;
				}				
				$count_return_levels++;
			}	
		}
	
		if(count($levels_array)!=$count_return_levels){		
			//not all levels were in the order table
			//so just make an array of the levels with the order of the level table
			$db->setQuery("SELECT id "
			."FROM #__viewlevels "
			."ORDER BY ordering DESC "
			."LIMIT 1 "		
			);
			$first_level = $db->loadResult();
			
		}
		
		return $first_level;
	}
	
	function set_grouplevel_redirect_url($id, $current_url, $login_logout, $user_id=0){
		
		$database = JFactory::getDBO();	
		$app = JFactory::getApplication();
		$helper = $this->get_helper();
		
		$redirect_url = '';
		$type = 'none';		
		$url = '';
		$logout = 0;	
		$message = '';
		$message_type = '';	
		$dynamic = 0;
		
		if ($app->isAdmin()){
			//backend
			$logout_message = $this->rol_config['logout_message_backend'];			
			if($this->rol_config['frontend_u_or_a']=='a'){
				//levels				
				$database->setQuery("SELECT * "
				."FROM #__redirectonlogin_levels  "
				."WHERE group_id='$id' "
				."LIMIT 1 "
				);								
			}else{		
				//groups			
				$database->setQuery("SELECT * "
				."FROM #__redirectonlogin_groups  "
				."WHERE group_id='$id' "
				."LIMIT 1 "
				);								
			}
			$rows = $database->loadObjectList();			
			$type = 'normal';
			$url = '';	
			$dynamic = 0;
			$component = '';
			$inherit = 0;
			foreach($rows as $row){	
				if($login_logout=='login'){
					//login
					if($this->rol_config['frontend_u_or_a']=='a'){
						$type = $row->loginbackend_type;
						$url = $row->loginbackend_url;	
						$component = $row->loginbackend_component;
						$dynamic = $row->loginbackend_dynamic;	
						$inherit = $row->loginbackend_inherit;	
					}else{
						$type = $row->backend_type;
						$url = $row->backend_url;	
						$component = $row->backend_component;
						$dynamic = $row->loginbackend_dynamic;	
						$inherit = $row->inherit_backend;	
					}
				}else{
					//logout
					$type = $row->logoutbackend_type;
					$url = $row->logoutbackend_url;	
					$menuitem = $row->logoutbackend_menu;
					if($this->rol_config['frontend_u_or_a']=='a'){
						$dynamic = $row->logoutbackend_dynamic;
					}else{
						$dynamic = $row->logoutbackend_dyna;
					}	
					$inherit = $row->logoutbackend_inherit;	
				}				
			}
			//end backend
		}else{
			//frontend			
			$logout_message = $this->rol_config['logout_message_frontend'];
			if($this->rol_config['frontend_u_or_a']=='a'){
				//levels				
				$database->setQuery("SELECT * "
				."FROM #__redirectonlogin_levels  "
				."WHERE group_id='$id' "
				."LIMIT 1 "
				);								
			}else{		
				//groups			
				$database->setQuery("SELECT * "
				."FROM #__redirectonlogin_groups  "
				."WHERE group_id='$id' "
				."LIMIT 1 "
				);								
			}
			$redirects = $database->loadObjectList();
			foreach($redirects as $redirect){
				if($login_logout=='login'){
					//login
					$type = $redirect->frontend_type;
					$url = $redirect->frontend_url;
					$menuitem = $redirect->menuitem_login;	
					$dynamic = $redirect->dynamic_login;
					$inherit = $redirect->inherit_login;
				}elseif($login_logout=='logout'){
					//logout
					$type = $redirect->frontend_type_logout;
					$url = $redirect->frontend_url_logout;
					$menuitem = $redirect->menuitem_logout;	
					$dynamic = $redirect->dynamic_logout;
					$inherit = $redirect->inherit_logout;
				}elseif($login_logout=='first'){
					//first
					$type = $redirect->first_type;
					$url = $redirect->first_url;
					$menuitem = $redirect->first_menu;	
					$dynamic = $redirect->first_dyna;
					$inherit = $redirect->first_inherit;
				}							
			}
			//end frontend
		}		
		
		if($type!='none' && $type!='normal'){
			//usergroup has redirect					
			if($type=='url' && $url!=''){
				$redirect_url = $url;				
			}
			if($type=='no'){						
				$redirect_url = 'no';					
			}
			if($type=='same'){						
				$redirect_url = $current_url;				
			}			
			if($type=='menuitem'){						
				$redirect_url = $helper->get_link_from_menuitem($menuitem);	
				if($app->isAdmin()){
					$redirect_url = str_replace('administrator/', '', $redirect_url);
				}								
			}			
			if($type=='dynamic'){				
				$dynamic_array = $helper->get_dynamic_link($dynamic, $user_id);
				$redirect_url = $dynamic_array[0];
				$message = $dynamic_array[1];
				$logout = $dynamic_array[2];
				$message_type = $dynamic_array[3];						
			}
			if($type=='inherit'){	
				//recursive							
				$this->set_grouplevel_redirect_url($inherit, $current_url, $login_logout);	
				return false;				
			}
			if($type=='component'){
				if($component!=''){												
					$redirect_url = $component;
				}
			}
			if($type=='logout'){
				$message = $logout_message;
				$logout = 1;
				$redirect_url = $current_url;													
			}												
		}		
		$this->grouplevel_redirect_url = $redirect_url;	
		$this->grouplevel_message = $message;
		$this->grouplevel_message_type = $message_type;	
		$this->grouplevel_logout = $logout;	
	}
	
	function set_grouplevel_redirect_url_silent($id, $current_url){
	
		$database = JFactory::getDBO();	
		$helper = $this->get_helper();
		$redirect_url_silent = '';
		$opening_site = '';		
		$opening_site_home = 0;
		$message = '';
		$message_type = '';
		$logout = 0;
		
		if($this->rol_config['frontend_u_or_a']=='a'){
			//level		
			$database->setQuery("SELECT * "
			."FROM #__redirectonlogin_levels  "
			."WHERE group_id='$id' "
			."LIMIT 1 "
			);
			
		}else{					
			//group		
			$database->setQuery("SELECT * "
			."FROM #__redirectonlogin_groups  "
			."WHERE group_id='$id' "
			."LIMIT 1 "
			);								
		}
		$grouplevels = $database->loadObjectList();		
		$opening_site = '';
		foreach($grouplevels as $grouplevel){			
			$opening_site  = $grouplevel->opening_site;		
		}
		
		if($opening_site){
			if($opening_site=='no'){
				$redirect_url_silent = 'no';				
			}
			if($opening_site=='yes'){					
				$opening_site_home = $grouplevel->opening_site_home;
				if($grouplevel->open_type=='menuitem' && $grouplevel->menuitem_open){
					$redirect_url_silent = $helper->get_link_from_menuitem($grouplevel->menuitem_open);
				}
				if($grouplevel->open_type=='url' && $grouplevel->opening_site_url!=''){							
					$redirect_url_silent = $grouplevel->opening_site_url;													
				}
				if($grouplevel->open_type=='dynamic' && $grouplevel->dynamic_open){
					//$redirect_url_silent = $helper->get_dynamic_link($grouplevel->dynamic_open);
					$dynamic_array = $helper->get_dynamic_link($grouplevel->dynamic_open);
					$redirect_url_silent = $dynamic_array[0];
					$message = $dynamic_array[1];
					$logout = $dynamic_array[2];
					$message_type = $dynamic_array[3];	
				}			
			}
			if($opening_site=='inherit'){				
				//recursive							
				$this->set_grouplevel_redirect_url_silent($grouplevel->inherit_open, $current_url);	
				return false;			
			}
		}		
		$this->grouplevel_redirect_url_silent = $redirect_url_silent;	
		$this->grouplevel_open_site_home = $opening_site_home;
		$this->grouplevel_message = $message;	
		$this->grouplevel_logout = $logout;
		$this->grouplevel_message_type = $message_type;
	}
	
	function get_helper(){
		$ds = DIRECTORY_SEPARATOR;
		require_once(JPATH_ROOT.$ds.'administrator'.$ds.'components'.$ds.'com_redirectonlogin'.$ds.'helpers'.$ds.'redirectonlogin.php');
		$helper = new redirectonloginHelper();
		return $helper;
	}
	
	function clean_sessions(){
		$database = JFactory::getDBO();	
		$time = time();	
		//one day is 24*60*60=86400 seconds
		$one_day_old = $time-86400;		
		$database->setQuery("DELETE FROM #__redirectonlogin_sessions WHERE unixtime<='$one_day_old' ");
		$database->query();
	}
	
	function rol_check_trial_version(){
		//config		
		$rol_trial_valid_until = 1309262132;						
		$rol_allow_localhost = true;
		//check trial time left		
		$rol_trial_seconds_left = $rol_trial_valid_until-time();
		//let class know demo time left			
		$this->rol_demo_seconds_left = $rol_trial_seconds_left;	
		//check the trialtime
		$rol_trial_still_valid = false;	
		if(
		//check localhost
		($rol_allow_localhost && ($_SERVER['SERVER_NAME']==='localhost' || $_SERVER['SERVER_NAME']==='127.0.0.1')) ||
		//check demo time 
		$rol_trial_seconds_left >= 0 ||
		//not a trial version
		$this->rol_version_type == 'free' || $this->rol_version_type == 'pro'
		){					
			$rol_trial_still_valid = true;								
		}
		return $rol_trial_still_valid;
	}
	
	function get_first_time_login($user_id){
		
		$db = JFactory::getDBO();
		
		$first_time_login = 0;	
		
		$query = $db->getQuery(true);
		$query->select('lastvisitDate');
		$query->from('#__users');
		$query->where('id='.$db->q($user_id));		
		$rows = $db->setQuery($query);				
		$rows = $db->loadObjectList();
			
		foreach($rows as $row){		
			if($row->lastvisitDate=='0000-00-00 00:00:00'){
				$first_time_login = 1;
			}
		}
				
		return $first_time_login;
	}
	
	
}
?>