<?php
/** Class to access a segments resources from the create send API.
 * This class includes functions to create and edits segments
 * along with accessing the subscribers of a specific segment
 * @author tobyb
 *
*/
require_once dirname(__FILE__).'/class/base_classes.php';
class CS_REST_Segments extends CS_REST_Wrapper_Base {
var $_segments_base_route;
function CS_REST_Segments (
$segment_id,
$auth_details,
$protocol = 'https',
$debug_level = CS_REST_LOG_NONE,
$host = 'api.createsend.com',
$log = NULL,
$serialiser = NULL,
$transport = NULL){
$this->CS_REST_Wrapper_Base($auth_details, $protocol, $debug_level, $host, $log, $serialiser, $transport);
$this->set_segment_id($segment_id);
}
function set_segment_id($segment_id){
$this->_segments_base_route = $this->_base_route.'segments/'.$segment_id;
}
function create($list_id, $segment_details){
return $this->post_request($this->_base_route.'segments/'.$list_id.'.json', $segment_details);
} 
function update($segment_details){
return $this->put_request($this->_segments_base_route.'.json', $segment_details);
} 
function add_rule($rule){
return $this->post_request($this->_segments_base_route.'/rules.json', $rule);
}
function get(){
return $this->get_request($this->_segments_base_route.'.json');
}
function delete(){
return $this->delete_request($this->_segments_base_route.'.json');
}
function clear_rules(){
return $this->delete_request($this->_segments_base_route.'/rules.json');
}
function get_subscribers($subscribed_since = '', $page_number = NULL, 
$page_size = NULL, $order_field = NULL, $order_direction = NULL){
return $this->get_request_paged($this->_segments_base_route.'/active.json?date='.urlencode($subscribed_since), 
$page_number, $page_size, $order_field, $order_direction);
}
}