<?php
/**
 * @copyright   Copyright (C) 2006 - 2014 IdealExtensions.com. All rights reserved.reserved.
 * @license	 GNU GPL2 or later; see LICENSE.txt
 */

defined('JPATH_BASE') or die;

class iDealCaptcha extends JObject
{
	public static function display(&$params,$namespace='com_contactenhanced')
	{
		$user = JFactory::getUser();
		if( ($params->get( 'enable_captcha', 2) > 0  AND !$user->id )
				OR $params->get( 'enable_captcha', 2) == 2)
		{
			$plugin	= $params->get('captcha_plugin',$params->get('captcha', JFactory::getApplication()->getParams()->get('captcha', JFactory::getConfig()->get('captcha','recaptcha'))));

			if(JPluginHelper::isEnabled('captcha')
				AND $plugin !== 0 AND $plugin !== '0' AND $plugin !== '' AND $plugin !== null
			){
				$class	 = 'required';
				if (($captcha = JCaptcha::getInstance($plugin, array('namespace' => $namespace))) == null){
					return '';
				}
				return $captcha->display('idealCaptcha', 'idealCaptcha', $class);

			}
		}
		return '';
	}

	public static function test(&$params, $value=null, $namespace='com_contactenhanced')
	{

		$user = JFactory::getUser();
		if( ($params->get( 'enable_captcha', 2) > 0  AND !$user->id )
				OR $params->get( 'enable_captcha', 2) == 2)
		{

			$plugin	= $params->get('captcha_plugin',$params->get('captcha', JFactory::getApplication()->getParams()->get('captcha', JFactory::getConfig()->get('captcha','recaptcha'))));

			if(JPluginHelper::isEnabled('captcha')
				AND $plugin !== 0 AND $plugin !== '0' AND $plugin !== '' AND $plugin !== null
			){
				$captcha = JCaptcha::getInstance($plugin, array('namespace' => $namespace));

				// Test the value.
				if (!$captcha->checkAnswer($value)){
					$error = $captcha->getError();
					JFactory::getApplication()->enqueueMessage($error,'error');
					return false;
				}
			}
		}
		return true;
	}
}