<?php
/** Performs all actions pertaining to scheduling Constant Contact Activities
 *
 * @package Services
 * @author ConstantContact
*/
namespace Ctct\Services;
use Ctct\Util\RestClient;
use Ctct\Util\Config;
use Ctct\Components\EmailMarketing\Schedule;
use Ctct\Components\EmailMarketing\TestSend;
use Ctct\Components\Activities\Activity;
use Ctct\Components\Activities\AddContacts;
use Ctct\Components\Activities\RemoveFromLists;
use Ctct\Components\Activities\ExportContacts;
use Ctct\Components\Activities\ClearLists;
class ActivityService extends BaseService
{
public function getActivities($accessToken)
{
$baseUrl = Config::get('endpoints.base_url') . Config::get('endpoints.activities');
$url = $this->buildUrl($baseUrl);
$response = parent::getRestClient()->get($url, parent::getHeaders($accessToken));
$jsonResponse = json_decode($response->body, true);
$activities = array();
foreach ($jsonResponse as $activity){
$activities[] = Activity::create($activity);
}
return $activities;
}
public function getActivity($accessToken, $activityId)
{
$baseUrl = Config::get('endpoints.base_url') . sprintf(Config::get('endpoints.activity'), $activityId);
$url = $this->buildUrl($baseUrl);
$response = parent::getRestClient()->get($url, parent::getHeaders($accessToken));
return Activity::create(json_decode($response->body, true));
}
public function createAddContactsActivity($accessToken, AddContacts $addContacts)
{
$baseUrl = Config::get('endpoints.base_url') . Config::get('endpoints.add_contacts_activity');
$url = $this->buildUrl($baseUrl);
$response = parent::getRestClient()->post($url, parent::getHeaders($accessToken), $addContacts->toJson());
return Activity::create(json_decode($response->body, true));
}
public function addClearListsActivity($accessToken, array $lists)
{
$baseUrl = Config::get('endpoints.base_url') . Config::get('endpoints.clear_lists_activity');
$url = $this->buildUrl($baseUrl);
$payload = array('lists' => $lists);
$response = parent::getRestClient()->post($url, parent::getHeaders($accessToken), json_encode($payload));
return Activity::create(json_decode($response->body, true));
}
public function addExportContactsActivity($accessToken, ExportContacts $exportContacts)
{
$baseUrl = Config::get('endpoints.base_url') . Config::get('endpoints.export_contacts_activity');
$url = $this->buildUrl($baseUrl);
$response = parent::getRestClient()->post($url, parent::getHeaders($accessToken), json_encode($exportContacts));
return Activity::create(json_decode($response->body, true));
}
public function addRemoveContactsFromListsActivity($accessToken, array $emailAddresses, array $lists)
{
$baseUrl = Config::get('endpoints.base_url') . Config::get('endpoints.remove_from_lists_activity');
$url = $this->buildUrl($baseUrl);
$payload = array(
'import_data' => array(),
'lists' => $lists
);
foreach ($emailAddresses as $emailAddress){
$payload['import_data'][] = array('email_addresses' => array($emailAddress));
}
$response = parent::getRestClient()->post($url, parent::getHeaders($accessToken), json_encode($payload));
return Activity::create(json_decode($response->body, true));
}
}
