<?php
/** Super class for all services
 *
 * @package Services
 * @author Constant Contact
*/
namespace Ctct\Services;
use Ctct\Util\RestClient;
use Ctct\Util\RestClientInterface;
abstract class BaseService
{
protected $restClient;
protected $apiKey;
public function __construct($apiKey, $restClient = null)
{
$this->apiKey = $apiKey;
if (is_null($restClient)){
$this->restClient = new RestClient();
}else{
$this->restClient = $restClient;
}
}
public function buildUrl($url, $queryParams = null)
{
$keyArr = array('api_key' => $this->apiKey);
if($queryParams){
$params = array_merge($keyArr, $queryParams);
}else{
$params = $keyArr;
}
return $url . '?' . http_build_query($params);
}
public function getRestClient()
{
return $this->restClient;
}
public function setRestClient(RestClientInterface $restClient)
{
$this->restClient = $restClient;
}
protected static function getHeaders($accessToken)
{
return array(
'Content-Type: application/json',
'Accept: application/json',
'Authorization: Bearer ' . $accessToken
);
}
}
