<?php
/** Performs all actions pertaining to Contact Tracking
 *
 * @package Services
 * @author Constant Contact
*/
namespace Ctct\Services;
use Ctct\Util\RestClient;
use Ctct\Util\Config;
use Ctct\Components\Tracking\BounceActivity;
use Ctct\Components\Tracking\TrackingActivity;
use Ctct\Components\Tracking\ClickActivity;
use Ctct\Components\Tracking\ForwardActivity;
use Ctct\Components\Tracking\OpenActivity;
use Ctct\Components\Tracking\UnsubscribeActivity;
use Ctct\Components\Tracking\SendActivity;
use Ctct\Components\Tracking\TrackingSummary;
use Ctct\Components\ResultSet;
class ContactTrackingService extends BaseService
{
public function getBounces($accessToken, $contactId, array $params = array())
{
$baseUrl = Config::get('endpoints.base_url') .
sprintf(Config::get('endpoints.contact_tracking_bounces'), $contactId);
$url = $this->buildUrl($baseUrl, $params);
$response = parent::getRestClient()->get($url, parent::getHeaders($accessToken));
$body = json_decode($response->body, true);
$bounces = array();
foreach ($body['results'] as $bounceActivity){
$bounces[] = BounceActivity::create($bounceActivity);
}
return new ResultSet($bounces, $body['meta']);
}
public function getClicks($accessToken, $contactId, array $params = array())
{
$baseUrl = Config::get('endpoints.base_url') .
sprintf(Config::get('endpoints.contact_tracking_clicks'), $contactId);
$url = $this->buildUrl($baseUrl, $params);
$response = parent::getRestClient()->get($url, parent::getHeaders($accessToken));
$body = json_decode($response->body, true);
$clicks = array();
foreach ($body['results'] as $click_activity){
$clicks[] = ClickActivity::create($click_activity);
}
return new ResultSet($clicks, $body['meta']);
}
public function getForwards($accessToken, $contactId, array $params = array())
{
$baseUrl = Config::get('endpoints.base_url') .
sprintf(Config::get('endpoints.contact_tracking_forwards'), $contactId);
$url = $this->buildUrl($baseUrl, $params);
$response = parent::getRestClient()->get($url, parent::getHeaders($accessToken));
$body = json_decode($response->body, true);
$forwards = array();
foreach ($body['results'] as $forward_activity){
$forwards[] = ForwardActivity::create($forward_activity);
}
return new ResultSet($forwards, $body['meta']);
}
public function getOpens($accessToken, $contactId, array $params = array())
{
$baseUrl = Config::get('endpoints.base_url') .
sprintf(Config::get('endpoints.contact_tracking_opens'), $contactId);
$url = $this->buildUrl($baseUrl, $params);
$response = parent::getRestClient()->get($url, parent::getHeaders($accessToken));
$body = json_decode($response->body, true);
$opens = array();
foreach ($body['results'] as $open_activity){
$opens[] = OpenActivity::create($open_activity);
}
return new ResultSet($opens, $body['meta']);
}
public function getSends($accessToken, $contact_id, array $params = array())
{
$baseUrl = Config::get('endpoints.base_url') .
sprintf(Config::get('endpoints.contact_tracking_sends'), $contact_id);
$url = $this->buildUrl($baseUrl, $params);
$response = parent::getRestClient()->get($url, parent::getHeaders($accessToken));
$body = json_decode($response->body, true);
$sends = array();
foreach ($body['results'] as $send_activity){
$sends[] = SendActivity::create($send_activity);
}
return new ResultSet($sends, $body['meta']);
}
public function getUnsubscribes($accessToken, $contact_id, array $params = array())
{
$baseUrl = Config::get('endpoints.base_url') .
sprintf(Config::get('endpoints.contact_tracking_unsubscribes'), $contact_id);
$url = $this->buildUrl($baseUrl, $params);
$response = parent::getRestClient()->get($url, parent::getHeaders($accessToken));
$body = json_decode($response->body, true);
$opt_outs = array();
foreach ($body['results'] as $opt_out_activity){
$opt_outs[] = UnsubscribeActivity::create($opt_out_activity);
}
return new ResultSet($opt_outs, $body['meta']);
}
public function getSummary($accessToken, $contact_id)
{
$baseUrl = Config::get('endpoints.base_url') .
sprintf(Config::get('endpoints.contact_tracking_summary'), $contact_id);
$url = $this->buildUrl($baseUrl);
$response = parent::getRestClient()->get($url, parent::getHeaders($accessToken));
return TrackingSummary::create(json_decode($response->body, true));
}
}
